/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container;

import com.ibm.ejs.container.BeanO;
import com.ibm.ejs.container.EJSHome;
import com.ibm.ejs.container.EJSWrapperBase;
import com.ibm.ejs.util.Util;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public final class WeakManagedBeanCache {
    private static final TraceComponent tc = Tr.register(WeakManagedBeanCache.class, (String)"EJBContainer", (String)"com.ibm.ejs.container.container");
    private static WeakManagedBeanCache svInstance = null;
    private final ReferenceQueue<EJSWrapperBase> ivRefQueue = new ReferenceQueue();
    private final Map<WeakReference<EJSWrapperBase>, BeanO> ivCache = new HashMap<WeakReference<EJSWrapperBase>, BeanO>();

    public static synchronized WeakManagedBeanCache instance() {
        if (svInstance == null) {
            svInstance = new WeakManagedBeanCache();
        }
        return svInstance;
    }

    private WeakManagedBeanCache() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("WeakManagedBeanCache : " + this.ivRefQueue + ", " + this.ivCache), (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(EJSWrapperBase wrapper, BeanO bean) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("add(" + Util.identity((Object)wrapper) + ", " + bean + ")"), (Object[])new Object[0]);
        }
        this.poll();
        WeakReference<EJSWrapperBase> key = new WeakReference<EJSWrapperBase>(wrapper, this.ivRefQueue);
        Map<WeakReference<EJSWrapperBase>, BeanO> map = this.ivCache;
        synchronized (map) {
            this.ivCache.put(key, bean);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("add : key = " + key));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(EJSHome home) {
        ArrayList<BeanO> removedBeans = new ArrayList<BeanO>();
        Map<WeakReference<EJSWrapperBase>, BeanO> map = this.ivCache;
        synchronized (map) {
            this.poll();
            Iterator<Map.Entry<WeakReference<EJSWrapperBase>, BeanO>> it = this.ivCache.entrySet().iterator();
            while (it.hasNext()) {
                BeanO bean = it.next().getValue();
                if (bean.home != home) continue;
                it.remove();
                removedBeans.add(bean);
            }
        }
        for (BeanO bean : removedBeans) {
            bean.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void poll() {
        Reference<EJSWrapperBase> ref;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        BeanO bean = null;
        int removeCount = 0;
        while ((ref = this.ivRefQueue.poll()) != null) {
            Map<WeakReference<EJSWrapperBase>, BeanO> map = this.ivCache;
            synchronized (map) {
                bean = this.ivCache.remove(ref);
            }
            ++removeCount;
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("poll : removed (" + ref + ", " + bean + ")"), (Object[])new Object[0]);
            }
            if (bean == null) continue;
            bean.destroy();
        }
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("poll : size = " + this.ivCache.size() + ", removed = " + removeCount), (Object[])new Object[0]);
        }
    }
}

