/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.telemetry.spi;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.kernel.productinfo.ProductInfo;
import com.ibm.ws.kernel.service.util.ServiceCaller;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.telemetry.internal.common.info.ErrorOpenTelemetryInfo;
import io.openliberty.microprofile.telemetry.internal.common.info.OpenTelemetryLifecycleManager;
import io.openliberty.microprofile.telemetry.spi.OpenTelemetryInfo;
import java.util.Optional;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/ejs/ras/TraceComponent;")
@InjectedFFDC
public class OpenTelemetryAccessor {
    private static final TraceComponent tc = Tr.register(OpenTelemetryAccessor.class);
    private static final ServiceCaller<OpenTelemetryLifecycleManager> openTelemetryLifecycleManagerService = new ServiceCaller(OpenTelemetryAccessor.class, OpenTelemetryLifecycleManager.class);
    private static boolean issuedBetaMessage = false;
    static final long serialVersionUID = -5097458981454000348L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public OpenTelemetryAccessor() {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"<init>", (Object)new Object[0]);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"<init>", (Object)this);
        }
    }

    @Deprecated
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public static OpenTelemetryInfo getOpenTelemetryInfo() {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getOpenTelemetryInfo", (Object)new Object[0]);
        }
        if (ProductInfo.getBetaEdition()) {
            Optional openTelemetryInfo = openTelemetryLifecycleManagerService.run(factory -> factory.getOpenTelemetryInfo());
            OpenTelemetryInfo openTelemetryInfo2 = openTelemetryInfo.orElseGet(ErrorOpenTelemetryInfo::getInstance);
            if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
                openTelemetryInfo2 = openTelemetryInfo2;
                Tr.exit((TraceComponent)tc, (String)"getOpenTelemetryInfo", (Object)openTelemetryInfo2);
            }
            return openTelemetryInfo2;
        }
        if (!issuedBetaMessage) {
            Tr.warning((TraceComponent)tc, (String)"BETA: A beta method has been invoked for the class OpenTelemetryAccessor for the first time.");
            issuedBetaMessage = true;
        }
        throw new UnsupportedOperationException("This feature is still in beta, add -Dcom.ibm.ws.beta.edition=true to jvm.options if you wish to use beta code");
    }
}

