/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.openapi20.internal.servlet;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.openapi.internal.common.services.OpenAPIEndpointProvider;
import io.openliberty.microprofile.openapi20.internal.services.DefaultHostListener;
import io.openliberty.microprofile.openapi20.internal.utils.OpenAPIUtils;
import io.openliberty.microprofile.openapi20.internal.utils.ProxySupportUtil;
import io.openliberty.microprofile.openapi20.internal.utils.ServerInfo;
import io.smallrye.openapi.runtime.io.Format;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import org.eclipse.microprofile.openapi.models.servers.Server;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public abstract class OpenAPIServletBase
extends HttpServlet {
    private static final long serialVersionUID = -6021365340147075272L;
    private ServiceTracker<DefaultHostListener, DefaultHostListener> defaultHostListenerTracker;
    private ServiceTracker<OpenAPIEndpointProvider, OpenAPIEndpointProvider> openAPIEndpointTracker;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public void init(ServletConfig config) throws ServletException {
        BundleContext bundleContext = (BundleContext)config.getServletContext().getAttribute("osgi-bundlecontext");
        this.defaultHostListenerTracker = new ServiceTracker(bundleContext, DefaultHostListener.class, null);
        this.defaultHostListenerTracker.open();
        this.openAPIEndpointTracker = new ServiceTracker(bundleContext, OpenAPIEndpointProvider.class, null);
        this.openAPIEndpointTracker.open();
        super.init(config);
    }

    public void destroy() {
        super.destroy();
        this.defaultHostListenerTracker.close();
        this.openAPIEndpointTracker.close();
    }

    protected Format getResponseFormat(HttpServletRequest request) {
        String formatParam;
        Format format = Format.YAML;
        String acceptHeader = request.getHeader("Accept");
        if (acceptHeader != null) {
            for (String value : acceptHeader.split(",")) {
                if (!value.trim().equals("application/json") && !value.trim().equals("application/javascript") && !value.trim().equals("text/javascript") && !value.trim().equals("text/json")) continue;
                format = Format.JSON;
                break;
            }
        }
        if ((formatParam = request.getParameter("format")) != null && formatParam.equalsIgnoreCase("json")) {
            format = Format.JSON;
        }
        return format;
    }

    protected List<Server> getOpenAPIModelServers(HttpServletRequest request) throws ServletException {
        return this.getOpenAPIModelServers(request, null);
    }

    protected List<Server> getOpenAPIModelServers(HttpServletRequest request, String applciationPath) throws ServletException {
        DefaultHostListener defaultHostListener = (DefaultHostListener)this.defaultHostListenerTracker.getService();
        if (defaultHostListener == null) {
            return Collections.emptyList();
        }
        ServerInfo serverInfo = new ServerInfo(defaultHostListener.getDefaultHostServerInfo());
        ProxySupportUtil.processRequest((HttpServletRequest)request, (OpenAPIEndpointProvider)((OpenAPIEndpointProvider)this.openAPIEndpointTracker.getService()), (ServerInfo)serverInfo);
        return OpenAPIUtils.getOpenAPIModelServers((ServerInfo)serverInfo, (String)applciationPath);
    }

    @Trivial
    protected void writeResponse(HttpServletResponse response, String document, Response.Status status, String contentType) throws IOException {
        response.setStatus(status.getStatusCode());
        response.setContentType(contentType);
        response.setCharacterEncoding(StandardCharsets.UTF_8.name());
        if (document != null) {
            PrintWriter writer = response.getWriter();
            ((Writer)writer).write(document);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"io.openliberty.microprofile.openapi20.internal.servlet.OpenAPIServletBase", OpenAPIServletBase.class, (String)"MPOPENAPI", (String)"io.openliberty.microprofile.openapi.internal.resources.OpenAPI");
    }
}

