/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.persistence.dispatcher;

import com.ibm.ws.sib.msgstore.persistence.dispatcher.StateUtils;

final class DispatcherState {
    static final StateUtils.StateUpdater<DispatcherState> updaterForStart = new StateUtils.StateUpdater<DispatcherState>(){

        @Override
        public DispatcherState update(DispatcherState currentState) {
            return currentState.stopRequested(false).running(true);
        }
    };
    static final StateUtils.StateUpdater<DispatcherState> updaterForStopRequested = new StateUtils.StateUpdater<DispatcherState>(){

        @Override
        public DispatcherState update(DispatcherState currentState) {
            if (!currentState.isRunning) {
                return currentState;
            }
            return currentState.stopRequested(true);
        }
    };
    static final StateUtils.StateUpdater<DispatcherState> updaterForStopped = new StateUtils.StateUpdater<DispatcherState>(){

        @Override
        public DispatcherState update(DispatcherState currentState) {
            return currentState.running(false);
        }
    };
    static final StateUtils.StateUpdater<DispatcherState> updaterForErrorOccurred = new StateUtils.StateUpdater<DispatcherState>(){

        @Override
        public DispatcherState update(DispatcherState currentState) {
            return currentState.addThreadWriteError();
        }
    };
    static final StateUtils.StateUpdater<DispatcherState> updaterForErrorCleared = new StateUtils.StateUpdater<DispatcherState>(){

        @Override
        public DispatcherState update(DispatcherState currentState) {
            return currentState.clearThreadWriteError();
        }
    };
    final boolean isRunning;
    final boolean isStopRequested;
    final int threadWriteErrors;

    DispatcherState() {
        this(false, false, 0);
    }

    private DispatcherState(boolean running, boolean stopRequested, int threadWriteErrors) {
        this.isRunning = running;
        this.isStopRequested = stopRequested;
        this.threadWriteErrors = threadWriteErrors;
    }

    private DispatcherState running(boolean running) {
        return running == this.isRunning ? this : new DispatcherState(running, this.isStopRequested, this.threadWriteErrors);
    }

    private DispatcherState stopRequested(boolean stopRequested) {
        return stopRequested == this.isStopRequested ? this : new DispatcherState(this.isRunning, stopRequested, this.threadWriteErrors);
    }

    private DispatcherState addThreadWriteError() {
        return new DispatcherState(this.isRunning, this.isStopRequested, this.threadWriteErrors + 1);
    }

    private DispatcherState clearThreadWriteError() {
        return 0 >= this.threadWriteErrors ? this : new DispatcherState(this.isRunning, this.isStopRequested, this.threadWriteErrors - 1);
    }

    boolean isHealthy() {
        return this.isRunning && !this.isStopRequested && 0 == this.threadWriteErrors;
    }

    String desc() {
        String s = "";
        if (this.isStopRequested) {
            s = s + " (STOP REQUESTED)";
        }
        if (!this.isRunning) {
            s = s + " (STOPPED)";
        }
        if (0 < this.threadWriteErrors) {
            s = s + " (ERROR)";
        }
        return s;
    }
}

