/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.persistence.dispatcher;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.JsMessagingEngine;
import com.ibm.ws.sib.msgstore.PersistenceException;
import com.ibm.ws.sib.msgstore.PersistentDataEncodingException;
import com.ibm.ws.sib.msgstore.SevereMessageStoreException;
import com.ibm.ws.sib.msgstore.SeverePersistenceException;
import com.ibm.ws.sib.msgstore.cache.links.AbstractItemLink;
import com.ibm.ws.sib.msgstore.impl.MessageStoreImpl;
import com.ibm.ws.sib.msgstore.persistence.BatchingContextFactory;
import com.ibm.ws.sib.msgstore.persistence.dispatcher.DispatchNotifier;
import com.ibm.ws.sib.msgstore.persistence.dispatcher.DispatcherBase;
import com.ibm.ws.sib.msgstore.persistence.dispatcher.DispatcherState;
import com.ibm.ws.sib.msgstore.persistence.dispatcher.StateUtils;
import com.ibm.ws.sib.msgstore.persistence.impl.Tuple;
import com.ibm.ws.sib.msgstore.task.Task;
import com.ibm.ws.sib.msgstore.transactions.impl.PersistentTransaction;
import com.ibm.ws.sib.msgstore.transactions.impl.TransactionState;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicReference;

public class SpillDispatcher
extends DispatcherBase {
    private static TraceComponent tc = SibTr.register(SpillDispatcher.class, (String)"SIBMessageStore", (String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    private long _minBytesPerBatch;
    private long _maxBytesPerBatch;
    private int _maxTasksPerBatch;
    private long _maxDispatchedBytesPerThread;
    public int _writesToResetErrorState;
    private int _maxThreads;
    private int _numThreads;
    private MessageStoreImpl _msi;
    private Thread[] _threads;
    private SpillDispatcherThread[] _workers;
    private BatchingContextFactory _bcfactory;
    private final AtomicReference<DispatcherState> stateRef = new AtomicReference<DispatcherState>(new DispatcherState());

    public SpillDispatcher(MessageStoreImpl msi, BatchingContextFactory bcfactory) {
        this(msi, bcfactory, SpillDispatcher.obtainIntConfigParameter(msi, "jdbcSpillThreads", "8", 1, 32));
    }

    public SpillDispatcher(MessageStoreImpl msi, BatchingContextFactory bcfactory, int maxThreads) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object)new Object[]{msi, bcfactory, maxThreads});
        }
        this._msi = msi;
        this._bcfactory = bcfactory;
        this._maxThreads = maxThreads;
        this._minBytesPerBatch = SpillDispatcher.obtainLongConfigParameter(this._msi, "jdbcSpillMinBytesPerBatch", "2000000", 10000L, 100000000L);
        this._maxBytesPerBatch = SpillDispatcher.obtainLongConfigParameter(this._msi, "jdbcSpillMaxBytesPerBatch", "4000000", 100000L, 100000000L);
        this._maxTasksPerBatch = SpillDispatcher.obtainIntConfigParameter(this._msi, "jdbcSpillMaxTasksPerBatch", "64", 1, 10000);
        this._maxDispatchedBytesPerThread = SpillDispatcher.obtainLongConfigParameter(this._msi, "jdbcSpillMaxDispatchedBytesPerThread", "10000000", 100000L, 1000000000L);
        if (this._minBytesPerBatch > this._maxDispatchedBytesPerThread) {
            this._minBytesPerBatch = this._maxDispatchedBytesPerThread;
        }
        if (this._minBytesPerBatch > this._maxBytesPerBatch) {
            this._minBytesPerBatch = this._maxBytesPerBatch;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    @Override
    public synchronized boolean isHealthy() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"isHealthy");
        }
        boolean retval = this.stateRef.get().isHealthy();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"isHealthy", (Object)retval);
        }
        return retval;
    }

    @Override
    public void dispatch(Collection tasks, PersistentTransaction tran, boolean canReject) throws PersistenceException, SevereMessageStoreException {
        block9: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"dispatch", (Object)new Object[]{tasks, canReject});
            }
            int taskCount = 0;
            long dispatchTime = System.currentTimeMillis();
            if (tasks != null) {
                boolean mustWait = false;
                taskCount = tasks.size();
                DispatchNotifier waitHere = new DispatchNotifier(taskCount, canReject);
                boolean[] mustNotifyThreads = new boolean[this._maxThreads];
                boolean[] mustWaitThreads = new boolean[this._maxThreads];
                for (Task task : tasks) {
                    task.copyDataIfVulnerable();
                    ((Tuple)task.getPersistable()).persistableOperationBegun();
                    int threadnum = (int)(task.getPersistable().getUniqueId() % (long)this._maxThreads);
                    mustWaitThreads[threadnum] = this._workers[threadnum].addTask(task, dispatchTime, waitHere);
                    mustNotifyThreads[threadnum] = true;
                }
                for (int i = 0; i < this._maxThreads; ++i) {
                    if (mustNotifyThreads[i]) {
                        this._workers[i].notifyDispatchArrived();
                    }
                    mustWait |= mustWaitThreads[i];
                }
                if (mustWait) {
                    try {
                        waitHere.waitForDispatch();
                    }
                    catch (PersistenceException pe) {
                        FFDCFilter.processException((Throwable)pe, (String)"com.ibm.ws.sib.msgstore.persistence.impl.SpillDispatcher.writeBatch", (String)"1:326:1.48", (Object)this);
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block9;
                        SibTr.event((Object)this, (TraceComponent)tc, (String)"Exception persisting batch", (Object)((Object)pe));
                    }
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"dispatch");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        JsMessagingEngine me;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"start");
        }
        int priorityDelta = SpillDispatcher.obtainIntConfigParameter(this._msi, "jdbcSpillThreadPriorityDelta", "0", -4, 5);
        this._threads = new Thread[this._maxThreads];
        this._workers = new SpillDispatcherThread[this._maxThreads];
        SpillDispatcher spillDispatcher = this;
        synchronized (spillDispatcher) {
            StateUtils.updateState(this.stateRef, DispatcherState.updaterForStart);
        }
        String meUUID = "";
        if (this._msi != null && (me = this._msi._getMessagingEngine()) != null) {
            meUUID = me.getUuid().toString() + "-";
        }
        for (int i = 0; i < this._maxThreads; ++i) {
            String threadName = "sib.SpillDispatcher-" + meUUID + i;
            this._workers[i] = new SpillDispatcherThread(i, threadName);
            this._threads[i] = new Thread((Runnable)this._workers[i], threadName);
            this._threads[i].setDaemon(true);
            this._threads[i].setPriority(5 + priorityDelta);
            this._threads[i].start();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"start");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop(int mode) {
        boolean performingTheStop;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"stop", (Object)mode);
        }
        SpillDispatcher spillDispatcher = this;
        synchronized (spillDispatcher) {
            performingTheStop = StateUtils.updateState(this.stateRef, DispatcherState.updaterForStopRequested);
        }
        if (performingTheStop) {
            for (int i = 0; i < this._maxThreads; ++i) {
                this._workers[i].cleanup();
            }
            long limitStopMillis = System.currentTimeMillis() + 60000L;
            for (int i = 0; i < this._maxThreads; ++i) {
                long remainingStopDelay = limitStopMillis - System.currentTimeMillis();
                if (remainingStopDelay <= 0L) {
                    remainingStopDelay = 1L;
                }
                try {
                    if (this._threads[i] == null) continue;
                    this._threads[i].join(remainingStopDelay);
                    if (!this._threads[i].isAlive() || !TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("Cannot join dispatcher thread " + this._workers[i]));
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"stop");
        }
    }

    public synchronized void threadWriteErrorOccurred(final int threadNum) {
        StateUtils.UpdateCallback<DispatcherState> callback = TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled() ? new StateUtils.UpdateCallback<DispatcherState>(){

            @Override
            public void updated(DispatcherState newState) {
                SibTr.event((Object)SpillDispatcher.this, (TraceComponent)tc, (String)String.format("threadWriteErrorOccurred: threadNum = %d, new writeErrorCount = %d", threadNum, newState.threadWriteErrors));
            }
        } : null;
        StateUtils.updateState(this.stateRef, DispatcherState.updaterForErrorOccurred, callback);
    }

    public synchronized void threadWriteErrorCleared(final int threadNum) {
        StateUtils.UpdateCallback<DispatcherState> callback = TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled() ? new StateUtils.UpdateCallback<DispatcherState>(){

            @Override
            public void updated(DispatcherState newState) {
                SibTr.event((Object)SpillDispatcher.this, (TraceComponent)tc, (String)String.format("threadWriteErrorCleared: threadNum = %d, new writeErrorCount = %d", threadNum, newState.threadWriteErrors));
            }
        } : null;
        StateUtils.updateState(this.stateRef, DispatcherState.updaterForErrorCleared, callback);
    }

    public String toString() {
        return super.toString() + this.stateRef.get().desc();
    }

    static /* synthetic */ MessageStoreImpl access$600(SpillDispatcher x0) {
        return x0._msi;
    }

    static /* synthetic */ AtomicReference access$700(SpillDispatcher x0) {
        return x0.stateRef;
    }

    static /* synthetic */ int access$510(SpillDispatcher x0) {
        return x0._numThreads--;
    }

    static /* synthetic */ int access$500(SpillDispatcher x0) {
        return x0._numThreads;
    }

    static /* synthetic */ BatchingContextFactory access$1300(SpillDispatcher x0) {
        return x0._bcfactory;
    }

    private class SpillDispatcherThread
    implements Runnable {
        private int _threadNum;
        private String _threadName;
        private LinkedList _waitingQueue;
        private LinkedList _dispatchAddingQueue;
        private LinkedList _dispatchUpdateQueue;
        private LinkedList _dispatchRemoveQueue;
        private final DispatchingLock _dispatchingLock = new DispatchingLock();
        private long _dispatchedBytes;
        private boolean _writeErrorOccurred = false;
        private int _goodWritesSinceLastError = 0;
        private int _consecutiveWriteErrors = 0;
        private boolean _isContributingToThreadWriteErrors = false;
        private long _writeErrorRetryDelay;
        private boolean _interruptible = false;
        private boolean _threadActive;
        private boolean _notifyOutstanding = false;

        SpillDispatcherThread(int threadNum, String threadName) {
            this._threadNum = threadNum;
            this._threadName = threadName;
            SpillDispatcher.this._numThreads++;
            this._waitingQueue = new LinkedList();
            this._threadActive = true;
            this._dispatchAddingQueue = new LinkedList();
            this._dispatchUpdateQueue = new LinkedList();
            this._dispatchRemoveQueue = new LinkedList();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            if (SpillDispatcher.access$600(SpillDispatcher.this) != null && SpillDispatcher.access$600(SpillDispatcher.this)._getMessagingEngine() != null) {
                SibTr.push((Object)SpillDispatcher.access$600(SpillDispatcher.this)._getMessagingEngine());
            }
            if (TraceComponent.isAnyTracingEnabled() && SpillDispatcher.access$300().isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)SpillDispatcher.access$300(), (String)"run");
            }
            batch = null;
            stopNow = false;
            while (true) {
                if (stopNow) ** GOTO lbl31
                dataToWrite = false;
                var4_7 = SpillDispatcher.this;
                synchronized (var4_7) {
                    stopNow = ((DispatcherState)SpillDispatcher.access$700((SpillDispatcher)SpillDispatcher.this).get()).isStopRequested;
                    ** GOTO lbl37
                }
                break;
            }
            {
                block59: {
                    catch (Throwable t) {
                        FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.sib.msgstore.persistence.dispatcher.SpillDispatcherThread.run", (String)"1:769:1.48", (Object)this);
                        if (TraceComponent.isAnyTracingEnabled() && SpillDispatcher.access$300().isEventEnabled()) {
                            SibTr.event((Object)this, (TraceComponent)SpillDispatcher.access$300(), (String)"Unexpected exception caught in SpillDispatcher thread!", (Object)t);
                        }
                        break block59;
                    }
                    finally {
                        dataToWrite = SpillDispatcher.this;
                        synchronized (dataToWrite) {
                            SpillDispatcher.access$510(SpillDispatcher.this);
                            if (!((DispatcherState)SpillDispatcher.access$700((SpillDispatcher)SpillDispatcher.this).get()).isStopRequested && SpillDispatcher.access$600(SpillDispatcher.this) != null) {
                                SpillDispatcher.access$600(SpillDispatcher.this).reportLocalError();
                            }
                            if (SpillDispatcher.access$500(SpillDispatcher.this) == 0) {
                                StateUtils.updateState(SpillDispatcher.access$700(SpillDispatcher.this), DispatcherState.updaterForStopped);
                            }
                        }
                    }
                }
                if (TraceComponent.isAnyTracingEnabled() && SpillDispatcher.access$300().isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)SpillDispatcher.access$300(), (String)"run");
                }
                if (SpillDispatcher.access$600(SpillDispatcher.this) != null && SpillDispatcher.access$600(SpillDispatcher.this)._getMessagingEngine() != null) {
                    SibTr.pop();
                }
                return;
lbl37:
                // 2 sources

                while (!dataToWrite && !stopNow) {
                    var4_7 = this._dispatchingLock;
                    synchronized (var4_7) {
                        this.promoteWaiters();
                        batch = this.buildBatch();
                        v0 = dataToWrite = batch.isEmpty() == false;
                        if (!dataToWrite) {
                            this._threadActive = false;
                            try {
                                if (TraceComponent.isAnyTracingEnabled() && SpillDispatcher.access$300().isDebugEnabled()) {
                                    SibTr.debug((Object)this, (TraceComponent)SpillDispatcher.access$300(), (String)"Spill dispatcher started indefinite wait", (Object)this);
                                }
                                this._dispatchingLock.wait(0L);
                                if (TraceComponent.isAnyTracingEnabled() && SpillDispatcher.access$300().isDebugEnabled()) {
                                    SibTr.debug((Object)this, (TraceComponent)SpillDispatcher.access$300(), (String)"Spill dispatcher completed wait", (Object)this);
                                }
                            }
                            catch (InterruptedException var5_10) {
                            }
                            finally {
                                this._threadActive = true;
                                this._notifyOutstanding = false;
                            }
                        }
                    }
                    var4_7 = SpillDispatcher.this;
                    synchronized (var4_7) {
                        stopNow = ((DispatcherState)SpillDispatcher.access$700((SpillDispatcher)SpillDispatcher.this).get()).isStopRequested;
                    }
                }
                if (!stopNow && this._writeErrorOccurred && this._consecutiveWriteErrors > 1) {
                    var4_7 = this._dispatchingLock;
                    synchronized (var4_7) {
                        this._interruptible = true;
                        ** if (!TraceComponent.isAnyTracingEnabled() || !SpillDispatcher.access$300().isDebugEnabled()) goto lbl69
                    }
lbl-1000:
                    // 1 sources

                    {
                        SibTr.debug((Object)this, (TraceComponent)SpillDispatcher.access$300(), (String)("Dispatcher started retry wait of " + this._writeErrorRetryDelay + " ms"), (Object)this);
                    }
lbl69:
                    // 2 sources

                    try {
                        Thread.sleep(this._writeErrorRetryDelay);
                        if (TraceComponent.isAnyTracingEnabled() && SpillDispatcher.access$300().isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)SpillDispatcher.access$300(), (String)"Dispatcher completed wait", (Object)this);
                        }
                    }
                    catch (InterruptedException ie) {
                        if (TraceComponent.isAnyTracingEnabled() && SpillDispatcher.access$300().isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)SpillDispatcher.access$300(), (String)"Dispatcher interrupted during wait", (Object)this);
                        }
                    }
                    finally {
                        ie = this._dispatchingLock;
                        synchronized (ie) {
                            this._interruptible = false;
                        }
                    }
                }
                if (stopNow || !dataToWrite) ** GOTO lbl-1000
                normalCompletion = false;
                try {
                    if (this.writeBatch(batch)) {
                        this.batchCompleted(batch);
                        dataToWrite = false;
                        if (this._writeErrorOccurred) {
                            this._consecutiveWriteErrors = 0;
                            ++this._goodWritesSinceLastError;
                            if (this._goodWritesSinceLastError > SpillDispatcher.this._writesToResetErrorState) {
                                if (TraceComponent.isAnyTracingEnabled() && SpillDispatcher.access$300().isDebugEnabled()) {
                                    SibTr.debug((Object)this, (TraceComponent)SpillDispatcher.access$300(), (String)"Good write threshold passed. Re-enabling batch mode.");
                                }
                                this._writeErrorOccurred = false;
                                if (this._isContributingToThreadWriteErrors) {
                                    this._isContributingToThreadWriteErrors = false;
                                    SpillDispatcher.this.threadWriteErrorCleared(this._threadNum);
                                }
                            }
                        }
                    }
                    normalCompletion = true;
                    if (!dataToWrite) ** GOTO lbl-1000
                }
                catch (Throwable var15_15) {}
                if (dataToWrite) {
                    numOfCancelled = this.batchCancelled(batch);
                    this.handleWriteError(normalCompletion == false, batch.size() - numOfCancelled);
                }
                throw var15_15;
                numOfCancelled = this.batchCancelled(batch);
                this.handleWriteError(normalCompletion == false, batch.size() - numOfCancelled);
                ** continue;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void cleanup() {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"cleanup");
            }
            DispatchingLock dispatchingLock = this._dispatchingLock;
            synchronized (dispatchingLock) {
                for (QueueElement qe : this._waitingQueue) {
                    qe.notifyDispatch();
                }
                this._waitingQueue.clear();
                if (this.isInterruptible()) {
                    SpillDispatcher.this._threads[this._threadNum].interrupt();
                }
                this._dispatchingLock.notify();
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"cleanup");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean addTask(Task newTask, long dispatchTime, DispatchNotifier dn) throws SevereMessageStoreException {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"addTask", (Object)new Object[]{newTask, dispatchTime, dn});
            }
            boolean callerMustWait = false;
            QueueElement newElement = new QueueElement(newTask, dn);
            int bytesForTask = newElement.getDataSize();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("bytesForTask=" + bytesForTask));
            }
            int skipCount = 0;
            int skipBytes = 0;
            DispatchingLock dispatchingLock = this._dispatchingLock;
            synchronized (dispatchingLock) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("_dispatchAddingQueue.size()=" + this._dispatchAddingQueue.size()));
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("_dispatchUpdateQueue.size()=" + this._dispatchUpdateQueue.size()));
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("_dispatchRemoveQueue.size()=" + this._dispatchRemoveQueue.size()));
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("_waitingQueue.size()=" + this._waitingQueue.size()));
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("_dispatchedBytes=" + this._dispatchedBytes));
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("_maxDispatchedBytesPerThread=" + SpillDispatcher.this._maxDispatchedBytesPerThread));
                }
                boolean cancelled = false;
                if (!newElement.isDelete()) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"New task is NOT a delete. SKIPPING cancellation.");
                    }
                } else {
                    AbstractItemLink currentLink;
                    Task currentTask;
                    QueueElement currentElement;
                    Object currentLink2;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"New task IS a delete. ATTEMPTING cancellation.");
                    }
                    boolean foundMatchingAdd = false;
                    boolean outstandingOperationsToCancel = true;
                    if (((Tuple)newTask.getPersistable()).persistableOperationsOutstanding() == 1) {
                        outstandingOperationsToCancel = false;
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)"No outstanding operations. STOPPING cancellation.");
                        }
                    }
                    if (outstandingOperationsToCancel && !((Tuple)newTask.getPersistable()).persistableRepresentationWasCreated()) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)"Searching the ADDING queue.");
                        }
                        boolean addAlreadyBatched = false;
                        Iterator it = this._dispatchAddingQueue.iterator();
                        while (!addAlreadyBatched && !foundMatchingAdd && it.hasNext()) {
                            QueueElement currentElement2 = (QueueElement)it.next();
                            Task currentTask2 = currentElement2.getTask();
                            currentLink2 = currentTask2.getLink();
                            if (!currentElement2.isBatched()) {
                                QueueElement queueElement = currentElement2;
                                synchronized (queueElement) {
                                    if (!currentElement2.isBatched()) {
                                        if (currentLink2 != null && currentLink2 == newTask.getLink() && ((AbstractItemLink)currentLink2).isRemoving() && !((Tuple)currentTask2.getPersistable()).persistableRepresentationWasCreated()) {
                                            it.remove();
                                            int currentBytes = currentElement2.getDataSize();
                                            this._dispatchedBytes -= (long)currentBytes;
                                            ((Tuple)currentTask2.getPersistable()).persistableOperationCancelled();
                                            if (((Tuple)newTask.getPersistable()).persistableOperationsOutstanding() == 1) {
                                                outstandingOperationsToCancel = false;
                                            }
                                            currentElement2.setCancelled();
                                            foundMatchingAdd = true;
                                            ++skipCount;
                                            skipBytes += currentBytes;
                                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Task matched and removed from ADDING queue: New Task: " + newTask + ", Cancelled Task: " + currentTask2));
                                            }
                                        }
                                    } else if (newTask.getLink() == currentLink2) {
                                        addAlreadyBatched = true;
                                    }
                                    continue;
                                }
                            }
                            if (newTask.getLink() != currentLink2) continue;
                            addAlreadyBatched = true;
                        }
                    }
                    if (outstandingOperationsToCancel && !this._dispatchUpdateQueue.isEmpty()) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)"Searching the UPDATE queue.");
                        }
                        Iterator it = this._dispatchUpdateQueue.iterator();
                        while (outstandingOperationsToCancel && it.hasNext()) {
                            currentElement = (QueueElement)it.next();
                            currentTask = currentElement.getTask();
                            currentLink = currentTask.getLink();
                            if (!currentElement.isBatched()) {
                                currentLink2 = currentElement;
                                synchronized (currentLink2) {
                                    if (!currentElement.isBatched()) {
                                        if (currentLink != null && currentLink == newTask.getLink() && currentLink.isRemoving()) {
                                            it.remove();
                                            int currentBytes = currentElement.getDataSize();
                                            this._dispatchedBytes -= (long)currentBytes;
                                            ((Tuple)currentTask.getPersistable()).persistableOperationCancelled();
                                            if (((Tuple)newTask.getPersistable()).persistableOperationsOutstanding() == 1) {
                                                outstandingOperationsToCancel = false;
                                            }
                                            currentElement.setCancelled();
                                            ++skipCount;
                                            skipBytes += currentBytes;
                                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Task matched and removed from UPDATE queue: New Task: " + newTask + ", Cancelled Task: " + currentTask));
                                            }
                                        }
                                    } else if (newTask.getLink() == currentLink && foundMatchingAdd) {
                                        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                                            SibTr.event((Object)this, (TraceComponent)tc, (String)"Update task batched after cancellation of add!");
                                        }
                                        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                                            SibTr.exit((Object)this, (TraceComponent)tc, (String)"addTask");
                                        }
                                        throw new SevereMessageStoreException("Update task batched after cancellation of add!");
                                    }
                                    continue;
                                }
                            }
                            if (newTask.getLink() != currentLink || !foundMatchingAdd) continue;
                            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                                SibTr.event((Object)this, (TraceComponent)tc, (String)"Update task batched after cancellation of add!");
                            }
                            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                                SibTr.exit((Object)this, (TraceComponent)tc, (String)"addTask");
                            }
                            throw new SevereMessageStoreException("Update task batched after cancellation of add!");
                        }
                    }
                    if (outstandingOperationsToCancel && !this._waitingQueue.isEmpty()) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)"Searching the WAITING queue.");
                        }
                        Iterator it = this._waitingQueue.iterator();
                        while (outstandingOperationsToCancel && it.hasNext()) {
                            currentElement = (QueueElement)it.next();
                            currentTask = currentElement.getTask();
                            currentLink = currentTask.getLink();
                            if (currentLink == null || currentLink != newTask.getLink() || !currentLink.isRemoving() || currentTask.isDeleteOfPersistentRepresentation()) continue;
                            it.remove();
                            int currentBytes = currentElement.getDataSize();
                            this._dispatchedBytes -= (long)currentBytes;
                            ((Tuple)currentTask.getPersistable()).persistableOperationCancelled();
                            if (((Tuple)newTask.getPersistable()).persistableOperationsOutstanding() == 1) {
                                outstandingOperationsToCancel = false;
                            }
                            currentElement.notifyDispatch();
                            if (currentElement.isAdd()) {
                                foundMatchingAdd = true;
                            }
                            ++skipCount;
                            skipBytes += currentBytes;
                            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)("Task matched and removed from WAITING queue: New Task: " + newTask + ", Cancelled Task: " + currentTask));
                        }
                    }
                    cancelled = foundMatchingAdd;
                }
                if (!cancelled) {
                    if ((long)bytesForTask >= SpillDispatcher.this._maxBytesPerBatch) {
                        if (newElement.isAdd()) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Adding to FRONT of dispatch ADDING queue");
                            }
                            this._dispatchAddingQueue.addFirst(newElement);
                        } else if (newElement.isUpdate()) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Adding to FRONT of dispatch UPDATE queue");
                            }
                            this._dispatchUpdateQueue.addFirst(newElement);
                        } else if (newElement.isDelete()) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Adding to FRONT of dispatch REMOVE queue");
                            }
                            this._dispatchRemoveQueue.addFirst(newElement);
                        }
                        this._dispatchedBytes += (long)bytesForTask;
                        newElement.notifyDispatch();
                    } else if (newElement.isDelete() || this._waitingQueue.isEmpty() && this._dispatchedBytes + (long)bytesForTask <= SpillDispatcher.this._maxDispatchedBytesPerThread) {
                        if (newElement.isAdd()) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Adding to dispatch ADDING queue");
                            }
                            this._dispatchAddingQueue.add(newElement);
                        } else if (newElement.isUpdate()) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Adding to dispatch UPDATE queue");
                            }
                            this._dispatchUpdateQueue.add(newElement);
                        } else if (newElement.isDelete()) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Adding to dispatch REMOVE queue");
                            }
                            this._dispatchRemoveQueue.add(newElement);
                        }
                        this._dispatchedBytes += (long)bytesForTask;
                        newElement.notifyDispatch();
                    } else {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)"Adding to WAITING queue");
                        }
                        this._waitingQueue.add(newElement);
                        if (this._isContributingToThreadWriteErrors) {
                            newElement.notifyDispatch();
                        } else {
                            callerMustWait = true;
                        }
                    }
                } else {
                    ((Tuple)newTask.getPersistable()).persistableOperationCancelled();
                    newElement.notifyDispatch();
                    ++skipCount;
                    skipBytes += bytesForTask;
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"addTask", (Object)callerMustWait);
            }
            return callerMustWait;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void notifyDispatchArrived() {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"notifyDispatchArrived");
            }
            DispatchingLock dispatchingLock = this._dispatchingLock;
            synchronized (dispatchingLock) {
                int maxTasksInBatch = this._writeErrorOccurred ? 1 : SpillDispatcher.this._maxTasksPerBatch;
                int dispatchAddingQueueSize = this._dispatchAddingQueue.size();
                int dispatchUpdateQueueSize = this._dispatchUpdateQueue.size();
                int dispatchRemoveQueueSize = this._dispatchRemoveQueue.size();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("_notifyOutstanding=" + this._notifyOutstanding));
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("_threadActive=" + this._threadActive));
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("_dispatchAddingQueue.size()=" + dispatchAddingQueueSize));
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("_dispatchUpdateQueue.size()=" + dispatchUpdateQueueSize));
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("_dispatchRemoveQueue.size()=" + dispatchRemoveQueueSize));
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("_waitingQueue.size()=" + this._waitingQueue.size()));
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("maxTasksInBatch=" + maxTasksInBatch));
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("_dispatchedBytes=" + this._dispatchedBytes));
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("_minBytesPerBatch=" + SpillDispatcher.this._minBytesPerBatch));
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("_maxBytesPerBatch=" + SpillDispatcher.this._maxBytesPerBatch));
                }
                if (!(this._notifyOutstanding || this._threadActive || dispatchAddingQueueSize + dispatchUpdateQueueSize + dispatchRemoveQueueSize < maxTasksInBatch && this._dispatchedBytes < SpillDispatcher.this._maxBytesPerBatch && this._waitingQueue.isEmpty())) {
                    this._notifyOutstanding = false;
                    this._dispatchingLock.notify();
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"notifyDispatchArrived");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private LinkedList buildBatch() {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"buildBatch");
            }
            int maxTasksInBatch = this._writeErrorOccurred ? 1 : SpillDispatcher.this._maxTasksPerBatch;
            LinkedList<QueueElement> batch = new LinkedList<QueueElement>();
            int dispatchAddingQueueSize = this._dispatchAddingQueue.size();
            int dispatchUpdateQueueSize = this._dispatchUpdateQueue.size();
            int dispatchRemoveQueueSize = this._dispatchRemoveQueue.size();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("_dispatchAddingQueue.size()=" + dispatchAddingQueueSize));
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("_dispatchUpdateQueue.size()=" + dispatchUpdateQueueSize));
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("_dispatchRemoveQueue.size()=" + dispatchRemoveQueueSize));
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("_waitingQueue.size()=" + this._waitingQueue.size()));
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("maxTasksInBatch=" + maxTasksInBatch));
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("_dispatchedBytes=" + this._dispatchedBytes));
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("_minBytesPerBatch=" + SpillDispatcher.this._minBytesPerBatch));
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("_maxBytesPerBatch=" + SpillDispatcher.this._maxBytesPerBatch));
            }
            if (dispatchAddingQueueSize + dispatchUpdateQueueSize + dispatchRemoveQueueSize >= maxTasksInBatch || this._dispatchedBytes >= SpillDispatcher.this._minBytesPerBatch || !this._waitingQueue.isEmpty()) {
                int numUncancelledTasksInBatch = 0;
                long bytesInBatch = 0L;
                long remainingDispatchedBytes = this._dispatchedBytes;
                boolean moreTasksToAdd = true;
                int dispatchQueuesChecked = 0;
                Iterator it = null;
                if (dispatchRemoveQueueSize > 0) {
                    it = this._dispatchRemoveQueue.iterator();
                } else if (dispatchAddingQueueSize > 0) {
                    it = this._dispatchAddingQueue.iterator();
                    dispatchQueuesChecked = 1;
                } else {
                    it = this._dispatchUpdateQueue.iterator();
                    dispatchQueuesChecked = 2;
                }
                block7: while (moreTasksToAdd && numUncancelledTasksInBatch < maxTasksInBatch && bytesInBatch < SpillDispatcher.this._maxBytesPerBatch) {
                    if (it.hasNext()) {
                        QueueElement qe;
                        QueueElement queueElement = qe = (QueueElement)it.next();
                        synchronized (queueElement) {
                            Task task = qe.getTask();
                            if (!qe.isCancelled()) {
                                if (!qe.isUpdate() || !task.getLink().isRemoving()) {
                                    int bytesForTask = qe.getDataSize();
                                    if ((long)bytesForTask + bytesInBatch >= SpillDispatcher.this._maxBytesPerBatch && numUncancelledTasksInBatch != 0) {
                                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                            SibTr.debug((Object)this, (TraceComponent)tc, (String)"Stopping batch creation as (bytesInBatch + newTask.size) > maxBytesPerBatch");
                                        }
                                        break;
                                    }
                                    if (remainingDispatchedBytes < SpillDispatcher.this._minBytesPerBatch) {
                                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                            SibTr.debug((Object)this, (TraceComponent)tc, (String)"Stopping batch creation as dispatchedBytes < minBytesPerBatch");
                                        }
                                        break;
                                    }
                                    bytesInBatch += (long)bytesForTask;
                                    ++numUncancelledTasksInBatch;
                                    remainingDispatchedBytes -= (long)bytesForTask;
                                    qe.setBatched(true);
                                    batch.add(qe);
                                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                        SibTr.debug((Object)this, (TraceComponent)tc, (String)("Task added to batch: " + task));
                                    }
                                } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("Task skipped as it is a candidate for cancellation: " + task));
                                }
                            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Task cancelled from under us: " + task));
                            }
                            continue;
                        }
                    }
                    switch (dispatchQueuesChecked) {
                        case 0: {
                            moreTasksToAdd = false;
                            continue block7;
                        }
                        case 1: {
                            it = this._dispatchUpdateQueue.iterator();
                            dispatchQueuesChecked = 2;
                            continue block7;
                        }
                    }
                    moreTasksToAdd = false;
                }
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"No batch built");
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"buildBatch", (Object)batch.size());
            }
            return batch;
        }

        /*
         * Unable to fully structure code
         */
        private boolean writeBatch(LinkedList batch) throws SevereMessageStoreException {
            if (TraceComponent.isAnyTracingEnabled() && SpillDispatcher.access$300().isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)SpillDispatcher.access$300(), (String)"writeBatch", (Object)batch.size());
            }
            batchWritten = false;
            batchingContext = null;
            skipCount = 0;
            skipBytes = 0;
            for (QueueElement qe : batch) {
                task = qe.getTask();
                if (qe.isDelete() && !((Tuple)task.getPersistable()).persistableRepresentationWasCreated()) {
                    qe.setCancelled();
                }
                try {
                    task.ensureDataAvailable();
                }
                catch (PersistentDataEncodingException pdee) {
                    if (TraceComponent.isAnyTracingEnabled() && SpillDispatcher.access$300().isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)SpillDispatcher.access$300(), (String)"ensureDataAvailable encountered item which couldn't encode");
                    }
                    qe.setCancelled();
                }
                catch (SevereMessageStoreException smse) {
                    if (TraceComponent.isAnyTracingEnabled() && SpillDispatcher.access$300().isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)SpillDispatcher.access$300(), (String)"ensureDataAvailable encountered item not in store");
                    }
                    qe.setCancelled();
                }
                if (!qe.isCancelled()) {
                    if (batchingContext == null) {
                        batchingContext = SpillDispatcher.access$1300(SpillDispatcher.this).createBatchingContext();
                    }
                    task.persist(batchingContext, TransactionState.STATE_COMMITTED);
                }
                if (!qe.isCancelled()) continue;
                ++skipCount;
                skipBytes += qe.getDataSize();
            }
            if (batchingContext != null) {
                try {
                    batchingContext.executeBatch();
                    batchWritten = true;
                }
                catch (SeverePersistenceException spe) {
                    FFDCFilter.processException((Throwable)spe, (String)"com.ibm.ws.sib.msgstore.persistence.impl.SpillDispatcher.writeBatch", (String)"1:1757:1.48", (Object)this);
                    if (TraceComponent.isAnyTracingEnabled() && SpillDispatcher.access$300().isEventEnabled()) {
                        SibTr.event((Object)this, (TraceComponent)SpillDispatcher.access$300(), (String)"Exception persisting batch", (Object)spe);
                    }
                    throw new SevereMessageStoreException((Throwable)spe);
                }
                catch (PersistenceException pe) {
                    FFDCFilter.processException((Throwable)pe, (String)"com.ibm.ws.sib.msgstore.persistence.impl.SpillDispatcher.writeBatch", (String)"1:1766:1.48", (Object)this);
                    if (!TraceComponent.isAnyTracingEnabled() || !SpillDispatcher.access$300().isEventEnabled()) ** GOTO lbl47
                    SibTr.event((Object)this, (TraceComponent)SpillDispatcher.access$300(), (String)"Exception persisting batch", (Object)pe);
                }
            } else {
                batchWritten = true;
            }
lbl47:
            // 4 sources

            if (TraceComponent.isAnyTracingEnabled() && SpillDispatcher.access$300().isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)SpillDispatcher.access$300(), (String)"writeBatch", (Object)batchWritten);
            }
            return batchWritten;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void batchCompleted(LinkedList batch) throws SevereMessageStoreException {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"batchCompleted");
            }
            int batchSize = batch.size();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("batchSize=" + batchSize));
            }
            if (batchSize > 0) {
                Iterator it = batch.iterator();
                DispatchingLock dispatchingLock = this._dispatchingLock;
                synchronized (dispatchingLock) {
                    while (it.hasNext()) {
                        QueueElement qeTemp;
                        QueueElement qe = (QueueElement)it.next();
                        if (qe.isCancelled()) {
                            ((Tuple)qe.getTask().getPersistable()).persistableOperationCancelled();
                        } else {
                            ((Tuple)qe.getTask().getPersistable()).persistableOperationCompleted();
                        }
                        if (qe.isAdd()) {
                            qeTemp = (QueueElement)this._dispatchAddingQueue.remove(0);
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Task removed from ADDING queue after batch completion: " + qeTemp.getTask()));
                            }
                        } else if (qe.isUpdate()) {
                            this._dispatchUpdateQueue.remove(qe);
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Task removed from UPDATE queue after batch completion: " + qe.getTask()));
                            }
                        } else if (qe.isDelete()) {
                            qeTemp = (QueueElement)this._dispatchRemoveQueue.remove(0);
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Task removed from REMOVE queue after batch completion: " + qeTemp.getTask()));
                            }
                        }
                        this._dispatchedBytes -= (long)qe.getDataSize();
                    }
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"batchCompleted");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int batchCancelled(LinkedList batch) throws SevereMessageStoreException {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"batchCancelled");
            }
            int batchSize = batch.size();
            int cancelledTasks = 0;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("batchSize=" + batchSize));
            }
            if (batchSize > 0) {
                Iterator it = batch.iterator();
                DispatchingLock dispatchingLock = this._dispatchingLock;
                synchronized (dispatchingLock) {
                    while (it.hasNext()) {
                        QueueElement qe = (QueueElement)it.next();
                        if (!qe.isCancelled()) continue;
                        ((Tuple)qe.getTask().getPersistable()).persistableOperationCancelled();
                        if (qe.isAdd()) {
                            if (this._dispatchAddingQueue.remove(qe)) {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Cancelled element removed from ADDING queue.");
                                }
                            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Cancelled element not found in ADDING queue!");
                            }
                        } else if (qe.isUpdate()) {
                            if (this._dispatchUpdateQueue.remove(qe)) {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Cancelled element removed from UPDATE queue.");
                                }
                            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Cancelled element not found in UPDATE queue!");
                            }
                        } else if (qe.isDelete()) {
                            if (this._dispatchRemoveQueue.remove(qe)) {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Cancelled element removed from REMOVE queue.");
                                }
                            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Cancelled element not found in REMOVE queue!");
                            }
                        }
                        this._dispatchedBytes -= (long)qe.getDataSize();
                        ++cancelledTasks;
                    }
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"batchCancelled", (Object)cancelledTasks);
            }
            return cancelledTasks;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleWriteError(boolean fatalError, int batchSize) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"handleWriteError", (Object)new Object[]{fatalError, new Integer(batchSize)});
            }
            boolean repeatedError = false;
            if (!this._writeErrorOccurred || this._consecutiveWriteErrors == 0) {
                this._writeErrorOccurred = true;
                this._goodWritesSinceLastError = 0;
                this._consecutiveWriteErrors = 1;
                SpillDispatcher.this._writesToResetErrorState = batchSize;
                this._writeErrorRetryDelay = 1L;
            } else {
                repeatedError = true;
            }
            if (fatalError || repeatedError) {
                if (!this._isContributingToThreadWriteErrors) {
                    this._isContributingToThreadWriteErrors = true;
                    SpillDispatcher.this.threadWriteErrorOccurred(this._threadNum);
                }
                ++this._consecutiveWriteErrors;
                this._writeErrorRetryDelay = 5000 * (this._consecutiveWriteErrors > 5 ? 5 : this._consecutiveWriteErrors);
                DispatchingLock dispatchingLock = this._dispatchingLock;
                synchronized (dispatchingLock) {
                    for (QueueElement qe : this._waitingQueue) {
                        qe.notifyDispatch();
                    }
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"handleWriteError");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void promoteWaiters() {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"promoteWaiters");
            }
            DispatchingLock dispatchingLock = this._dispatchingLock;
            synchronized (dispatchingLock) {
                if (!this._waitingQueue.isEmpty() && this._dispatchedBytes < SpillDispatcher.this._maxDispatchedBytesPerThread) {
                    Iterator it = this._waitingQueue.iterator();
                    while (it.hasNext()) {
                        QueueElement qe = (QueueElement)it.next();
                        if (this._dispatchedBytes >= SpillDispatcher.this._minBytesPerBatch && this._dispatchedBytes + (long)qe.getDataSize() > SpillDispatcher.this._maxDispatchedBytesPerThread) break;
                        qe.notifyDispatch();
                        it.remove();
                        if (qe.isAdd()) {
                            this._dispatchAddingQueue.add(qe);
                        } else if (qe.isUpdate()) {
                            this._dispatchUpdateQueue.add(qe);
                        } else if (qe.isDelete()) {
                            this._dispatchRemoveQueue.add(qe);
                        }
                        this._dispatchedBytes += (long)qe.getDataSize();
                    }
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"promoteWaiters");
            }
        }

        public boolean isInterruptible() {
            return this._interruptible;
        }

        public String toString() {
            return this._threadName;
        }
    }

    private static class QueueElement {
        private Task _task;
        private int _dataSize;
        private DispatchNotifier _waiter;
        private boolean _notified;
        private boolean _cancelled;
        private boolean _batched;
        private boolean _isAdd;
        private boolean _isDelete;

        public QueueElement(Task task, DispatchNotifier waiter) {
            this._task = task;
            this._dataSize = task.getPersistableInMemorySizeApproximation(TransactionState.STATE_COMMITTED);
            this._waiter = waiter;
            this._isAdd = this._task.isCreateOfPersistentRepresentation();
            this._isDelete = this._task.isDeleteOfPersistentRepresentation();
        }

        public Task getTask() {
            return this._task;
        }

        public int getDataSize() {
            return this._dataSize;
        }

        public void setCancelled() {
            this._cancelled = true;
        }

        public boolean isCancelled() {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("isCancelled=" + this._cancelled));
            }
            return this._cancelled;
        }

        public void setBatched(boolean batched) {
            this._batched = batched;
        }

        public boolean isBatched() {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("isBatched=" + this._batched));
            }
            return this._batched;
        }

        public final boolean isAdd() {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("isAdd=" + this._isAdd));
            }
            return this._isAdd;
        }

        public final boolean isUpdate() {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("isUpdate=" + (!this._isAdd && !this._isDelete)));
            }
            return !this._isAdd && !this._isDelete;
        }

        public final boolean isDelete() {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("isDelete=" + this._isDelete));
            }
            return this._isDelete;
        }

        public void notifyDispatch() {
            if (!this._notified) {
                this._notified = true;
                this._waiter.notifyDispatch();
            }
        }
    }

    private static final class DispatchingLock {
        private DispatchingLock() {
        }
    }
}

