/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.ra.inbound.impl;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.ra.impl.SibRaUtils;
import com.ibm.ws.sib.ra.inbound.impl.SibRaDispatcher;
import com.ibm.ws.sib.ra.inbound.impl.SibRaEndpointActivation;
import com.ibm.ws.sib.ra.inbound.impl.SibRaMessagingEngineConnection;
import com.ibm.ws.sib.ra.inbound.impl.SibRaStringGenerator;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.AbstractConsumerSession;
import com.ibm.wsspi.sib.core.SIBusMessage;
import com.ibm.wsspi.sib.core.SIMessageHandle;
import com.ibm.wsspi.sib.core.SITransaction;
import com.ibm.wsspi.sib.core.SIUncoordinatedTransaction;
import jakarta.resource.ResourceException;
import jakarta.resource.spi.UnavailableException;
import jakarta.resource.spi.endpoint.MessageEndpoint;
import java.util.ArrayList;
import java.util.List;

class SibRaNonTransactionalDispatcher
extends SibRaDispatcher {
    private final List _unsuccessfulMessages = new ArrayList();
    private static final TraceComponent TRACE = SibRaUtils.getTraceComponent(SibRaNonTransactionalDispatcher.class);
    private static final String CLASS_NAME = SibRaNonTransactionalDispatcher.class.getName();
    private static final String FFDC_PROBE_1 = "1";
    private static final String FFDC_PROBE_2 = "2";

    SibRaNonTransactionalDispatcher(SibRaMessagingEngineConnection connection, AbstractConsumerSession session, SibRaEndpointActivation endpointActivation, Reliability unrecoveredReliability, int maxFailedDeliveries, int sequentialFailureThreshold) throws ResourceException {
        super(connection, session, endpointActivation, unrecoveredReliability, maxFailedDeliveries, sequentialFailureThreshold);
        String methodName = "SibRaNonTransactionalDispatcher";
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"SibRaNonTransactionalDispatcher", (Object)new Object[]{connection, session, endpointActivation});
        }
        boolean bl = this._deleteUnrecoverableMessages = !endpointActivation.isEndpointMethodTransactional();
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"SibRaNonTransactionalDispatcher");
        }
    }

    @Override
    protected SITransaction getTransaction() {
        if (TRACE.isEntryEnabled()) {
            String methodName = "getTransaction";
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"getTransaction");
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"getTransaction", null);
        }
        return null;
    }

    @Override
    protected final MessageEndpoint createEndpoint() throws UnavailableException {
        String methodName = "createEndpoint";
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"createEndpoint");
        }
        MessageEndpoint endpoint = this._endpointFactory.createEndpoint(null);
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"createEndpoint", (Object)endpoint);
        }
        return endpoint;
    }

    @Override
    protected final void beforeDelivery(SIBusMessage message, MessageEndpoint endpoint) {
        if (TRACE.isEntryEnabled()) {
            String methodName = "beforeDelivery";
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"beforeDelivery", (Object)new Object[]{message, endpoint});
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"beforeDelivery");
        }
    }

    @Override
    protected final void beforeDelivery(MessageEndpoint endpoint) {
        if (TRACE.isEntryEnabled()) {
            String methodName = "beforeDelivery";
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"beforeDelivery", (Object)endpoint);
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"beforeDelivery");
        }
    }

    @Override
    protected void afterDelivery(SIBusMessage message, MessageEndpoint endpoint, boolean success) throws ResourceException {
        String methodName = "afterDelivery";
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"afterDelivery", (Object)new Object[]{message, success});
        }
        if (!success && this.processMessage(message)) {
            this._unsuccessfulMessages.add(message);
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"afterDelivery");
        }
    }

    @Override
    protected void cleanup() {
        String methodName = "cleanup";
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"cleanup");
        }
        if (this._unsuccessfulMessages.size() > 0) {
            try {
                try {
                    SIUncoordinatedTransaction localTran = this._connection.createUncoordinatedTransaction();
                    this.deleteMessages(SibRaNonTransactionalDispatcher.getMessageHandles(this._unsuccessfulMessages), (SITransaction)localTran);
                    localTran.rollback();
                }
                catch (SIException ex) {
                    FFDCFilter.processException((Throwable)ex, (String)(CLASS_NAME + "." + "cleanup"), (String)FFDC_PROBE_2, (Object)this);
                    if (TRACE.isEventEnabled()) {
                        SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)ex));
                    }
                }
            }
            catch (ResourceException exception) {
                FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + "." + "cleanup"), (String)FFDC_PROBE_1, (Object)this);
                if (TRACE.isEventEnabled()) {
                    SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)exception));
                }
            }
            finally {
                this._unsuccessfulMessages.clear();
            }
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"cleanup");
        }
    }

    protected boolean processMessage(SIBusMessage message) {
        Reliability preInvokeMessageReliability = (Reliability)this._reliabilityPreInvoke.get(message.getMessageHandle());
        boolean canDeleteMessage = preInvokeMessageReliability != null ? this._unrecoverableReliability.compareTo((Object)preInvokeMessageReliability) >= 0 : this._unrecoverableReliability.compareTo((Object)message.getReliability()) >= 0;
        return !this._deleteUnrecoverableMessages || !canDeleteMessage;
    }

    @Override
    protected SibRaStringGenerator getStringGenerator() {
        SibRaStringGenerator generator = super.getStringGenerator();
        generator.addField("unsuccessfulMessages", this._unsuccessfulMessages);
        return generator;
    }

    @Override
    SIBusMessage readMessage(SIMessageHandle handle) {
        return null;
    }
}

