/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jca.inbound.security;

import com.ibm.ws.jca.inbound.security.SecurityInflowContext;
import com.ibm.ws.security.authentication.AuthenticationService;
import com.ibm.ws.security.authentication.UnauthenticatedSubjectService;
import com.ibm.ws.security.credentials.CredentialsService;
import com.ibm.ws.security.intfc.WSSecurityService;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.threadcontext.ThreadContext;
import com.ibm.wsspi.threadcontext.ThreadContextDeserializationInfo;
import com.ibm.wsspi.threadcontext.ThreadContextProvider;
import com.ibm.wsspi.threadcontext.jca.JCAContextProvider;
import jakarta.resource.spi.work.SecurityContext;
import java.io.IOException;
import java.io.NotSerializableException;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;

public class SecurityInflowContextProviderImpl
implements JCAContextProvider,
ThreadContextProvider {
    final AtomicServiceReference<Object> securityServiceRef = new AtomicServiceReference("securityService");
    final AtomicServiceReference<Object> unauthSubjectServiceRef = new AtomicServiceReference("unauthenticatedSubjectService");
    final AtomicServiceReference<Object> authServiceRef = new AtomicServiceReference("authenticationService");
    final AtomicServiceReference<Object> credServiceRef = new AtomicServiceReference("credentialsService");

    protected void activate(ComponentContext context) {
        this.securityServiceRef.activate(context);
        this.unauthSubjectServiceRef.activate(context);
        this.authServiceRef.activate(context);
        this.credServiceRef.activate(context);
    }

    protected void deactivate(ComponentContext context) {
        this.securityServiceRef.deactivate(context);
        this.unauthSubjectServiceRef.deactivate(context);
        this.authServiceRef.deactivate(context);
        this.credServiceRef.deactivate(context);
    }

    public ThreadContext getInflowContext(Object workContext, Map<String, String> execProps) {
        CredentialsService credService = (CredentialsService)this.credServiceRef.getServiceWithException();
        WSSecurityService wss = (WSSecurityService)this.securityServiceRef.getServiceWithException();
        UnauthenticatedSubjectService unauthSubjService = (UnauthenticatedSubjectService)this.unauthSubjectServiceRef.getServiceWithException();
        AuthenticationService authService = (AuthenticationService)this.authServiceRef.getServiceWithException();
        return new SecurityInflowContext(credService, wss, unauthSubjService, authService, workContext, execProps.get("com.ibm.ws.concurrent.TASK_OWNER"));
    }

    public ThreadContext captureThreadContext(Map<String, String> execProps, Map<String, ?> threadContextConfig) {
        throw new UnsupportedOperationException("captureThreadContext");
    }

    public ThreadContext deserializeThreadContext(ThreadContextDeserializationInfo info, byte[] bytes) throws ClassNotFoundException, IOException {
        throw new NotSerializableException();
    }

    public ThreadContext createDefaultThreadContext(Map<String, String> execProps) {
        String identityName = execProps.get("com.ibm.ws.concurrent.TASK_OWNER");
        SecurityContext defaultCtx = new SecurityContext(){
            private static final long serialVersionUID = 1924323423421234352L;

            public void setupSecurityContext(CallbackHandler arg0, Subject arg1, Subject arg2) {
            }
        };
        CredentialsService credService = (CredentialsService)this.credServiceRef.getServiceWithException();
        WSSecurityService wss = (WSSecurityService)this.securityServiceRef.getServiceWithException();
        UnauthenticatedSubjectService unauthSubjService = (UnauthenticatedSubjectService)this.unauthSubjectServiceRef.getServiceWithException();
        AuthenticationService authService = (AuthenticationService)this.authServiceRef.getServiceWithException();
        return new SecurityInflowContext(credService, wss, unauthSubjService, authService, defaultCtx, identityName);
    }

    public List<ThreadContextProvider> getPrerequisites() {
        return null;
    }

    protected void setAuthenticationService(ServiceReference<Object> ref) {
        this.authServiceRef.setReference(ref);
    }

    protected void unsetAuthenticationService(ServiceReference<Object> ref) {
        this.authServiceRef.unsetReference(ref);
    }

    protected void setUnauthenticatedSubjectService(ServiceReference<Object> ref) {
        this.unauthSubjectServiceRef.setReference(ref);
    }

    protected void unsetUnauthenticatedSubjectService(ServiceReference<Object> ref) {
        this.unauthSubjectServiceRef.unsetReference(ref);
    }

    protected void setSecurityService(ServiceReference<Object> ref) {
        this.securityServiceRef.setReference(ref);
    }

    protected void unsetSecurityService(ServiceReference<Object> ref) {
        this.securityServiceRef.unsetReference(ref);
    }

    protected void setCredentialsService(ServiceReference<Object> ref) {
        this.credServiceRef.setReference(ref);
    }

    protected void unsetCredentialsService(ServiceReference<Object> ref) {
        this.credServiceRef.unsetReference(ref);
    }
}

