/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.j2c;

import com.ibm.ejs.cm.logger.TraceWriter;
import com.ibm.ejs.j2c.CommonFunction;
import com.ibm.ejs.j2c.ConnectionManager;
import com.ibm.ejs.j2c.ConnectorServiceImpl;
import com.ibm.ejs.j2c.FreePool;
import com.ibm.ejs.j2c.J2CGlobalConfigProperties;
import com.ibm.ejs.j2c.MCWrapper;
import com.ibm.ejs.j2c.MCWrapperList;
import com.ibm.ejs.j2c.SharedPool;
import com.ibm.ejs.j2c.TaskTimerMaxInUseTime;
import com.ibm.ejs.j2c.TaskTimerReaperThread;
import com.ibm.ejs.j2c.ThreadSupportedCleanupAndDestroy;
import com.ibm.ejs.ras.RasHelper;
import com.ibm.websphere.ce.j2c.ConnectionWaitTimeoutException;
import com.ibm.websphere.jca.pmi.JCAPMIHelper;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jca.adapter.PurgePolicy;
import com.ibm.ws.jca.adapter.WSManagedConnection;
import com.ibm.ws.jca.adapter.WSManagedConnectionFactory;
import com.ibm.ws.jca.cm.AbstractConnectionFactoryService;
import com.ibm.ws.resource.ResourceRefInfo;
import com.ibm.ws.util.WSThreadLocal;
import jakarta.resource.ResourceException;
import jakarta.resource.spi.ConnectionRequestInfo;
import jakarta.resource.spi.ManagedConnection;
import jakarta.resource.spi.ManagedConnectionFactory;
import jakarta.resource.spi.ResourceAllocationException;
import jakarta.resource.spi.ValidatingManagedConnectionFactory;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.PrintWriter;
import java.io.Writer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.security.auth.Subject;

public final class PoolManager
implements Runnable,
PropertyChangeListener,
VetoableChangeListener,
JCAPMIHelper {
    private static final TraceComponent tc = Tr.register(PoolManager.class, (String)"WAS.j2c", (String)"com.ibm.ws.j2c.resources.J2CAMessages");
    protected static final String alertResourceBundleName = "com.ibm.ws.j2c.resources.J2CAMessages";
    final String nl = CommonFunction.nl;
    final ConnectorServiceImpl connectorSvc;
    protected J2CGlobalConfigProperties gConfigProps;
    protected boolean reaperThreadStarted = false;
    private final Object taskTimerLockObject = new PoolManagerLock();
    protected int waitSkip = 0;
    protected boolean displayInfiniteWaitMessage;
    protected final ConcurrentHashMap<com.ibm.ws.j2c.MCWrapper, ArrayList<com.ibm.ws.j2c.MCWrapper>> tlsArrayLists = new ConcurrentHashMap();
    private SharedPool[] sharedPool;
    protected FreePool[] freePool;
    protected final MCWrapperList mcWrapperWaiterList;
    protected final HashMap<ManagedConnection, com.ibm.ws.j2c.MCWrapper> mcToMCWMap;
    private final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
    private final Lock mcToMCWMapRead = this.rwl.readLock();
    final Lock mcToMCWMapWrite = this.rwl.writeLock();
    private ClassLoader raClassLoader;
    protected final Object pmCounterLock = new PoolManagerLock();
    protected final Object destroyMCWrapperListLock = new PoolManagerLock();
    protected final AtomicInteger totalConnectionCount = new AtomicInteger(0);
    protected final Object poolManagerBalancePoolLock = new PoolManagerLock();
    protected final Object waiterFreePoolLock = new PoolManagerLock();
    protected int waiterCount = 0;
    protected boolean allowConnectionRequests = true;
    private boolean connectionPoolShutDown = false;
    protected final Object poolManagerTestConnectionLock = new PoolManagerLock();
    private int collectorCount = 0;
    private final ArrayList<com.ibm.ws.j2c.MCWrapper> mcWrappersToDestroy = new ArrayList(50);
    private static final boolean mcWrapperDoesExistInFreePool = true;
    private static final boolean synchronizedAllReady = false;
    private static final boolean dontNotifyWaiter = true;
    private static final boolean dontDecrementTotalCounter = false;
    protected boolean unusedTimeoutEnabled = false;
    protected int connectionTimeout = 0;
    protected int maxConnections = 0;
    protected int minConnections = 0;
    protected PurgePolicy purgePolicy = null;
    protected int reapTime = 0;
    private int unusedTimeout = 0;
    protected int agedTimeout = 0;
    protected long agedTimeoutMillis = 0L;
    protected int holdTimeLimit = 10;
    protected int maxSharedBuckets = 0;
    protected int maxFreePoolHashSize = 0;
    protected int maxNumberOfMCsAllowableInThread = 0;
    protected boolean throwExceptionOnMCThreadCheck = false;
    protected long waitersStartedTime;
    protected long waitersEndedTime;
    protected com.ibm.ws.j2c.MCWrapper parkedMCWrapper = null;
    protected boolean createParkedConnection;
    protected final Object parkedConnectionLockObject = new PoolManagerLock();
    protected int totalPoolConnectionRequests = 0;
    protected ScheduledFuture<?> am = null;
    protected final Object amLockObject = new PoolManagerLock();
    private boolean pmQuiesced = false;
    protected final AtomicInteger activeRequest = new AtomicInteger(0);
    protected final Object updateToPoolInProgressLockObject = new PoolManagerLock();
    protected boolean updateToPoolInProgress = false;
    protected int updateToPoolInProgressSleepTime = 250;
    protected final AtomicInteger activeTLSRequest = new AtomicInteger(0);
    protected final Object updateToTLSPoolInProgressLockObject = new PoolManagerLock();
    protected final AtomicBoolean updateToTLSPoolInProgress = new AtomicBoolean(false);
    protected int updateToTLSPoolInProgressSleepTime = 250;
    protected Writer writer = null;
    protected TraceWriter traceWriter = null;
    protected PrintWriter printWriter = null;
    protected Vector<ThreadSupportedCleanupAndDestroy> tscdList = new Vector();
    protected boolean logSerialReuseMessage = true;
    private boolean _quiesce;
    private Date _quiesceTime;
    protected boolean nonDeferredReaperAlarm = false;
    double claimedVictimPercent = 0.0;
    private boolean enableInuseConnectionDestroy = false;
    private WSThreadLocal<ArrayList<com.ibm.ws.j2c.MCWrapper>> localConnection_ = null;
    protected int maxCapacity = 0;
    protected boolean isThreadLocalConnectionEnabled = false;
    public transient ConcurrentHashMap<String, AtomicInteger> getConnectionMap = new ConcurrentHashMap();
    protected final AtomicInteger alarmThreadCounter = new AtomicInteger(0);
    protected static final String abortConnectionsActionName = "abortConnections";
    protected static final String abortConnectionsInUse = "inuse";
    protected final Object amMaxInUseTimeLockObject = new PoolManagerLock();
    protected final AtomicInteger maxInUseTimeAlarmThreadCounter = new AtomicInteger(0);
    protected int maxInUseTime = 0;
    protected ScheduledFuture<?> amMaxInUseTime = null;
    protected boolean maxInUseTimeThreadStarted = false;
    private final Object maxInUseTimeTaskTimerLockObject = new PoolManagerLock();
    private int maxInUseTimeCollectorCount = 0;

    public int getMaxCapacity() {
        return this.maxCapacity;
    }

    public PoolManager(AbstractConnectionFactoryService cfSvc, Properties dsProps, J2CGlobalConfigProperties gConfigProps, ClassLoader raClassLoader) {
        this.raClassLoader = raClassLoader;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object[])new Object[0]);
        }
        this.connectorSvc = (ConnectorServiceImpl)cfSvc.getConnectorService();
        this.gConfigProps = gConfigProps;
        this.enableInuseConnectionDestroy = true;
        this.logSerialReuseMessage = true;
        this.connectionTimeout = gConfigProps.getConnectionTimeout();
        this.createParkedConnection = gConfigProps.getAutoCloseConnections() && !gConfigProps.isSmartHandleSupport();
        this.maxConnections = gConfigProps.getMaxConnections();
        this.minConnections = gConfigProps.getMinConnections();
        this.purgePolicy = gConfigProps.getPurgePolicy();
        this.reapTime = gConfigProps.getReapTime();
        this.maxInUseTime = gConfigProps.getMaxInUseTime();
        this.unusedTimeout = gConfigProps.getUnusedTimeout();
        this.agedTimeout = gConfigProps.getAgedTimeout();
        this.agedTimeoutMillis = (long)this.agedTimeout * 1000L;
        this.maxFreePoolHashSize = gConfigProps.getMaxFreePoolHashSize();
        this.maxSharedBuckets = gConfigProps.getMaxSharedBuckets();
        this.maxNumberOfMCsAllowableInThread = gConfigProps.getMaxNumberOfMCsAllowableInThread();
        this.throwExceptionOnMCThreadCheck = gConfigProps.getThrowExceptionOnMCThreadCheck();
        this.holdTimeLimit = gConfigProps.getOrphanConnHoldTimeLimitSeconds();
        this.maxCapacity = gConfigProps.getnumConnectionsPerThreadLocal();
        this.connectionTimeout = gConfigProps.getConnectionTimeout();
        if (this.maxCapacity < 1) {
            this.localConnection_ = null;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"PoolManager: Thread local connection Disabled", (Object[])new Object[0]);
                Tr.debug((Object)this, (TraceComponent)tc, (String)("Maximum connection thread local storage capacity is " + this.maxCapacity), (Object[])new Object[0]);
            }
        } else {
            this.localConnection_ = new WSThreadLocal<ArrayList<com.ibm.ws.j2c.MCWrapper>>(){

                protected ArrayList<com.ibm.ws.j2c.MCWrapper> initialValue() {
                    return new ArrayList<com.ibm.ws.j2c.MCWrapper>(2);
                }
            };
            this.isThreadLocalConnectionEnabled = true;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"PoolManager: Thread local connection ENABLED", (Object[])new Object[0]);
                Tr.debug((Object)this, (TraceComponent)tc, (String)("Maximum connection thread local storage capacity is " + this.maxCapacity), (Object[])new Object[0]);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            StringBuffer sb = new StringBuffer();
            sb.append(this.nl);
            sb.append("maxSharedBuckets = ");
            sb.append(this.maxSharedBuckets);
            sb.append(this.nl);
            sb.append("maxFreePoolHashSize = ");
            sb.append(this.maxFreePoolHashSize);
            sb.append(this.nl);
            sb.append("holdTimeLimit = ");
            sb.append(this.holdTimeLimit);
            sb.append(this.nl);
            Tr.debug((Object)this, (TraceComponent)tc, (String)sb.toString(), (Object[])new Object[0]);
        }
        int initialMCWLSize = this.maxConnections;
        this.sharedPool = new SharedPool[this.maxSharedBuckets];
        this.freePool = new FreePool[this.maxFreePoolHashSize];
        this.mcToMCWMap = this.maxConnections > 500 ? new HashMap(500) : new HashMap(this.maxConnections);
        for (int i = 0; i < this.maxSharedBuckets; ++i) {
            this.sharedPool[i] = new SharedPool(this.maxConnections, this);
        }
        for (int j = 0; j < this.maxFreePoolHashSize; ++j) {
            this.freePool[j] = new FreePool(initialMCWLSize, this, this.gConfigProps, raClassLoader);
        }
        this.mcWrapperWaiterList = initialMCWLSize > 500 ? new MCWrapperList(500) : (initialMCWLSize > 0 ? new MCWrapperList(initialMCWLSize) : new MCWrapperList(50));
        this._quiesce = false;
        this._quiesceTime = null;
        gConfigProps.addPropertyChangeListener(this);
        gConfigProps.addVetoableChangeListener(this);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("Initial pool properties used by PoolManager " + gConfigProps.getXpathId()), (Object[])new Object[0]);
            Tr.debug((Object)this, (TraceComponent)tc, (String)("Connection Timeout                      = " + this.connectionTimeout + " (seconds)"), (Object[])new Object[0]);
            Tr.debug((Object)this, (TraceComponent)tc, (String)("Maximum Connections                     = " + this.maxConnections), (Object[])new Object[0]);
            Tr.debug((Object)this, (TraceComponent)tc, (String)("Minimum Connections                     = " + this.minConnections), (Object[])new Object[0]);
            Tr.debug((Object)this, (TraceComponent)tc, (String)("Purge Policy                            = " + (Object)((Object)this.purgePolicy)), (Object[])new Object[0]);
            Tr.debug((Object)this, (TraceComponent)tc, (String)("Reclaim Connection Thread Time Interval = " + this.reapTime + " (seconds)"), (Object[])new Object[0]);
            Tr.debug((Object)this, (TraceComponent)tc, (String)("Unused Timeout                          = " + this.unusedTimeout + " (seconds)"), (Object[])new Object[0]);
            Tr.debug((Object)this, (TraceComponent)tc, (String)("Aged Timeout                            = " + this.agedTimeout + " (seconds)"), (Object[])new Object[0]);
            Tr.debug((Object)this, (TraceComponent)tc, (String)("Free Pool Distribution Table Size       = " + this.maxFreePoolHashSize), (Object[])new Object[0]);
            Tr.debug((Object)this, (TraceComponent)tc, (String)("Number Of Shared Pool Partitions        = " + this.maxSharedBuckets), (Object[])new Object[0]);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void fatalErrorNotification(ManagedConnectionFactory managedConnectionFactory, com.ibm.ws.j2c.MCWrapper mcWrapper, Object affinity) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"fatalErrorNotification", (Object[])new Object[0]);
        }
        this.requestingAccessToPool();
        if (mcWrapper != null) {
            mcWrapper.markStale();
        }
        if (this.gConfigProps.connectionPoolingEnabled) {
            if (this.gConfigProps.getPurgePolicy() != null) {
                boolean aborted;
                boolean bl = aborted = mcWrapper != null && mcWrapper.getManagedConnectionWithoutStateCheck() instanceof WSManagedConnection && ((WSManagedConnection)mcWrapper.getManagedConnectionWithoutStateCheck()).isAborted();
                if (this.gConfigProps.getPurgePolicy() == PurgePolicy.EntirePool && !aborted) {
                    ArrayList<com.ibm.ws.j2c.MCWrapper> destroyMCWrapperList = new ArrayList<com.ibm.ws.j2c.MCWrapper>();
                    Object object = this.destroyMCWrapperListLock;
                    synchronized (object) {
                        void var7_11;
                        boolean bl2 = false;
                        while (var7_11 < this.gConfigProps.getMaxFreePoolHashSize()) {
                            Object object2 = this.waiterFreePoolLock;
                            synchronized (object2) {
                                Object object3 = this.freePool[var7_11].freeConnectionLockObject;
                                synchronized (object3) {
                                    this.freePool[var7_11].incrementFatalErrorValue((int)var7_11);
                                    if (this.freePool[var7_11].mcWrapperList.size() > 0) {
                                        int mcWrapperListIndex;
                                        for (int k = mcWrapperListIndex = this.freePool[var7_11].mcWrapperList.size() - 1; k >= 0; --k) {
                                            com.ibm.ws.j2c.MCWrapper mcw = (com.ibm.ws.j2c.MCWrapper)this.freePool[var7_11].mcWrapperList.remove(k);
                                            mcw.setPoolState(0);
                                            destroyMCWrapperList.add(mcw);
                                            --this.freePool[var7_11].numberOfConnectionsAssignedToThisFreePool;
                                        }
                                    }
                                }
                            }
                            ++var7_11;
                        }
                    }
                    for (int i = 0; i < destroyMCWrapperList.size(); ++i) {
                        com.ibm.ws.j2c.MCWrapper mCWrapper = (com.ibm.ws.j2c.MCWrapper)destroyMCWrapperList.get(i);
                        this.freePool[0].cleanupAndDestroyMCWrapper(mCWrapper);
                        this.totalConnectionCount.decrementAndGet();
                    }
                } else {
                    if (this.gConfigProps.validatingMCFSupported && !aborted) {
                        this.validateConnections(managedConnectionFactory, false);
                    }
                    if (this.gConfigProps.getPurgePolicy() == PurgePolicy.ValidateAllConnections) {
                        this.mcToMCWMapWrite.lock();
                        try {
                            Collection<com.ibm.ws.j2c.MCWrapper> s = this.mcToMCWMap.values();
                            for (MCWrapper mCWrapper : s) {
                                if (mCWrapper.getState() == 4) continue;
                                mCWrapper.setPretestThisConnection(true);
                            }
                        }
                        finally {
                            this.mcToMCWMapWrite.unlock();
                        }
                    }
                }
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"Pooling disabled, fatal error processing completed.", (Object[])new Object[0]);
        }
        this.activeRequest.decrementAndGet();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"fatalErrorNotification");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void validateConnections(ManagedConnectionFactory managedConnectionFactory, boolean prepopulateEnabled) {
        Object object;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"validateConnections", (Object[])new Object[]{this.gConfigProps.cfName});
        }
        HashSet<ManagedConnection> mcSet = new HashSet<ManagedConnection>();
        LinkedList<com.ibm.ws.j2c.MCWrapper> invalidMCWList = new LinkedList<com.ibm.ws.j2c.MCWrapper>();
        Iterator iterator = this.destroyMCWrapperListLock;
        synchronized (iterator) {
            for (int j = 0; j < this.gConfigProps.getMaxFreePoolHashSize(); ++j) {
                object = this.waiterFreePoolLock;
                synchronized (object) {
                    Object object2 = this.freePool[j].freeConnectionLockObject;
                    synchronized (object2) {
                        if (this.freePool[j].mcWrapperList.size() > 0) {
                            int mcWrapperListIndex;
                            for (int k = mcWrapperListIndex = this.freePool[j].mcWrapperList.size() - 1; k >= 0; --k) {
                                com.ibm.ws.j2c.MCWrapper mcw = (com.ibm.ws.j2c.MCWrapper)this.freePool[j].mcWrapperList.get(k);
                                if (mcw.getPoolState() != 1 || mcw.isStale()) continue;
                                mcSet.add(mcw.getManagedConnection());
                                mcw.setPoolState(50);
                                Set invalidConnectionsSet = null;
                                try {
                                    invalidConnectionsSet = ((ValidatingManagedConnectionFactory)managedConnectionFactory).getInvalidConnections(mcSet);
                                }
                                catch (ResourceException e) {
                                    Object[] parms = new Object[]{"validateConnections", CommonFunction.exceptionList(e), "ResourceException", this.gConfigProps.cfName};
                                    Tr.error((TraceComponent)tc, (String)"ATTEMPT_TO_VALIDATE_MC_CONNECTIONS_J2CA0285", (Object[])parms);
                                }
                                finally {
                                    mcSet.clear();
                                    mcw.setPoolState(1);
                                }
                                if (invalidConnectionsSet != null && !invalidConnectionsSet.isEmpty()) {
                                    this.freePool[j].mcWrapperList.remove(k);
                                    mcw.setPoolState(0);
                                    invalidMCWList.add(mcw);
                                    --this.freePool[j].numberOfConnectionsAssignedToThisFreePool;
                                }
                                if (!prepopulateEnabled) continue;
                                ((MCWrapper)mcw).resetIdleTimeOut();
                            }
                        }
                    }
                }
            }
        }
        for (com.ibm.ws.j2c.MCWrapper mcw : invalidMCWList) {
            this.freePool[0].cleanupAndDestroyMCWrapper(mcw);
            object = this.waiterFreePoolLock;
            synchronized (object) {
                this.totalConnectionCount.decrementAndGet();
                if (this.waiterCount > 0) {
                    this.waiterFreePoolLock.notify();
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("Returning from getInvalidConnections with " + mcSet.size() + " managed connections and " + invalidMCWList.size() + " invalid connections."), (Object[])new Object[0]);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"validateConnections");
        }
    }

    private void checkForConnectionInFreePool(com.ibm.ws.j2c.MCWrapper mcw) {
        int hashMapBucket;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"checkForConnectionInFreePool", (Object[])new Object[0]);
        }
        if (this.freePool[hashMapBucket = mcw.getHashMapBucket()].removeMCWrapperFromList(mcw)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("Managed connection wrapper was removed from the free pool wrapper list.  mcw is " + mcw), (Object[])new Object[0]);
            }
            this.freePool[hashMapBucket].cleanupAndDestroyMCWrapper(mcw);
            this.freePool[hashMapBucket].removeMCWrapperFromList(mcw, false, true, false, true);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"checkForConnectionInFreePool");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serverShutDown() throws ResourceException {
        Object object;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"serverShutDown", (Object[])new Object[0]);
        }
        this.connectionPoolShutDown = true;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"Shutting down pool manager connections in free pool ", (Object[])new Object[0]);
            Tr.debug((Object)this, (TraceComponent)tc, (String)this.toString(), (Object[])new Object[0]);
        }
        if (!this.gConfigProps.isSmartHandleSupport()) {
            this.freePool[0].removeParkedConnection();
        }
        for (int j = 0; j < this.gConfigProps.getMaxFreePoolHashSize(); ++j) {
            object = this.freePool[j].freeConnectionLockObject;
            synchronized (object) {
                block33: {
                    this.freePool[j].incrementFatalErrorValue(j);
                    if (this.freePool[j].mcWrapperList.size() > 0) {
                        try {
                            this.freePool[j].cleanupAndDestroyAllFreeConnections();
                        }
                        catch (Exception ex) {
                            if (!tc.isDebugEnabled()) break block33;
                            Tr.debug((Object)this, (TraceComponent)tc, (String)"Exception during destroy of freepool connection: ", (Object[])new Object[]{this.freePool[j], ex});
                        }
                    }
                }
                continue;
            }
        }
        if (this.enableInuseConnectionDestroy) {
            this.allowConnectionRequests = false;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"Destroying sharable, in-use connections", (Object[])new Object[0]);
            }
            for (int i = 0; i < this.maxSharedBuckets; ++i) {
                object = this.sharedPool[i].sharedLockObject;
                synchronized (object) {
                    if (this.sharedPool[i].getMCWrapperListSize() > 0) {
                        com.ibm.ws.j2c.MCWrapper[] mcw = this.sharedPool[i].getMCWrapperList();
                        for (int j = 0; j < this.sharedPool[i].getMCWrapperListSize(); ++j) {
                            try {
                                ManagedConnection mc;
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug((Object)this, (TraceComponent)tc, (String)("Destroying inuse managed connection " + mcw[j]), (Object[])new Object[0]);
                                }
                                if ((mc = mcw[j].getManagedConnectionWithoutStateCheck()) == null) continue;
                                mc.destroy();
                                continue;
                            }
                            catch (ResourceException resX) {
                                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                                Tr.debug((Object)this, (TraceComponent)tc, (String)"error during destroy of sharable, in-use connection: ", (Object[])new Object[]{mcw[j], resX});
                            }
                        }
                    }
                    continue;
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"Destroying unsharable, in-use connections", (Object[])new Object[0]);
            }
            com.ibm.ws.j2c.MCWrapper[] mcw = this.getUnSharedPoolConnections();
            for (int j = 0; j < mcw.length; ++j) {
                try {
                    ManagedConnection mc;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)("Destroying inuse managed connection " + mcw[j]), (Object[])new Object[0]);
                    }
                    if ((mc = mcw[j].getManagedConnectionWithoutStateCheck()) == null) continue;
                    mc.destroy();
                    continue;
                }
                catch (ResourceException resX) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"error during destroy of unsharable in-use connection: ", (Object[])new Object[]{mcw[j], resX});
                }
            }
        }
        Object object2 = this.amLockObject;
        synchronized (object2) {
            if (this.am != null && !this.am.isDone()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"Alarm for pool manager has not completed yet.  Cancelling now.", (Object[])new Object[0]);
                }
                this.am.cancel(false);
                if (this.am.isDone()) {
                    this.alarmThreadCounter.decrementAndGet();
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"serverShutDown");
        }
    }

    private void quiesce() throws ResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"quiesce", (Object[])new Object[]{this.gConfigProps.cfName});
        }
        if (!this.gConfigProps.isSmartHandleSupport()) {
            this.freePool[0].removeParkedConnection();
        }
        if (this.parkedMCWrapper != null) {
            this.parkedMCWrapper.clearMCWrapper();
        }
        this.pmQuiesced = true;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"quiesce", (Object)this.gConfigProps.cfName);
        }
    }

    public com.ibm.ws.j2c.MCWrapper getParkedConnection() {
        return this.parkedMCWrapper;
    }

    public void release(com.ibm.ws.j2c.MCWrapper mcWrapper, Object affinity) throws ResourceException {
        this.release(mcWrapper, affinity, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(com.ibm.ws.j2c.MCWrapper mcWrapper, Object affinity, boolean pausedPoolAbortOverRide) throws ResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"release", (Object[])new Object[]{mcWrapper, affinity, "Pool contents ==>", this.toString2(1)});
        }
        if (((MCWrapper)mcWrapper).isAlreadyBeingReleased()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("AddingJMS - release - Already releasing managed connection " + mcWrapper), (Object[])new Object[0]);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"release", (Object)new Object[]{mcWrapper.getManagedConnectionWithoutStateCheck(), "Pool contents ==>", this});
            }
            return;
        }
        ((MCWrapper)mcWrapper).setAlreadyBeingReleased(true);
        this.requestingAccessToPool(pausedPoolAbortOverRide);
        if (this.localConnection_ != null) {
            if (mcWrapper.getPoolState() == 5 || mcWrapper.getPoolState() == 7) {
                if (mcWrapper.isDestroyState() || mcWrapper.isStale() || mcWrapper.hasFatalErrorNotificationOccurred(this.freePool[0].getFatalErrorNotificationTime()) || this.agedTimeout != -1 && mcWrapper.hasAgedTimedOut(this.agedTimeoutMillis)) {
                    this.removeMCWFromTLS(mcWrapper);
                    return;
                }
                try {
                    if (this.waiterCount > 0) {
                        Object object = this.waiterFreePoolLock;
                        synchronized (object) {
                            if (this.waiterCount > 0 && this.waiterCount > this.mcWrapperWaiterList.size()) {
                                ArrayList mh = (ArrayList)this.localConnection_.get();
                                if (mh != null) {
                                    this.requestingAccessToTLSPool();
                                    mh.remove(mcWrapper);
                                    this.tlsArrayLists.remove(mcWrapper);
                                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                        ((MCWrapper)mcWrapper).setThreadID(((MCWrapper)mcWrapper).getThreadID() + "-release-waiter-removed");
                                        Tr.debug((Object)this, (TraceComponent)tc, (String)("removed mcWrapper from thread local " + mcWrapper), (Object[])new Object[0]);
                                    }
                                    this.endingAccessToTLSPool();
                                }
                                ((MCWrapper)mcWrapper).tlsCleanup();
                                mcWrapper.setSharedPoolCoordinator(null);
                                this.mcWrapperWaiterList.add(mcWrapper);
                                mcWrapper.setPoolState(4);
                                this.waiterFreePoolLock.notify();
                                this.activeRequest.decrementAndGet();
                                ((MCWrapper)mcWrapper).setAlreadyBeingReleased(false);
                                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                                    Tr.exit((Object)this, (TraceComponent)tc, (String)"release");
                                }
                                return;
                            }
                        }
                    }
                    mcWrapper.setSharedPoolCoordinator(null);
                    ((MCWrapper)mcWrapper).tlsCleanup();
                    mcWrapper.setPoolState(6);
                    this.activeRequest.decrementAndGet();
                    ((MCWrapper)mcWrapper).setAlreadyBeingReleased(false);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit((Object)this, (TraceComponent)tc, (String)"release", (Object)new Object[]{mcWrapper.getManagedConnectionWithoutStateCheck(), "Pool contents ==>", this});
                    }
                    return;
                }
                catch (ResourceException re) {
                    this.removeMCWFromTLS(mcWrapper);
                    return;
                }
            }
            if (mcWrapper.getPoolState() == 6) {
                ((MCWrapper)mcWrapper).setAlreadyBeingReleased(false);
                this.activeRequest.decrementAndGet();
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit((Object)this, (TraceComponent)tc, (String)"release", (Object)new Object[]{mcWrapper.getManagedConnectionWithoutStateCheck(), "Pool contents ==>", this});
                }
                return;
            }
        }
        if (mcWrapper.isInSharedPool()) {
            ((SharedPool)mcWrapper.getSharedPool()).removeSharedConnection(mcWrapper);
            mcWrapper.setSharedPoolCoordinator(null);
            mcWrapper.setSharedPool(null);
            mcWrapper.setInSharedPool(false);
        }
        if (!this.gConfigProps.connectionPoolingEnabled || mcWrapper instanceof MCWrapper && ((MCWrapper)mcWrapper).isMCAborted()) {
            block40: {
                this.mcToMCWMapWrite.lock();
                try {
                    this.mcToMCWMap.remove(mcWrapper.getManagedConnectionWithoutStateCheck());
                }
                finally {
                    this.mcToMCWMapWrite.unlock();
                }
                try {
                    mcWrapper.cleanup();
                }
                catch (Exception exn1) {
                    boolean aborted;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)("MCWrapper cleanup failed, datasource: " + this.gConfigProps.cfName), (Object[])new Object[0]);
                    }
                    boolean bl = aborted = mcWrapper.getManagedConnection() instanceof WSManagedConnection && ((WSManagedConnection)mcWrapper.getManagedConnection()).isAborted();
                    if (aborted) break block40;
                    FFDCFilter.processException((Throwable)exn1, (String)"com.ibm.ejs.j2c.poolmanager.PoolManager.release", (String)"1131", (Object)this);
                }
            }
            try {
                mcWrapper.destroy();
            }
            catch (Exception exn2) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("MCWrapper destroy failed, datasource: " + this.gConfigProps.cfName), (Object[])new Object[0]);
                }
                FFDCFilter.processException((Throwable)exn2, (String)"com.ibm.ejs.j2c.poolmanager.PoolManager.release", (String)"1144", (Object)this);
            }
            Object exn2 = this.waiterFreePoolLock;
            synchronized (exn2) {
                this.totalConnectionCount.decrementAndGet();
                if (this.waiterCount > 0) {
                    this.waiterFreePoolLock.notify();
                }
            }
        }
        if (!mcWrapper.isInSharedPool()) {
            mcWrapper.setPoolState(0);
        }
        int hashMapBucket = mcWrapper.getHashMapBucket();
        this.freePool[hashMapBucket].returnToFreePool(mcWrapper);
        this.activeRequest.decrementAndGet();
        if (this._quiesce) {
            this.quiesceIfPossible();
        }
        ((MCWrapper)mcWrapper).setAlreadyBeingReleased(false);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("released managed connection " + mcWrapper.getManagedConnectionWithoutStateCheck()), (Object[])new Object[]{"pool contents ==>", this});
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"release");
        }
    }

    private void removeMCWFromTLS(com.ibm.ws.j2c.MCWrapper mcWrapper) {
        ArrayList mh = (ArrayList)this.localConnection_.get();
        if (mh != null) {
            this.requestingAccessToTLSPool();
            mh.remove(mcWrapper);
            this.tlsArrayLists.remove(mcWrapper);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                ((MCWrapper)mcWrapper).setThreadID(((MCWrapper)mcWrapper).getThreadID() + "-release-destroy-removed");
                Tr.debug((Object)this, (TraceComponent)tc, (String)("removed mcWrapper from thread local " + mcWrapper), (Object[])new Object[0]);
            }
            this.endingAccessToTLSPool();
            this.removeConnectionFromPool(mcWrapper);
        }
        this.activeRequest.decrementAndGet();
        ((MCWrapper)mcWrapper).setAlreadyBeingReleased(false);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"release", (Object)new Object[]{mcWrapper.getManagedConnectionWithoutStateCheck(), "Pool contents ==>", this});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeConnectionFromPool(com.ibm.ws.j2c.MCWrapper mcWrapper) {
        this.freePool[0].cleanupAndDestroyMCWrapper(mcWrapper);
        Object object = this.waiterFreePoolLock;
        synchronized (object) {
            mcWrapper.setPoolState(0);
            this.totalConnectionCount.decrementAndGet();
            this.waiterFreePoolLock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public com.ibm.ws.j2c.MCWrapper reserve(ManagedConnectionFactory managedConnectionFactory, Subject subject, ConnectionRequestInfo requestInfo, Object affinity, boolean connectionSharing, boolean enforceSerialReuse, int commitPriority, int branchCoupling) throws ResourceException, ResourceAllocationException {
        com.ibm.ws.j2c.MCWrapper mcWrapper;
        boolean isTracingEnabled;
        block92: {
            block97: {
                int hashMapBucket;
                int hashCode;
                int sharedbucket;
                block94: {
                    block95: {
                        int tempLocalHashMapBucket;
                        int searchHashMapBucket;
                        Object mcwtemp;
                        block96: {
                            block93: {
                                block89: {
                                    block90: {
                                        com.ibm.ws.j2c.MCWrapper localConnection;
                                        int arraySize;
                                        ArrayList mh;
                                        block91: {
                                            block86: {
                                                block87: {
                                                    com.ibm.ws.j2c.MCWrapper freeLocalConnection;
                                                    block84: {
                                                        block88: {
                                                            block85: {
                                                                isTracingEnabled = TraceComponent.isAnyTracingEnabled();
                                                                if (isTracingEnabled && tc.isEntryEnabled()) {
                                                                    Tr.entry((Object)this, (TraceComponent)tc, (String)"reserve", (Object[])new Object[0]);
                                                                }
                                                                if (isTracingEnabled && tc.isDebugEnabled()) {
                                                                    StringBuffer sbuff = new StringBuffer(250);
                                                                    sbuff.append("input parms... ");
                                                                    sbuff.append(this.nl);
                                                                    sbuff.append(" subject = ");
                                                                    if (subject == null) {
                                                                        sbuff.append("null");
                                                                    } else {
                                                                        SubjectToString subjectToString = new SubjectToString();
                                                                        subjectToString.setSubject(subject);
                                                                        sbuff.append(AccessController.doPrivileged(subjectToString));
                                                                    }
                                                                    sbuff.append(" affinity = ");
                                                                    sbuff.append(affinity);
                                                                    sbuff.append(this.nl);
                                                                    sbuff.append(" Shared connection = ");
                                                                    sbuff.append(connectionSharing);
                                                                    sbuff.append(this.nl);
                                                                    sbuff.append(" Force new MC = ");
                                                                    sbuff.append(enforceSerialReuse);
                                                                    sbuff.append(this.nl);
                                                                    sbuff.append(" commitPriority = ");
                                                                    sbuff.append(commitPriority);
                                                                    sbuff.append(this.nl);
                                                                    sbuff.append(" branchCoupling = ");
                                                                    sbuff.append(branchCoupling);
                                                                    sbuff.append(this.nl);
                                                                    sbuff.append(" Connection Request Information = ");
                                                                    sbuff.append(requestInfo);
                                                                    Tr.debug((Object)this, (TraceComponent)tc, (String)sbuff.toString(), (Object[])new Object[0]);
                                                                    Tr.debug((Object)this, (TraceComponent)tc, (String)("reserve(), Pool contents ==> " + this.toString2(1)), (Object[])new Object[0]);
                                                                }
                                                                this.requestingAccessToPool();
                                                                if (this.maxNumberOfMCsAllowableInThread != 0 && this.maxNumberOfMCsAllowableInThread > 0) {
                                                                    this.checkForMCsOnThread(this.maxNumberOfMCsAllowableInThread);
                                                                }
                                                                if (isTracingEnabled && tc.isDebugEnabled()) {
                                                                    ++this.totalPoolConnectionRequests;
                                                                }
                                                                mcWrapper = null;
                                                                sharedbucket = 0;
                                                                hashCode = this.computeHashCode(subject, requestInfo);
                                                                hashMapBucket = hashCode % this.maxFreePoolHashSize;
                                                                if (affinity == null || !connectionSharing) break block85;
                                                                if (this.localConnection_ == null || (mh = (ArrayList)this.localConnection_.get()) == null) break block86;
                                                                this.requestingAccessToTLSPool();
                                                                arraySize = mh.size();
                                                                if (arraySize <= 0) break block87;
                                                                freeLocalConnection = null;
                                                                if (arraySize != 1) break block88;
                                                                localConnection = (com.ibm.ws.j2c.MCWrapper)mh.get(0);
                                                                if (localConnection.getPoolState() == 6) {
                                                                    freeLocalConnection = this.getMCWrapperFromMatch(subject, requestInfo, managedConnectionFactory, localConnection);
                                                                    break block84;
                                                                } else if (localConnection.getPoolState() == 5 && localConnection.getSharedPoolCoordinator() != null && localConnection.getSharedPoolCoordinator().equals(affinity) && PoolManager.isBranchCouplingCompatible(commitPriority, branchCoupling, localConnection) && PoolManager.isCRIsMatching(requestInfo, localConnection) && this.isSubjectsMatching(subject, localConnection)) {
                                                                    if (enforceSerialReuse && localConnection.getHandleCount() >= 1) {
                                                                        PoolManager.logLTCSerialReuseInfo(affinity, this.gConfigProps.cfName, localConnection, this);
                                                                        break block84;
                                                                    } else {
                                                                        localConnection = this.validateConnection(localConnection, managedConnectionFactory, subject, requestInfo, hashMapBucket, connectionSharing, hashCode);
                                                                        this.endingAccessToTLSPool();
                                                                        this.activeRequest.decrementAndGet();
                                                                        if (!isTracingEnabled) return localConnection;
                                                                        if (!tc.isEntryEnabled()) return localConnection;
                                                                        Tr.exit((Object)this, (TraceComponent)tc, (String)"reserve", (Object)new Object[]{localConnection, localConnection.getManagedConnection()});
                                                                        return localConnection;
                                                                    }
                                                                }
                                                                break block84;
                                                            }
                                                            if (this.localConnection_ == null || (mh = (ArrayList)this.localConnection_.get()) == null) break block89;
                                                            this.requestingAccessToTLSPool();
                                                            arraySize = mh.size();
                                                            if (arraySize <= 0) break block90;
                                                            break block91;
                                                        }
                                                        for (int i = 0; i < arraySize; ++i) {
                                                            com.ibm.ws.j2c.MCWrapper localConnection2 = (com.ibm.ws.j2c.MCWrapper)mh.get(i);
                                                            if (localConnection2.getPoolState() == 6) {
                                                                if (freeLocalConnection != null) continue;
                                                                freeLocalConnection = this.getMCWrapperFromMatch(subject, requestInfo, managedConnectionFactory, localConnection2);
                                                                continue;
                                                            }
                                                            if (localConnection2.getPoolState() != 5 || localConnection2.getSharedPoolCoordinator() == null || !localConnection2.getSharedPoolCoordinator().equals(affinity) || !PoolManager.isBranchCouplingCompatible(commitPriority, branchCoupling, localConnection2) || !PoolManager.isCRIsMatching(requestInfo, localConnection2) || !this.isSubjectsMatching(subject, localConnection2)) continue;
                                                            if (enforceSerialReuse && localConnection2.getHandleCount() >= 1) {
                                                                PoolManager.logLTCSerialReuseInfo(affinity, this.gConfigProps.cfName, localConnection2, this);
                                                                continue;
                                                            }
                                                            localConnection2 = this.validateConnection(localConnection2, managedConnectionFactory, subject, requestInfo, hashMapBucket, connectionSharing, hashCode);
                                                            this.endingAccessToTLSPool();
                                                            this.activeRequest.decrementAndGet();
                                                            if (!isTracingEnabled) return localConnection2;
                                                            if (!tc.isEntryEnabled()) return localConnection2;
                                                            Tr.exit((Object)this, (TraceComponent)tc, (String)"reserve", (Object)new Object[]{localConnection2, localConnection2.getManagedConnection()});
                                                            return localConnection2;
                                                        }
                                                    }
                                                    if (freeLocalConnection != null) {
                                                        freeLocalConnection = this.validateConnection(freeLocalConnection, managedConnectionFactory, subject, requestInfo, hashMapBucket, connectionSharing, hashCode);
                                                        freeLocalConnection.setPoolState(5);
                                                        freeLocalConnection.setSharedPoolCoordinator(affinity);
                                                        freeLocalConnection.markInUse();
                                                        this.endingAccessToTLSPool();
                                                        this.activeRequest.decrementAndGet();
                                                        if (!isTracingEnabled) return freeLocalConnection;
                                                        if (!tc.isEntryEnabled()) return freeLocalConnection;
                                                        Tr.exit((Object)this, (TraceComponent)tc, (String)"reserve", (Object)new Object[]{freeLocalConnection, freeLocalConnection.getManagedConnection()});
                                                        return freeLocalConnection;
                                                    }
                                                }
                                                this.endingAccessToTLSPool();
                                            }
                                            sharedbucket = Math.abs(affinity.hashCode() % this.maxSharedBuckets);
                                            if (isTracingEnabled && tc.isDebugEnabled()) {
                                                Tr.debug((Object)this, (TraceComponent)tc, (String)("Searching for shared connection in partition " + sharedbucket), (Object[])new Object[0]);
                                            }
                                            mcWrapper = this.sharedPool[sharedbucket].getSharedConnection(affinity, subject, requestInfo, enforceSerialReuse, this.gConfigProps.getXpathId(), commitPriority, branchCoupling);
                                            break block89;
                                        }
                                        for (int i = 0; i < arraySize; ++i) {
                                            localConnection = (com.ibm.ws.j2c.MCWrapper)mh.get(i);
                                            if (localConnection.getPoolState() != 6 || (mcwtemp = this.getMCWrapperFromMatch(subject, requestInfo, managedConnectionFactory, localConnection)) == null) continue;
                                            localConnection.setPoolState(7);
                                            localConnection.markInUse();
                                            this.endingAccessToTLSPool();
                                            this.activeRequest.decrementAndGet();
                                            if (!isTracingEnabled) return localConnection;
                                            if (!tc.isEntryEnabled()) return localConnection;
                                            Tr.exit((Object)this, (TraceComponent)tc, (String)"reserve", (Object)new Object[]{localConnection, localConnection.getManagedConnection()});
                                            return localConnection;
                                        }
                                    }
                                    this.endingAccessToTLSPool();
                                }
                                if (mcWrapper != null) break block92;
                                if (!this.allowConnectionRequests) {
                                    ResourceAllocationException throwMe = null;
                                    if (this.connectionPoolShutDown) {
                                        Object[] parms = new Object[]{"reserve", "Pool requests blocked, connection pool is being shut down.", "ResourceAllocationException", this.gConfigProps.cfName};
                                        Tr.error((TraceComponent)tc, (String)"POOL_MANAGER_EXCP_CCF2_0002_J2CA0046", (Object[])parms);
                                        throwMe = new ResourceAllocationException("Pool requests blocked for " + this.gConfigProps.getXpathId() + ", connection pool is being shut down.");
                                    } else {
                                        Object[] parms = new Object[]{"reserve", "Failed preTestConnection. Pool requests blocked until the test connection thread is successful.", "ResourceAllocationException", this.gConfigProps.cfName};
                                        Tr.error((TraceComponent)tc, (String)"POOL_MANAGER_EXCP_CCF2_0002_J2CA0046", (Object[])parms);
                                        throwMe = new ResourceAllocationException("Failed preTestConnection. Pool requests blocked for " + this.gConfigProps.getXpathId() + " until the test connection thread is successful.");
                                    }
                                    this.activeRequest.decrementAndGet();
                                    if (!isTracingEnabled) throw throwMe;
                                    if (!tc.isEntryEnabled()) throw throwMe;
                                    Tr.exit((Object)this, (TraceComponent)tc, (String)"reserve", (Object)((Object)throwMe));
                                    throw throwMe;
                                }
                                if (this.waiterCount >= 1 || !this.gConfigProps.connectionPoolingEnabled) break block93;
                                if (this.freePool[hashMapBucket].mcWrapperList.size() > 0) {
                                    mcWrapper = this.freePool[hashMapBucket].getFreeConnection(managedConnectionFactory, subject, requestInfo, hashCode);
                                } else if (isTracingEnabled && tc.isDebugEnabled()) {
                                    ++this.freePool[hashMapBucket].fop_get_notfound;
                                }
                                if (mcWrapper != null) break block94;
                                if (this.maxConnections == 0) break block95;
                                boolean tryToClaimVictim = false;
                                if (this.totalConnectionCount.get() >= this.maxConnections) {
                                    tryToClaimVictim = true;
                                }
                                if (!tryToClaimVictim) break block95;
                                searchHashMapBucket = hashMapBucket;
                                tempLocalHashMapBucket = hashMapBucket;
                                break block96;
                            }
                            if (isTracingEnabled && tc.isDebugEnabled()) {
                                ++this.waitSkip;
                            }
                            try {
                                mcWrapper = this.freePool[hashMapBucket].createOrWaitForConnection(managedConnectionFactory, subject, requestInfo, hashMapBucket, this.maxFreePoolHashSize, false, connectionSharing, hashCode);
                            }
                            catch (ConnectionWaitTimeoutException e) {
                                throw e;
                            }
                            catch (ResourceAllocationException e) {
                                if (e.getCause() instanceof InterruptedException) {
                                    if (isTracingEnabled && tc.isDebugEnabled()) {
                                        Tr.debug((TraceComponent)tc, (String)"Thread was interrupted, skipping decrement of total connection count", (Object[])new Object[0]);
                                    }
                                    Object object = this.waiterFreePoolLock;
                                    synchronized (object) {
                                        if (this.waiterCount <= 0) throw e;
                                        this.waiterFreePoolLock.notify();
                                        throw e;
                                    }
                                }
                                Object object = this.waiterFreePoolLock;
                                synchronized (object) {
                                    int totalCount = this.totalConnectionCount.decrementAndGet();
                                    if (isTracingEnabled && tc.isDebugEnabled()) {
                                        Tr.debug((TraceComponent)tc, (String)("Decrement of total connection count " + totalCount), (Object[])new Object[0]);
                                    }
                                    if (this.waiterCount <= 0) throw e;
                                    this.waiterFreePoolLock.notify();
                                    throw e;
                                }
                            }
                        }
                        for (int i = 0; i < this.maxFreePoolHashSize; ++i) {
                            if (this.freePool[searchHashMapBucket].mcWrapperList.size() > 0) {
                                try {
                                    mcwtemp = this.freePool[searchHashMapBucket].freeConnectionLockObject;
                                    synchronized (mcwtemp) {
                                        if (this.freePool[searchHashMapBucket].mcWrapperList.size() > 0) {
                                            mcWrapper = this.claimVictim(managedConnectionFactory, searchHashMapBucket, subject, requestInfo);
                                        }
                                        if (mcWrapper != null) break;
                                    }
                                    mcWrapper = this.freePool[hashMapBucket].createOrWaitForConnection(managedConnectionFactory, subject, requestInfo, hashMapBucket, this.maxFreePoolHashSize, true, connectionSharing, hashCode);
                                    break;
                                }
                                catch (ConnectionWaitTimeoutException e) {
                                    throw e;
                                }
                                catch (ResourceAllocationException e) {
                                    if (e.getCause() instanceof InterruptedException) {
                                        if (isTracingEnabled && tc.isDebugEnabled()) {
                                            Tr.debug((TraceComponent)tc, (String)"Thread was interrupted, skipping decrement of total connection count", (Object[])new Object[0]);
                                        }
                                        Object object = this.waiterFreePoolLock;
                                        synchronized (object) {
                                            if (this.waiterCount <= 0) throw e;
                                            this.waiterFreePoolLock.notify();
                                            throw e;
                                        }
                                    }
                                    Object object = this.waiterFreePoolLock;
                                    synchronized (object) {
                                        int totalCount = this.totalConnectionCount.decrementAndGet();
                                        if (isTracingEnabled && tc.isDebugEnabled()) {
                                            Tr.debug((TraceComponent)tc, (String)("Decrement of total connection count " + totalCount), (Object[])new Object[0]);
                                        }
                                        if (this.waiterCount <= 0) throw e;
                                        this.waiterFreePoolLock.notify();
                                        throw e;
                                    }
                                }
                            }
                            searchHashMapBucket = ++tempLocalHashMapBucket % this.maxFreePoolHashSize;
                        }
                    }
                    if (mcWrapper == null) {
                        try {
                            mcWrapper = this.freePool[hashMapBucket].createOrWaitForConnection(managedConnectionFactory, subject, requestInfo, hashMapBucket, this.maxFreePoolHashSize, false, connectionSharing, hashCode);
                        }
                        catch (ConnectionWaitTimeoutException e) {
                            throw e;
                        }
                        catch (ResourceAllocationException e) {
                            if (e.getCause() instanceof InterruptedException) {
                                if (isTracingEnabled && tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"Thread was interrupted, skipping decrement of total connection count", (Object[])new Object[0]);
                                }
                                Object object = this.waiterFreePoolLock;
                                synchronized (object) {
                                    if (this.waiterCount <= 0) throw e;
                                    this.waiterFreePoolLock.notify();
                                    throw e;
                                }
                            }
                            Object object = this.waiterFreePoolLock;
                            synchronized (object) {
                                int totalCount = this.totalConnectionCount.decrementAndGet();
                                if (isTracingEnabled && tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)("Decrement of total connection count " + totalCount), (Object[])new Object[0]);
                                }
                                if (this.waiterCount <= 0) throw e;
                                this.waiterFreePoolLock.notify();
                                throw e;
                            }
                        }
                    }
                }
                mcWrapper = this.validateConnection(mcWrapper, managedConnectionFactory, subject, requestInfo, hashMapBucket, connectionSharing, hashCode);
                mcWrapper.markInUse();
                if (this.gConfigProps.raSupportsReauthentication) {
                    mcWrapper.setHashMapBucketReAuth(hashMapBucket);
                }
                if (affinity == null || !connectionSharing || ((MCWrapper)mcWrapper).isEnlistmentDisabled()) break block97;
                if (this.gConfigProps.isConnectionSynchronizationProvider()) {
                    if (isTracingEnabled && tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)"Shareable connections are not allowed with connections that are a SynchronizationProvider.  This connection will not be shareable.", (Object[])new Object[0]);
                    }
                    mcWrapper.setPoolState(3);
                    mcWrapper.setInSharedPool(false);
                    break block92;
                } else {
                    if (this.isThreadLocalConnectionEnabled && this.localConnection_ != null) {
                        ArrayList mh = (ArrayList)this.localConnection_.get();
                        this.requestingAccessToTLSPool();
                        if (mh.size() < this.maxCapacity) {
                            mcWrapper.setPoolState(5);
                            mcWrapper.setSharedPoolCoordinator(affinity);
                            mh.add(mcWrapper);
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                ((MCWrapper)mcWrapper).setThreadID(((MCWrapper)mcWrapper).getThreadID() + "-reserve-added");
                                Tr.debug((Object)this, (TraceComponent)tc, (String)("Added mcWrapper from thread local " + mcWrapper), (Object[])new Object[0]);
                            }
                            this.tlsArrayLists.put(mcWrapper, mh);
                        } else {
                            this.sharedPool[sharedbucket].setSharedConnection(affinity, mcWrapper);
                            mcWrapper.setInSharedPool(true);
                        }
                        this.endingAccessToTLSPool();
                    } else {
                        this.sharedPool[sharedbucket].setSharedConnection(affinity, mcWrapper);
                        mcWrapper.setInSharedPool(true);
                    }
                    if (this.createParkedConnection) {
                        Object mh = this.parkedConnectionLockObject;
                        synchronized (mh) {
                            if (this.createParkedConnection) {
                                this.createParkedConnection(managedConnectionFactory, subject, requestInfo);
                            }
                        }
                    }
                }
                break block92;
            }
            if (this.isThreadLocalConnectionEnabled && this.localConnection_ != null) {
                ArrayList mh = (ArrayList)this.localConnection_.get();
                this.requestingAccessToTLSPool();
                if (mh.size() < this.maxCapacity) {
                    mcWrapper.setPoolState(7);
                    mh.add(mcWrapper);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        ((MCWrapper)mcWrapper).setThreadID(((MCWrapper)mcWrapper).getThreadID() + "-reserve-added");
                        Tr.debug((Object)this, (TraceComponent)tc, (String)("Added mcWrapper from thread local " + mcWrapper), (Object[])new Object[0]);
                    }
                    this.tlsArrayLists.put(mcWrapper, mh);
                } else {
                    mcWrapper.setPoolState(3);
                    mcWrapper.setInSharedPool(false);
                }
                this.endingAccessToTLSPool();
            } else {
                mcWrapper.setPoolState(3);
                mcWrapper.setInSharedPool(false);
            }
        }
        if (this.traceWriter.isTraceEnabled()) {
            if (!mcWrapper.isLogWriterSet()) {
                this.turnOnLogWriter();
            }
        } else if (mcWrapper.isLogWriterSet()) {
            this.turnOffLogWriter();
        }
        this.activeRequest.decrementAndGet();
        if (isTracingEnabled && tc.isDebugEnabled() && mcWrapper.getPoolState() == 3) {
            ((MCWrapper)mcWrapper).setUnSharedPoolCoordinator(affinity);
        }
        if (!isTracingEnabled) return mcWrapper;
        if (!tc.isEntryEnabled()) return mcWrapper;
        Tr.exit((Object)this, (TraceComponent)tc, (String)"reserve", (Object)new Object[]{mcWrapper, mcWrapper.getManagedConnection()});
        return mcWrapper;
    }

    protected com.ibm.ws.j2c.MCWrapper validateConnection(com.ibm.ws.j2c.MCWrapper mcWrapper, ManagedConnectionFactory managedConnectionFactory, Subject subject, ConnectionRequestInfo requestInfo, int hashMapBucket, boolean connectionSharing, int hashCode) throws ResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"validateConnection", (Object[])new Object[]{mcWrapper});
        }
        ManagedConnection mc = mcWrapper.getManagedConnection();
        if ((managedConnectionFactory instanceof WSManagedConnectionFactory && ((WSManagedConnectionFactory)managedConnectionFactory).isPooledConnectionValidationEnabled() || ((MCWrapper)mcWrapper).isPretestThisConnection()) && this.gConfigProps.validatingMCFSupported) {
            ((MCWrapper)mcWrapper).setPretestThisConnection(false);
            int poolState = mcWrapper.getPoolState();
            mcWrapper.setPoolState(50);
            ValidatingManagedConnectionFactory validatingMCF = (ValidatingManagedConnectionFactory)managedConnectionFactory;
            Set invalid = validatingMCF.getInvalidConnections(Collections.singleton(mc));
            if (invalid.isEmpty()) {
                mcWrapper.setPoolState(poolState);
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"Connection is invalid, attempt to cleanup and destroy", (Object[])new Object[0]);
                }
                this.freePool[0].cleanupAndDestroyMCWrapper(mcWrapper);
                try {
                    mcWrapper = this.freePool[0].createManagedConnectionWithMCWrapper(managedConnectionFactory, subject, requestInfo, connectionSharing, hashCode);
                    mcWrapper.setHashMapBucket(hashMapBucket);
                }
                catch (ResourceException re) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)"ResourceException when trying to get a new connection, call preTestFailed.", (Object[])new Object[0]);
                    }
                    this.preTestFailed(managedConnectionFactory, subject, requestInfo, hashMapBucket, (Exception)((Object)re));
                }
                mc = mcWrapper.getManagedConnection();
                invalid = validatingMCF.getInvalidConnections(Collections.singleton(mc));
                if (invalid.isEmpty()) {
                    this.allowConnectionRequests = true;
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)"New connection failed validation, call preTestFailed.", (Object[])new Object[0]);
                    }
                    this.preTestFailed(managedConnectionFactory, subject, requestInfo, hashMapBucket, (Exception)((Object)new ResourceAllocationException()));
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"validateConnection");
        }
        return mcWrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected com.ibm.ws.j2c.MCWrapper searchTLSForMatchingConnection(ManagedConnectionFactory managedConnectionFactory, Subject subject, ConnectionRequestInfo cri) throws ResourceAllocationException {
        if (tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"searchTLSForMatchingConnection", (Object[])new Object[0]);
        }
        com.ibm.ws.j2c.MCWrapper mcWrapper = null;
        if (tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"Attempting to reassign a tls connection to waiting thread", (Object[])new Object[0]);
        }
        boolean searchTLS = false;
        this.updateToTLSPoolInProgress.set(true);
        Object object = this.updateToTLSPoolInProgressLockObject;
        synchronized (object) {
            try {
                this.sleep(20L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.activeTLSRequest.get() > 1) {
                try {
                    this.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.activeTLSRequest.get() > 1) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)("To many active requests to search tls, active request value is " + this.activeRequest.get()), (Object[])new Object[0]);
                    }
                } else {
                    searchTLS = true;
                }
            } else {
                searchTLS = true;
            }
            if (searchTLS) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"Searching tls for a connection.", (Object[])new Object[0]);
                }
                for (Map.Entry<com.ibm.ws.j2c.MCWrapper, ArrayList<com.ibm.ws.j2c.MCWrapper>> e : this.tlsArrayLists.entrySet()) {
                    com.ibm.ws.j2c.MCWrapper mcw = e.getKey();
                    if (mcw.getPoolState() != 6) continue;
                    ArrayList<com.ibm.ws.j2c.MCWrapper> mh = e.getValue();
                    mcWrapper = this.getMCWrapperFromMatch(subject, cri, managedConnectionFactory, mcw);
                    if (mcWrapper == null) continue;
                    mh.remove(mcw);
                    this.tlsArrayLists.remove(mcw);
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break;
                    ((MCWrapper)mcWrapper).setThreadID(((MCWrapper)mcWrapper).getThreadID() + "-search-removed");
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("removed mcWrapper from thread local " + mcWrapper), (Object[])new Object[0]);
                    break;
                }
            }
            this.updateToTLSPoolInProgress.set(false);
            this.updateToTLSPoolInProgressLockObject.notifyAll();
        }
        if (tc.isDebugEnabled()) {
            if (mcWrapper != null) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("Found matching tls connection " + mcWrapper), (Object[])new Object[0]);
            }
            Tr.debug((Object)this, (TraceComponent)tc, (String)("Current pool information" + this.toString()), (Object[])new Object[0]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"searchTLSForMatchingConnection");
        }
        return mcWrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkForMCsOnThread(int maxNumberOfMCsAllowableInThread2) throws ResourceException {
        String ivThreadId = RasHelper.getThreadId();
        int numberOfMatchingThreads = 0;
        ArrayList<MCWrapper> matchingMCWsOnThisThread = new ArrayList<MCWrapper>();
        this.mcToMCWMapWrite.lock();
        try {
            Collection<com.ibm.ws.j2c.MCWrapper> s = this.mcToMCWMap.values();
            for (MCWrapper mCWrapper : s) {
                if (!ivThreadId.equals(mCWrapper.getThreadID())) continue;
                matchingMCWsOnThisThread.add(mCWrapper);
                if (++numberOfMatchingThreads < maxNumberOfMCsAllowableInThread2) continue;
                StringBuffer matchingThreadBuffer = new StringBuffer(1000);
                for (int j = 0; j < numberOfMatchingThreads; ++j) {
                    MCWrapper mCWrapper2 = (MCWrapper)matchingMCWsOnThisThread.get(j);
                    long startHoldTime = mCWrapper2.getHoldTimeStart();
                    long holdTime = System.currentTimeMillis() - startHoldTime;
                    Date startDateTime = new Date(startHoldTime);
                    long timeInUseInSeconds = holdTime / 1000L;
                    Throwable t = mCWrapper2.getInitialRequestStackTrace();
                    if (t == null) continue;
                    matchingThreadBuffer.append("  " + mCWrapper2);
                    matchingThreadBuffer.append("     Start time inuse " + startDateTime + " Time inuse " + timeInUseInSeconds + " (seconds)" + this.nl);
                    matchingThreadBuffer.append("     Last allocation time " + new Date(mCWrapper2.getLastAllocationTime()) + this.nl);
                    matchingThreadBuffer.append("       getConnection stack trace information:" + this.nl);
                    StackTraceElement[] ste = t.getStackTrace();
                    for (int k = 0; k < ste.length; ++k) {
                        if (k <= 1) continue;
                        matchingThreadBuffer.append("          " + ste[k].toString() + this.nl);
                    }
                    matchingThreadBuffer.append(this.nl);
                }
                String debugText = "Exceeded the number of allowable managed connection on thread " + ivThreadId + ".  " + maxNumberOfMCsAllowableInThread2 + " managed connections are already being used on this thread.    Managed connection being used on this thread " + this.nl + matchingThreadBuffer.toString();
                if (tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)debugText, (Object[])new Object[0]);
                }
                throw new ResourceException(debugText);
            }
        }
        finally {
            this.mcToMCWMapWrite.unlock();
        }
    }

    private void turnOnLogWriter() throws ResourceException {
        this.mcToMCWMapWrite.lock();
        try {
            for (com.ibm.ws.j2c.MCWrapper mcw : this.mcToMCWMap.values()) {
                mcw.getManagedConnection().setLogWriter(this.printWriter);
                mcw.setLogWriterSet(true);
            }
        }
        finally {
            this.mcToMCWMapWrite.unlock();
        }
    }

    private void turnOffLogWriter() throws ResourceException {
        this.mcToMCWMapWrite.lock();
        try {
            for (com.ibm.ws.j2c.MCWrapper mcw : this.mcToMCWMap.values()) {
                mcw.getManagedConnection().setLogWriter(null);
                mcw.setLogWriterSet(false);
            }
        }
        finally {
            this.mcToMCWMapWrite.unlock();
        }
    }

    private void preTestFailed(ManagedConnectionFactory managedConnectionFactory, Subject subject, ConnectionRequestInfo cri, int hashMapBucket, Exception exn) throws ResourceAllocationException {
        Object object = this.poolManagerTestConnectionLock;
        synchronized (object) {
            this.totalConnectionCount.decrementAndGet();
            this.fatalErrorNotification(managedConnectionFactory, null, null);
            Object[] parms = new Object[]{"reserve", CommonFunction.exceptionList(exn), "ResourceAllocationException", this.gConfigProps.cfName};
            Tr.error((TraceComponent)tc, (String)"POOL_MANAGER_EXCP_CCF2_0002_J2CA0046", (Object[])parms);
            ResourceAllocationException throwMe = new ResourceAllocationException(exn.getMessage());
            throwMe.initCause((Throwable)exn);
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"Abnormal exit from method preTestFailed", (Object[])new Object[0]);
            }
            this.activeRequest.decrementAndGet();
            throw throwMe;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkForActiveConnections(int value) {
        boolean activeConnections = false;
        if (value == 0) {
            this.mcToMCWMapWrite.lock();
            try {
                Collection<com.ibm.ws.j2c.MCWrapper> mcWrappers = this.mcToMCWMap.values();
                for (com.ibm.ws.j2c.MCWrapper mcw : mcWrappers) {
                    if (this.activeRequest.get() > 0) {
                        activeConnections = true;
                    }
                    int poolState = mcw.getPoolState();
                    if (poolState == 1 || poolState == 9) continue;
                    activeConnections = true;
                }
            }
            finally {
                this.mcToMCWMapWrite.unlock();
            }
        } else if (this.activeRequest.get() > 0) {
            activeConnections = true;
        }
        return activeConnections;
    }

    public synchronized String gatherPoolStatisticalData() {
        StringBuffer rVal = new StringBuffer();
        rVal.append("*************************************" + this.nl);
        rVal.append("*************************************" + this.nl);
        long total_sop_gets = 0L;
        long total_snop_gets = 0L;
        long total_sop_gets_notfound = 0L;
        long total_snop_gets_notfound = 0L;
        long total_fop_gets = 0L;
        long total_fnop_gets = 0L;
        long total_fop_get_notfound = 0L;
        long total_fnop_get_notfound = 0L;
        long total_freePoolQueuedRequests = 0L;
        long total_freePoolCreateManagedConnection = 0L;
        long total_numberOfClaimedVictims = 0L;
        long total_numberOfClaimedVictims_CRIMM = 0L;
        long total_numberOfClaimedVictims_SubjectMM = 0L;
        long total_numberOfClaimedVictims_CRISubjectMM = 0L;
        for (int j = 0; j < this.maxFreePoolHashSize; ++j) {
            total_fop_gets = (long)this.freePool[j].fop_gets + total_fop_gets;
            total_fnop_gets = (long)this.freePool[j].fnop_gets + total_fnop_gets;
            total_numberOfClaimedVictims = (long)this.freePool[j].numberOfClaimedVictims + total_numberOfClaimedVictims;
            total_numberOfClaimedVictims_CRIMM = (long)this.freePool[j].numberOfClaimedVictims_CRI_Only_Mismatch + total_numberOfClaimedVictims_CRIMM;
            total_numberOfClaimedVictims_SubjectMM = (long)this.freePool[j].numberOfClaimedVictims_Subject_Only_Mismatch + total_numberOfClaimedVictims_SubjectMM;
            total_numberOfClaimedVictims_CRISubjectMM = (long)this.freePool[j].numberOfClaimedVictims_CRI_Subject_Mismatch + total_numberOfClaimedVictims_CRISubjectMM;
            total_fop_get_notfound = (long)this.freePool[j].fop_get_notfound + total_fop_get_notfound;
            total_fnop_get_notfound = (long)this.freePool[j].fnop_get_notfound + total_fnop_get_notfound;
            total_freePoolCreateManagedConnection = (long)this.freePool[j].freePoolCreateManagedConnection + total_freePoolCreateManagedConnection;
            total_freePoolQueuedRequests = (long)this.freePool[j].freePoolQueuedRequests + total_freePoolQueuedRequests;
        }
        for (int i = 0; i < this.maxSharedBuckets; ++i) {
            total_sop_gets = (long)this.sharedPool[i].sop_gets + total_sop_gets;
            total_snop_gets = (long)this.sharedPool[i].snop_gets + total_snop_gets;
            total_sop_gets_notfound = (long)this.sharedPool[i].sop_gets_notfound + total_sop_gets_notfound;
            total_snop_gets_notfound = (long)this.sharedPool[i].snop_gets_notfound + total_snop_gets_notfound;
        }
        rVal.append("Total number of connection requests " + this.totalPoolConnectionRequests + this.nl);
        rVal.append("Shared good optimistic gets " + total_sop_gets + this.nl);
        rVal.append("Shared non optimistic gets " + total_snop_gets + this.nl);
        rVal.append("Shared sop_gets_notfound " + total_sop_gets_notfound + this.nl);
        rVal.append("Shared snop_gets_notfound " + total_snop_gets_notfound + this.nl);
        long totalShared = total_sop_gets + total_snop_gets + total_sop_gets_notfound + total_snop_gets_notfound;
        rVal.append("    Total number of connection requests " + totalShared + this.nl);
        long sharedGood = total_sop_gets + total_sop_gets_notfound;
        rVal.append("Total good shared pool access " + sharedGood + this.nl);
        long sharedBad = total_snop_gets + total_snop_gets_notfound;
        rVal.append("Total bad shared pool access " + sharedBad + this.nl);
        long sharedPoolGoodAccessPercent = 100L;
        if (totalShared > 0L) {
            sharedPoolGoodAccessPercent = sharedGood * 100L / totalShared;
        }
        rVal.append("    Good Shared Access " + sharedPoolGoodAccessPercent + "%" + this.nl);
        if (sharedPoolGoodAccessPercent < 80L) {
            rVal.append("Need to increase the shared pool partition size" + this.nl + this.nl);
        } else {
            rVal.append(this.nl);
        }
        rVal.append("Free good optimistic gets " + total_fop_gets + this.nl);
        rVal.append("Free non optimistic gets " + total_fnop_gets + this.nl);
        rVal.append("Free good optimistic get not found " + total_fop_get_notfound + this.nl);
        rVal.append("Free non optimistic get not found " + total_fnop_get_notfound + this.nl);
        rVal.append("Wait skip code " + this.waitSkip + this.nl);
        rVal.append("Number of connection created " + total_freePoolCreateManagedConnection + this.nl);
        long totalFree = total_fop_gets + total_fnop_gets + total_fnop_get_notfound + total_fop_get_notfound + (long)this.waitSkip;
        rVal.append("Free pool accesses " + totalFree + this.nl);
        long freeGood = total_fop_gets + total_fop_get_notfound + (long)this.waitSkip;
        rVal.append("Total good free pool access " + freeGood + this.nl);
        long freeBad = total_fnop_gets + total_fnop_get_notfound;
        rVal.append("Total bad free pool access " + freeBad + this.nl);
        rVal.append("Total Waiters " + total_freePoolQueuedRequests + this.nl);
        long freePoolGoodAccessPercent = 0L;
        if (freeGood > 0L) {
            freePoolGoodAccessPercent = freeGood * 100L / totalFree;
        }
        rVal.append("    Good Free Access " + freePoolGoodAccessPercent + "%" + this.nl + this.nl);
        if (freePoolGoodAccessPercent < 90L) {
            rVal.append("Need to increase the max connections pool partition size" + this.nl);
        }
        rVal.append("Numer of claimed victims " + total_numberOfClaimedVictims + this.nl);
        this.claimedVictimPercent = 0.0;
        if (total_numberOfClaimedVictims > 0L) {
            this.claimedVictimPercent = (double)total_numberOfClaimedVictims * 100.0 / (double)totalFree;
        }
        rVal.append("Percent of connections claimed as a victim " + this.claimedVictimPercent + this.nl);
        rVal.append("  Victims claimed due to Subject mismatch only    " + total_numberOfClaimedVictims_SubjectMM + this.nl);
        rVal.append("  Victims claimed due to CRI mismatch only        " + total_numberOfClaimedVictims_CRIMM + this.nl);
        rVal.append("  Victims claimed due to Subject and CRI mismatch " + total_numberOfClaimedVictims_CRISubjectMM + this.nl);
        return rVal.toString();
    }

    public synchronized String gatherClaimVictimStatisticalData() {
        StringBuffer rVal = new StringBuffer();
        rVal.append("*************************************" + this.nl);
        rVal.append("*************************************" + this.nl);
        long total_numberOfClaimedVictims = 0L;
        long total_numberOfClaimedVictims_CRIMM = 0L;
        long total_numberOfClaimedVictims_SubjectMM = 0L;
        long total_numberOfClaimedVictims_CRISubjectMM = 0L;
        long total_fop_gets = 0L;
        long total_fnop_gets = 0L;
        long total_fop_get_notfound = 0L;
        long total_fnop_get_notfound = 0L;
        for (int j = 0; j < this.maxFreePoolHashSize; ++j) {
            total_fop_gets = (long)this.freePool[j].fop_gets + total_fop_gets;
            total_fnop_gets = (long)this.freePool[j].fnop_gets + total_fnop_gets;
            total_numberOfClaimedVictims = (long)this.freePool[j].numberOfClaimedVictims + total_numberOfClaimedVictims;
            total_numberOfClaimedVictims_CRIMM = (long)this.freePool[j].numberOfClaimedVictims_CRI_Only_Mismatch + total_numberOfClaimedVictims_CRIMM;
            total_numberOfClaimedVictims_SubjectMM = (long)this.freePool[j].numberOfClaimedVictims_Subject_Only_Mismatch + total_numberOfClaimedVictims_SubjectMM;
            total_numberOfClaimedVictims_CRISubjectMM = (long)this.freePool[j].numberOfClaimedVictims_CRI_Subject_Mismatch + total_numberOfClaimedVictims_CRISubjectMM;
            total_fop_get_notfound = (long)this.freePool[j].fop_get_notfound + total_fop_get_notfound;
            total_fnop_get_notfound = (long)this.freePool[j].fnop_get_notfound + total_fnop_get_notfound;
        }
        long totalFree = total_fop_gets + total_fnop_gets + total_fnop_get_notfound + total_fop_get_notfound + (long)this.waitSkip;
        rVal.append("Numer of claimed victims " + total_numberOfClaimedVictims + this.nl);
        rVal.append("Free pool accesses " + totalFree + this.nl);
        long claimedVictimPercent = 0L;
        if (total_numberOfClaimedVictims > 0L) {
            claimedVictimPercent = total_numberOfClaimedVictims * 100L / totalFree;
        }
        rVal.append("Percent of connections claimed as a victim " + claimedVictimPercent + this.nl);
        rVal.append("  Victims claimed due to Subject mismatch only    " + total_numberOfClaimedVictims_SubjectMM + this.nl);
        rVal.append("  Victims claimed due to CRI mismatch only        " + total_numberOfClaimedVictims_CRIMM + this.nl);
        rVal.append("  Victims claimed due to Subject and CRI mismatch " + total_numberOfClaimedVictims_CRISubjectMM + this.nl);
        return rVal.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purgePoolContents() throws ResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"purgePoolContents", (Object[])new Object[]{this.gConfigProps.cfName});
        }
        ArrayList<com.ibm.ws.j2c.MCWrapper> destroyMCWrapperList = new ArrayList<com.ibm.ws.j2c.MCWrapper>();
        Object object = this.destroyMCWrapperListLock;
        synchronized (object) {
            for (int j = 0; j < this.gConfigProps.getMaxFreePoolHashSize(); ++j) {
                Object object2 = this.freePool[j].freeConnectionLockObject;
                synchronized (object2) {
                    this.freePool[j].incrementFatalErrorValue(j);
                    if (this.freePool[j].mcWrapperList.size() > 0) {
                        int mcWrapperListIndex;
                        for (int k = mcWrapperListIndex = this.freePool[j].mcWrapperList.size() - 1; k >= 0; --k) {
                            com.ibm.ws.j2c.MCWrapper mcw = (com.ibm.ws.j2c.MCWrapper)this.freePool[j].mcWrapperList.remove(k);
                            if (mcw.isMarkedForPurgeDestruction()) continue;
                            mcw.setPoolState(0);
                            mcw.markForPurgeDestruction();
                            destroyMCWrapperList.add(mcw);
                            --this.freePool[j].numberOfConnectionsAssignedToThisFreePool;
                        }
                    }
                    continue;
                }
            }
        }
        if (this.localConnection_ != null) {
            boolean purgeTLS = false;
            this.updateToTLSPoolInProgress.set(true);
            Object j = this.updateToTLSPoolInProgressLockObject;
            synchronized (j) {
                try {
                    this.sleep(20L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.activeTLSRequest.get() > 0) {
                    try {
                        this.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (this.activeTLSRequest.get() > 0) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((Object)this, (TraceComponent)tc, (String)("To many active requests to search tls, active request value is " + this.activeRequest.get()), (Object[])new Object[0]);
                        }
                    } else {
                        purgeTLS = true;
                    }
                } else {
                    purgeTLS = true;
                }
                if (purgeTLS) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)"Searching tls for a connections to purge.", (Object[])new Object[0]);
                    }
                    for (Map.Entry<com.ibm.ws.j2c.MCWrapper, ArrayList<com.ibm.ws.j2c.MCWrapper>> e : this.tlsArrayLists.entrySet()) {
                        com.ibm.ws.j2c.MCWrapper mcw = e.getKey();
                        if (mcw.getPoolState() != 6) continue;
                        ArrayList<com.ibm.ws.j2c.MCWrapper> mh = e.getValue();
                        mh.remove(mcw);
                        this.tlsArrayLists.remove(mcw);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            ((MCWrapper)mcw).setThreadID(((MCWrapper)mcw).getThreadID() + "-purge-removed");
                            Tr.debug((Object)this, (TraceComponent)tc, (String)("removed mcWrapper from thread local " + mcw), (Object[])new Object[0]);
                        }
                        if (mcw.isMarkedForPurgeDestruction()) continue;
                        mcw.setPoolState(0);
                        mcw.markForPurgeDestruction();
                        destroyMCWrapperList.add(mcw);
                    }
                }
                this.updateToTLSPoolInProgress.set(false);
                this.updateToTLSPoolInProgressLockObject.notifyAll();
            }
        }
        for (int i = 0; i < destroyMCWrapperList.size(); ++i) {
            com.ibm.ws.j2c.MCWrapper mcw = (com.ibm.ws.j2c.MCWrapper)destroyMCWrapperList.get(i);
            this.freePool[0].cleanupAndDestroyMCWrapper(mcw);
            this.totalConnectionCount.decrementAndGet();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"purgePoolContents");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String abortConnections(String actionName, Object[] params) throws ResourceException {
        boolean entryExitEnabled;
        boolean debugEnabled = TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled();
        boolean bl = entryExitEnabled = TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled();
        if (entryExitEnabled) {
            Tr.entry((TraceComponent)tc, (String)abortConnectionsActionName, (Object[])new Object[0]);
        }
        long maxInUseIdleValue = 0L;
        if (params[1] instanceof String) {
            maxInUseIdleValue = Long.parseLong((String)params[1]);
        } else if (params[1] instanceof Long) {
            maxInUseIdleValue = (Long)params[1];
        } else if (params[1] instanceof Integer) {
            maxInUseIdleValue = ((Integer)params[1]).longValue();
        } else {
            Tr.error((TraceComponent)tc, (String)"INVALID_MBEAN_INVOKE_PARAM_J2CA8060", (Object[])new Object[]{Arrays.toString(params), actionName});
            String translatedError = Tr.formatMessage((TraceComponent)tc, (String)"INVALID_MBEAN_INVOKE_PARAM_J2CA8060", (Object[])new Object[]{Arrays.toString(params), actionName});
            throw new ResourceException((Throwable)new IllegalArgumentException(translatedError));
        }
        String errorString = null;
        StringBuffer sb = new StringBuffer();
        this.updateToPoolInProgress = true;
        Object object = this.updateToPoolInProgressLockObject;
        synchronized (object) {
            long inuseAbortedHighValue = 0L;
            long inuseAbortedLowValue = Long.MAX_VALUE;
            long inuseTotalAborted = 0L;
            long inuseNotAbortedHighValue = 0L;
            long inuseNotAbortedLowValue = Long.MAX_VALUE;
            long inuseNotTotalAborted = 0L;
            int inuseNotAborted = 0;
            boolean parkedConnectionExists = false;
            try {
                if (this.checkForActiveConnections(1)) {
                    try {
                        if (debugEnabled) {
                            Tr.debug((TraceComponent)tc, (String)"Active connection pool activity detected, try again in 100 milliseconds", (Object[])new Object[0]);
                        }
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        if (debugEnabled) {
                            Tr.debug((TraceComponent)tc, (String)"abortConnections thread interrupted", (Object[])new Object[0]);
                        }
                        if (entryExitEnabled) {
                            Tr.exit((TraceComponent)tc, (String)abortConnectionsActionName);
                        }
                        throw new ResourceException((Throwable)e);
                    }
                }
                if (this.checkForActiveConnections(1)) {
                    this.updateToPoolInProgress = false;
                    this.updateToPoolInProgressLockObject.notifyAll();
                    errorString = "Active connection pool activity occurring that prevents  abortConnections.   Try again.";
                    ResourceException e = new ResourceException(errorString);
                    throw e;
                }
                ArrayList<com.ibm.ws.j2c.MCWrapper> abortMCWrapperList = new ArrayList<com.ibm.ws.j2c.MCWrapper>();
                this.mcToMCWMapWrite.lock();
                try {
                    Collection<com.ibm.ws.j2c.MCWrapper> mcWrappers = this.mcToMCWMap.values();
                    for (com.ibm.ws.j2c.MCWrapper mcw : mcWrappers) {
                        if (mcw.getPoolState() == 2 || mcw.getPoolState() == 3) {
                            long startHoldTime = ((MCWrapper)mcw).getHoldTimeStart();
                            long currentTime = System.currentTimeMillis();
                            long inuseTime = currentTime - startHoldTime;
                            if (inuseTime > maxInUseIdleValue) {
                                if (debugEnabled) {
                                    Tr.debug((TraceComponent)tc, (String)("Managed connection added to abort list. In use time is greater than maximum in use idle time " + inuseTime + "/" + maxInUseIdleValue + " (in use time/maximum in use time)"), (Object[])new Object[]{mcw});
                                }
                                abortMCWrapperList.add(mcw);
                                if (inuseAbortedHighValue < inuseTime) {
                                    inuseAbortedHighValue = inuseTime;
                                }
                                if (inuseAbortedLowValue > inuseTime) {
                                    inuseAbortedLowValue = inuseTime;
                                }
                                inuseTotalAborted += inuseTime;
                            } else {
                                if (debugEnabled) {
                                    Tr.debug((TraceComponent)tc, (String)("Managed connection was not added to abort list. In use time is not greater than maximum in use idle time " + inuseTime + "/" + maxInUseIdleValue + " (in use time/maximum in use time)"), (Object[])new Object[]{mcw});
                                }
                                if (inuseNotAbortedHighValue < inuseTime) {
                                    inuseNotAbortedHighValue = inuseTime;
                                }
                                if (inuseNotAbortedLowValue > inuseTime) {
                                    inuseNotAbortedLowValue = inuseTime;
                                }
                                inuseNotTotalAborted += inuseTime;
                                ++inuseNotAborted;
                            }
                        }
                        if (mcw.getPoolState() != 9) continue;
                        parkedConnectionExists = true;
                    }
                }
                finally {
                    this.mcToMCWMapWrite.unlock();
                }
                int abortedListSize = abortMCWrapperList.size();
                if (abortedListSize > 0) {
                    for (com.ibm.ws.j2c.MCWrapper mcw : abortMCWrapperList) {
                        if (mcw instanceof MCWrapper && ((MCWrapper)mcw).abortMC(true) || !debugEnabled) continue;
                        Tr.debug((TraceComponent)tc, (String)"Unable to abort connection with connection.abort().  Review trace for failures.", (Object[])new Object[]{mcw});
                    }
                    long averageTime = inuseTotalAborted / (long)abortedListSize;
                    String idleInUseAbortinfo = " abortConnections maximum in use time " + maxInUseIdleValue + " for pool jndi name " + this.gConfigProps.getJNDIName() + " - " + abortedListSize + " in use connections added to the in use abort list with the highest/lowest in use times " + inuseAbortedHighValue + "/" + inuseAbortedLowValue + " Average in use time " + averageTime + " (all time values in milliseconds)";
                    sb.append(idleInUseAbortinfo + this.nl);
                    if (debugEnabled) {
                        Tr.debug((TraceComponent)tc, (String)idleInUseAbortinfo, (Object[])new Object[0]);
                    }
                }
                int remainConnectionInPool = this.mcToMCWMap.size();
                if (parkedConnectionExists) {
                    --remainConnectionInPool;
                }
                if (remainConnectionInPool > 0) {
                    if (inuseNotAborted == 0) {
                        String freeNotIdleInUseInfo = " abortConnections maximum in use time " + maxInUseIdleValue + " for pool jndi name " + this.gConfigProps.getJNDIName() + " - " + remainConnectionInPool + " free connections not added to the in use abort list ";
                        sb.append(freeNotIdleInUseInfo + this.nl);
                        if (debugEnabled) {
                            Tr.debug((TraceComponent)tc, (String)freeNotIdleInUseInfo, (Object[])new Object[0]);
                        }
                    } else {
                        long averageTime = inuseNotTotalAborted / (long)inuseNotAborted;
                        int freeConnections = remainConnectionInPool - inuseNotAborted;
                        String inuseNotIdleInUseInfo = " abortConnections maximum in use time " + maxInUseIdleValue + " for pool jndi name " + this.gConfigProps.getJNDIName() + " - " + inuseNotAborted + " in use connections not added to the in use abort list with the highest/lowest in use times " + inuseNotAbortedHighValue + "/" + inuseNotAbortedLowValue + " Average in use time " + averageTime + " (all time values in milliseconds)";
                        sb.append(inuseNotIdleInUseInfo + this.nl);
                        String freeNotIdleInUseInfo = " abortConnections maximum in use time " + maxInUseIdleValue + " for pool jndi name " + this.gConfigProps.getJNDIName() + " - " + freeConnections + " free connections not added to the in use abort list ";
                        sb.append(freeNotIdleInUseInfo + this.nl);
                        if (debugEnabled) {
                            Tr.debug((TraceComponent)tc, (String)inuseNotIdleInUseInfo, (Object[])new Object[0]);
                            Tr.debug((TraceComponent)tc, (String)freeNotIdleInUseInfo, (Object[])new Object[0]);
                        }
                    }
                }
            }
            finally {
                this.updateToPoolInProgress = false;
                this.updateToPoolInProgressLockObject.notifyAll();
                if (debugEnabled) {
                    if (errorString == null) {
                        Tr.debug((TraceComponent)tc, (String)("Completed processing abortConnections - " + this.nl + this.toString()), (Object[])new Object[0]);
                    } else {
                        Tr.debug((TraceComponent)tc, (String)(errorString + this.nl + this.toString()), (Object[])new Object[0]);
                    }
                }
                if (entryExitEnabled) {
                    Tr.exit((TraceComponent)tc, (String)abortConnectionsActionName);
                }
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purgePoolContents(String value) throws ResourceException {
        Object object;
        if (!"immediate".equalsIgnoreCase(value) && !"abort".equalsIgnoreCase(value)) {
            this.purgePoolContents();
            return;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"purgePoolContents", (Object[])new Object[0]);
        }
        boolean purgeWithAbort = "abort".equalsIgnoreCase(value);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Clearing free pool connections", (Object[])new Object[0]);
        }
        for (int j = 0; j < this.maxFreePoolHashSize; ++j) {
            object = this.freePool[j].freeConnectionLockObject;
            synchronized (object) {
                this.freePool[j].incrementFatalErrorValue(j);
                if (this.freePool[j].mcWrapperList.size() > 0) {
                    int mcWrapperListIndex;
                    for (int k = mcWrapperListIndex = this.freePool[j].mcWrapperList.size() - 1; k >= 0; --k) {
                        com.ibm.ws.j2c.MCWrapper mcw = (com.ibm.ws.j2c.MCWrapper)this.freePool[j].mcWrapperList.remove(k);
                        if (mcw.isMarkedForPurgeDestruction()) continue;
                        mcw.setDestroyState();
                        mcw.markForPurgeDestruction();
                        --this.freePool[j].numberOfConnectionsAssignedToThisFreePool;
                        if (mcw.getManagedConnection() instanceof WSManagedConnection) {
                            ((WSManagedConnection)mcw.getManagedConnection()).markStale();
                        }
                        if (purgeWithAbort && mcw instanceof MCWrapper && ((MCWrapper)mcw).abortMC()) continue;
                        if (purgeWithAbort && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Unable to purge connection with abort.  Using ThreadSupportedCleanupAndDestroy.", (Object[])new Object[]{mcw});
                        }
                        com.ibm.ws.j2c.MCWrapper tempMCWrapper = mcw;
                        FreePool tempFP = this.freePool[j];
                        ThreadSupportedCleanupAndDestroy tscd = new ThreadSupportedCleanupAndDestroy(this.tscdList, tempFP, tempMCWrapper);
                        this.tscdList.add(tscd);
                        ((ExecutorService)this.connectorSvc.execSvcRef.getServiceWithException()).submit(tscd);
                        this.totalConnectionCount.decrementAndGet();
                    }
                }
                continue;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Marking inuse pool connections stale", (Object[])new Object[0]);
        }
        for (int i = 0; i < this.maxSharedBuckets; ++i) {
            object = this.sharedPool[i].sharedLockObject;
            synchronized (object) {
                if (this.sharedPool[i].getMCWrapperListSize() > 0) {
                    com.ibm.ws.j2c.MCWrapper[] mcwl = this.sharedPool[i].getMCWrapperList();
                    for (int j = 0; j < this.sharedPool[i].getMCWrapperListSize(); ++j) {
                        if (mcwl[j].isDestroyState()) continue;
                        mcwl[j].setDestroyState();
                        if (purgeWithAbort && mcwl[j] instanceof MCWrapper && ((MCWrapper)mcwl[j]).abortMC()) continue;
                        if (mcwl[j].getManagedConnection() instanceof WSManagedConnection) {
                            ((WSManagedConnection)mcwl[j].getManagedConnection()).markStale();
                        }
                        this.totalConnectionCount.decrementAndGet();
                    }
                }
                continue;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Clearing unshared pool connections", (Object[])new Object[0]);
        }
        this.mcToMCWMapWrite.lock();
        try {
            int mcToMCWSize = this.mcToMCWMap.size();
            Object[] tempObject = this.mcToMCWMap.values().toArray();
            for (int ti = 0; ti < mcToMCWSize; ++ti) {
                com.ibm.ws.j2c.MCWrapper mcw = (com.ibm.ws.j2c.MCWrapper)tempObject[ti];
                if (mcw.getPoolState() != 3) continue;
                mcw.setDestroyState();
                if (purgeWithAbort && mcw instanceof MCWrapper && ((MCWrapper)mcw).abortMC()) continue;
                ManagedConnection mc = mcw.getManagedConnection();
                if (mc instanceof WSManagedConnection) {
                    ((WSManagedConnection)mc).markStale();
                }
                this.totalConnectionCount.decrementAndGet();
            }
        }
        finally {
            this.mcToMCWMapWrite.unlock();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"purgePoolContents");
        }
    }

    protected com.ibm.ws.j2c.MCWrapper getFreeWaiterConnection(ManagedConnectionFactory managedConnectionFactory, Subject subject, ConnectionRequestInfo cri) throws ResourceAllocationException, ConnectionWaitTimeoutException {
        if (tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"getFreeWaiterConnection", (Object[])new Object[]{this.gConfigProps.cfName});
        }
        com.ibm.ws.j2c.MCWrapper mcWrapper = null;
        com.ibm.ws.j2c.MCWrapper mcWrapperTemp = null;
        int mcwlSize = this.mcWrapperWaiterList.size();
        if (mcwlSize > 0) {
            int mcwlIndex = mcwlSize - 1;
            mcWrapperTemp = (com.ibm.ws.j2c.MCWrapper)this.mcWrapperWaiterList.remove(mcwlIndex);
            mcWrapperTemp.setPoolState(0);
            mcWrapper = this.getMCWrapperFromMatch(subject, cri, managedConnectionFactory, mcWrapperTemp);
            if (((MCWrapper)mcWrapperTemp).do_not_reuse_mcw) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("Connection error occurred for this mcw " + mcWrapperTemp + ", mcw will not be reused"), (Object[])new Object[0]);
                }
                this.freePool[0].cleanupAndDestroyMCWrapper(mcWrapperTemp);
                if (this.waiterCount > 0 && this.waiterCount > this.mcWrapperWaiterList.size()) {
                    this.waiterFreePoolLock.notify();
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((Object)this, (TraceComponent)tc, (String)"getFreeWaiterConnection", (Object)new Object[]{"Returning destroyed mcWrapper", mcWrapperTemp});
                }
                return mcWrapperTemp;
            }
            if (mcWrapper == null) {
                this.mcWrapperWaiterList.add(mcWrapperTemp);
                mcWrapperTemp.setPoolState(4);
                for (int i = mcwlIndex - 1; i >= 0; --i) {
                    mcWrapperTemp = (com.ibm.ws.j2c.MCWrapper)this.mcWrapperWaiterList.get(i);
                    mcWrapper = this.getMCWrapperFromMatch(subject, cri, managedConnectionFactory, mcWrapperTemp);
                    if (((MCWrapper)mcWrapperTemp).do_not_reuse_mcw) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((Object)this, (TraceComponent)tc, (String)("Connection error occurred for this mcw " + mcWrapperTemp + ", mcw will not be reused"), (Object[])new Object[0]);
                        }
                        this.mcWrapperWaiterList.remove(i);
                        this.freePool[0].cleanupAndDestroyMCWrapper(mcWrapperTemp);
                        if (this.waiterCount > 0 && this.waiterCount > this.mcWrapperWaiterList.size()) {
                            this.waiterFreePoolLock.notify();
                        }
                        if (tc.isEntryEnabled()) {
                            Tr.exit((Object)this, (TraceComponent)tc, (String)"getFreeWaiterConnection", (Object)new Object[]{"Returning destroyed mcWrapper", mcWrapperTemp});
                        }
                        return mcWrapperTemp;
                    }
                    if (mcWrapper == null) continue;
                    this.mcWrapperWaiterList.remove(i);
                    mcWrapper.setPoolState(0);
                    break;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            if (tc.isDebugEnabled()) {
                if (mcWrapper != null) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("Returning mcWrapper " + mcWrapper), (Object[])new Object[0]);
                } else {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"MCWrapper was not found in Free Pool", (Object[])new Object[0]);
                }
            }
            Tr.exit((Object)this, (TraceComponent)tc, (String)"getFreeWaiterConnection", mcWrapper);
        }
        return mcWrapper;
    }

    protected com.ibm.ws.j2c.MCWrapper claimVictim(ManagedConnectionFactory managedConnectionFactory, int hashCode, Subject subject, ConnectionRequestInfo cri) throws ResourceAllocationException {
        if (tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"claimVictim", (Object[])new Object[0]);
        }
        com.ibm.ws.j2c.MCWrapper mcWrapper = null;
        int mcWrapperListSize = this.freePool[hashCode].mcWrapperList.size();
        if (mcWrapperListSize > 0) {
            com.ibm.ws.j2c.MCWrapper mcw = (com.ibm.ws.j2c.MCWrapper)this.freePool[hashCode].mcWrapperList.remove(0);
            mcw.setPoolState(0);
            mcWrapper = this.getMCWrapperFromMatch(subject, cri, managedConnectionFactory, mcw);
            if (((MCWrapper)mcw).do_not_reuse_mcw) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("Connection error occurred for this mcw " + mcw + ", mcw will not be reused"), (Object[])new Object[0]);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("Claiming victim " + mcw), (Object[])new Object[0]);
                }
                this.freePool[hashCode].cleanupAndDestroyMCWrapper(mcw);
                --this.freePool[hashCode].numberOfConnectionsAssignedToThisFreePool;
                if (tc.isEntryEnabled()) {
                    Tr.exit((Object)this, (TraceComponent)tc, (String)"claimVictim", (Object)mcWrapper);
                }
                return mcWrapper;
            }
            if (mcWrapper == null) {
                ManagedConnection mc = mcw.getManagedConnection();
                if (this.gConfigProps.sendClaimedVictomToGetConnection && mc instanceof WSManagedConnection) {
                    ((WSManagedConnection)mc).setClaimedVictim();
                    mcWrapper = mcw;
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)("Claiming victim " + mcw), (Object[])new Object[0]);
                    }
                    this.freePool[hashCode].cleanupAndDestroyMCWrapper(mcw);
                    --this.freePool[hashCode].numberOfConnectionsAssignedToThisFreePool;
                    if (tc.isDebugEnabled()) {
                        ++this.freePool[hashCode].numberOfClaimedVictims;
                        boolean subjectMismatch = false;
                        boolean criMismatch = false;
                        if (cri == null && mcw.getCRI() != null || cri != null && mcw.getCRI() == null || cri != null && !cri.equals((Object)mcw.getCRI())) {
                            criMismatch = true;
                        }
                        if (subject == null && mcw.getSubject() != null || subject != null && mcw.getSubject() == null) {
                            subjectMismatch = true;
                        } else if (subject != null) {
                            Equals equalsHelper = new Equals();
                            equalsHelper.setSubjects(subject, mcw.getSubject());
                            if (!AccessController.doPrivileged(equalsHelper).booleanValue()) {
                                subjectMismatch = true;
                            }
                        }
                        if (criMismatch && subjectMismatch) {
                            ++this.freePool[hashCode].numberOfClaimedVictims_CRI_Subject_Mismatch;
                        } else if (criMismatch) {
                            ++this.freePool[hashCode].numberOfClaimedVictims_CRI_Only_Mismatch;
                        } else if (subjectMismatch) {
                            ++this.freePool[hashCode].numberOfClaimedVictims_Subject_Only_Mismatch;
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug((Object)this, (TraceComponent)tc, (String)this.gatherClaimVictimStatisticalData(), (Object[])new Object[0]);
                        }
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"claimVictim", mcWrapper);
        }
        return mcWrapper;
    }

    protected com.ibm.ws.j2c.MCWrapper getMCWrapperFromMatch(Subject subject, ConnectionRequestInfo cri, ManagedConnectionFactory managedFactory, com.ibm.ws.j2c.MCWrapper mcWrapperTemp) throws ResourceAllocationException {
        if (tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"getMCWrapperFromMatch", (Object[])new Object[]{mcWrapperTemp});
        }
        com.ibm.ws.j2c.MCWrapper mcWrapper = null;
        ManagedConnection mc = null;
        HashSet<ManagedConnection> freePoolMCSet = new HashSet<ManagedConnection>(1);
        freePoolMCSet.add(mcWrapperTemp.getManagedConnection());
        try {
            int poolState = mcWrapperTemp.getPoolState();
            mcWrapperTemp.setPoolState(50);
            mc = managedFactory.matchManagedConnections(freePoolMCSet, subject, cri);
            mcWrapperTemp.setPoolState(poolState);
        }
        catch (ResourceException exn1) {
            FFDCFilter.processException((Throwable)exn1, (String)"com.ibm.ejs.j2c.poolmanager.PoolManager.getMCWrapperFromMatch", (String)"786", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("datasource " + this.gConfigProps.cfName + ": ResourceException " + (Object)((Object)exn1)), (Object[])new Object[0]);
                Tr.debug((Object)this, (TraceComponent)tc, (String)"Throwing ResourceAllocationException...", (Object[])new Object[0]);
                Tr.debug((Object)this, (TraceComponent)tc, (String)("match(), Pool contents ==> " + this), (Object[])new Object[0]);
            }
            ResourceAllocationException throwMe = new ResourceAllocationException("ResourceException");
            throwMe.initCause(exn1.getCause());
            if (tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"getMCWrapperFromMatch", (Object)((Object)exn1));
            }
            this.activeRequest.decrementAndGet();
            throw throwMe;
        }
        if (mc != null) {
            mcWrapper = mcWrapperTemp;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"getMCWrapperFromMatch", (Object)mcWrapper);
        }
        return mcWrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startReclaimConnectionThread() {
        if (tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"startReclaimConnectionThread", (Object[])new Object[0]);
        }
        Object object = this.taskTimerLockObject;
        synchronized (object) {
            if (!(this.reaperThreadStarted || this.reapTime <= 0 || this.unusedTimeout <= 0 && this.agedTimeout <= 0)) {
                final PoolManager tempPM = this;
                this.reaperThreadStarted = true;
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        new TaskTimerReaperThread(tempPM);
                        return null;
                    }
                });
                if (tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("Started reclaim connection thread for pool " + this.gConfigProps.getXpathId()), (Object[])new Object[0]);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"startReclaimConnectionThread");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startMaxInUseTimeReclaimConnectionThread() {
        String methodName = "startMaxInUseTimeReclaimConnectionThread";
        if (tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)methodName, (Object[])new Object[0]);
        }
        Object object = this.maxInUseTimeTaskTimerLockObject;
        synchronized (object) {
            if (!this.maxInUseTimeThreadStarted && this.maxInUseTime > 0) {
                final PoolManager tempPM = this;
                this.maxInUseTimeThreadStarted = true;
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        new TaskTimerMaxInUseTime(tempPM);
                        return null;
                    }
                });
                if (tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("Started MaxInUseTime reclaimation connection thread for pool " + this.gConfigProps.getXpathId()), (Object[])new Object[0]);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)methodName);
        }
    }

    public String toString() {
        return this.toString2(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString2(int options) {
        int tscdSize;
        StringBuffer aBuffer = new StringBuffer(500);
        StringBuffer bBuffer = new StringBuffer(500);
        ArrayList<ToStringStackElements> throwableStackTraceElements = new ArrayList<ToStringStackElements>();
        aBuffer.append("JNDI name:");
        aBuffer.append(this.gConfigProps.cfName);
        aBuffer.append(this.nl);
        aBuffer.append("PoolManager object:");
        aBuffer.append(this.hashCode());
        aBuffer.append(this.nl);
        aBuffer.append("Total number of connections: ");
        if (this.connectionPoolShutDown) {
            aBuffer.append("purging ");
        }
        aBuffer.append(this.totalConnectionCount.get());
        aBuffer.append(" (max/min ");
        aBuffer.append(this.maxConnections);
        aBuffer.append("/");
        aBuffer.append(this.minConnections);
        aBuffer.append(", reap/unused/aged/maxInUseTime ");
        aBuffer.append(this.reapTime);
        aBuffer.append("/");
        aBuffer.append(this.unusedTimeout);
        aBuffer.append("/");
        aBuffer.append(this.agedTimeout);
        aBuffer.append("/");
        aBuffer.append(this.maxInUseTime);
        aBuffer.append(", connectiontimeout/purge ");
        aBuffer.append(this.connectionTimeout);
        aBuffer.append("/");
        aBuffer.append((Object)this.purgePolicy);
        aBuffer.append(")");
        if (this.localConnection_ != null) {
            bBuffer.append(", maxTLS ");
            bBuffer.append(this.maxCapacity);
        }
        if (bBuffer.length() > 1) {
            aBuffer.append(this.nl);
            aBuffer.append("                              ");
            aBuffer.append(" (");
            aBuffer.append(bBuffer.substring(2));
            aBuffer.append(")");
        }
        bBuffer.delete(0, bBuffer.length());
        if (this._quiesce) {
            aBuffer.append("  quiesce time:");
            aBuffer.append(this._quiesceTime);
        }
        aBuffer.append(this.nl);
        if (this.waiterCount > 0) {
            aBuffer.append("The waiter count is ");
            aBuffer.append(this.waiterCount);
            aBuffer.append(this.nl);
            aBuffer.append("The mcWrappers in waiter queue ");
            try {
                aBuffer.append(this.mcWrapperWaiterList);
            }
            catch (ConcurrentModificationException cm) {
                aBuffer.append("info not available");
            }
            aBuffer.append(this.nl);
        }
        if (!this.gConfigProps.connectionPoolingEnabled) {
            aBuffer.append("Connection pooling is disabled, free connections are not pooled.");
        }
        int totalNumberOfSharedConnections = 0;
        StringBuffer connectionLeakBuffer = null;
        long currentTime = 0L;
        int holdTimeLimit_loc = -1;
        if (options == 0) {
            holdTimeLimit_loc = this.holdTimeLimit;
        }
        if (holdTimeLimit_loc > -1) {
            connectionLeakBuffer = new StringBuffer();
            currentTime = System.currentTimeMillis();
        }
        aBuffer.append("Shared Connection information (shared partitions " + this.maxSharedBuckets + ")");
        aBuffer.append(this.nl);
        boolean atleastOne = false;
        currentTime = System.currentTimeMillis();
        this.mcToMCWMapWrite.lock();
        try {
            int mcToMCWSize = this.mcToMCWMap.size();
            if (mcToMCWSize > 0) {
                Object[] tempObject = this.mcToMCWMap.values().toArray();
                for (int ti = 0; ti < mcToMCWSize; ++ti) {
                    com.ibm.ws.j2c.MCWrapper mcw = (com.ibm.ws.j2c.MCWrapper)tempObject[ti];
                    if (mcw.getPoolState() != 2) continue;
                    aBuffer.append("    ");
                    if (mcw.isDestroyState()) {
                        aBuffer.append("Connection marked for thread supported cleanup and destroy.  Waiting ");
                        aBuffer.append("for transaction end and connection close - ");
                    } else if (mcw.isStale() || mcw.hasFatalErrorNotificationOccurred(this.freePool[0].getFatalErrorNotificationTime()) || this.agedTimeout != -1 && mcw.hasAgedTimedOut(this.agedTimeoutMillis)) {
                        aBuffer.append("Connection marked to be destroyed.  Waiting ");
                        aBuffer.append("for transaction end and connection close - ");
                    }
                    aBuffer.append(mcw.getSharedPoolCoordinator());
                    aBuffer.append("  ");
                    aBuffer.append(mcw);
                    if (holdTimeLimit_loc > -1) {
                        this.dumpHoldTimeAndStackInfo(mcw, aBuffer, connectionLeakBuffer, currentTime, throwableStackTraceElements);
                    }
                    ++totalNumberOfSharedConnections;
                    atleastOne = true;
                }
            }
        }
        finally {
            this.mcToMCWMapWrite.unlock();
        }
        if (atleastOne) {
            aBuffer.append("  Total number of connection in shared pool: ");
            aBuffer.append(totalNumberOfSharedConnections);
        } else {
            aBuffer.append("  No shared connections");
            aBuffer.append(this.nl);
        }
        int totalNumberOfFreeConnections = 0;
        aBuffer.append(this.nl);
        aBuffer.append("Free Connection information (free distribution table " + this.maxFreePoolHashSize + ")");
        aBuffer.append(this.nl);
        atleastOne = false;
        this.mcToMCWMapWrite.lock();
        try {
            int mcToMCWSize = this.mcToMCWMap.size();
            if (mcToMCWSize > 0) {
                Object[] tempObject = this.mcToMCWMap.values().toArray();
                for (int ti = 0; ti < mcToMCWSize; ++ti) {
                    com.ibm.ws.j2c.MCWrapper mcw = (com.ibm.ws.j2c.MCWrapper)tempObject[ti];
                    if (mcw.getPoolState() != 1) continue;
                    aBuffer.append("  (" + mcw.getHashMapBucket() + ")");
                    aBuffer.append(mcw);
                    ++totalNumberOfFreeConnections;
                    atleastOne = true;
                }
            }
        }
        finally {
            this.mcToMCWMapWrite.unlock();
        }
        aBuffer.append(this.nl);
        if (atleastOne) {
            aBuffer.append("  Total number of connection in free pool: ");
            aBuffer.append(totalNumberOfFreeConnections);
        } else {
            aBuffer.append("  No free connections");
            aBuffer.append(this.nl);
        }
        aBuffer.append(this.nl);
        int totalNumberOfUnSharedConnections = 0;
        aBuffer.append("UnShared Connection information");
        aBuffer.append(this.nl);
        atleastOne = false;
        this.mcToMCWMapWrite.lock();
        try {
            int mcToMCWSize = this.mcToMCWMap.size();
            if (mcToMCWSize > 0) {
                Object[] tempObject = this.mcToMCWMap.values().toArray();
                for (int ti = 0; ti < mcToMCWSize; ++ti) {
                    com.ibm.ws.j2c.MCWrapper mcw = (com.ibm.ws.j2c.MCWrapper)tempObject[ti];
                    if (mcw.getPoolState() != 3) continue;
                    aBuffer.append("    ");
                    if (mcw.isStale() || mcw.hasFatalErrorNotificationOccurred(this.freePool[0].getFatalErrorNotificationTime()) || this.agedTimeout != -1 && mcw.hasAgedTimedOut(this.agedTimeoutMillis)) {
                        aBuffer.append("Connection marked to be destroyed.  Waiting ");
                        aBuffer.append("for transaction end and connection close - ");
                    }
                    aBuffer.append(mcw);
                    if (holdTimeLimit_loc > -1) {
                        this.dumpHoldTimeAndStackInfo(mcw, aBuffer, connectionLeakBuffer, currentTime, throwableStackTraceElements);
                    }
                    ++totalNumberOfUnSharedConnections;
                    atleastOne = true;
                }
            }
        }
        finally {
            this.mcToMCWMapWrite.unlock();
        }
        if (atleastOne) {
            aBuffer.append("  Total number of connection in unshared pool: ");
            aBuffer.append(totalNumberOfUnSharedConnections);
            aBuffer.append(this.nl);
        } else {
            aBuffer.append("  No unshared connections");
            aBuffer.append(this.nl);
        }
        int holdTimeLimit_loc_disabled = -1;
        if (this.localConnection_ != null) {
            this.displaySharedTLSConnections(aBuffer, connectionLeakBuffer, currentTime, holdTimeLimit_loc_disabled, throwableStackTraceElements);
            this.displayFreeTLSConnections(aBuffer, connectionLeakBuffer, currentTime, holdTimeLimit_loc_disabled, throwableStackTraceElements);
            this.displayUnsharedTLSConnections(aBuffer, connectionLeakBuffer, currentTime, holdTimeLimit_loc_disabled, throwableStackTraceElements);
        }
        if ((tscdSize = this.tscdList.size()) > 0) {
            aBuffer.append(this.nl + "Thread supported cleanup and destroy connection information" + this.nl);
            ThreadSupportedCleanupAndDestroy o = null;
            for (int i = 0; i < this.tscdList.size(); ++i) {
                try {
                    o = this.tscdList.get(i);
                }
                catch (IndexOutOfBoundsException e) {
                    break;
                }
                if (o == null) continue;
                aBuffer.append("  " + ((Object)o).toString());
            }
            aBuffer.append("  Total number of thread supported cleanup and destroy connections requests being processed: " + tscdSize + " (not included in total connection count)" + this.nl);
        }
        if (holdTimeLimit_loc > -1 && connectionLeakBuffer.length() > 0) {
            aBuffer.append(this.nl);
            aBuffer.append("Connection Leak Logic Information: (Note, applications using managed connections in this list may not be following the recommended getConnection(), use connection, close() connection  programming model pattern)" + this.nl);
            aBuffer.append(connectionLeakBuffer);
        }
        return aBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void displaySharedTLSConnections(StringBuffer aBuffer, StringBuffer connectionLeakBuffer, long currentTime, int holdTimeLimit_loc, ArrayList<ToStringStackElements> throwableStackTraceElements) {
        aBuffer.append(this.nl);
        int totalNumberOfSharedTLSConnections = 0;
        aBuffer.append("Shared TLS Connection information");
        aBuffer.append(this.nl);
        boolean atleastOne = false;
        this.mcToMCWMapWrite.lock();
        try {
            int mcToMCWSize = this.mcToMCWMap.size();
            if (mcToMCWSize > 0) {
                Object[] tempObject = this.mcToMCWMap.values().toArray();
                for (int ti = 0; ti < mcToMCWSize; ++ti) {
                    com.ibm.ws.j2c.MCWrapper mcw = (com.ibm.ws.j2c.MCWrapper)tempObject[ti];
                    if (mcw.getPoolState() != 5) continue;
                    aBuffer.append("    ");
                    if (mcw.isStale() || mcw.hasFatalErrorNotificationOccurred(this.freePool[0].getFatalErrorNotificationTime()) || this.agedTimeout != -1 && mcw.hasAgedTimedOut(this.agedTimeoutMillis)) {
                        aBuffer.append("Connection marked to be destroyed.  Waiting ");
                        aBuffer.append("for transaction end and connection close - ");
                    }
                    aBuffer.append(mcw.getSharedPoolCoordinator());
                    aBuffer.append("  ");
                    aBuffer.append(mcw);
                    if (holdTimeLimit_loc > -1) {
                        this.dumpHoldTimeAndStackInfo(mcw, aBuffer, connectionLeakBuffer, currentTime, throwableStackTraceElements);
                    }
                    ++totalNumberOfSharedTLSConnections;
                    atleastOne = true;
                }
            }
        }
        finally {
            this.mcToMCWMapWrite.unlock();
        }
        if (atleastOne) {
            aBuffer.append("  Total number of connection in shared TLS pool: ");
            aBuffer.append(totalNumberOfSharedTLSConnections);
            aBuffer.append(this.nl);
        } else {
            aBuffer.append("  No shared TLS connections");
            aBuffer.append(this.nl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void displayFreeTLSConnections(StringBuffer aBuffer, StringBuffer connectionLeakBuffer, long currentTime, int holdTimeLimit_loc, ArrayList<ToStringStackElements> throwableStackTraceElements) {
        aBuffer.append(this.nl);
        int totalNumberOfFreeSharedTLSConnections = 0;
        aBuffer.append("Free TLS Connection information");
        aBuffer.append(this.nl);
        boolean atleastOne = false;
        this.mcToMCWMapWrite.lock();
        try {
            int mcToMCWSize = this.mcToMCWMap.size();
            if (mcToMCWSize > 0) {
                Object[] tempObject = this.mcToMCWMap.values().toArray();
                for (int ti = 0; ti < mcToMCWSize; ++ti) {
                    com.ibm.ws.j2c.MCWrapper mcw = (com.ibm.ws.j2c.MCWrapper)tempObject[ti];
                    if (mcw.getPoolState() != 6) continue;
                    aBuffer.append("    ");
                    if (mcw.isStale() || mcw.hasFatalErrorNotificationOccurred(this.freePool[0].getFatalErrorNotificationTime()) || this.agedTimeout != -1 && mcw.hasAgedTimedOut(this.agedTimeoutMillis)) {
                        aBuffer.append("Connection marked to be destroyed.  Waiting ");
                        aBuffer.append("for transaction end and connection close - ");
                    }
                    aBuffer.append(mcw);
                    if (holdTimeLimit_loc > -1) {
                        this.dumpHoldTimeAndStackInfo(mcw, aBuffer, connectionLeakBuffer, currentTime, throwableStackTraceElements);
                    }
                    ++totalNumberOfFreeSharedTLSConnections;
                    atleastOne = true;
                }
            }
        }
        finally {
            this.mcToMCWMapWrite.unlock();
        }
        if (atleastOne) {
            aBuffer.append("  Total number of connection in free TLS pool: ");
            aBuffer.append(totalNumberOfFreeSharedTLSConnections);
            aBuffer.append(this.nl);
        } else {
            aBuffer.append("  No free TLS connections");
            aBuffer.append(this.nl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void displayUnsharedTLSConnections(StringBuffer aBuffer, StringBuffer connectionLeakBuffer, long currentTime, int holdTimeLimit_loc, ArrayList<ToStringStackElements> throwableStackTraceElements) {
        aBuffer.append(this.nl);
        int totalNumberOfUnSharedTLSConnections = 0;
        aBuffer.append("UnShared TLS Connection information");
        aBuffer.append(this.nl);
        boolean atleastOne = false;
        this.mcToMCWMapWrite.lock();
        try {
            int mcToMCWSize = this.mcToMCWMap.size();
            if (mcToMCWSize > 0) {
                Object[] tempObject = this.mcToMCWMap.values().toArray();
                for (int ti = 0; ti < mcToMCWSize; ++ti) {
                    com.ibm.ws.j2c.MCWrapper mcw = (com.ibm.ws.j2c.MCWrapper)tempObject[ti];
                    if (mcw.getPoolState() != 7) continue;
                    aBuffer.append("    ");
                    if (mcw.isStale() || mcw.hasFatalErrorNotificationOccurred(this.freePool[0].getFatalErrorNotificationTime()) || this.agedTimeout != -1 && mcw.hasAgedTimedOut(this.agedTimeoutMillis)) {
                        aBuffer.append("Connection marked to be destroyed.  Waiting ");
                        aBuffer.append("for transaction end and connection close - ");
                    }
                    if (mcw.getSharedPoolCoordinator() != null) {
                        aBuffer.append(mcw.getSharedPoolCoordinator());
                        aBuffer.append("  ");
                    }
                    aBuffer.append(mcw);
                    if (holdTimeLimit_loc > -1) {
                        this.dumpHoldTimeAndStackInfo(mcw, aBuffer, connectionLeakBuffer, currentTime, throwableStackTraceElements);
                    }
                    ++totalNumberOfUnSharedTLSConnections;
                    atleastOne = true;
                }
            }
        }
        finally {
            this.mcToMCWMapWrite.unlock();
        }
        if (atleastOne) {
            aBuffer.append("  Total number of connection in unshared TLS pool: ");
            aBuffer.append(totalNumberOfUnSharedTLSConnections);
            aBuffer.append(this.nl);
        } else {
            aBuffer.append("  No unshared TLS connections");
            aBuffer.append(this.nl);
        }
    }

    private void dumpHoldTimeAndStackInfo(com.ibm.ws.j2c.MCWrapper mcw, StringBuffer aBuffer, StringBuffer connectionLeakBuffer, long currentTime, ArrayList<ToStringStackElements> mcwInitialStackList) {
        long holdTime;
        Throwable t = null;
        long startHoldTime = ((MCWrapper)mcw).getHoldTimeStart();
        if (startHoldTime != 0L && (holdTime = currentTime - startHoldTime) > (long)(this.holdTimeLimit * 1000)) {
            for (int i = 0; i < this.nl.length(); ++i) {
                aBuffer.deleteCharAt(aBuffer.length() - 1);
            }
            Date startDateTime = new Date(startHoldTime);
            long lastAllTime = ((MCWrapper)mcw).getLastAllocationTime();
            String startDateAllocationTime = startHoldTime == lastAllTime ? " Start time same as last allocation time " : " Last allocation time " + new Date(lastAllTime);
            long timeInUseInSeconds = holdTime / 1000L;
            aBuffer.append(" Start time inuse " + startDateTime + " Time inuse " + timeInUseInSeconds + " (seconds) " + startDateAllocationTime + this.nl);
            t = ((MCWrapper)mcw).getInitialRequestStackTrace();
            if (t != null) {
                connectionLeakBuffer.append("  " + mcw);
                connectionLeakBuffer.append("     Start time inuse " + startDateTime + " Time inuse " + timeInUseInSeconds + " (seconds)" + this.nl);
                connectionLeakBuffer.append("    " + startDateAllocationTime + this.nl);
                connectionLeakBuffer.append("       getConnection stack trace information:");
                StackTraceElement[] mcwInitialStack = t.getStackTrace();
                boolean stringBuffersEqual = false;
                int matchingMCStack = -1;
                int occurred = -1;
                if (mcwInitialStackList.size() != 0) {
                    int j = 0;
                    for (ToStringStackElements previousMCWSTE : mcwInitialStackList) {
                        boolean stackLinesEqual = true;
                        if (mcwInitialStack.length == previousMCWSTE.ste.length) {
                            int i = 0;
                            for (StackTraceElement currentMCWSTE : mcwInitialStack) {
                                if (((Object)currentMCWSTE).toString().equals(previousMCWSTE.ste[i++].toString())) continue;
                                stackLinesEqual = false;
                                break;
                            }
                            if (stackLinesEqual) {
                                stringBuffersEqual = true;
                                matchingMCStack = ++j;
                                occurred = ++previousMCWSTE.numberOfOccurrents;
                                break;
                            }
                        }
                        ++j;
                    }
                }
                if (stringBuffersEqual) {
                    connectionLeakBuffer.append("          Matches stack number " + matchingMCStack + " occurred " + occurred + " times" + this.nl);
                } else {
                    mcwInitialStackList.add(new ToStringStackElements(mcwInitialStack, 1));
                    connectionLeakBuffer.append("          Stack number " + mcwInitialStackList.size() + this.nl);
                    for (StackTraceElement o : mcwInitialStack) {
                        connectionLeakBuffer.append("          " + ((Object)o).toString() + this.nl);
                    }
                }
                connectionLeakBuffer.append(this.nl);
            }
        }
    }

    public void executeTask() {
        ++this.collectorCount;
        if (this.collectorCount > 1) {
            --this.collectorCount;
            return;
        }
        this.reclaimConnections();
        --this.collectorCount;
    }

    public void executeMaxInUseTimeTask() {
        ++this.maxInUseTimeCollectorCount;
        if (this.maxInUseTimeCollectorCount > 1) {
            --this.maxInUseTimeCollectorCount;
            return;
        }
        this.reclaimMaxInUseTimeConnections();
        --this.maxInUseTimeCollectorCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean needToReclaimTLSConnections() {
        boolean removemcw = false;
        this.mcToMCWMapRead.lock();
        try {
            Collection<com.ibm.ws.j2c.MCWrapper> s = this.mcToMCWMap.values();
            for (com.ibm.ws.j2c.MCWrapper mcw : s) {
                if (mcw.getPoolState() != 6) continue;
                if (this.agedTimeout != -1 && mcw.hasAgedTimedOut(this.agedTimeoutMillis)) {
                    removemcw = true;
                } else {
                    if (removemcw || this.unusedTimeout == -1 || !mcw.hasIdleTimedOut(this.unusedTimeout * 1000) || this.totalConnectionCount.get() <= this.minConnections) continue;
                    removemcw = true;
                }
                break;
            }
        }
        finally {
            this.mcToMCWMapRead.unlock();
        }
        return removemcw;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean needToReclaimConnections() {
        boolean removemcw = false;
        for (int j = 0; j < this.maxFreePoolHashSize; ++j) {
            Object object = this.freePool[j].freeConnectionLockObject;
            synchronized (object) {
                int localtotalConnectionCount = this.totalConnectionCount.get();
                int mcwlSize = this.freePool[j].mcWrapperList.size();
                for (int k = 0; k < mcwlSize; ++k) {
                    com.ibm.ws.j2c.MCWrapper mcw = (com.ibm.ws.j2c.MCWrapper)this.freePool[j].mcWrapperList.get(k);
                    if (this.agedTimeout != -1 && mcw.hasAgedTimedOut(this.agedTimeoutMillis)) {
                        removemcw = true;
                        break;
                    }
                    if (removemcw || this.unusedTimeout == -1 || !mcw.hasIdleTimedOut(this.unusedTimeout * 1000) || localtotalConnectionCount <= this.minConnections) continue;
                    removemcw = true;
                    break;
                }
            }
            if (removemcw) break;
        }
        return removemcw;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reclaimConnections() {
        if (tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"reclaimConnections", (Object[])new Object[0]);
        }
        if (this.totalConnectionCount.get() == 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"reclaimConnections", (Object)"Total connection count is zero");
            }
            return;
        }
        int totalNumberOfConnectionRemoved = 0;
        for (int j = 0; j < this.maxFreePoolHashSize; ++j) {
            int k;
            com.ibm.ws.j2c.MCWrapper mcw;
            Object object = this.freePool[j].freeConnectionLockObject;
            synchronized (object) {
                int k2;
                boolean removemcw = false;
                int mcwlSize = this.freePool[j].mcWrapperList.size();
                for (k2 = 0; k2 < mcwlSize; ++k2) {
                    mcw = (com.ibm.ws.j2c.MCWrapper)this.freePool[j].mcWrapperList.get(k2);
                    if (!removemcw && this.agedTimeout != -1 && mcw.hasAgedTimedOut(this.agedTimeoutMillis)) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((Object)this, (TraceComponent)tc, (String)("Aged timeout reclaim connection " + mcw), (Object[])new Object[0]);
                        }
                        removemcw = true;
                    }
                    if (!removemcw && this.unusedTimeout != -1 && mcw.hasIdleTimedOut(this.unusedTimeout * 1000) && this.totalConnectionCount.get() > this.minConnections) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((Object)this, (TraceComponent)tc, (String)("Unused timeout reclaim connection " + mcw), (Object[])new Object[0]);
                        }
                        removemcw = true;
                    }
                    if (!removemcw) continue;
                    this.mcWrappersToDestroy.add(mcw);
                    this.totalConnectionCount.decrementAndGet();
                    removemcw = false;
                }
                for (k2 = 0; k2 < this.mcWrappersToDestroy.size(); ++k2) {
                    this.freePool[j].removeMCWrapperFromList(this.mcWrappersToDestroy.get(k2), true, false, true, false);
                }
            }
            if (this.localConnection_ != null && this.needToReclaimTLSConnections()) {
                boolean reapTLS = false;
                this.updateToTLSPoolInProgress.set(true);
                Object removemcw = this.updateToTLSPoolInProgressLockObject;
                synchronized (removemcw) {
                    try {
                        this.sleep(20L);
                    }
                    catch (InterruptedException mcwlSize) {
                        // empty catch block
                    }
                    if (this.activeTLSRequest.get() > 0) {
                        try {
                            this.sleep(100L);
                        }
                        catch (InterruptedException mcwlSize) {
                            // empty catch block
                        }
                        if (this.activeTLSRequest.get() > 0) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((Object)this, (TraceComponent)tc, (String)("To many active requests to search tls, active request value is " + this.activeRequest.get()), (Object[])new Object[0]);
                            }
                        } else {
                            reapTLS = true;
                        }
                    } else {
                        reapTLS = true;
                    }
                    if (reapTLS) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((Object)this, (TraceComponent)tc, (String)"Searching tls for a connections to reap.", (Object[])new Object[0]);
                        }
                        for (Map.Entry<com.ibm.ws.j2c.MCWrapper, ArrayList<com.ibm.ws.j2c.MCWrapper>> e : this.tlsArrayLists.entrySet()) {
                            mcw = e.getKey();
                            if (mcw.getPoolState() != 6) continue;
                            ArrayList<com.ibm.ws.j2c.MCWrapper> mh = e.getValue();
                            if (this.agedTimeout != -1 && mcw.hasAgedTimedOut(this.agedTimeoutMillis)) {
                                mh.remove(mcw);
                                this.tlsArrayLists.remove(mcw);
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    ((MCWrapper)mcw).setThreadID(((MCWrapper)mcw).getThreadID() + "-reclaim-removed");
                                    Tr.debug((Object)this, (TraceComponent)tc, (String)("removed mcWrapper from thread local " + mcw), (Object[])new Object[0]);
                                }
                                mcw.setPoolState(0);
                                this.mcWrappersToDestroy.add(mcw);
                                this.totalConnectionCount.decrementAndGet();
                                continue;
                            }
                            if (this.unusedTimeout == -1 || !mcw.hasIdleTimedOut(this.unusedTimeout * 1000) || this.totalConnectionCount.get() <= this.minConnections) continue;
                            mh.remove(mcw);
                            this.tlsArrayLists.remove(mcw);
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                ((MCWrapper)mcw).setThreadID(((MCWrapper)mcw).getThreadID() + "-reclaim-removed");
                                Tr.debug((Object)this, (TraceComponent)tc, (String)("removed mcWrapper from thread local " + mcw), (Object[])new Object[0]);
                            }
                            mcw.setPoolState(0);
                            this.mcWrappersToDestroy.add(mcw);
                            this.totalConnectionCount.decrementAndGet();
                        }
                    }
                    this.updateToTLSPoolInProgress.set(false);
                    this.updateToTLSPoolInProgressLockObject.notifyAll();
                }
            }
            int destroyListSize = this.mcWrappersToDestroy.size();
            totalNumberOfConnectionRemoved += destroyListSize;
            for (k = destroyListSize; k > 0; --k) {
                com.ibm.ws.j2c.MCWrapper mcw2 = this.mcWrappersToDestroy.remove(k - 1);
                mcw2.setInSharedPool(false);
                this.freePool[j].cleanupAndDestroyMCWrapper(mcw2);
            }
            for (k = 0; k < destroyListSize; ++k) {
                Object object2 = this.waiterFreePoolLock;
                synchronized (object2) {
                    if (this.waiterCount > 0) {
                        this.waiterFreePoolLock.notify();
                    }
                    continue;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            if (tc.isDebugEnabled()) {
                if (totalNumberOfConnectionRemoved > 0) {
                    Tr.debug((TraceComponent)tc, (String)("Total number of connections removed are " + totalNumberOfConnectionRemoved), (Object[])new Object[0]);
                } else {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"No connection were removed", (Object[])new Object[0]);
                }
                Tr.debug((Object)this, (TraceComponent)tc, (String)"Current state of pool:", (Object[])new Object[0]);
                Tr.debug((Object)this, (TraceComponent)tc, (String)this.toString(), (Object[])new Object[0]);
            }
            Tr.exit((Object)this, (TraceComponent)tc, (String)"reclaimConnections");
        }
    }

    private void reclaimMaxInUseTimeConnections() {
        try {
            this.abortConnections(abortConnectionsActionName, new String[]{abortConnectionsInUse, String.valueOf(this.maxInUseTime)});
        }
        catch (ResourceException e) {
            Tr.warning((TraceComponent)tc, (String)("Exception when attempting to abort in use connections older than maxInUseTime:" + this.maxInUseTime), (Object[])new Object[0]);
            Tr.warning((TraceComponent)tc, (String)e.toString(), (Object[])new Object[0]);
        }
    }

    protected final int computeHashCode(Subject subject, ConnectionRequestInfo cri) {
        int sHash;
        boolean isTracingEnabled = TraceComponent.isAnyTracingEnabled();
        if (isTracingEnabled && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"computeHashCode", (Object[])new Object[0]);
        }
        if (isTracingEnabled && tc.isDebugEnabled()) {
            StringBuffer sbuff = new StringBuffer();
            sbuff.append("computeHashCode for Subject ");
            if (subject == null) {
                sbuff.append("null");
            } else {
                SubjectToString subjectToString = new SubjectToString();
                subjectToString.setSubject(subject);
                sbuff.append(AccessController.doPrivileged(subjectToString));
            }
            if (cri == null) {
                sbuff.append(" and CRI null");
            } else {
                sbuff.append(" and CRI " + cri.toString());
            }
            Tr.debug((Object)this, (TraceComponent)tc, (String)sbuff.toString(), (Object[])new Object[0]);
        }
        if (subject != null) {
            if (!this.gConfigProps.raSupportsReauthentication) {
                SubjectHashCode subjectHashCode = new SubjectHashCode();
                subjectHashCode.setSubject(subject);
                sHash = AccessController.doPrivileged(subjectHashCode);
            } else {
                sHash = 1;
            }
        } else {
            sHash = 1;
        }
        int cHash = cri != null ? cri.hashCode() : 1;
        int hashCode = Math.abs(sHash / 2 + cHash / 2);
        if (isTracingEnabled && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("Subject's hash code is " + sHash + " and the CRI's hash code is " + cHash), (Object[])new Object[0]);
            Tr.debug((Object)this, (TraceComponent)tc, (String)("computeHashCode, hashCode is " + hashCode), (Object[])new Object[0]);
        }
        if (isTracingEnabled && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"computeHashCode");
        }
        return hashCode;
    }

    public Object getMCWFromMctoMCWMap(Object mc) {
        com.ibm.ws.j2c.MCWrapper mcw = null;
        this.mcToMCWMapRead.lock();
        try {
            mcw = this.mcToMCWMap.get(mc);
        }
        finally {
            this.mcToMCWMapRead.unlock();
        }
        return mcw;
    }

    public String getMCtoMCWMapToString() {
        String mcToMCWMapString;
        this.mcToMCWMapRead.lock();
        try {
            mcToMCWMapString = this.mcToMCWMap.toString();
        }
        finally {
            this.mcToMCWMapRead.unlock();
        }
        return mcToMCWMapString;
    }

    public void putMcToMCWMap(ManagedConnection mc, com.ibm.ws.j2c.MCWrapper mcw) {
        this.mcToMCWMapWrite.lock();
        try {
            this.mcToMCWMap.put(mc, mcw);
        }
        finally {
            this.mcToMCWMapWrite.unlock();
        }
    }

    public void removeMcToMCWMap(Object mc) {
        if (tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"removeMcToMCWMap", (Object[])new Object[0]);
        }
        this.mcToMCWMapWrite.lock();
        try {
            this.mcToMCWMap.remove(mc);
        }
        finally {
            this.mcToMCWMapWrite.unlock();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)(this.mcToMCWMap.size() + " connections remaining in mc to mcw table"), (Object[])new Object[0]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"removeMcToMCWMap");
        }
    }

    protected void requestingAccessToPool() {
        this.requestingAccessToPool(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void requestingAccessToPool(boolean pausedPoolAbortOverRide) {
        Object object;
        if (this.updateToPoolInProgress && !pausedPoolAbortOverRide) {
            object = this.updateToPoolInProgressLockObject;
            synchronized (object) {
                while (this.updateToPoolInProgress) {
                    try {
                        this.updateToPoolInProgressLockObject.wait(this.updateToPoolInProgressSleepTime);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
        this.activeRequest.incrementAndGet();
        if (this.updateToPoolInProgress && !pausedPoolAbortOverRide) {
            this.activeRequest.decrementAndGet();
            object = this.updateToPoolInProgressLockObject;
            synchronized (object) {
                while (this.updateToPoolInProgress) {
                    try {
                        this.updateToPoolInProgressLockObject.wait(this.updateToPoolInProgressSleepTime);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            this.activeRequest.incrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void requestingAccessToTLSPool() {
        Object object;
        if (this.updateToTLSPoolInProgress.get()) {
            object = this.updateToTLSPoolInProgressLockObject;
            synchronized (object) {
                while (this.updateToTLSPoolInProgress.get()) {
                    try {
                        this.updateToTLSPoolInProgressLockObject.wait(this.updateToTLSPoolInProgressSleepTime);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
        this.activeTLSRequest.incrementAndGet();
        if (this.updateToTLSPoolInProgress.get()) {
            this.activeTLSRequest.decrementAndGet();
            object = this.updateToTLSPoolInProgressLockObject;
            synchronized (object) {
                while (this.updateToTLSPoolInProgress.get()) {
                    try {
                        this.updateToTLSPoolInProgressLockObject.wait(this.updateToTLSPoolInProgressSleepTime);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            this.activeTLSRequest.incrementAndGet();
        }
    }

    protected void endingAccessToTLSPool() {
        this.activeTLSRequest.decrementAndGet();
    }

    public void moveMCWrapperFromUnSharedToShared(Object value1, Object affinity) {
        if (tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"moveMCWrapperFromUnSharedToShared", (Object[])new Object[0]);
        }
        com.ibm.ws.j2c.MCWrapper mcWrapper = (com.ibm.ws.j2c.MCWrapper)value1;
        int sharedbucket = Math.abs(affinity.hashCode() % this.maxSharedBuckets);
        if (this.localConnection_ != null && mcWrapper.getPoolState() == 7) {
            mcWrapper.setPoolState(5);
            mcWrapper.setSharedPoolCoordinator(affinity);
        } else {
            this.sharedPool[sharedbucket].setSharedConnection(affinity, mcWrapper);
            mcWrapper.setInSharedPool(true);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"moveMCWrapperFromUnSharedToShared");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public com.ibm.ws.j2c.MCWrapper[] getUnSharedPoolConnections() {
        com.ibm.ws.j2c.MCWrapper[] m = null;
        int j = 0;
        this.mcToMCWMapWrite.lock();
        try {
            Object[] o = this.mcToMCWMap.values().toArray();
            int objectSize = o.length;
            m = new com.ibm.ws.j2c.MCWrapper[objectSize];
            com.ibm.ws.j2c.MCWrapper mcw = null;
            for (int i = 0; i < objectSize; ++i) {
                mcw = (com.ibm.ws.j2c.MCWrapper)o[i];
                if (mcw.getPoolState() != 3) continue;
                m[j] = mcw;
                ++j;
            }
        }
        finally {
            this.mcToMCWMapWrite.unlock();
        }
        com.ibm.ws.j2c.MCWrapper[] mreturn = new com.ibm.ws.j2c.MCWrapper[j];
        System.arraycopy(m, 0, mreturn, 0, j);
        return mreturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean isTracingEnabled = TraceComponent.isAnyTracingEnabled();
        if (isTracingEnabled && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"run", (Object[])new Object[]{"alarm"});
        }
        if (isTracingEnabled && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("run: alarm, Pool contents ==> " + this.toString()), (Object[])new Object[0]);
            Tr.debug((Object)this, (TraceComponent)tc, (String)"reaperThreadStarted: ", (Object[])new Object[]{this.reaperThreadStarted});
        }
        if (this.needToReclaimConnections() || this.needToReclaimTLSConnections()) {
            this.startReclaimConnectionThread();
        }
        if (isTracingEnabled && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("run: alarm, Pool contents ==> " + this.toString()), (Object[])new Object[0]);
            Tr.debug((Object)this, (TraceComponent)tc, (String)"reaperThreadStarted: ", (Object[])new Object[]{this.reaperThreadStarted});
        }
        Object object = this.amLockObject;
        synchronized (object) {
            if (this.agedTimeout < 1) {
                if (this.totalConnectionCount.get() > this.minConnections && this.alarmThreadCounter.get() >= 0) {
                    this.createReaperAlarm();
                } else {
                    if (this.alarmThreadCounter.get() > 0) {
                        this.alarmThreadCounter.decrementAndGet();
                    }
                    if (isTracingEnabled && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Alarm thread was NOT started. Number of alarm threads is " + this.alarmThreadCounter.get()), (Object[])new Object[0]);
                    }
                }
            } else if (this.totalConnectionCount.get() > 0 && this.alarmThreadCounter.get() >= 0) {
                this.createReaperAlarm();
            } else {
                if (this.alarmThreadCounter.get() > 0) {
                    this.alarmThreadCounter.decrementAndGet();
                }
                if (isTracingEnabled && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Alarm thread was NOT started. Number of alarm threads is " + this.alarmThreadCounter.get()), (Object[])new Object[0]);
                }
            }
        }
        if (isTracingEnabled && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"run");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void quiesceIfPossible() throws ResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"quiesceIfPossible", (Object[])new Object[]{this._quiesce});
        }
        if (!this._quiesce) {
            this._quiesce = true;
            this._quiesceTime = new Date(System.currentTimeMillis());
            for (int j = 0; j < this.maxFreePoolHashSize; ++j) {
                Object object = this.freePool[j].freeConnectionLockObject;
                synchronized (object) {
                    this.freePool[j].incrementFatalErrorValue(j);
                    if (this.freePool[j].mcWrapperList.size() > 0) {
                        this.freePool[j].cleanupAndDestroyAllFreeConnections();
                    }
                    continue;
                }
            }
        }
        if (this.totalConnectionCount.get() == 0) {
            this.quiesce();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"quiesceIfPossible");
        }
    }

    private void createParkedConnection(ManagedConnectionFactory managedConnectionFactory, Subject subject, ConnectionRequestInfo cri) throws ResourceAllocationException {
        try {
            ManagedConnection parkedConnection = null;
            parkedConnection = managedConnectionFactory.createManagedConnection(subject, cri);
            this.parkedMCWrapper = new MCWrapper(this, this.gConfigProps);
            if (parkedConnection != null) {
                this.parkedMCWrapper.setManagedConnection(parkedConnection);
            }
            this.parkedMCWrapper.setParkedWrapper(true);
            this.parkedMCWrapper.setPoolState(9);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("The parked connection is " + parkedConnection), (Object[])new Object[0]);
            }
            this.createParkedConnection = false;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"4044", (Object)this);
            Object[] parms = new Object[]{"createParkedConnection", CommonFunction.exceptionList(e), "ResourceAllocationException", this.gConfigProps.cfName};
            Tr.error((TraceComponent)tc, (String)"POOL_MANAGER_EXCP_CCF2_0002_J2CA0046", (Object[])parms);
            ResourceAllocationException throwMe = e instanceof ResourceException ? new ResourceAllocationException(e.getMessage(), ((ResourceException)((Object)e)).getErrorCode()) : new ResourceAllocationException(e.getMessage());
            throwMe.initCause(e.getCause());
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"createParkedConnection", (Object)e);
            }
            this.activeRequest.decrementAndGet();
            throw throwMe;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void propertyChange(PropertyChangeEvent event) {
        String propName;
        if (tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"propertyChange", (Object[])new Object[]{event.getPropertyName()});
        }
        if ((propName = event.getPropertyName()).equals("orphanConnHoldTimeLimitSeconds")) {
            int value = (Integer)event.getNewValue();
            if (tc.isInfoEnabled()) {
                this.logPropertyChangeMsg("holdTimeLimit", this.holdTimeLimit, value);
            }
            this.holdTimeLimit = value;
        } else if (propName.equals("minConnections")) {
            int value = (Integer)event.getNewValue();
            if (tc.isInfoEnabled()) {
                this.logPropertyChangeMsg("minConnections", this.minConnections, value);
            }
            this.minConnections = value;
        } else if (propName.equals("purgePolicy")) {
            PurgePolicy value = (PurgePolicy)((Object)event.getNewValue());
            if (tc.isInfoEnabled()) {
                this.logPropertyChangeMsg("purgePolicy", this.purgePolicy.toString(), value.toString());
            }
            this.purgePolicy = value;
        } else if (propName.equals("reapTime")) {
            int value = (Integer)event.getNewValue();
            if (tc.isInfoEnabled()) {
                this.logPropertyChangeMsg("reapTime", this.reapTime, value);
            }
            this.reapTime = value;
            this.checkForStartingReaperThread();
        } else if (propName.equals("unusedTimeoutEnabled")) {
            boolean value = (Boolean)event.getNewValue();
            if (tc.isInfoEnabled()) {
                this.logPropertyChangeMsg("unusedTimeoutEnabled", this.unusedTimeoutEnabled, value);
            }
            this.unusedTimeoutEnabled = value;
        } else if (propName.equals("connectionTimeout")) {
            int value = (Integer)event.getNewValue();
            if (tc.isInfoEnabled()) {
                this.logPropertyChangeMsg("connectionTimeout", this.connectionTimeout, value);
            }
            this.connectionTimeout = value;
            this.displayInfiniteWaitMessage = this.connectionTimeout == -1;
            Object object = this.waiterFreePoolLock;
            synchronized (object) {
                this.waiterFreePoolLock.notifyAll();
            }
        } else if (propName.equals("unusedTimeout")) {
            int value = (Integer)event.getNewValue();
            if (tc.isInfoEnabled()) {
                this.logPropertyChangeMsg("unusedTimeout", this.unusedTimeout, value);
            }
            this.unusedTimeout = value;
            this.unusedTimeoutEnabled = value > -1;
            this.checkForStartingReaperThread();
        } else if (propName.equals("agedTimeout")) {
            int value = (Integer)event.getNewValue();
            if (tc.isInfoEnabled()) {
                this.logPropertyChangeMsg("agedTimeout", this.agedTimeout, value);
            }
            this.agedTimeout = value;
            this.agedTimeoutMillis = (long)value * 1000L;
            this.checkForStartingReaperThread();
        } else if (propName.equals("maxInUseTime")) {
            int value = (Integer)event.getNewValue();
            if (tc.isInfoEnabled()) {
                this.logPropertyChangeMsg("maxInUseTime", this.maxInUseTime, value);
            }
            this.maxInUseTime = value;
            this.checkForStartingMaxInUseTimeThread();
        } else if (propName.equals("holdTimeLimit")) {
            int value = (Integer)event.getNewValue();
            if (tc.isInfoEnabled()) {
                this.logPropertyChangeMsg("holdTimeLimit", this.holdTimeLimit, value);
            }
            this.holdTimeLimit = value;
        } else if (propName.equals("maxNumberOfMCsAllowableInThread")) {
            int value = (Integer)event.getNewValue();
            if (tc.isInfoEnabled()) {
                this.logPropertyChangeMsg("maxNumberOfMCsAllowableInThread", this.maxNumberOfMCsAllowableInThread, value);
            }
            this.maxNumberOfMCsAllowableInThread = value;
        } else if (propName.equals("throwExceptionOnMCThreadCheck")) {
            boolean value = (Boolean)event.getNewValue();
            if (tc.isInfoEnabled()) {
                this.logPropertyChangeMsg("throwExceptionOnMCThreadCheck", this.throwExceptionOnMCThreadCheck, value);
            }
            this.throwExceptionOnMCThreadCheck = value;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"propertyChange", (Object)propName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkForStartingMaxInUseTimeThread() {
        boolean isAnyTracingEnabled = TraceComponent.isAnyTracingEnabled();
        if (isAnyTracingEnabled && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("Property change occurred, checking maxInUSeTime thread status for pool. Current number of alarm threads is " + this.maxInUseTimeAlarmThreadCounter.get()), (Object[])new Object[0]);
        }
        if (this.maxInUseTime > 0) {
            Object object = this.amMaxInUseTimeLockObject;
            synchronized (object) {
                if (this.totalConnectionCount.get() > 0) {
                    this.createMaxInUseTimeAlarm();
                }
            }
        }
        if (isAnyTracingEnabled && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("Property change occurred, number of maxInUseTime alarm threads is " + this.maxInUseTimeAlarmThreadCounter.get()), (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkForStartingReaperThread() {
        boolean isAnyTracingEnabled = TraceComponent.isAnyTracingEnabled();
        if (isAnyTracingEnabled && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("Property change occurred, checking reaper thread status for pool. Current number of alarm threads is " + this.alarmThreadCounter.get()), (Object[])new Object[0]);
        }
        if (this.gConfigProps.connectionPoolingEnabled && this.reapTime > 0) {
            Object object = this.amLockObject;
            synchronized (object) {
                if (this.agedTimeout < 1) {
                    if (this.totalConnectionCount.get() > this.minConnections) {
                        this.createReaperAlarm();
                    }
                } else if (this.totalConnectionCount.get() > 0) {
                    this.createReaperAlarm();
                }
            }
        }
        if (isAnyTracingEnabled && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("Property change occurred, number of alarm threads is " + this.alarmThreadCounter.get()), (Object[])new Object[0]);
        }
    }

    private void createMaxInUseTimeAlarm() {
        boolean isTracingEnabled = TraceComponent.isAnyTracingEnabled();
        if (this.pmQuiesced) {
            if (isTracingEnabled && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)" PM has been Quiesced, so cancel old maxInUseTime alarm.", (Object[])new Object[0]);
            }
            if (this.amMaxInUseTime != null) {
                this.amMaxInUseTime.cancel(false);
            }
            return;
        }
        if (isTracingEnabled && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"Creating deferrable alarm for maxInUseTime", (Object[])new Object[0]);
        }
        if (this.amMaxInUseTime != null) {
            this.amMaxInUseTime.cancel(false);
            if (this.amMaxInUseTime.isDone()) {
                this.maxInUseTimeAlarmThreadCounter.decrementAndGet();
                if (isTracingEnabled && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"Previous maxInUseTime alarm thread cancelled.", (Object[])new Object[0]);
                }
                this.maxInUseTimeAlarmThreadCounter.incrementAndGet();
                try {
                    this.amMaxInUseTime = ((ScheduledExecutorService)this.connectorSvc.deferrableSchedXSvcRef.getServiceWithException()).schedule(new MaxInUseTimeThreadStarter(), (long)this.maxInUseTime, TimeUnit.MILLISECONDS);
                }
                catch (Exception e) {
                    this.maxInUseTimeAlarmThreadCounter.decrementAndGet();
                    throw new RuntimeException(e);
                }
            }
        } else {
            if (isTracingEnabled && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"No previous maxInUseTime alarm thread exists. Creating a new one.", (Object[])new Object[0]);
            }
            this.maxInUseTimeAlarmThreadCounter.incrementAndGet();
            try {
                this.amMaxInUseTime = ((ScheduledExecutorService)this.connectorSvc.deferrableSchedXSvcRef.getServiceWithException()).schedule(new MaxInUseTimeThreadStarter(), (long)this.maxInUseTime, TimeUnit.MILLISECONDS);
            }
            catch (Exception e) {
                this.maxInUseTimeAlarmThreadCounter.decrementAndGet();
                throw new RuntimeException(e);
            }
        }
    }

    private void createReaperAlarm() {
        boolean isTracingEnabled = TraceComponent.isAnyTracingEnabled();
        if (this.pmQuiesced) {
            if (isTracingEnabled && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)" PM has been Quiesced, so cancel old reaper alarm.", (Object[])new Object[0]);
            }
            if (this.am != null) {
                this.am.cancel(false);
            }
            return;
        }
        if (this.nonDeferredReaperAlarm) {
            if (isTracingEnabled && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"Creating non-deferrable alarm for reaper", (Object[])new Object[0]);
            }
            if (this.am != null) {
                this.am.cancel(false);
                if (this.am.isDone()) {
                    this.alarmThreadCounter.decrementAndGet();
                    if (isTracingEnabled && tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)"Previous alarm thread cancelled.", (Object[])new Object[0]);
                    }
                    this.alarmThreadCounter.incrementAndGet();
                    try {
                        this.am = ((ScheduledExecutorService)this.connectorSvc.nonDeferrableSchedXSvcRef.getServiceWithException()).schedule(this, (long)this.reapTime, TimeUnit.SECONDS);
                    }
                    catch (Exception e) {
                        this.alarmThreadCounter.decrementAndGet();
                        throw new RuntimeException(e);
                    }
                }
            } else {
                if (isTracingEnabled && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"No previous alarm thread exists. Creating a new one.", (Object[])new Object[0]);
                }
                this.alarmThreadCounter.incrementAndGet();
                try {
                    this.am = ((ScheduledExecutorService)this.connectorSvc.nonDeferrableSchedXSvcRef.getServiceWithException()).schedule(this, (long)this.reapTime, TimeUnit.SECONDS);
                }
                catch (Exception e) {
                    this.alarmThreadCounter.decrementAndGet();
                    throw new RuntimeException(e);
                }
            }
        } else {
            if (isTracingEnabled && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"Creating deferrable alarm for reaper", (Object[])new Object[0]);
            }
            if (this.am != null) {
                this.am.cancel(false);
                if (this.am.isDone()) {
                    this.alarmThreadCounter.decrementAndGet();
                    if (isTracingEnabled && tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)"Previous alarm thread cancelled.", (Object[])new Object[0]);
                    }
                    this.alarmThreadCounter.incrementAndGet();
                    try {
                        this.am = ((ScheduledExecutorService)this.connectorSvc.deferrableSchedXSvcRef.getServiceWithException()).schedule(this, (long)this.reapTime, TimeUnit.SECONDS);
                    }
                    catch (Exception e) {
                        this.alarmThreadCounter.decrementAndGet();
                        throw new RuntimeException(e);
                    }
                }
            } else {
                if (isTracingEnabled && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"No previous alarm thread exists. Creating a new one.", (Object[])new Object[0]);
                }
                this.alarmThreadCounter.incrementAndGet();
                try {
                    this.am = ((ScheduledExecutorService)this.connectorSvc.deferrableSchedXSvcRef.getServiceWithException()).schedule(this, (long)this.reapTime, TimeUnit.SECONDS);
                }
                catch (Exception e) {
                    this.alarmThreadCounter.decrementAndGet();
                    throw new RuntimeException(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized void vetoableChange(PropertyChangeEvent event) throws PropertyVetoException {
        block54: {
            int oldMaxConnection2;
            int value;
            block58: {
                int value2;
                block61: {
                    String propName;
                    block60: {
                        block59: {
                            block57: {
                                if (tc.isEntryEnabled()) {
                                    Tr.entry((Object)this, (TraceComponent)tc, (String)"vetoableChange", (Object[])new Object[]{event.getPropertyName()});
                                }
                                if (!(propName = event.getPropertyName()).equals("maxConnections")) break block57;
                                value = (Integer)event.getNewValue();
                                oldMaxConnection2 = this.maxConnections;
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((Object)this, (TraceComponent)tc, (String)("vetoableChange " + propName + " new/old " + value + "/" + this.maxConnections + " total connection count " + this.totalConnectionCount.get()), (Object[])new Object[0]);
                                }
                                this.maxConnections = value;
                                if (this.totalConnectionCount.get() <= value || value == 0) break block54;
                                break block58;
                            }
                            if (!propName.equals("maxFreePoolHashSize")) break block59;
                            int value3 = (Integer)event.getNewValue();
                            this.updateToPoolInProgress = true;
                            Object oldMaxConnection2 = this.updateToPoolInProgressLockObject;
                            synchronized (oldMaxConnection2) {
                                if (this.checkForActiveConnections(1)) {
                                    this.updateToPoolInProgress = false;
                                    this.updateToPoolInProgressLockObject.notifyAll();
                                    String errorString = "There are active connections in the Pool.  The freePoolHashValue cannot be changed at this time.";
                                    PropertyVetoException e = new PropertyVetoException(errorString, event);
                                    throw e;
                                }
                                if (tc.isInfoEnabled()) {
                                    this.logPropertyChangeMsg("maxFreePoolHashSize", this.maxFreePoolHashSize, value3);
                                }
                                this.maxFreePoolHashSize = value3;
                                int fatalErrorNotificationTime = this.freePool[0].getFatalErrorNotificationTime();
                                FreePool[] newFreePool = new FreePool[this.maxFreePoolHashSize];
                                for (int j = 0; j < this.maxFreePoolHashSize; ++j) {
                                    newFreePool[j] = new FreePool(this.maxConnections, this, this.gConfigProps, this.raClassLoader);
                                    newFreePool[j].setFatalErrorNotificationTime(fatalErrorNotificationTime);
                                }
                                this.mcToMCWMapWrite.lock();
                                try {
                                    Collection<com.ibm.ws.j2c.MCWrapper> mcWrappers = this.mcToMCWMap.values();
                                    for (com.ibm.ws.j2c.MCWrapper mcw : mcWrappers) {
                                        if (mcw.isParkedWrapper()) continue;
                                        int hashCode = this.computeHashCode(mcw.getSubject(), mcw.getCRI());
                                        int hashMapBucket = hashCode % value3;
                                        mcw.setHashMapBucket(hashMapBucket);
                                        mcw.setSubjectCRIHashCode(hashCode);
                                        if (mcw.getPoolState() != 1) continue;
                                        newFreePool[hashMapBucket].getMCWrapperList().add(mcw);
                                    }
                                }
                                finally {
                                    this.mcToMCWMapWrite.unlock();
                                }
                                this.freePool = newFreePool;
                                this.updateToPoolInProgress = false;
                                this.updateToPoolInProgressLockObject.notifyAll();
                                break block54;
                            }
                        }
                        if (!propName.equals("maxSharedBuckets")) break block60;
                        int value4 = (Integer)event.getNewValue();
                        this.updateToPoolInProgress = true;
                        Object oldMaxConnection2 = this.updateToPoolInProgressLockObject;
                        synchronized (oldMaxConnection2) {
                            if (this.checkForActiveConnections(1)) {
                                this.updateToPoolInProgress = false;
                                this.updateToPoolInProgressLockObject.notifyAll();
                                String errorString = "There are active connections in the Pool.  The sharedPoolBuckets cannot be changed at this time.";
                                PropertyVetoException e = new PropertyVetoException(errorString, event);
                                throw e;
                            }
                            if (tc.isInfoEnabled()) {
                                this.logPropertyChangeMsg("maxSharedBuckets", this.maxSharedBuckets, value4);
                            }
                            this.maxSharedBuckets = value4;
                            SharedPool[] newSharedPool = new SharedPool[this.maxSharedBuckets];
                            for (int i = 0; i < this.maxSharedBuckets; ++i) {
                                newSharedPool[i] = new SharedPool(this.maxConnections, this);
                            }
                            this.mcToMCWMapWrite.lock();
                            try {
                                Collection<com.ibm.ws.j2c.MCWrapper> mcWrappers = this.mcToMCWMap.values();
                                for (com.ibm.ws.j2c.MCWrapper mcw : mcWrappers) {
                                    if (mcw.isParkedWrapper() || mcw.getPoolState() != 2) continue;
                                    Object coordinator = mcw.getSharedPoolCoordinator();
                                    int sharedPoolBucket = Math.abs(coordinator.hashCode() % value4);
                                    newSharedPool[sharedPoolBucket].setSharedConnection(coordinator, mcw);
                                }
                            }
                            finally {
                                this.mcToMCWMapWrite.unlock();
                            }
                            this.sharedPool = newSharedPool;
                            this.updateToPoolInProgress = false;
                            this.updateToPoolInProgressLockObject.notifyAll();
                            break block54;
                        }
                    }
                    if (!propName.equals("numConnectionsPerThreadLocal")) break block54;
                    value2 = (Integer)event.getNewValue();
                    if (this.localConnection_ == null) break block61;
                    if (value2 > 0) {
                        block53: {
                            try {
                                this.purgePoolContents();
                            }
                            catch (ResourceException e) {
                                if (!tc.isDebugEnabled()) break block53;
                                Tr.debug((Object)this, (TraceComponent)tc, (String)("An exception occurred when attempting to purge the pool. " + (Object)((Object)e)), (Object[])new Object[0]);
                            }
                        }
                        if (tc.isInfoEnabled()) {
                            this.logPropertyChangeMsg("numConnectionsPerThreadLocal", this.maxCapacity, value2);
                        }
                        this.maxCapacity = value2;
                        this.isThreadLocalConnectionEnabled = true;
                        break block54;
                    } else {
                        if (tc.isInfoEnabled()) {
                            this.logPropertyChangeMsg("numConnectionsPerThreadLocal", this.maxCapacity, value2);
                        }
                        this.maxCapacity = value2;
                        this.isThreadLocalConnectionEnabled = false;
                        try {
                            this.purgePoolContents();
                        }
                        catch (ResourceException e) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug((Object)this, (TraceComponent)tc, (String)("An exception occurred when attempting to purge the pool. " + (Object)((Object)e)), (Object[])new Object[0]);
                            }
                            break block54;
                        }
                    }
                }
                this.updateToPoolInProgress = true;
                Object object = this.updateToPoolInProgressLockObject;
                synchronized (object) {
                    if (this.checkForActiveConnections(1)) {
                        this.updateToPoolInProgress = false;
                        this.updateToPoolInProgressLockObject.notifyAll();
                        String errorString = "There are active connections in the Pool.  The numConnectionsPerThreadLocal cannot be changed at this time.";
                        PropertyVetoException e = new PropertyVetoException(errorString, event);
                        throw e;
                    }
                    if (value2 > 0) {
                        block55: {
                            try {
                                this.purgePoolContents();
                            }
                            catch (ResourceException e) {
                                if (!tc.isDebugEnabled()) break block55;
                                Tr.debug((Object)this, (TraceComponent)tc, (String)("An exception occurred when attempting to purge the pool. " + (Object)((Object)e)), (Object[])new Object[0]);
                            }
                        }
                        this.maxCapacity = value2;
                        this.localConnection_ = new WSThreadLocal<ArrayList<com.ibm.ws.j2c.MCWrapper>>(){

                            protected ArrayList<com.ibm.ws.j2c.MCWrapper> initialValue() {
                                return new ArrayList<com.ibm.ws.j2c.MCWrapper>(2);
                            }
                        };
                        this.isThreadLocalConnectionEnabled = true;
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((Object)this, (TraceComponent)tc, (String)"PoolManager: Thread local connection ENABLED", (Object[])new Object[0]);
                        }
                    }
                    if (tc.isInfoEnabled()) {
                        this.logPropertyChangeMsg("numConnectionsPerThreadLocal", this.maxCapacity, value2);
                    }
                    this.updateToPoolInProgress = false;
                    this.updateToPoolInProgressLockObject.notifyAll();
                    break block54;
                }
            }
            for (int j = 0; j < this.maxFreePoolHashSize; ++j) {
                Object object = this.freePool[j].freeConnectionLockObject;
                synchronized (object) {
                    int mcwlSize = this.freePool[j].mcWrapperList.size();
                    for (int k = mcwlSize - 1; k > -1; --k) {
                        com.ibm.ws.j2c.MCWrapper mcw = (com.ibm.ws.j2c.MCWrapper)this.freePool[j].mcWrapperList.remove(k);
                        this.freePool[j].cleanupAndDestroyMCWrapper(mcw);
                        this.totalConnectionCount.decrementAndGet();
                        if (this.totalConnectionCount.get() <= value) break;
                    }
                    if (this.totalConnectionCount.get() <= value) {
                        break;
                    }
                    continue;
                }
            }
            if (this.totalConnectionCount.get() > value) {
                int reduceConnectionCount = this.totalConnectionCount.get() - value;
                this.mcToMCWMapWrite.lock();
                try {
                    Collection<com.ibm.ws.j2c.MCWrapper> mcWrappers = this.mcToMCWMap.values();
                    for (com.ibm.ws.j2c.MCWrapper mcw : mcWrappers) {
                        if (mcw.isParkedWrapper()) continue;
                        if (this.totalConnectionCount.get() > value && reduceConnectionCount > 0) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("Reducing pool size " + reduceConnectionCount), (Object[])new Object[]{mcw});
                            }
                            mcw.setDestroyConnectionOnReturn();
                            --reduceConnectionCount;
                            continue;
                        }
                        break;
                    }
                }
                finally {
                    this.mcToMCWMapWrite.unlock();
                }
            }
            if (tc.isInfoEnabled()) {
                this.logPropertyChangeMsg("maxConnections", oldMaxConnection2, this.maxConnections);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"vetoableChange");
        }
    }

    private void logPropertyChangeMsg(String msgKey, boolean oldValue, boolean newValue) {
        if (oldValue == newValue) {
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)msgKey, (Object[])new Object[]{oldValue, newValue, this.gConfigProps.cfName});
        }
    }

    private void logPropertyChangeMsg(String msgKey, int oldValue, int newValue) {
        if (oldValue == newValue) {
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)msgKey, (Object[])new Object[]{oldValue, newValue, this.gConfigProps.cfName});
        }
    }

    private void logPropertyChangeMsg(String msgKey, String oldValue, String newValue) {
        if (oldValue.equals(newValue)) {
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)msgKey, (Object[])new Object[]{oldValue, newValue, this.gConfigProps.cfName});
        }
    }

    public final J2CGlobalConfigProperties getGConfigProps() {
        return this.gConfigProps;
    }

    protected static void logLTCSerialReuseInfo(Object affinity, String pmiName, com.ibm.ws.j2c.MCWrapper mcWrapperTemp, PoolManager pm) {
        boolean isTracingEnabled = TraceComponent.isAnyTracingEnabled();
        if (isTracingEnabled && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("allocateConnection_Common:  HandleCount = " + mcWrapperTemp.getHandleCount()), (Object[])new Object[0]);
        }
        if (pm.logSerialReuseMessage) {
            Tr.info((TraceComponent)tc, (String)"ATTEMPT_TO_SHARE_LTC_CONNECTION_J2CA0086", (Object[])new Object[]{mcWrapperTemp, pmiName});
            pm.logSerialReuseMessage = false;
        }
        if (isTracingEnabled && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Attempt to share connection within LTC (J2CA0086)", (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("mcWrapper = " + mcWrapperTemp), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("pmiName   = " + pmiName), (Object[])new Object[0]);
        }
    }

    private static boolean isCRIsMatching(ConnectionRequestInfo cri, com.ibm.ws.j2c.MCWrapper mcWrapperTemp) {
        ManagedConnection mc = mcWrapperTemp.getManagedConnection();
        ConnectionRequestInfo mcWrapperCRI = mc instanceof WSManagedConnection ? ((WSManagedConnection)mc).getConnectionRequestInfo() : mcWrapperTemp.getCRI();
        return cri == mcWrapperCRI || cri != null && cri.equals((Object)mcWrapperCRI);
    }

    protected boolean isSubjectsMatching(Subject subject, com.ibm.ws.j2c.MCWrapper mcWrapperTemp) {
        boolean subjectMatch = false;
        Subject mcWrapperSubject = mcWrapperTemp.getSubject();
        if (subject == null && mcWrapperSubject == null) {
            subjectMatch = true;
        } else if (subject != null && mcWrapperSubject != null) {
            Equals e = new Equals();
            e.setSubjects(subject, mcWrapperTemp.getSubject());
            if (AccessController.doPrivileged(e).booleanValue()) {
                subjectMatch = true;
            }
        }
        return subjectMatch;
    }

    protected static boolean isBranchCouplingCompatible(int commitPriority, int branchCoupling, com.ibm.ws.j2c.MCWrapper mcWrapperTemp) {
        boolean cmConfigDataIsCompatible = false;
        ConnectionManager cm = ((MCWrapper)mcWrapperTemp).getCm();
        ResourceRefInfo resRefInfo = cm.getResourceRefInfo();
        if (resRefInfo.getCommitPriority() == commitPriority) {
            int tempBranchCoupling = resRefInfo.getBranchCoupling();
            cmConfigDataIsCompatible = branchCoupling == tempBranchCoupling ? true : cm.matchBranchCoupling(branchCoupling, tempBranchCoupling, ((MCWrapper)mcWrapperTemp).get_managedConnectionFactory());
        }
        return cmConfigDataIsCompatible;
    }

    private void sleep(long ms) throws InterruptedException {
        Thread.sleep(ms);
    }

    @Override
    public String getUniqueId() {
        return this.gConfigProps.getXpathId();
    }

    @Override
    public boolean getParkedValue() {
        return false;
    }

    @Override
    public String getJNDIName() {
        return this.gConfigProps.getJNDIName();
    }

    protected AtomicInteger getTotalConnectionCount() {
        return this.totalConnectionCount;
    }

    @Override
    public int getMaximumConnectionValue() {
        return this.maxConnections;
    }

    private static class PoolManagerLock {
        private PoolManagerLock() {
        }
    }

    private static class SubjectToString
    implements PrivilegedAction<String> {
        Subject subject;

        private SubjectToString() {
        }

        public final void setSubject(Subject s) {
            this.subject = s;
        }

        @Override
        public String run() {
            return this.subject.toString();
        }
    }

    static class Equals
    implements PrivilegedAction<Boolean> {
        Subject _s1;
        Subject _s2;

        Equals() {
        }

        public final void setSubjects(Subject s1, Subject s2) {
            this._s1 = s1;
            this._s2 = s2;
        }

        @Override
        public Boolean run() {
            boolean subjectsMatch = false;
            if (this.checkCredentials(this._s1.getPrivateCredentials(), this._s2.getPrivateCredentials())) {
                subjectsMatch = this.checkCredentials(this._s1.getPublicCredentials(), this._s2.getPublicCredentials());
            }
            return subjectsMatch;
        }

        private boolean checkCredentials(Set<Object> s1Credentials, Set<Object> s2Credentials) {
            boolean rVal = false;
            if (s1Credentials != s2Credentials) {
                if (s1Credentials != null && s2Credentials != null) {
                    int it2size;
                    int it1size = s1Credentials.size();
                    if (it1size == (it2size = s2Credentials.size())) {
                        if (it1size == 0) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug((Object)this, (TraceComponent)tc, (String)"Processing credential sets, both are empty, They are equal", (Object[])new Object[0]);
                            }
                            return true;
                        }
                    } else {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Processing credential sets, sets do not contain the same number of elements. They are not equal", (Object[])new Object[0]);
                        }
                        return false;
                    }
                    if (it1size > 1) {
                        Iterator<Object> it1 = s1Credentials.iterator();
                        int objectsEqual = 0;
                        block0: while (it1.hasNext()) {
                            Object s1Cred = it1.next();
                            for (Object s2Cred : s2Credentials) {
                                if (s1Cred != null ? !s1Cred.equals(s2Cred) : s2Cred != null) continue;
                                ++objectsEqual;
                                continue block0;
                            }
                        }
                        if (objectsEqual == it1size) {
                            rVal = true;
                        }
                    } else {
                        Iterator<Object> it1 = s1Credentials.iterator();
                        Iterator<Object> it2 = s2Credentials.iterator();
                        Object s1Cred = it1.next();
                        Object s2Cred = it2.next();
                        if (s1Cred != null) {
                            if (!s1Cred.equals(s2Cred)) {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug((Object)this, (TraceComponent)tc, (String)"PK69110 - Objects are not equal", (Object[])new Object[0]);
                                }
                                return false;
                            }
                        } else if (s2Cred != null) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug((Object)this, (TraceComponent)tc, (String)"PK69110 - Objects are not equal, one objest is null", (Object[])new Object[0]);
                            }
                            return false;
                        }
                        rVal = true;
                    }
                }
            } else {
                rVal = true;
            }
            return rVal;
        }
    }

    private class ToStringStackElements {
        StackTraceElement[] ste = null;
        int numberOfOccurrents = 0;

        public ToStringStackElements(StackTraceElement[] ste, int numberOfOccurrents) {
            this.ste = ste;
            this.numberOfOccurrents = numberOfOccurrents;
        }
    }

    static class SubjectHashCode
    implements PrivilegedAction<Integer> {
        Subject subject;

        SubjectHashCode() {
        }

        public final void setSubject(Subject s1) {
            this.subject = s1;
        }

        @Override
        public Integer run() {
            int privateC = 0;
            int publicC = 0;
            if (this.subject.getPrivateCredentials() != null) {
                privateC = this.subject.getPrivateCredentials().hashCode() / 2;
            }
            if (this.subject.getPublicCredentials() != null) {
                publicC = this.subject.getPublicCredentials().hashCode() / 2;
            }
            return privateC + publicC;
        }
    }

    public class MaxInUseTimeThreadStarter
    implements Runnable {
        private final TraceComponent traceC = Tr.register(MaxInUseTimeThreadStarter.class, (String)"WAS.j2c", (String)"com.ibm.ws.j2c.resources.J2CAMessages");

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean isTracingEnabled = TraceComponent.isAnyTracingEnabled();
            if (isTracingEnabled && this.traceC.isEntryEnabled()) {
                Tr.entry((Object)this, (TraceComponent)this.traceC, (String)"run", (Object[])new Object[]{"maxInUseTime alarm"});
            }
            if (isTracingEnabled && this.traceC.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)this.traceC, (String)("run: maxInUseTime alarm, Pool contents ==> " + this.toString()), (Object[])new Object[0]);
                Tr.debug((Object)this, (TraceComponent)this.traceC, (String)"maxInUseTimeThreadStarted: ", (Object[])new Object[]{PoolManager.this.maxInUseTimeThreadStarted});
            }
            PoolManager.this.startMaxInUseTimeReclaimConnectionThread();
            if (isTracingEnabled && this.traceC.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)this.traceC, (String)("run: maxInUseTime alarm, Pool contents ==> " + this.toString()), (Object[])new Object[0]);
                Tr.debug((Object)this, (TraceComponent)this.traceC, (String)"maxInUseTimeThreadStarted: ", (Object[])new Object[]{PoolManager.this.maxInUseTimeThreadStarted});
            }
            Object object = PoolManager.this.amMaxInUseTimeLockObject;
            synchronized (object) {
                if (PoolManager.this.maxInUseTime > 0 && PoolManager.this.totalConnectionCount.get() > 0 && PoolManager.this.maxInUseTimeAlarmThreadCounter.get() >= 0) {
                    PoolManager.this.createMaxInUseTimeAlarm();
                } else {
                    if (PoolManager.this.maxInUseTimeAlarmThreadCounter.get() > 0) {
                        PoolManager.this.maxInUseTimeAlarmThreadCounter.decrementAndGet();
                    }
                    if (isTracingEnabled && this.traceC.isDebugEnabled()) {
                        Tr.debug((TraceComponent)this.traceC, (String)("maxInUseTime alarm thread was NOT started. Number of maxInUseTime alarm threads is " + PoolManager.this.maxInUseTimeAlarmThreadCounter.get()), (Object[])new Object[0]);
                    }
                }
            }
            if (isTracingEnabled && this.traceC.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)this.traceC, (String)"run");
            }
        }
    }
}

