/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;

public class PrimitiveArrayPool {
    private static TraceComponent tc = Tr.register(PrimitiveArrayPool.class, (String)"WebSphere Dynamic Cache", (String)"com.ibm.ws.cache.resources.dynacache");
    private static boolean IS_UNIT_TEST = false;
    private HashMap pools = null;
    private PoolConfig poolConfig = null;
    private long lastScanTime = 0L;
    private String cacheName = null;

    public PrimitiveArrayPool(PoolConfig poolConfig, String cacheName) {
        String methodName = "PrimitiveArrayPool() - CTOR";
        poolConfig.verifyConfig();
        this.poolConfig = poolConfig;
        this.pools = new HashMap(poolConfig.numberOfPools);
        this.cacheName = cacheName;
        this.traceDebug("PrimitiveArrayPool() - CTOR", "cacheName=" + this.cacheName + " " + poolConfig);
    }

    private void releaseUnusedPools() {
        String methodName = "releaseUnusedPools()";
        long currentTime = System.currentTimeMillis();
        Iterator i = this.pools.values().iterator();
        while (i.hasNext()) {
            ArrayList pool = (ArrayList)i.next();
            Iterator j = pool.iterator();
            while (j.hasNext()) {
                PoolEntry poolEntry = (PoolEntry)j.next();
                if (currentTime - poolEntry.getLastAccess() <= (long)this.poolConfig.poolEntryLife) continue;
                this.traceDebug("releaseUnusedPools()", "cacheName=" + this.cacheName + " unused pool entry released for type=" + this.poolConfig.getType() + " size=" + poolEntry.getLength());
                j.remove();
                poolEntry.release();
                if (pool.size() != 0) continue;
                i.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PoolEntry allocate(int size) {
        Object array;
        String methodName = "allocate()";
        PoolEntry poolEntry = null;
        HashMap hashMap = this.pools;
        synchronized (hashMap) {
            if (this.pools.size() > 0) {
                ArrayList pool = (ArrayList)this.pools.get("" + size);
                if (pool != null && pool.size() > 0) {
                    poolEntry = (PoolEntry)pool.remove(0);
                } else {
                    this.releaseUnusedPools();
                }
            }
        }
        if (poolEntry == null) {
            switch (this.poolConfig.type) {
                case 2: {
                    poolEntry = new PoolEntry(new long[size]);
                    break;
                }
                case 1: {
                    poolEntry = new PoolEntry(new byte[size]);
                    break;
                }
                default: {
                    throw new IllegalStateException(this.poolConfig.toString());
                }
            }
            this.traceDebug("allocate()", "cacheName=" + this.cacheName + " pool entry created for type=" + this.poolConfig.getType() + " size=" + size);
        }
        if ((array = poolEntry.getArray()) != null && array instanceof byte[]) {
            Arrays.fill((byte[])array, (byte)0);
        } else if (array != null && array instanceof long[]) {
            Arrays.fill((long[])array, 0L);
        }
        return poolEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean returnToPool(PoolEntry poolEntry) {
        String methodName = "returnToPool()";
        boolean rc = false;
        HashMap hashMap = this.pools;
        synchronized (hashMap) {
            long currentTime = System.currentTimeMillis();
            if (currentTime - this.lastScanTime > (long)this.poolConfig.scanFrequency) {
                this.lastScanTime = currentTime;
                this.releaseUnusedPools();
            }
            if (this.pools.size() < this.poolConfig.numberOfPools) {
                ArrayList<PoolEntry> pool = (ArrayList<PoolEntry>)this.pools.get("" + poolEntry.getLength());
                if (pool == null) {
                    pool = new ArrayList<PoolEntry>(this.poolConfig.poolSize);
                    this.pools.put("" + poolEntry.getLength(), pool);
                }
                if (pool.size() < this.poolConfig.poolSize) {
                    pool.add(poolEntry);
                    poolEntry.touch();
                    rc = true;
                } else {
                    this.traceDebug("returnToPool()", "cacheName=" + this.cacheName + " the pool is full for type=" + this.poolConfig.getType() + " size=" + poolEntry.getLength());
                    this.releaseUnusedPools();
                }
            } else {
                this.traceDebug("returnToPool()", "cacheName=" + this.cacheName + " there are no more pool slots");
                this.releaseUnusedPools();
            }
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        HashMap hashMap = this.pools;
        synchronized (hashMap) {
            if (this.pools.size() > 0) {
                this.releaseUnusedPools();
            }
        }
    }

    private void traceDebug(String methodName, String message) {
        if (IS_UNIT_TEST) {
            System.out.println(this.getClass().getName() + "." + methodName + " " + message);
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(methodName + " " + message), (Object[])new Object[0]);
        }
    }

    static class PoolConfig {
        public static final int TYPE_BYTE = 1;
        public static final int TYPE_LONG = 2;
        public int type = -1;
        public int numberOfPools = 0;
        public int poolSize = 0;
        public int poolEntryLife = 0;
        public int scanFrequency = 0;

        PoolConfig() {
        }

        public String toString() {
            return "PoolConfig@@" + this.hashCode() + " type=" + (this.type == 1 ? "byte[]" : (this.type == 2 ? "long[]" : "unknown")) + " numberOfPools=" + this.numberOfPools + " poolSize=" + this.poolSize + " poolEntryLife=" + this.poolEntryLife + " scanFrequency=" + this.scanFrequency;
        }

        protected void verifyConfig() {
            if (this.numberOfPools < 0 || this.poolSize < 0 || this.poolEntryLife <= 0 || this.scanFrequency < 0 || this.type == -1) {
                throw new IllegalStateException("PoolConfig error " + this.toString());
            }
        }

        protected String getType() {
            String primitiveType = "";
            switch (this.type) {
                case 2: {
                    primitiveType = "long[]";
                    break;
                }
                case 1: {
                    primitiveType = "byte[]";
                    break;
                }
                default: {
                    throw new IllegalStateException(this.toString());
                }
            }
            return primitiveType;
        }
    }

    public static class PoolEntry {
        private Object primitiveArray = null;
        private long lastAccess = 0L;
        private int length = 0;

        public PoolEntry(Object primitiveArray) {
            this.primitiveArray = primitiveArray;
            if (primitiveArray instanceof byte[]) {
                this.length = ((byte[])primitiveArray).length;
            } else if (primitiveArray instanceof long[]) {
                this.length = ((long[])primitiveArray).length;
            }
        }

        public Object getArray() {
            this.touch();
            return this.primitiveArray;
        }

        protected void release() {
            this.primitiveArray = null;
        }

        protected long getLastAccess() {
            return this.lastAccess;
        }

        protected int getLength() {
            return this.length;
        }

        protected void touch() {
            this.lastAccess = System.currentTimeMillis();
        }
    }
}

