/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.renderkit.html;

import jakarta.el.ValueExpression;
import jakarta.faces.FacesException;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.myfaces.config.webparameters.MyfacesConfig;
import org.apache.myfaces.core.api.shared.ComponentUtils;
import org.apache.myfaces.core.api.shared.lang.Assert;
import org.apache.myfaces.renderkit.ContentTypeUtils;
import org.apache.myfaces.renderkit.html.util.HTMLEncoder;
import org.apache.myfaces.renderkit.html.util.UnicodeEncoder;
import org.apache.myfaces.util.CommentUtils;
import org.apache.myfaces.util.lang.StreamCharBuffer;

public class HtmlResponseWriterImpl
extends ResponseWriter {
    private static final Logger log = Logger.getLogger(HtmlResponseWriterImpl.class.getName());
    private static final String DEFAULT_CONTENT_TYPE = "text/html";
    private static final String DEFAULT_CHARACTER_ENCODING = "ISO-8859-1";
    private static final String UTF8 = "UTF-8";
    private static final String APPLICATION_XML_CONTENT_TYPE = "application/xml";
    private static final String TEXT_XML_CONTENT_TYPE = "text/xml";
    private static final String CDATA_START = "<![CDATA[ \n";
    private static final String CDATA_START_NO_LINE_RETURN = "<![CDATA[";
    private static final String COMMENT_START = "<!--\n";
    private static final String CDATA_COMMENT_START = "//<![CDATA[ \n";
    private static final String CDATA_COMMENT_END = "\n//]]>";
    private static final String CDATA_END = "\n]]>";
    private static final String CDATA_END_NO_LINE_RETURN = "]]>";
    private static final String COMMENT_COMMENT_END = "\n//-->";
    private static final String COMMENT_END = "\n-->";
    private static final String[][] EMPTY_ELEMENT_ARR = new String[256][];
    private static final String[] A_NAMES = new String[]{"area"};
    private static final String[] B_NAMES = new String[]{"br", "base", "basefont"};
    private static final String[] C_NAMES = new String[]{"col"};
    private static final String[] E_NAMES = new String[]{"embed"};
    private static final String[] F_NAMES = new String[]{"frame"};
    private static final String[] H_NAMES = new String[]{"hr"};
    private static final String[] I_NAMES = new String[]{"img", "input", "isindex"};
    private static final String[] L_NAMES = new String[]{"link"};
    private static final String[] M_NAMES = new String[]{"meta"};
    private static final String[] P_NAMES = new String[]{"param"};
    private Writer _outputWriter;
    private Writer _currentWriter;
    private StreamCharBuffer _buffer;
    private String _contentType;
    private String _writerContentTypeMode;
    private boolean _isXhtmlContentType;
    private boolean _useStraightXml;
    private String _characterEncoding;
    private boolean _wrapScriptContentWithXmlCommentTag;
    private boolean _isUTF8;
    private String _startElementName;
    private boolean _isInsideScript = false;
    private boolean _isStyle = false;
    private Boolean _isTextArea;
    private UIComponent _startElementUIComponent;
    private boolean _startTagOpen;
    private Map<String, Object> _passThroughAttributesMap;
    private FacesContext _facesContext;
    private boolean _cdataOpen;
    private List<String> _startedChangedElements;
    private List<Integer> _startedElementsCount;

    public HtmlResponseWriterImpl(Writer writer, String contentType, String characterEncoding) {
        this(writer, contentType, characterEncoding, true);
    }

    public HtmlResponseWriterImpl(Writer writer, String contentType, String characterEncoding, boolean wrapScriptContentWithXmlCommentTag) {
        this(writer, contentType, characterEncoding, wrapScriptContentWithXmlCommentTag, contentType != null && ContentTypeUtils.isXHTMLContentType(contentType) ? "application/xhtml+xml" : DEFAULT_CONTENT_TYPE);
    }

    public HtmlResponseWriterImpl(Writer writer, String contentType, String characterEncoding, boolean wrapScriptContentWithXmlCommentTag, String writerContentTypeMode) throws FacesException {
        this._currentWriter = this._outputWriter = writer;
        this._wrapScriptContentWithXmlCommentTag = wrapScriptContentWithXmlCommentTag;
        this._contentType = contentType;
        if (this._contentType == null) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("No content type given, using default content type text/html");
            }
            this._contentType = DEFAULT_CONTENT_TYPE;
        }
        this._writerContentTypeMode = writerContentTypeMode;
        this._isXhtmlContentType = writerContentTypeMode.contains("application/xhtml+xml");
        boolean bl = this._useStraightXml = this._isXhtmlContentType && (this._contentType.contains(APPLICATION_XML_CONTENT_TYPE) || this._contentType.contains(TEXT_XML_CONTENT_TYPE));
        if (characterEncoding == null) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("No character encoding given, using default character encoding ISO-8859-1");
            }
            this._characterEncoding = DEFAULT_CHARACTER_ENCODING;
        } else {
            this._characterEncoding = characterEncoding.toUpperCase();
            if (!Charset.isSupported(this._characterEncoding)) {
                throw new IllegalArgumentException("Encoding " + this._characterEncoding + " not supported by HtmlResponseWriterImpl");
            }
        }
        this._isUTF8 = UTF8.equals(this._characterEncoding);
        this._startedChangedElements = new ArrayList<String>();
        this._startedElementsCount = new ArrayList<Integer>();
    }

    public static boolean supportsContentType(String contentType) {
        String[] supportedContentTypes;
        for (String supportedContentType : supportedContentTypes = ContentTypeUtils.getSupportedContentTypes()) {
            if (!supportedContentType.contains(contentType)) continue;
            return true;
        }
        return false;
    }

    public String getContentType() {
        return this._contentType;
    }

    public String getWriterContentTypeMode() {
        return this._writerContentTypeMode;
    }

    public String getCharacterEncoding() {
        return this._characterEncoding;
    }

    public void flush() throws IOException {
        this.closeStartTagIfNecessary();
    }

    public void startDocument() {
    }

    public void endDocument() throws IOException {
        MyfacesConfig myfacesConfig = MyfacesConfig.getCurrentInstance(FacesContext.getCurrentInstance());
        if (myfacesConfig.isEarlyFlushEnabled()) {
            this._currentWriter.flush();
        }
        this._facesContext = null;
    }

    public void startElement(String name, UIComponent uiComponent) throws IOException {
        Assert.notNull((Object)name, (String)"name");
        this.closeStartTagIfNecessary();
        this._currentWriter.write(60);
        this.resetStartedElement();
        this._startElementName = name;
        this._startElementUIComponent = uiComponent;
        this._startTagOpen = true;
        Map<String, Object> map = this._passThroughAttributesMap = this._startElementUIComponent != null ? this._startElementUIComponent.getPassThroughAttributes(false) : null;
        if (this._passThroughAttributesMap != null) {
            Object value = this._passThroughAttributesMap.get("elementName");
            if (value != null) {
                String elementName;
                if (value instanceof ValueExpression) {
                    value = ((ValueExpression)value).getValue(this.getFacesContext().getELContext());
                }
                if (!name.equals(elementName = value.toString().trim())) {
                    this._startElementName = elementName;
                    this._startedChangedElements.add(elementName);
                    this._startedElementsCount.add(0);
                }
                this._currentWriter.write(elementName);
            } else {
                this._currentWriter.write(name);
            }
        } else {
            this._currentWriter.write(name);
        }
        if (!this._startedElementsCount.isEmpty()) {
            int i = this._startedElementsCount.size() - 1;
            this._startedElementsCount.set(i, this._startedElementsCount.get(i) + 1);
        }
        if (this.isScript(this._startElementName)) {
            this._isInsideScript = true;
            this._isStyle = false;
            this._isTextArea = Boolean.FALSE;
        } else if (this.isStyle(this._startElementName)) {
            this._isInsideScript = false;
            this._isStyle = true;
            this._isTextArea = Boolean.FALSE;
        }
    }

    public void startCDATA() throws IOException {
        if (!this._cdataOpen) {
            this.write(CDATA_START_NO_LINE_RETURN);
            this._cdataOpen = true;
        }
    }

    public void endCDATA() throws IOException {
        if (this._cdataOpen) {
            this.write(CDATA_END_NO_LINE_RETURN);
            this._cdataOpen = false;
        }
    }

    private void closeStartTagIfNecessary() throws IOException {
        if (this._startTagOpen) {
            if (this._passThroughAttributesMap != null) {
                for (Map.Entry<String, Object> entry : this._passThroughAttributesMap.entrySet()) {
                    String key = entry.getKey();
                    if ("elementName".equals(key)) continue;
                    Object value = entry.getValue();
                    if (value instanceof ValueExpression) {
                        value = ((ValueExpression)value).getValue(this.getFacesContext().getELContext());
                    }
                    this.encodeAndWriteAttribute(key, value);
                }
            }
            if (!this._useStraightXml && this.isEmptyElement(this._startElementName)) {
                this._currentWriter.write(" />");
                this.resetStartedElement();
            } else {
                this._currentWriter.write(62);
                if (this.isScript(this._startElementName) && (this._isXhtmlContentType || this._wrapScriptContentWithXmlCommentTag)) {
                    this._currentWriter = this.getInternalBuffer(true).getWriter();
                }
                if (this.isStyle(this._startElementName) && this._isXhtmlContentType) {
                    this._currentWriter = this.getInternalBuffer(true).getWriter();
                }
            }
            this._startTagOpen = false;
        }
    }

    private boolean isEmptyElement(String elem) {
        String[] array = EMPTY_ELEMENT_ARR[elem.charAt(0)];
        if (array != null) {
            for (int i = array.length - 1; i >= 0; --i) {
                if (!elem.equalsIgnoreCase(array[i])) continue;
                return true;
            }
        }
        return false;
    }

    private void resetStartedElement() {
        this._startElementName = null;
        this._startElementUIComponent = null;
        this._passThroughAttributesMap = null;
        this._isStyle = false;
        this._isTextArea = null;
    }

    public void endElement(String name) throws IOException {
        Assert.notNull((Object)name, (String)"name");
        String elementName = name;
        if (!this._startedElementsCount.isEmpty()) {
            int i = this._startedElementsCount.size() - 1;
            this._startedElementsCount.set(i, this._startedElementsCount.get(i) - 1);
            if (this._startedElementsCount.get(i) == 0) {
                elementName = this._startedChangedElements.get(i);
                this._startedChangedElements.remove(i);
                this._startedElementsCount.remove(i);
            }
        }
        if (log.isLoggable(Level.WARNING) && this._startElementName != null && !elementName.equals(this._startElementName)) {
            log.warning("HTML nesting warning on closing " + elementName + ": element " + this._startElementName + (String)(this._startElementUIComponent == null ? "" : " rendered by component : " + ComponentUtils.getPathToComponent((UIComponent)this._startElementUIComponent)) + " not explicitly closed");
        }
        if (this._startTagOpen) {
            this.closeStartTagIfNecessary();
            if (this._startElementName != null) {
                if (this.isScript() && (this._isXhtmlContentType || this._wrapScriptContentWithXmlCommentTag)) {
                    this.writeScriptContent();
                    this._currentWriter = this._outputWriter;
                } else if (this.isStyle() && this._isXhtmlContentType) {
                    this.writeStyleContent();
                    this._currentWriter = this._outputWriter;
                }
                this.writeEndTag(elementName);
            }
        } else if (this._useStraightXml || !this.isEmptyElement(elementName)) {
            if (this.isScript() && (this._isXhtmlContentType || this._wrapScriptContentWithXmlCommentTag)) {
                this.writeScriptContent();
                this._currentWriter = this._outputWriter;
            } else if (this.isStyle() && this._isXhtmlContentType) {
                this.writeStyleContent();
                this._currentWriter = this._outputWriter;
            }
            this.writeEndTag(elementName);
        }
        this.resetStartedElement();
    }

    private void writeStyleContent() throws IOException {
        String content = this.getInternalBuffer().toString();
        if (this._isXhtmlContentType) {
            String trimmedContent = content.trim();
            if (trimmedContent.startsWith(CDATA_START_NO_LINE_RETURN) && trimmedContent.endsWith(CDATA_END_NO_LINE_RETURN)) {
                this._outputWriter.write(content);
                return;
            }
            if (CommentUtils.isStartMatchWithCommentedCDATA((String)trimmedContent) && CommentUtils.isEndMatchWithCommentedCDATA((String)trimmedContent)) {
                this._outputWriter.write(content);
                return;
            }
            if (trimmedContent.startsWith("<!--") && trimmedContent.endsWith("-->")) {
                this._outputWriter.write(CDATA_START);
                this._outputWriter.write(trimmedContent.substring(4, trimmedContent.length() - 3));
                this._outputWriter.write(CDATA_END);
                return;
            }
            this._outputWriter.write(CDATA_START);
            this._outputWriter.write(content);
            this._outputWriter.write(CDATA_END);
            return;
        }
        this._outputWriter.write(content);
    }

    private void writeScriptContent() throws IOException {
        String content = this.getInternalBuffer().toString();
        String trimmedContent = null;
        if (this._isXhtmlContentType) {
            trimmedContent = content.trim();
            if (trimmedContent.startsWith("<!--") && CommentUtils.isEndMatchtWithInlineCommentedXmlCommentTag((String)trimmedContent)) {
                if (this._cdataOpen) {
                    this._outputWriter.write("//\n");
                } else {
                    this._outputWriter.write(CDATA_COMMENT_START);
                }
                this._outputWriter.write(trimmedContent.substring(4));
                if (this._cdataOpen) {
                    this._outputWriter.write(10);
                } else {
                    this._outputWriter.write(CDATA_COMMENT_END);
                }
                return;
            }
            if (CommentUtils.isStartMatchWithCommentedCDATA((String)trimmedContent) && CommentUtils.isEndMatchWithCommentedCDATA((String)trimmedContent)) {
                this._outputWriter.write(content);
                return;
            }
            if (CommentUtils.isStartMatchWithInlineCommentedCDATA((String)trimmedContent) && CommentUtils.isEndMatchWithInlineCommentedCDATA((String)trimmedContent)) {
                this._outputWriter.write(content);
                return;
            }
            if (this._cdataOpen) {
                this._outputWriter.write("//\n");
            } else {
                this._outputWriter.write(CDATA_COMMENT_START);
            }
            this._outputWriter.write(content);
            if (this._cdataOpen) {
                this._outputWriter.write(10);
            } else {
                this._outputWriter.write(CDATA_COMMENT_END);
            }
            return;
        }
        if (this._wrapScriptContentWithXmlCommentTag) {
            trimmedContent = content.trim();
            if (trimmedContent.startsWith("<!--") && CommentUtils.isEndMatchtWithInlineCommentedXmlCommentTag((String)trimmedContent)) {
                this._outputWriter.write(content);
                return;
            }
            if (CommentUtils.isStartMatchWithCommentedCDATA((String)trimmedContent) && CommentUtils.isEndMatchWithCommentedCDATA((String)trimmedContent)) {
                this._outputWriter.write(content);
                return;
            }
            if (CommentUtils.isStartMatchWithInlineCommentedCDATA((String)trimmedContent) && CommentUtils.isEndMatchWithInlineCommentedCDATA((String)trimmedContent)) {
                this._outputWriter.write(content);
                return;
            }
            this._outputWriter.write(COMMENT_START);
            this._outputWriter.write(content);
            this._outputWriter.write(COMMENT_COMMENT_END);
            return;
        }
        this._outputWriter.write(content);
    }

    private void writeEndTag(String name) throws IOException {
        if (this.isScript(name)) {
            this._isInsideScript = false;
        } else if (this.isStyle(name)) {
            this._isStyle = false;
        }
        this._currentWriter.write("</");
        this._currentWriter.write(name);
        this._currentWriter.write(62);
    }

    public void writeAttribute(String name, Object value, String componentPropertyName) throws IOException {
        Assert.notNull((Object)name, (String)"name");
        if (!this._startTagOpen) {
            throw new IllegalStateException("Must be called before the start element is closed (attribute '" + name + "')");
        }
        if (this._passThroughAttributesMap != null && this._passThroughAttributesMap.containsKey(name)) {
            return;
        }
        if (value instanceof Boolean) {
            if (((Boolean)value).booleanValue()) {
                this._currentWriter.write(32);
                this._currentWriter.write(name);
                this._currentWriter.write("=\"");
                this._currentWriter.write(name);
                this._currentWriter.write(34);
            }
        } else {
            this._currentWriter.write(32);
            this._currentWriter.write(name);
            this._currentWriter.write("=\"");
            if (value != null) {
                HTMLEncoder.encode(this._currentWriter, value.toString(), false, false, !this._isUTF8);
            }
            this._currentWriter.write(34);
        }
    }

    private void encodeAndWriteAttribute(String name, Object value) throws IOException {
        this._currentWriter.write(32);
        this._currentWriter.write(name);
        this._currentWriter.write("=\"");
        if (value != null) {
            HTMLEncoder.encode(this._currentWriter, value.toString(), false, false, !this._isUTF8);
        }
        this._currentWriter.write(34);
    }

    public void writeURIAttribute(String name, Object value, String componentPropertyName) throws IOException {
        Assert.notNull((Object)name, (String)"name");
        if (!this._startTagOpen) {
            throw new IllegalStateException("Must be called before the start element is closed (attribute '" + name + "')");
        }
        if (this._passThroughAttributesMap != null && this._passThroughAttributesMap.containsKey(name)) {
            return;
        }
        this.encodeAndWriteURIAttribute(name, value);
    }

    private void encodeAndWriteURIAttribute(String name, Object value) throws IOException {
        String strValue = value.toString();
        this._currentWriter.write(32);
        this._currentWriter.write(name);
        this._currentWriter.write("=\"");
        if (strValue.toLowerCase().startsWith("javascript:")) {
            HTMLEncoder.encode(this._currentWriter, strValue, false, false, !this._isUTF8);
        } else {
            HTMLEncoder.encodeURIAttribute(this._currentWriter, strValue, this._characterEncoding);
        }
        this._currentWriter.write(34);
    }

    public void writeComment(Object value) throws IOException {
        Assert.notNull((Object)value, (String)"value");
        this.closeStartTagIfNecessary();
        this._currentWriter.write("<!--");
        this._currentWriter.write(value.toString());
        this._currentWriter.write("-->");
    }

    public void writeText(Object value, String componentPropertyName) throws IOException {
        Assert.notNull((Object)value, (String)"value");
        this.closeStartTagIfNecessary();
        String strValue = value.toString();
        if (this.isScriptOrStyle()) {
            if (this._isUTF8) {
                this._currentWriter.write(strValue);
            } else {
                UnicodeEncoder.encode(this._currentWriter, strValue);
            }
        } else {
            HTMLEncoder.encode(this._currentWriter, strValue, false, false, !this._isUTF8);
        }
    }

    public void writeText(char[] cbuf, int off, int len) throws IOException {
        Assert.notNull((Object)cbuf, (String)"cbuf");
        if (cbuf.length < off + len) {
            throw new IndexOutOfBoundsException(off + len + " > " + cbuf.length);
        }
        this.closeStartTagIfNecessary();
        if (this.isScriptOrStyle()) {
            String strValue = new String(cbuf, off, len);
            if (this._isUTF8) {
                this._currentWriter.write(strValue);
            } else {
                UnicodeEncoder.encode(this._currentWriter, strValue);
            }
        } else if (this.isTextarea()) {
            HTMLEncoder.encode(cbuf, off, len, false, false, !this._isUTF8, this._currentWriter);
        } else {
            HTMLEncoder.encode(cbuf, off, len, true, true, !this._isUTF8, this._currentWriter);
        }
    }

    private boolean isScriptOrStyle() {
        return this._isStyle || this._isInsideScript;
    }

    private boolean isScript(String element) {
        return "script".equalsIgnoreCase(element);
    }

    private boolean isScript() {
        return this._isInsideScript;
    }

    private boolean isStyle(String element) {
        return "style".equalsIgnoreCase(element);
    }

    private boolean isStyle() {
        return this._isStyle;
    }

    private boolean isTextarea() {
        this.initializeStartedTagInfo();
        return this._isTextArea != null && this._isTextArea != false;
    }

    private void initializeStartedTagInfo() {
        if (this._startElementName != null && this._isTextArea == null) {
            this._isTextArea = this._startElementName.equalsIgnoreCase("textarea") ? Boolean.TRUE : Boolean.FALSE;
        }
    }

    public ResponseWriter cloneWithWriter(Writer writer) {
        HtmlResponseWriterImpl newWriter = new HtmlResponseWriterImpl(writer, this.getContentType(), this.getCharacterEncoding(), this._wrapScriptContentWithXmlCommentTag, this._writerContentTypeMode);
        return newWriter;
    }

    public void close() throws IOException {
        this.closeStartTagIfNecessary();
        this._currentWriter.close();
        this._facesContext = null;
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        this.closeStartTagIfNecessary();
        if (this._isUTF8) {
            this._currentWriter.write(cbuf, off, len);
        } else {
            UnicodeEncoder.encode(this._currentWriter, cbuf, off, len);
        }
    }

    public void write(int c) throws IOException {
        this.closeStartTagIfNecessary();
        this._currentWriter.write(c);
    }

    public void write(char[] cbuf) throws IOException {
        this.closeStartTagIfNecessary();
        if (this._isUTF8) {
            this._currentWriter.write(cbuf);
        } else {
            UnicodeEncoder.encode(this._currentWriter, cbuf, 0, cbuf.length);
        }
    }

    public void write(String str) throws IOException {
        this.closeStartTagIfNecessary();
        if (str != null && str.length() > 0) {
            if (this._isUTF8) {
                this._currentWriter.write(str);
            } else {
                UnicodeEncoder.encode(this._currentWriter, str);
            }
        }
    }

    public void write(String str, int off, int len) throws IOException {
        this.closeStartTagIfNecessary();
        if (this._isUTF8) {
            this._currentWriter.write(str, off, len);
        } else {
            UnicodeEncoder.encode(this._currentWriter, str, off, len);
        }
    }

    public void writeText(Object object, UIComponent component, String string) throws IOException {
        this.writeText(object, string);
    }

    protected StreamCharBuffer getInternalBuffer() {
        return this.getInternalBuffer(false);
    }

    protected StreamCharBuffer getInternalBuffer(boolean reset) {
        if (this._buffer == null) {
            this._buffer = new StreamCharBuffer(256, 100);
        } else if (reset) {
            this._buffer.reset();
        }
        return this._buffer;
    }

    protected FacesContext getFacesContext() {
        if (this._facesContext == null) {
            this._facesContext = FacesContext.getCurrentInstance();
        }
        return this._facesContext;
    }

    protected boolean getWrapScriptContentWithXmlCommentTag() {
        return this._wrapScriptContentWithXmlCommentTag;
    }

    protected void forceFlush() throws IOException {
        this._currentWriter.flush();
    }

    static {
        HtmlResponseWriterImpl.EMPTY_ELEMENT_ARR[97] = A_NAMES;
        HtmlResponseWriterImpl.EMPTY_ELEMENT_ARR[65] = A_NAMES;
        HtmlResponseWriterImpl.EMPTY_ELEMENT_ARR[98] = B_NAMES;
        HtmlResponseWriterImpl.EMPTY_ELEMENT_ARR[66] = B_NAMES;
        HtmlResponseWriterImpl.EMPTY_ELEMENT_ARR[99] = C_NAMES;
        HtmlResponseWriterImpl.EMPTY_ELEMENT_ARR[67] = C_NAMES;
        HtmlResponseWriterImpl.EMPTY_ELEMENT_ARR[101] = E_NAMES;
        HtmlResponseWriterImpl.EMPTY_ELEMENT_ARR[69] = E_NAMES;
        HtmlResponseWriterImpl.EMPTY_ELEMENT_ARR[102] = F_NAMES;
        HtmlResponseWriterImpl.EMPTY_ELEMENT_ARR[70] = F_NAMES;
        HtmlResponseWriterImpl.EMPTY_ELEMENT_ARR[104] = H_NAMES;
        HtmlResponseWriterImpl.EMPTY_ELEMENT_ARR[72] = H_NAMES;
        HtmlResponseWriterImpl.EMPTY_ELEMENT_ARR[105] = I_NAMES;
        HtmlResponseWriterImpl.EMPTY_ELEMENT_ARR[73] = I_NAMES;
        HtmlResponseWriterImpl.EMPTY_ELEMENT_ARR[108] = L_NAMES;
        HtmlResponseWriterImpl.EMPTY_ELEMENT_ARR[76] = L_NAMES;
        HtmlResponseWriterImpl.EMPTY_ELEMENT_ARR[109] = M_NAMES;
        HtmlResponseWriterImpl.EMPTY_ELEMENT_ARR[77] = M_NAMES;
        HtmlResponseWriterImpl.EMPTY_ELEMENT_ARR[112] = P_NAMES;
        HtmlResponseWriterImpl.EMPTY_ELEMENT_ARR[80] = P_NAMES;
    }
}

