/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.common.service;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.SIDestinationAddressFactory;
import com.ibm.ws.messaging.lifecycle.Singleton;
import com.ibm.ws.messaging.lifecycle.SingletonsReady;
import com.ibm.ws.sib.admin.JsAdminService;
import com.ibm.ws.sib.comms.ClientConnectionFactory;
import com.ibm.ws.sib.comms.CommsClientServiceFacadeInterface;
import com.ibm.ws.sib.mfp.JsDestinationAddressFactory;
import com.ibm.ws.sib.mfp.trm.TrmMessageFactory;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SelectionCriteriaFactory;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPolicy=ConfigurationPolicy.IGNORE, property={"type=com.ibm.ws.sib.common.service", "service.vendor=IBM"})
public class CommonServiceFacade
implements Singleton {
    private static final TraceComponent tc = SibTr.register(CommonServiceFacade.class, (String)"SIBAdmin", (String)"com.ibm.ws.sib.admin.internal.CWSIDMessages");
    private static final String CLASS_NAME = "com.ibm.ws.sib.common.service.CommonServiceFacade";
    private final CommsClientServiceFacadeInterface commsClient;

    @Activate
    public CommonServiceFacade(@Reference(name="commsClient") CommsClientServiceFacadeInterface commsClient) {
        String methodName = "<init>";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object)commsClient);
        }
        this.commsClient = commsClient;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    public static ClientConnectionFactory getClientConnectionFactory() {
        return SingletonsReady.findService(CommonServiceFacade.class).map(f -> f.commsClient.getClientConnectionFactory()).orElse(null);
    }

    public static JsAdminService getJsAdminService() {
        return SingletonsReady.findService(JsAdminService.class).orElse(null);
    }

    public TrmMessageFactory getTrmMessageFactory() {
        return TrmMessageFactory.getInstance();
    }

    public static JsDestinationAddressFactory getJsDestinationAddressFactory() {
        return (JsDestinationAddressFactory)SIDestinationAddressFactory.getInstance();
    }

    public static SelectionCriteriaFactory getSelectionCriteriaFactory() {
        return SelectionCriteriaFactory.getInstance();
    }
}

