/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.telemetry10.internal.rest;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.checkpoint.spi.CheckpointPhase;
import io.openliberty.microprofile.telemetry.internal.common.AgentDetection;
import io.openliberty.microprofile.telemetry.internal.common.info.OpenTelemetryInfoInternal;
import io.openliberty.microprofile.telemetry.internal.common.rest.AbstractTelemetryClientFilter;
import io.openliberty.microprofile.telemetry.internal.interfaces.OpenTelemetryAccessor;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.propagation.TextMapSetter;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.InstrumenterBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpClientAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpClientAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpCommonAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpSpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpSpanStatusExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.net.NetClientAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.net.NetClientAttributesGetter;
import jakarta.annotation.Nullable;
import jakarta.ws.rs.client.ClientRequestContext;
import jakarta.ws.rs.client.ClientRequestFilter;
import jakarta.ws.rs.client.ClientResponseContext;
import jakarta.ws.rs.client.ClientResponseFilter;
import jakarta.ws.rs.ext.Provider;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

@Provider
@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class TelemetryClientFilter
extends AbstractTelemetryClientFilter
implements ClientRequestFilter,
ClientResponseFilter {
    private static final TraceComponent tc = Tr.register(TelemetryClientFilter.class, (String)"TELEMETRY", (String)"io.openliberty.microprofile.telemetry.internal.common.resources.MPTelemetry");
    private Instrumenter<ClientRequestContext, ClientResponseContext> instrumenter;
    private volatile boolean lazyCreate = false;
    private final AtomicReference<Instrumenter<ClientRequestContext, ClientResponseContext>> lazyInstrumenter = new AtomicReference();
    private final String configString = "otel.span.client.";
    private static final NetClientAttributesGetterImpl NET_CLIENT_ATTRIBUTES_GETTER = new NetClientAttributesGetterImpl();
    private static final HttpClientAttributesGetterImpl HTTP_CLIENT_ATTRIBUTES_GETTER = new HttpClientAttributesGetterImpl();
    static final long serialVersionUID = -5056344167070931267L;

    TelemetryClientFilter() {
        if (!CheckpointPhase.getPhase().restored()) {
            this.lazyCreate = true;
        } else {
            this.instrumenter = this.createInstrumenter();
        }
    }

    private Instrumenter<ClientRequestContext, ClientResponseContext> getInstrumenter() {
        if (this.instrumenter != null) {
            return this.instrumenter;
        }
        if (this.lazyCreate) {
            this.instrumenter = this.lazyInstrumenter.updateAndGet(i -> {
                if (i == null) {
                    return this.createInstrumenter();
                }
                return i;
            });
            this.lazyCreate = false;
        }
        return this.instrumenter;
    }

    /*
     * WARNING - void declaration
     */
    private Instrumenter<ClientRequestContext, ClientResponseContext> createInstrumenter() {
        OpenTelemetryInfoInternal openTelemetryInfo = OpenTelemetryAccessor.getOpenTelemetryInfo();
        try {
            if (openTelemetryInfo.isEnabled() && !AgentDetection.isAgentActive()) {
                InstrumenterBuilder builder = Instrumenter.builder((OpenTelemetry)openTelemetryInfo.getOpenTelemetry(), (String)"Client filter", (SpanNameExtractor)HttpSpanNameExtractor.create((HttpCommonAttributesGetter)HTTP_CLIENT_ATTRIBUTES_GETTER));
                Instrumenter result = builder.setSpanStatusExtractor(HttpSpanStatusExtractor.create((HttpClientAttributesGetter)HTTP_CLIENT_ATTRIBUTES_GETTER)).addAttributesExtractor((AttributesExtractor)HttpClientAttributesExtractor.create((HttpClientAttributesGetter)HTTP_CLIENT_ATTRIBUTES_GETTER)).addAttributesExtractor((AttributesExtractor)NetClientAttributesExtractor.create((NetClientAttributesGetter)NET_CLIENT_ATTRIBUTES_GETTER)).buildClientInstrumenter((TextMapSetter)new ClientRequestContextTextMapSetter());
                return result;
            }
            return null;
        }
        catch (Exception builder) {
            void e;
            FFDCFilter.processException((Throwable)builder, (String)"io.openliberty.microprofile.telemetry10.internal.rest.TelemetryClientFilter", (String)"105", (Object)((Object)this), (Object[])new Object[0]);
            Tr.error((TraceComponent)tc, (String)Tr.formatMessage((TraceComponent)tc, (String)"CWMOT5002.telemetry.error", (Object[])new Object[]{e}), (Object[])new Object[0]);
            return null;
        }
    }

    public void filter(final ClientRequestContext request) {
        final Instrumenter<ClientRequestContext, ClientResponseContext> currentInstrumenter = this.getInstrumenter();
        if (currentInstrumenter != null) {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){
                static final long serialVersionUID = 6601868179157417130L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                /*
                 * WARNING - void declaration
                 */
                @Override
                public Void run() {
                    try {
                        Context parentContext = Context.current();
                        if (currentInstrumenter.shouldStart(parentContext, (Object)request)) {
                            Context spanContext = currentInstrumenter.start(parentContext, (Object)request);
                            request.setProperty("otel.span.client.context", (Object)spanContext);
                            request.setProperty("otel.span.client.parentContext", (Object)parentContext);
                        }
                    }
                    catch (Exception parentContext) {
                        void e;
                        FFDCFilter.processException((Throwable)parentContext, (String)"io.openliberty.microprofile.telemetry10.internal.rest.TelemetryClientFilter$1", (String)"125", (Object)this, (Object[])new Object[0]);
                        Tr.error((TraceComponent)tc, (String)Tr.formatMessage((TraceComponent)tc, (String)"CWMOT5002.telemetry.error", (Object[])new Object[]{e}), (Object[])new Object[0]);
                    }
                    return null;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"io.openliberty.microprofile.telemetry10.internal.rest.TelemetryClientFilter$1", 1.class, (String)"TELEMETRY", (String)"io.openliberty.microprofile.telemetry.internal.common.resources.MPTelemetry");
                }
            });
        }
    }

    public void filter(final ClientRequestContext request, final ClientResponseContext response) {
        final Instrumenter<ClientRequestContext, ClientResponseContext> currentInstrumenter = this.getInstrumenter();
        if (currentInstrumenter != null) {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){
                static final long serialVersionUID = -7752309423345723588L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                /*
                 * WARNING - void declaration
                 */
                @Override
                public Void run() {
                    try {
                        Context spanContext = (Context)request.getProperty("otel.span.client.context");
                        if (spanContext == null) {
                            return null;
                        }
                        try {
                            currentInstrumenter.end(spanContext, (Object)request, (Object)response, null);
                        }
                        finally {
                            request.removeProperty("otel.span.client.context");
                            request.removeProperty("otel.span.client.parentContext");
                        }
                    }
                    catch (Exception spanContext) {
                        void e;
                        FFDCFilter.processException((Throwable)spanContext, (String)"io.openliberty.microprofile.telemetry10.internal.rest.TelemetryClientFilter$2", (String)"152", (Object)this, (Object[])new Object[0]);
                        Tr.error((TraceComponent)tc, (String)Tr.formatMessage((TraceComponent)tc, (String)"CWMOT5002.telemetry.error", (Object[])new Object[]{e}), (Object[])new Object[0]);
                    }
                    return null;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"io.openliberty.microprofile.telemetry10.internal.rest.TelemetryClientFilter$2", 2.class, (String)"TELEMETRY", (String)"io.openliberty.microprofile.telemetry.internal.common.resources.MPTelemetry");
                }
            });
        }
    }

    public boolean isEnabled() {
        if (!CheckpointPhase.getPhase().restored()) {
            return true;
        }
        return this.getInstrumenter() != null;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class HttpClientAttributesGetterImpl
    implements HttpClientAttributesGetter<ClientRequestContext, ClientResponseContext> {
        static final long serialVersionUID = 5710692352897825971L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private HttpClientAttributesGetterImpl() {
        }

        public String flavor(ClientRequestContext request, ClientResponseContext response) {
            return null;
        }

        public String method(ClientRequestContext request) {
            return request.getMethod();
        }

        public Integer statusCode(ClientRequestContext request, ClientResponseContext response, @Nullable Throwable error) {
            return response.getStatus();
        }

        public String url(ClientRequestContext request) {
            return request.getUri().toString();
        }

        public List<String> requestHeader(ClientRequestContext request, String name) {
            return (List)request.getStringHeaders().getOrDefault((Object)name, Collections.emptyList());
        }

        public List<String> responseHeader(ClientRequestContext request, ClientResponseContext response, String name) {
            return (List)response.getHeaders().getOrDefault((Object)name, Collections.emptyList());
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"io.openliberty.microprofile.telemetry10.internal.rest.TelemetryClientFilter$HttpClientAttributesGetterImpl", HttpClientAttributesGetterImpl.class, (String)"TELEMETRY", (String)"io.openliberty.microprofile.telemetry.internal.common.resources.MPTelemetry");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class NetClientAttributesGetterImpl
    implements NetClientAttributesGetter<ClientRequestContext, ClientResponseContext> {
        static final long serialVersionUID = 5533074519017810200L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private NetClientAttributesGetterImpl() {
        }

        public String transport(ClientRequestContext request, ClientResponseContext response) {
            return "ip_tcp";
        }

        public String peerName(ClientRequestContext request) {
            return request.getUri().getHost();
        }

        public Integer peerPort(ClientRequestContext request) {
            return request.getUri().getPort();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"io.openliberty.microprofile.telemetry10.internal.rest.TelemetryClientFilter$NetClientAttributesGetterImpl", NetClientAttributesGetterImpl.class, (String)"TELEMETRY", (String)"io.openliberty.microprofile.telemetry.internal.common.resources.MPTelemetry");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class ClientRequestContextTextMapSetter
    implements TextMapSetter<ClientRequestContext> {
        static final long serialVersionUID = -7845756453616280046L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private ClientRequestContextTextMapSetter() {
        }

        public void set(ClientRequestContext carrier, String key, String value) {
            if (carrier != null) {
                carrier.getHeaders().put((Object)key, Collections.singletonList(value));
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"io.openliberty.microprofile.telemetry10.internal.rest.TelemetryClientFilter$ClientRequestContextTextMapSetter", ClientRequestContextTextMapSetter.class, (String)"TELEMETRY", (String)"io.openliberty.microprofile.telemetry.internal.common.resources.MPTelemetry");
        }
    }
}

