/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.transport.iiop.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.util.ThreadContextAccessor;
import java.security.AccessController;
import javax.rmi.CORBA.Stub;
import javax.rmi.CORBA.Util;
import org.apache.yoko.rmi.impl.PortableRemoteObjectImpl;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.portable.IDLEntity;
import org.omg.CORBA.portable.ObjectImpl;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class WSPortableRemoteObjectImpl
extends PortableRemoteObjectImpl {
    private static final TraceComponent tc = Tr.register(WSPortableRemoteObjectImpl.class, (String)"IIOP", (String)"com.ibm.ws.transport.iiop.resources.IiopMessages");
    private static ThreadContextAccessor threadContextAccessor = (ThreadContextAccessor)AccessController.doPrivileged(ThreadContextAccessor.getPrivilegedAction());
    static final long serialVersionUID = 8554961151206043202L;

    @FFDCIgnore(value={BAD_OPERATION.class})
    public Object narrow(Object narrowFrom, Class narrowTo) throws ClassCastException {
        Stub stub;
        block8: {
            if (narrowFrom == null) {
                return null;
            }
            if (narrowTo.isInstance(narrowFrom)) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"object is already an instance", (Object[])new Object[0]);
                }
                return narrowFrom;
            }
            if (!(narrowFrom instanceof ObjectImpl)) {
                throw new ClassCastException(narrowTo.getName());
            }
            if (IDLEntity.class.isAssignableFrom(narrowTo)) {
                return super.narrow(narrowFrom, narrowTo);
            }
            Class<?> stubClass = WSPortableRemoteObjectImpl.loadStubClass(narrowTo);
            if (stubClass == null) {
                return super.narrow(narrowFrom, narrowTo);
            }
            stub = WSPortableRemoteObjectImpl.newStub(stubClass, narrowTo);
            try {
                stub._set_delegate(((ObjectImpl)narrowFrom)._get_delegate());
            }
            catch (BAD_OPERATION e) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block8;
                Tr.debug((TraceComponent)tc, (String)"unable to copy delegate", (Object[])new Object[]{e});
            }
        }
        return narrowTo.cast(stub);
    }

    /*
     * WARNING - void declaration
     */
    private static Stub newStub(Class<?> stubClass, Class<?> narrowTo) {
        try {
            return (Stub)stubClass.newInstance();
        }
        catch (Throwable throwable) {
            void t;
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.transport.iiop.internal.WSPortableRemoteObjectImpl", (String)"85", null, (Object[])new Object[]{stubClass, narrowTo});
            throw (ClassCastException)new ClassCastException(narrowTo.getName()).initCause((Throwable)t);
        }
    }

    @FFDCIgnore(value={ClassNotFoundException.class})
    private static Class<?> loadStubClass(Class<?> type) {
        Class stubClass;
        block6: {
            String name = type.getName();
            int index = name.lastIndexOf(46);
            String stubName = index == -1 ? '_' + name + "_Stub" : name.substring(0, index + 1) + '_' + name.substring(index + 1) + "_Stub";
            ClassLoader loader = threadContextAccessor.getContextClassLoaderForUnprivileged(Thread.currentThread());
            try {
                stubClass = Util.loadClass((String)stubName, null, (ClassLoader)loader);
            }
            catch (ClassNotFoundException e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("unable to load class " + stubName), (Object[])new Object[]{e});
                }
                stubClass = null;
            }
            if (stubClass == null) {
                String altStubName = "org.omg.stub." + stubName;
                try {
                    stubClass = Util.loadClass((String)altStubName, null, (ClassLoader)loader);
                }
                catch (ClassNotFoundException e) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block6;
                    Tr.debug((TraceComponent)tc, (String)("unable to load class " + altStubName), (Object[])new Object[]{e});
                }
            }
        }
        return stubClass;
    }
}

