/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.security.oidcclientcore.logout;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.webcontainer.security.AuthResult;
import com.ibm.ws.webcontainer.security.ProviderAuthenticationResult;
import io.openliberty.security.oidcclientcore.client.LogoutConfig;
import io.openliberty.security.oidcclientcore.client.OidcClientConfig;
import io.openliberty.security.oidcclientcore.http.OidcClientHttpUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class RPInitiatedLogoutStrategy {
    private final OidcClientConfig oidcClientConfig;
    private LogoutConfig logoutConfig;
    private final String endSessionEndPoint;
    private final String idTokenString;
    OidcClientHttpUtil oidcClientHttpUtil = OidcClientHttpUtil.getInstance();
    static final long serialVersionUID = 4879124849135482505L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public RPInitiatedLogoutStrategy(OidcClientConfig oidcClientConfig, String endSessionEndPoint, String idTokenString) {
        this.oidcClientConfig = oidcClientConfig;
        if (oidcClientConfig != null) {
            this.logoutConfig = oidcClientConfig.getLogoutConfig();
        }
        this.endSessionEndPoint = endSessionEndPoint;
        this.idTokenString = idTokenString;
    }

    public ProviderAuthenticationResult logout() {
        String endSessionUrl = this.buildEndSessionUrl();
        return new ProviderAuthenticationResult(AuthResult.REDIRECT_TO_PROVIDER, 200, null, null, null, endSessionUrl);
    }

    String buildEndSessionUrl() {
        String queryString = "";
        if (this.oidcClientConfig != null) {
            queryString = this.appendParameter(queryString, "client_id", this.oidcClientConfig.getClientId());
        }
        if (this.logoutConfig != null) {
            queryString = this.appendParameter(queryString, "post_logout_redirect_uri", this.logoutConfig.getRedirectURI());
        }
        String endSessionUrlWithQueryParams = this.endSessionEndPoint;
        if (!queryString.isEmpty()) {
            endSessionUrlWithQueryParams = !this.endSessionEndPoint.contains("?") ? endSessionUrlWithQueryParams + "?" : endSessionUrlWithQueryParams + "&";
        }
        endSessionUrlWithQueryParams = endSessionUrlWithQueryParams + queryString;
        return endSessionUrlWithQueryParams;
    }

    @FFDCIgnore(value={UnsupportedEncodingException.class})
    String appendParameter(String queryString, String parameterName, String parameterValue) {
        if (parameterValue != null && !parameterValue.isEmpty()) {
            if (queryString == null) {
                queryString = "";
            }
            if (!queryString.isEmpty()) {
                queryString = queryString + "&";
            }
            try {
                queryString = queryString + parameterName + "=" + URLEncoder.encode(parameterValue, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return queryString;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"io.openliberty.security.oidcclientcore.logout.RPInitiatedLogoutStrategy", RPInitiatedLogoutStrategy.class, (String)"OpenIdConnect", (String)"io.openliberty.security.oidcclientcore.internal.resources.OidcClientCoreMessages");
    }
}

