/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.metrics.internal.monitor.computed.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ComputedMappingTable {
    public static final int COMPUTED_METRIC_NAME = 0;
    public static final int COMPUTED_METRIC_DESCRIPTION = 1;
    public static final int COMPUTED_METRIC_TYPE = 2;
    public static final int COMPUTED_METRIC_UNIT = 3;
    public static final int MONITOR_METRIC_REGISTRY_SCOPE = 4;
    public static final int MONITOR_METRIC_DURATION = 5;
    public static final int MONITOR_METRIC_TOTAL_COUNT = 6;
    private static ComputedMappingTable singleton;
    private Map<String, String[][]> mappingTable = new HashMap<String, String[][]>();
    static final long serialVersionUID = -8624485192912449934L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static ComputedMappingTable getInstance() {
        if (singleton == null) {
            singleton = new ComputedMappingTable();
        }
        return singleton;
    }

    private ComputedMappingTable() {
        String[][] cpuTable = new String[][]{{"cpu.processCpuUtilization", "cpu.processCpuUtilization.description", "GAUGE", "percent", "base", "cpu.processCpuTime", "cpu.availableProcessors"}};
        this.mappingTable.put("cpuStats", cpuTable);
        String[][] memoryTable = new String[][]{{"memory.heapUtilization", "memory.heapUtilization.description", "GAUGE", "percent", "base", "memory.usedHeap", "memory.maxHeap"}};
        this.mappingTable.put("memoryStats", memoryTable);
        String[][] gcTable = new String[][]{{"gc.time.per.cycle", "gc.time.per.cycle.description", "GAUGE", "seconds", "base", "gc.time", "gc.total"}};
        this.mappingTable.put("gcStats", gcTable);
        String[][] servletTable = new String[][]{{"servlet.request.elapsedTime.per.request", "servlet.request.elapsedTime.per.request.description", "GAUGE", "seconds", "vendor", "servlet.responseTime.total", "servlet.request.total"}};
        this.mappingTable.put("ServletStats", servletTable);
        String[][] connectionPoolTable = new String[][]{{"connectionpool.inUseTime.per.usedConnection", "connectionpool.inUseTime.per.usedConnection.description", "GAUGE", "seconds", "vendor", "connectionpool.inUseTime.total", "connectionpool.usedConnections.total"}, {"connectionpool.waitTime.per.queuedRequest", "connectionpool.waitTime.per.queuedRequest.description", "GAUGE", "seconds", "vendor", "connectionpool.waitTime.total", "connectionpool.queuedRequests.total"}};
        this.mappingTable.put("ConnectionPoolStats", connectionPoolTable);
        String[][] restTable = new String[][]{{"REST.request.elapsedTime.per.request", "REST.request.elapsedTime.per.request.description", "GAUGE", "seconds", "vendor", "REST.request.seconds.sum", "REST.request.seconds.count"}};
        this.mappingTable.put("RESTStats", restTable);
    }

    public List<String> getMetricGroupsList(String metricScope) {
        ArrayList<String> metricGroupList = new ArrayList<String>();
        for (Map.Entry<String, String[][]> entry : this.mappingTable.entrySet()) {
            String[][] data;
            for (String[] metricData : data = entry.getValue()) {
                if (!metricData[4].equals(metricScope)) continue;
                metricGroupList.add(entry.getKey());
            }
        }
        return metricGroupList;
    }

    public String[][] getData(String metricGroup) {
        String group = metricGroup.contains(",") ? this.getType(metricGroup) : metricGroup;
        for (String k : this.mappingTable.keySet()) {
            if (!group.contains(k)) continue;
            return this.mappingTable.get(k);
        }
        return null;
    }

    private String getType(String objectName) {
        for (String subString : objectName.split(",")) {
            if (!(subString = subString.trim()).contains("type=")) continue;
            return subString.split("=")[1];
        }
        return "notype";
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"io.openliberty.microprofile.metrics.internal.monitor.computed.internal.ComputedMappingTable", ComputedMappingTable.class, (String)"METRICS", (String)"com.ibm.ws.microprofile.metrics.resources.Metrics");
        singleton = null;
    }
}

