/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.injection;

import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.event.ObserverException;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.EventMetadata;
import java.lang.reflect.Modifier;
import java.util.List;
import org.jboss.weld.bean.builtin.BeanManagerProxy;
import org.jboss.weld.bean.proxy.CombinedInterceptorAndDecoratorStackMethodHandler;
import org.jboss.weld.bean.proxy.InterceptionDecorationContext;
import org.jboss.weld.bean.proxy.MethodHandler;
import org.jboss.weld.bean.proxy.ProxyObject;
import org.jboss.weld.event.CurrentEventMetadata;
import org.jboss.weld.injection.MethodInjectionPoint;
import org.jboss.weld.injection.ParameterInjectionPoint;
import org.jboss.weld.manager.BeanManagerImpl;

public abstract class MethodInvocationStrategy {
    private static final MethodInvocationStrategy DISPOSER_DEFAULT_STRATEGY = new DefaultMethodInvocationStrategy(IllegalArgumentException.class);
    private static final MethodInvocationStrategy DISPOSER_SIMPLE_STRATEGY = new SimpleMethodInvocationStrategy(IllegalArgumentException.class);
    private static final MethodInvocationStrategy OBSERVER_DEFAULT_STRATEGY = new DefaultMethodInvocationStrategy(ObserverException.class);
    private static final MethodInvocationStrategy OBSERVER_SIMPLE_STRATEGY = new SimpleMethodInvocationStrategy(ObserverException.class);
    private static final MethodInvocationStrategy OBSERVER_EVENT_PLUS_BEAN_MANAGER_STRATEGY = new SpecialParamPlusBeanManagerStrategy(ObserverException.class);
    protected final Class<? extends RuntimeException> exceptionTypeToThrow;

    MethodInvocationStrategy(Class<? extends RuntimeException> exceptionTypeToThrow) {
        this.exceptionTypeToThrow = exceptionTypeToThrow;
    }

    MethodInvocationStrategy() {
        this.exceptionTypeToThrow = null;
    }

    public static MethodInvocationStrategy forDisposer(MethodInjectionPoint<?, ?> method, BeanManagerImpl manager) {
        List parameters = method.getParameterInjectionPoints();
        if (parameters.size() == 1 && ((ParameterInjectionPoint)parameters.get(0)).getAnnotated().isAnnotationPresent(Observes.class)) {
            return DISPOSER_SIMPLE_STRATEGY;
        }
        return DISPOSER_DEFAULT_STRATEGY;
    }

    public static MethodInvocationStrategy forObserver(MethodInjectionPoint<?, ?> method, BeanManagerImpl manager) {
        List parameters = method.getParameterInjectionPoints();
        if (parameters.size() == 1 && ((ParameterInjectionPoint)parameters.get(0)).getAnnotated().isAnnotationPresent(Observes.class)) {
            return OBSERVER_SIMPLE_STRATEGY;
        }
        if (parameters.size() == 2 && ((ParameterInjectionPoint)parameters.get(0)).getAnnotated().isAnnotationPresent(Observes.class)) {
            if (BeanManager.class.equals((Object)((ParameterInjectionPoint)parameters.get(1)).getType())) {
                return OBSERVER_EVENT_PLUS_BEAN_MANAGER_STRATEGY;
            }
            if (EventMetadata.class.equals((Object)((ParameterInjectionPoint)parameters.get(1)).getType())) {
                return new EventPlusMetadataStrategy(manager);
            }
        }
        return OBSERVER_DEFAULT_STRATEGY;
    }

    public abstract <T> void invoke(Object var1, MethodInjectionPoint<?, ?> var2, T var3, BeanManagerImpl var4, CreationalContext<?> var5);

    protected boolean startInterceptionContextIfNeeded(Object receiver, MethodInjectionPoint<?, ?> method) {
        ProxyObject proxy;
        MethodHandler methodHandler;
        if (Modifier.isFinal(method.getMember().getModifiers()) && receiver instanceof ProxyObject && (methodHandler = (proxy = (ProxyObject)receiver).weld_getHandler()) instanceof CombinedInterceptorAndDecoratorStackMethodHandler) {
            InterceptionDecorationContext.startIfNotOnTop((CombinedInterceptorAndDecoratorStackMethodHandler)methodHandler);
            return true;
        }
        return false;
    }

    protected void endInterceptionContext() {
        InterceptionDecorationContext.endInterceptorContext();
    }

    private static class EventPlusMetadataStrategy
    extends MethodInvocationStrategy {
        private final CurrentEventMetadata metadata;

        private EventPlusMetadataStrategy(BeanManagerImpl manager) {
            this.metadata = manager.getServices().get(CurrentEventMetadata.class);
        }

        @Override
        public <T> void invoke(Object receiver, MethodInjectionPoint<?, ?> method, T instance, BeanManagerImpl manager, CreationalContext<?> creationalContext) {
            boolean interceptionContextStarted = this.startInterceptionContextIfNeeded(receiver, method);
            method.invoke(receiver, new Object[]{instance, this.metadata.peek()}, ObserverException.class);
            if (interceptionContextStarted) {
                this.endInterceptionContext();
            }
        }
    }

    private static class SpecialParamPlusBeanManagerStrategy
    extends MethodInvocationStrategy {
        public SpecialParamPlusBeanManagerStrategy(Class<? extends RuntimeException> exceptionTypeToThrow) {
            super(exceptionTypeToThrow);
        }

        @Override
        public <T> void invoke(Object receiver, MethodInjectionPoint<?, ?> method, T instance, BeanManagerImpl manager, CreationalContext<?> creationalContext) {
            boolean interceptionContextStarted = this.startInterceptionContextIfNeeded(receiver, method);
            method.invoke(receiver, new Object[]{instance, new BeanManagerProxy(manager)}, this.exceptionTypeToThrow);
            if (interceptionContextStarted) {
                this.endInterceptionContext();
            }
        }
    }

    private static class SimpleMethodInvocationStrategy
    extends MethodInvocationStrategy {
        public SimpleMethodInvocationStrategy(Class<? extends RuntimeException> exceptionTypeToThrow) {
            super(exceptionTypeToThrow);
        }

        @Override
        public <T> void invoke(Object receiver, MethodInjectionPoint<?, ?> method, T instance, BeanManagerImpl manager, CreationalContext<?> creationalContext) {
            boolean interceptionContextStarted = this.startInterceptionContextIfNeeded(receiver, method);
            method.invoke(receiver, instance, manager, creationalContext, this.exceptionTypeToThrow);
            if (interceptionContextStarted) {
                this.endInterceptionContext();
            }
        }
    }

    private static class DefaultMethodInvocationStrategy
    extends MethodInvocationStrategy {
        public DefaultMethodInvocationStrategy(Class<? extends RuntimeException> exceptionTypeToThrow) {
            super(exceptionTypeToThrow);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> void invoke(Object receiver, MethodInjectionPoint<?, ?> method, T instance, BeanManagerImpl manager, CreationalContext<?> creationalContext) {
            boolean release;
            boolean bl = release = creationalContext == null;
            if (release) {
                creationalContext = manager.createCreationalContext((Contextual)null);
            }
            try {
                boolean interceptionContextStarted = this.startInterceptionContextIfNeeded(receiver, method);
                method.invoke(receiver, instance, manager, creationalContext, this.exceptionTypeToThrow);
                if (interceptionContextStarted) {
                    this.endInterceptionContext();
                }
            }
            finally {
                if (release) {
                    creationalContext.release();
                }
            }
        }
    }
}

