/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.recoverylog.spi;

import com.ibm.tx.config.ConfigurationProvider;
import com.ibm.tx.config.ConfigurationProviderManager;
import com.ibm.tx.util.Utils;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.recoverylog.spi.LeaseInfo;
import com.ibm.ws.recoverylog.spi.LeaseLogImpl;
import com.ibm.ws.recoverylog.spi.PeerLeaseData;
import com.ibm.ws.recoverylog.spi.PeerLeaseTable;
import com.ibm.ws.recoverylog.spi.SharedServerLeaseLog;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.time.Instant;
import java.util.stream.Stream;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class FileSharedServerLeaseLog
extends LeaseLogImpl
implements SharedServerLeaseLog {
    static Path _tranRecoveryLogDirStem;
    static String _localRecoveryIdentity;
    static Path _leaseLogDirectory;
    static String _recoveryGroup;
    static Path _serverInstallLeaseLogDir;
    boolean leaseLogWrittenInThisRun;
    static Path _controlFile;
    private int _leaseTimeout;
    private LeaseLock _peerLeaseLock;
    private LeaseLock _localLeaseLock;
    private static final FileSharedServerLeaseLog _fileLeaseLog;
    private static final TraceComponent tc;
    static final long serialVersionUID = 4933668169491323603L;

    private FileSharedServerLeaseLog() {
    }

    @ManualTrace
    public static FileSharedServerLeaseLog getFileSharedServerLeaseLog(Path logDirStem, String localRecoveryIdentity, String recoveryGroup) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getFileSharedServerLeaseLog", (Object[])new Object[]{logDirStem, localRecoveryIdentity, recoveryGroup});
        }
        if (_serverInstallLeaseLogDir == null) {
            FileSharedServerLeaseLog.setLeaseLog(logDirStem, localRecoveryIdentity, recoveryGroup);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getFileSharedServerLeaseLog", (Object)_fileLeaseLog);
        }
        return _fileLeaseLog;
    }

    @ManualTrace
    private static void setLeaseLog(Path logDirStem, String localRecoveryIdentity, String recoveryGroup) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setLeaseLog", (Object[])new Object[]{logDirStem, localRecoveryIdentity, recoveryGroup});
        }
        if (recoveryGroup == null) {
            recoveryGroup = "defaultGroup";
        }
        _recoveryGroup = recoveryGroup;
        Path leasesDir = logDirStem.getParent();
        ConfigurationProvider cp = ConfigurationProviderManager.getConfigurationProvider();
        Path wlpUserDir = Paths.get(cp.getUserDir(), new String[0]);
        Path serverOutputDir = wlpUserDir.resolve(Paths.get("servers", cp.getServerName()));
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"leasesDirCanonicalPath: {0}\nserverOutputDir: {1}\nwlpUserDir: {2}", (Object[])new Object[]{leasesDir, serverOutputDir, wlpUserDir});
        }
        _serverInstallLeaseLogDir = leasesDir.equals(serverOutputDir) || localRecoveryIdentity == null || localRecoveryIdentity.trim().isEmpty() ? wlpUserDir.resolve(Paths.get("shared", "leases", recoveryGroup)) : leasesDir.resolve(Paths.get("leases", recoveryGroup));
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("_serverInstallLeaseLogDir: " + _serverInstallLeaseLogDir.toString()), (Object[])new Object[0]);
        }
        _tranRecoveryLogDirStem = logDirStem;
        if (_leaseLogDirectory == null) {
            _leaseLogDirectory = _serverInstallLeaseLogDir;
            AccessController.doPrivileged(new PrivilegedAction<Void>(){
                static final long serialVersionUID = 3085797037830036996L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                /*
                 * WARNING - void declaration
                 */
                @Override
                public Void run() {
                    try {
                        if (!Files.isDirectory(_leaseLogDirectory, new LinkOption[0])) {
                            Files.createDirectories(_leaseLogDirectory, new FileAttribute[0]);
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"Created: {0}", (Object[])new Object[]{_leaseLogDirectory});
                            }
                        }
                        if (!Files.exists(_controlFile = FileSystems.getDefault().getPath(_serverInstallLeaseLogDir.toString(), "control"), new LinkOption[0])) {
                            Files.createFile(_controlFile, new FileAttribute[0]);
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"Created: {0}", (Object[])new Object[]{_controlFile});
                            }
                        }
                    }
                    catch (IOException iOException) {
                        void e;
                        FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.recoverylog.spi.FileSharedServerLeaseLog$1", (String)"184", (Object)this, (Object[])new Object[0]);
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.recoverylog.spi.FileSharedServerLeaseLog.setLeaseLog", (String)"191");
                    }
                    return null;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.recoverylog.spi.FileSharedServerLeaseLog$1", 1.class, null, null);
                }
            });
        }
        _localRecoveryIdentity = localRecoveryIdentity;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setLeaseLog");
        }
    }

    @Override
    @ManualTrace
    public void updateServerLease(String recoveryIdentity, String recoveryGroup, boolean isServerStartup) throws Exception {
        block12: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"updateServerLease", (Object[])new Object[]{recoveryIdentity, recoveryGroup, isServerStartup, _tranRecoveryLogDirStem, this});
            }
            try {
                if (recoveryIdentity.equals(_localRecoveryIdentity)) {
                    block13: {
                        if (this._localLeaseLock == null) break block12;
                        if (!this.leaseLogWrittenInThisRun) {
                            try {
                                String line;
                                ByteBuffer byteBuffer = null;
                                FileChannel fChannel = this._localLeaseLock.getFileChannel();
                                if (tc.isDebugEnabled()) {
                                    byteBuffer = ByteBuffer.allocate((int)fChannel.size());
                                    fChannel.position(0L);
                                    fChannel.read(byteBuffer);
                                    byteBuffer.flip();
                                    line = new String(byteBuffer.array());
                                    Tr.debug((TraceComponent)tc, (String)"Originally {0} lease file length {1} contains {2}", (Object[])new Object[]{recoveryIdentity, line.length(), line});
                                }
                                byteBuffer = ByteBuffer.wrap(_tranRecoveryLogDirStem.toString().getBytes());
                                fChannel.position(0L);
                                fChannel.write(byteBuffer);
                                byteBuffer = ByteBuffer.wrap(("\n" + this.getBackendURL()).getBytes());
                                fChannel.write(byteBuffer);
                                fChannel.force(false);
                                this.leaseLogWrittenInThisRun = true;
                                if (tc.isDebugEnabled()) {
                                    byteBuffer = ByteBuffer.allocate((int)fChannel.size());
                                    fChannel.position(0L);
                                    fChannel.read(byteBuffer);
                                    byteBuffer.flip();
                                    line = new String(byteBuffer.array());
                                    Tr.debug((TraceComponent)tc, (String)"On writing {0} lease file length {1} contains {2}", (Object[])new Object[]{recoveryIdentity, line.length(), line});
                                }
                            }
                            catch (IOException byteBuffer) {
                                FFDCFilter.processException((Throwable)byteBuffer, (String)"com.ibm.ws.recoverylog.spi.FileSharedServerLeaseLog", (String)"243", (Object)this, (Object[])new Object[]{recoveryIdentity, recoveryGroup, isServerStartup});
                                if (!tc.isDebugEnabled()) break block13;
                                Tr.debug((TraceComponent)tc, (String)"Caught I/O exception when trying to write to file", (Object[])new Object[0]);
                            }
                        }
                    }
                    Path leaseFile = this._localLeaseLock.getFile();
                    if (this.leaseLogWrittenInThisRun) {
                        Files.setLastModifiedTime(leaseFile, FileTime.from(Instant.now()));
                    }
                    break block12;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Don't modify time as this is not the local server", (Object[])new Object[0]);
                }
            }
            catch (OverlappingFileLockException leaseFile) {
                FFDCFilter.processException((Throwable)leaseFile, (String)"com.ibm.ws.recoverylog.spi.FileSharedServerLeaseLog", (String)"259", (Object)this, (Object[])new Object[]{recoveryIdentity, recoveryGroup, isServerStartup});
                if (!tc.isDebugEnabled()) break block12;
                Tr.debug((TraceComponent)tc, (String)"{0} already appears to be locked in another thread", (Object[])new Object[]{this._localLeaseLock.getFile()});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"updateServerLease");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - void declaration
     */
    @Override
    @ManualTrace
    @FFDCIgnore(value={NoSuchFileException.class, Throwable.class})
    public void deleteServerLease(String recoveryIdentity, boolean isPeerServer) throws Exception {
        block85: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"deleteServerLease", (Object[])new Object[]{this, recoveryIdentity, isPeerServer});
            }
            Path leaseFile = _serverInstallLeaseLogDir.resolve(recoveryIdentity);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Block until we acquire the lock on the control file", (Object[])new Object[0]);
            }
            try (FileChannel theChannel = new RandomAccessFile(_controlFile.toFile(), "rw").getChannel();
                 FileLock lock = theChannel.lock();){
                PeerLeaseData pld;
                boolean attemptDelete = true;
                if (!recoveryIdentity.equals(_localRecoveryIdentity) && !(pld = new PeerLeaseData(recoveryIdentity, Files.getLastModifiedTime(leaseFile, new LinkOption[0]), this._leaseTimeout)).isExpired()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"The lease file has not expired, do not attempt deletion", (Object[])new Object[0]);
                    }
                    attemptDelete = false;
                }
                if (attemptDelete) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Prepare to delete file {0}", (Object[])new Object[]{leaseFile});
                    }
                    Files.deleteIfExists(leaseFile);
                }
            }
            try (Stream<Path> files = Files.list(_serverInstallLeaseLogDir);){
                long fileCount = files.peek(p -> {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Lease directory contents: ", (Object[])new Object[]{p});
                    }
                }).count();
                if (fileCount == 1L && Files.exists(_controlFile, new LinkOption[0])) {
                    try {
                        Files.delete(_controlFile);
                        Files.delete(_serverInstallLeaseLogDir);
                    }
                    catch (IOException pld) {
                        FFDCFilter.processException((Throwable)pld, (String)"com.ibm.ws.recoverylog.spi.FileSharedServerLeaseLog", (String)"325", (Object)this, (Object[])new Object[]{recoveryIdentity, isPeerServer});
                        if (tc.isDebugEnabled()) {
                            void e2;
                            Tr.debug((TraceComponent)tc, (String)"Couldn't delete remaining files in {0}: {1}", (Object[])new Object[]{_serverInstallLeaseLogDir, e2});
                        }
                    }
                }
                break block85;
            }
            catch (FileNotFoundException | NoSuchFileException e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"{0} is already deleted", (Object[])new Object[]{_serverInstallLeaseLogDir});
                }
                break block85;
            }
            catch (IOException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.recoverylog.spi.FileSharedServerLeaseLog", (String)"334", (Object)this, (Object[])new Object[]{recoveryIdentity, isPeerServer});
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Error deleting in {0}: {1}", (Object[])new Object[]{_serverInstallLeaseLogDir, e});
                }
                break block85;
            }
            catch (FileNotFoundException | NoSuchFileException e) {
                block86: {
                    if (!tc.isDebugEnabled()) break block86;
                    Tr.debug((TraceComponent)tc, (String)"{0} is already deleted", (Object[])new Object[]{_serverInstallLeaseLogDir});
                }
                try (Stream<Path> files = Files.list(_serverInstallLeaseLogDir);){
                    long fileCount = files.peek(p -> {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Lease directory contents: ", (Object[])new Object[]{p});
                        }
                    }).count();
                    if (fileCount == 1L && Files.exists(_controlFile, new LinkOption[0])) {
                        try {
                            Files.delete(_controlFile);
                            Files.delete(_serverInstallLeaseLogDir);
                        }
                        catch (IOException e2) {
                            FFDCFilter.processException((Throwable)e2, (String)"com.ibm.ws.recoverylog.spi.FileSharedServerLeaseLog", (String)"325", (Object)this, (Object[])new Object[]{recoveryIdentity, isPeerServer});
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"Couldn't delete remaining files in {0}: {1}", (Object[])new Object[]{_serverInstallLeaseLogDir, e2});
                            }
                        }
                    }
                }
                catch (FileNotFoundException | NoSuchFileException e3) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"{0} is already deleted", (Object[])new Object[]{_serverInstallLeaseLogDir});
                    }
                    break block85;
                }
                catch (IOException e3) {
                    FFDCFilter.processException((Throwable)e3, (String)"com.ibm.ws.recoverylog.spi.FileSharedServerLeaseLog", (String)"334", (Object)this, (Object[])new Object[]{recoveryIdentity, isPeerServer});
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Error deleting in {0}: {1}", (Object[])new Object[]{_serverInstallLeaseLogDir, e3});
                    }
                    break block85;
                }
            }
            catch (IOException e2) {
                block87: {
                    FFDCFilter.processException((Throwable)e2, (String)"com.ibm.ws.recoverylog.spi.FileSharedServerLeaseLog", (String)"310", (Object)this, (Object[])new Object[]{recoveryIdentity, isPeerServer});
                    if (!tc.isDebugEnabled()) break block87;
                    Tr.debug((TraceComponent)tc, (String)"Exception locking lease control file: ", (Object[])new Object[]{e2});
                    {
                        catch (Throwable throwable) {
                            block88: {
                                try (Stream<Path> files = Files.list(_serverInstallLeaseLogDir);){
                                    long fileCount = files.peek(p -> {
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug((TraceComponent)tc, (String)"Lease directory contents: ", (Object[])new Object[]{p});
                                        }
                                    }).count();
                                    if (fileCount == 1L && Files.exists(_controlFile, new LinkOption[0])) {
                                        try {
                                            Files.delete(_controlFile);
                                            Files.delete(_serverInstallLeaseLogDir);
                                        }
                                        catch (IOException iOException) {
                                            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.recoverylog.spi.FileSharedServerLeaseLog", (String)"325", (Object)this, (Object[])new Object[]{recoveryIdentity, isPeerServer});
                                            if (tc.isDebugEnabled()) {
                                                void e4;
                                                Tr.debug((TraceComponent)tc, (String)"Couldn't delete remaining files in {0}: {1}", (Object[])new Object[]{_serverInstallLeaseLogDir, e4});
                                            }
                                        }
                                    }
                                }
                                catch (FileNotFoundException | NoSuchFileException e5) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug((TraceComponent)tc, (String)"{0} is already deleted", (Object[])new Object[]{_serverInstallLeaseLogDir});
                                    }
                                }
                                catch (IOException e5) {
                                    FFDCFilter.processException((Throwable)e5, (String)"com.ibm.ws.recoverylog.spi.FileSharedServerLeaseLog", (String)"334", (Object)this, (Object[])new Object[]{recoveryIdentity, isPeerServer});
                                    if (!tc.isDebugEnabled()) break block88;
                                    Tr.debug((TraceComponent)tc, (String)"Error deleting in {0}: {1}", (Object[])new Object[]{_serverInstallLeaseLogDir, e5});
                                }
                            }
                            throw throwable;
                        }
                    }
                }
                try (Stream<Path> files = Files.list(_serverInstallLeaseLogDir);){
                    long fileCount = files.peek(p -> {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Lease directory contents: ", (Object[])new Object[]{p});
                        }
                    }).count();
                    if (fileCount == 1L && Files.exists(_controlFile, new LinkOption[0])) {
                        try {
                            Files.delete(_controlFile);
                            Files.delete(_serverInstallLeaseLogDir);
                        }
                        catch (IOException e6) {
                            FFDCFilter.processException((Throwable)e6, (String)"com.ibm.ws.recoverylog.spi.FileSharedServerLeaseLog", (String)"325", (Object)this, (Object[])new Object[]{recoveryIdentity, isPeerServer});
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"Couldn't delete remaining files in {0}: {1}", (Object[])new Object[]{_serverInstallLeaseLogDir, e6});
                            }
                        }
                    }
                }
                catch (FileNotFoundException | NoSuchFileException e7) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"{0} is already deleted", (Object[])new Object[]{_serverInstallLeaseLogDir});
                    }
                }
                catch (IOException e7) {
                    FFDCFilter.processException((Throwable)e7, (String)"com.ibm.ws.recoverylog.spi.FileSharedServerLeaseLog", (String)"334", (Object)this, (Object[])new Object[]{recoveryIdentity, isPeerServer});
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Error deleting in {0}: {1}", (Object[])new Object[]{_serverInstallLeaseLogDir, e7});
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"deleteServerLease", (Object)this);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @ManualTrace
    public boolean claimPeerLeaseForRecovery(String recoveryIdentityToRecover, String myRecoveryIdentity, LeaseInfo leaseInfo) throws Exception {
        boolean claimedLease;
        block22: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"claimPeerLeaseForRecovery", (Object[])new Object[]{recoveryIdentityToRecover, myRecoveryIdentity, this});
            }
            claimedLease = false;
            FileChannel fChannel = null;
            try {
                PeerLeaseData pld;
                boolean attemptClaim = true;
                final Path leaseFile = _serverInstallLeaseLogDir.resolve(recoveryIdentityToRecover);
                FileTime newleaseTime = AccessController.doPrivileged(new PrivilegedExceptionAction<FileTime>(){
                    static final long serialVersionUID = 942915722903378784L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    @Override
                    public FileTime run() throws IOException {
                        return Files.getLastModifiedTime(leaseFile, new LinkOption[0]);
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register((String)"com.ibm.ws.recoverylog.spi.FileSharedServerLeaseLog$2", 2.class, null, null);
                    }
                });
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"recoveryId: {0}, new leaseTime: {1}", (Object[])new Object[]{recoveryIdentityToRecover, Utils.traceTime((FileTime)newleaseTime)});
                }
                if (!(pld = new PeerLeaseData(recoveryIdentityToRecover, newleaseTime, this._leaseTimeout)).isExpired()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"The lease file has not expired, or does not exist do not attempt recovery", (Object[])new Object[0]);
                    }
                    attemptClaim = false;
                }
                if (attemptClaim) {
                    if (this.lockPeerLease(recoveryIdentityToRecover)) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Attempt to read lease file", (Object[])new Object[0]);
                        }
                        if ((fChannel = this._peerLeaseLock.getFileChannel()) != null) {
                            int newline;
                            long fileSize = fChannel.size();
                            ByteBuffer buffer = ByteBuffer.allocate((int)fileSize);
                            fChannel.read(buffer);
                            buffer.flip();
                            String line = new String(buffer.array());
                            if (tc.isDebugEnabled()) {
                                Tr.info((TraceComponent)tc, (String)("On reading " + recoveryIdentityToRecover + " lease file length " + line.length() + " contains " + line), (Object[])new Object[0]);
                            }
                            if ((newline = line.indexOf("\n")) > 0) {
                                line = line.substring(0, newline);
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("String is now " + line + " of length " + line.length()), (Object[])new Object[0]);
                            }
                            leaseInfo.setLeaseDetail(new File(line));
                            ByteBuffer myBackendURL = null;
                            long filePos = 0L;
                            if (newline > 0) {
                                fChannel.truncate(newline + 1);
                                myBackendURL = ByteBuffer.wrap(this.getBackendURL().getBytes());
                                filePos = newline + 1;
                            } else {
                                myBackendURL = ByteBuffer.wrap(("\n" + this.getBackendURL()).getBytes());
                                filePos = fileSize;
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"Write in our own backendURL {0} from file position {1}", (Object[])new Object[]{myBackendURL, filePos});
                            }
                            fChannel.write(myBackendURL, filePos);
                            fChannel.force(false);
                            if (tc.isDebugEnabled()) {
                                buffer = ByteBuffer.allocate((int)fChannel.size());
                                fChannel.position(0L);
                                fChannel.read(buffer);
                                buffer.flip();
                                line = new String(buffer.array());
                                Tr.info((TraceComponent)tc, (String)("On writing " + recoveryIdentityToRecover + " lease file length " + line.length() + " contains " + line), (Object[])new Object[0]);
                            }
                            claimedLease = true;
                        } else if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Lease Lock's channel was null", (Object[])new Object[0]);
                        }
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Failed to lock or read lease file", (Object[])new Object[0]);
                    }
                }
                Files.setLastModifiedTime(leaseFile, newleaseTime);
            }
            catch (IOException attemptClaim) {
                void e;
                FFDCFilter.processException((Throwable)attemptClaim, (String)"com.ibm.ws.recoverylog.spi.FileSharedServerLeaseLog", (String)"452", (Object)this, (Object[])new Object[]{recoveryIdentityToRecover, myRecoveryIdentity, leaseInfo});
                if (!tc.isDebugEnabled()) break block22;
                Tr.debug((TraceComponent)tc, (String)("Caught an IOException - " + e), (Object[])new Object[0]);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"claimPeerLeaseForRecovery", (Object)claimedLease);
        }
        return claimedLease;
    }

    @Override
    @ManualTrace
    public void getLeasesForPeers(final PeerLeaseTable peerLeaseTable, String recoveryGroup) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getLeasesForPeers", (Object[])new Object[]{peerLeaseTable, recoveryGroup, this});
        }
        AccessController.doPrivileged(new PrivilegedAction<Void>(){
            static final long serialVersionUID = -6776425850758784230L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public Void run() {
                try {
                    FileChannel theChannel = new RandomAccessFile(_controlFile.toFile(), "rw").getChannel();
                    try {
                        block15: {
                            FileLock lock = theChannel.tryLock();
                            try {
                                block14: {
                                    Stream<Path> files = Files.list(_leaseLogDirectory);
                                    try {
                                        files.filter(path -> !Files.isDirectory(path, new LinkOption[0])).filter(path -> 0 != path.compareTo(_controlFile)).filter(path -> !path.getFileName().toString().equals(_localRecoveryIdentity)).forEach(peer -> {
                                            block2: {
                                                try {
                                                    peerLeaseTable.addPeerEntry(new PeerLeaseData(peer.getFileName().toString(), Files.getLastModifiedTime(peer, new LinkOption[0]), FileSharedServerLeaseLog.this._leaseTimeout));
                                                }
                                                catch (IOException e) {
                                                    if (!tc.isDebugEnabled()) break block2;
                                                    Tr.debug((TraceComponent)tc, (String)"Exception getting last modified time for {0}\n{1}", (Object[])new Object[]{peer, e});
                                                }
                                            }
                                        });
                                        if (files == null) break block14;
                                    }
                                    catch (Throwable throwable) {
                                        FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.recoverylog.spi.FileSharedServerLeaseLog$3", (String)"478", (Object)this, (Object[])new Object[0]);
                                        if (files == null) throw throwable;
                                        try {
                                            files.close();
                                            throw throwable;
                                        }
                                        catch (Throwable throwable2) {
                                            FFDCFilter.processException((Throwable)throwable2, (String)"com.ibm.ws.recoverylog.spi.FileSharedServerLeaseLog$3", (String)"478", (Object)this, (Object[])new Object[0]);
                                            throwable.addSuppressed(throwable2);
                                        }
                                        throw throwable;
                                    }
                                    files.close();
                                }
                                if (lock == null) break block15;
                            }
                            catch (Throwable throwable) {
                                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.recoverylog.spi.FileSharedServerLeaseLog$3", (String)"478", (Object)this, (Object[])new Object[0]);
                                if (lock == null) throw throwable;
                                try {
                                    lock.close();
                                    throw throwable;
                                }
                                catch (Throwable throwable3) {
                                    FFDCFilter.processException((Throwable)throwable3, (String)"com.ibm.ws.recoverylog.spi.FileSharedServerLeaseLog$3", (String)"478", (Object)this, (Object[])new Object[0]);
                                    throwable.addSuppressed(throwable3);
                                }
                                throw throwable;
                            }
                            lock.close();
                        }
                        if (theChannel == null) return null;
                    }
                    catch (Throwable throwable) {
                        FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.recoverylog.spi.FileSharedServerLeaseLog$3", (String)"478", (Object)this, (Object[])new Object[0]);
                        if (theChannel == null) throw throwable;
                        try {
                            theChannel.close();
                            throw throwable;
                        }
                        catch (Throwable throwable4) {
                            FFDCFilter.processException((Throwable)throwable4, (String)"com.ibm.ws.recoverylog.spi.FileSharedServerLeaseLog$3", (String)"478", (Object)this, (Object[])new Object[0]);
                            throwable.addSuppressed(throwable4);
                        }
                        throw throwable;
                    }
                    theChannel.close();
                    return null;
                }
                catch (Exception theChannel) {
                    void e;
                    FFDCFilter.processException((Throwable)theChannel, (String)"com.ibm.ws.recoverylog.spi.FileSharedServerLeaseLog$3", (String)"487", (Object)this, (Object[])new Object[0]);
                    if (!tc.isDebugEnabled()) return null;
                    Tr.debug((TraceComponent)tc, (String)"Exception locking lease control file: ", (Object[])new Object[]{e});
                }
                return null;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.recoverylog.spi.FileSharedServerLeaseLog$3", 3.class, null, null);
            }
        });
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getLeasesForPeers", (Object)this);
        }
    }

    @Override
    public boolean lockPeerLease(String recoveryIdentity) {
        Path leaseFile = _serverInstallLeaseLogDir.resolve(recoveryIdentity);
        if (!Files.exists(leaseFile, new LinkOption[0])) {
            return false;
        }
        this._peerLeaseLock = this.lock(leaseFile);
        return this._peerLeaseLock != null;
    }

    /*
     * WARNING - void declaration
     */
    @FFDCIgnore(value={OverlappingFileLockException.class})
    private LeaseLock lock(Path leaseFile) {
        block12: {
            FileChannel fChannel;
            block11: {
                fChannel = null;
                try {
                    fChannel = new RandomAccessFile(leaseFile.toFile(), "rw").getChannel();
                }
                catch (IOException iOException) {
                    void e;
                    FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.recoverylog.spi.FileSharedServerLeaseLog", (String)"538", (Object)this, (Object[])new Object[]{leaseFile});
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.recoverylog.spi.FileSharedServerLeaseLog.setLeaseLog", (String)"603");
                }
                try {
                    FileLock fLock;
                    if (fChannel != null && (fLock = fChannel.tryLock()) != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"We have claimed the lock for {0}", (Object[])new Object[]{leaseFile});
                        }
                        return new LeaseLock(fLock, fChannel, leaseFile);
                    }
                }
                catch (OverlappingFileLockException e) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"{0} appears to be locked in another thread", (Object[])new Object[]{leaseFile});
                    }
                }
                catch (IOException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.recoverylog.spi.FileSharedServerLeaseLog", (String)"558", (Object)this, (Object[])new Object[]{leaseFile});
                    if (!tc.isDebugEnabled()) break block11;
                    Tr.debug((TraceComponent)tc, (String)"Caught an IOException", (Object[])new Object[]{e});
                }
            }
            if (fChannel != null) {
                try {
                    fChannel.close();
                }
                catch (IOException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.recoverylog.spi.FileSharedServerLeaseLog", (String)"567", (Object)this, (Object[])new Object[]{leaseFile});
                    if (!tc.isDebugEnabled()) break block12;
                    Tr.debug((TraceComponent)tc, (String)"Caught an IOException on channel close", (Object[])new Object[]{e});
                }
            }
        }
        return null;
    }

    @Override
    public void releasePeerLease(String recoveryIdentity) throws Exception {
        if (this._peerLeaseLock != null) {
            this._peerLeaseLock.release();
            this._peerLeaseLock = null;
        }
    }

    @Override
    public boolean lockLocalLease(String recoveryIdentity) {
        Path leaseFile = _serverInstallLeaseLogDir.resolve(recoveryIdentity);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Attempting to lock {0}", (Object[])new Object[]{leaseFile});
        }
        this._localLeaseLock = this.lock(leaseFile);
        return this._localLeaseLock != null;
    }

    @Override
    public void releaseLocalLease(String recoveryIdentity) throws Exception {
        if (this._localLeaseLock != null) {
            this._localLeaseLock.release();
            this._localLeaseLock = null;
        }
    }

    @Override
    @ManualTrace
    public void setPeerRecoveryLeaseTimeout(int leaseTimeout) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setPeerRecoveryLeaseTimeout", (Object[])new Object[]{leaseTimeout});
        }
        this._leaseTimeout = leaseTimeout;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setPeerRecoveryLeaseTimeout", (Object)this);
        }
    }

    @Override
    @ManualTrace
    @FFDCIgnore(value={FileNotFoundException.class, IOException.class, Throwable.class})
    public String getBackendURL(String recoveryId) {
        String filename = _serverInstallLeaseLogDir + File.separator + recoveryId;
        String ret = null;
        int retries = 0;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getBackendURL", (Object[])new Object[]{filename});
        }
        while (true) {
            String string;
            BufferedReader reader = new BufferedReader(new FileReader(filename));
            try {
                reader.readLine();
                ret = reader.readLine();
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"getBackendURL", (Object)ret);
                }
                string = ret;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (FileNotFoundException e) {
                    if (!tc.isDebugEnabled()) break;
                    Tr.debug((TraceComponent)tc, (String)"getBackendURL: Lease file not found. Recovery is probably done.", (Object[])new Object[0]);
                    break;
                }
                catch (IOException e) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"getBackendURL: Lease was probably being renewed. Wait 500ms and try again.", (Object[])new Object[]{e});
                    }
                    if (retries++ > 60) {
                        if (!tc.isDebugEnabled()) break;
                        Tr.debug((TraceComponent)tc, (String)"getBackendURL: Couldn't access lease file even after retrying.", (Object[])new Object[0]);
                        break;
                    }
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.recoverylog.spi.FileSharedServerLeaseLog", (String)"716", (Object)this, (Object[])new Object[]{recoveryId});
                    }
                    continue;
                }
            }
            reader.close();
            return string;
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getBackendURL", ret);
        }
        return ret;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        _fileLeaseLog = new FileSharedServerLeaseLog();
        tc = Tr.register(FileSharedServerLeaseLog.class, (String)"Transaction", (String)"com.ibm.ws.recoverylog.resources.RecoveryLogMsgs");
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private class LeaseLock {
        private final FileLock _leaseFileLock;
        private final FileChannel _leaseChannel;
        private final Path _leaseFile;
        static final long serialVersionUID = 509180146002585474L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @ManualTrace
        public LeaseLock(FileLock fLock, FileChannel fChannel, Path leaseFile) {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"LeaseLock", (Object[])new Object[]{fLock, fChannel, leaseFile});
            }
            this._leaseFileLock = fLock;
            this._leaseChannel = fChannel;
            this._leaseFile = leaseFile;
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"LeaseLock", (Object)this);
            }
        }

        public void release() throws IOException {
            this._leaseFileLock.release();
            this._leaseChannel.close();
        }

        public FileLock getFileLock() {
            return this._leaseFileLock;
        }

        public Path getFile() {
            return this._leaseFile;
        }

        public FileChannel getFileChannel() {
            return this._leaseChannel;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.recoverylog.spi.FileSharedServerLeaseLog$LeaseLock", LeaseLock.class, null, null);
        }
    }
}

