/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.classloading.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.artifact.url.WSJarURLConnection;
import com.ibm.ws.classloading.ClassGenerator;
import com.ibm.ws.classloading.configuration.GlobalClassloadingConfiguration;
import com.ibm.ws.classloading.internal.ClassLoadingConstants;
import com.ibm.ws.classloading.internal.ContainerClassLoader;
import com.ibm.ws.classloading.internal.DeclaredApiAccess;
import com.ibm.ws.classloading.internal.GatewayClassLoader;
import com.ibm.ws.classloading.internal.LibertyLoader;
import com.ibm.ws.classloading.internal.NoClassNotFoundLoader;
import com.ibm.ws.classloading.internal.ShadowClassLoader;
import com.ibm.ws.classloading.internal.SpringLoader;
import com.ibm.ws.classloading.internal.Util;
import com.ibm.ws.classloading.internal.providers.Providers;
import com.ibm.ws.classloading.internal.util.ClassRedefiner;
import com.ibm.ws.classloading.internal.util.FeatureSuggestion;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.kernel.boot.classloader.ClassLoaderHook;
import com.ibm.ws.kernel.boot.classloader.ClassLoaderHookFactory;
import com.ibm.ws.kernel.boot.classloader.NameBasedClassLoaderLock;
import com.ibm.ws.kernel.security.thread.ThreadIdentityManager;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.classloading.ApiType;
import com.ibm.wsspi.classloading.ClassLoaderConfiguration;
import com.ibm.wsspi.classloading.ClassLoaderIdentity;
import com.ibm.wsspi.config.Fileset;
import com.ibm.wsspi.kernel.service.utils.CompositeEnumeration;
import com.ibm.wsspi.library.Library;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.osgi.framework.Bundle;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class AppClassLoader
extends ContainerClassLoader
implements SpringLoader {
    static final TraceComponent tc = Tr.register(AppClassLoader.class, (String)"ClassLoadingService", (String)"com.ibm.ws.classloading.internal.resources.ClassLoadingServiceMessages");
    private static final Set<String> forbiddenClassNames = Collections.unmodifiableSet(AppClassLoader.loadForbidden());
    private static final String FORBIDDEN_PROPERTIES = "forbidden.properties";
    public static final String NOTHING_FORBIDDEN_PROPERTY = "io.openliberty.classloading.nothing.forbidden";
    private static final boolean disableSharedClassesCache;
    static final List<SearchLocation> PARENT_FIRST_SEARCH_ORDER;
    private final Set<String> packagesDefined = Collections.newSetFromMap(new ConcurrentHashMap());
    static final String CLASS_LOADING_TRACE_PREFIX = "com.ibm.ws.class.load.";
    static final String DEFAULT_PACKAGE = "default.package";
    final ConcurrentMap<String, TraceComponent> perPackageClassLoadingTraceComponents = new ConcurrentHashMap<String, TraceComponent>();
    protected final ClassLoaderConfiguration config;
    private volatile List<Library> privateLibraries;
    private final Iterable<LibertyLoader> delegateLoaders;
    private final List<File> nativeLibraryFiles = new ArrayList<File>();
    private final List<ClassFileTransformer> transformers = new ArrayList<ClassFileTransformer>();
    private final List<ClassFileTransformer> systemTransformers;
    private final DeclaredApiAccess apiAccess;
    private final ClassGenerator generator;
    private final ConcurrentHashMap<String, ProtectionDomain> protectionDomains = new ConcurrentHashMap();
    private final ClassLoaderHook hook;
    static final long serialVersionUID = 5906478461061001036L;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Set<String> loadForbidden() {
        HashSet<String> forbidden;
        block8: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Loading forbidden.properties", (Object[])new Object[0]);
            }
            if (Boolean.getBoolean(NOTHING_FORBIDDEN_PROPERTY)) {
                return Collections.emptySet();
            }
            forbidden = new HashSet<String>();
            try {
                InputStream inputStream = AppClassLoader.class.getResourceAsStream(FORBIDDEN_PROPERTIES);
                try {
                    Properties props = new Properties();
                    props.load(inputStream);
                    Properties castProps = props;
                    forbidden.addAll(castProps.keySet());
                    if (inputStream == null) break block8;
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.classloading.internal.AppClassLoader", (String)"110", null, (Object[])new Object[0]);
                    if (inputStream == null) throw throwable;
                    try {
                        inputStream.close();
                        throw throwable;
                    }
                    catch (Throwable throwable2) {
                        FFDCFilter.processException((Throwable)throwable2, (String)"com.ibm.ws.classloading.internal.AppClassLoader", (String)"110", null, (Object[])new Object[0]);
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                inputStream.close();
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.classloading.internal.AppClassLoader", (String)"116", null, (Object[])new Object[0]);
            }
        }
        if (!TraceComponent.isAnyTracingEnabled()) return forbidden;
        if (!tc.isDebugEnabled()) return forbidden;
        Tr.debug((TraceComponent)tc, (String)("Loaded Forbidden Set" + forbidden), (Object[])new Object[0]);
        return forbidden;
    }

    private TraceComponent getClassLoadingTraceComponent(String pkg) {
        TraceComponent tc = (TraceComponent)this.perPackageClassLoadingTraceComponents.get(pkg);
        if (tc == null) {
            tc = Tr.register((String)(CLASS_LOADING_TRACE_PREFIX + pkg), AppClassLoader.class, (String)null);
            this.perPackageClassLoadingTraceComponents.put(pkg, tc);
        }
        return tc;
    }

    AppClassLoader(ClassLoader parent, ClassLoaderConfiguration config, List<Container> containers, DeclaredApiAccess access, ClassRedefiner redefiner, ClassGenerator generator, GlobalClassloadingConfiguration globalConfig, List<ClassFileTransformer> systemTransformers) {
        super(containers, parent, redefiner, globalConfig);
        this.systemTransformers = systemTransformers;
        this.config = config;
        this.apiAccess = access;
        for (Container container : config.getNativeLibraryContainers()) {
            this.addNativeLibraryContainer(container);
        }
        this.privateLibraries = Providers.getPrivateLibraries(config);
        this.delegateLoaders = Providers.getDelegateLoaders(config, this.apiAccess);
        this.generator = generator;
        this.hook = disableSharedClassesCache ? null : ClassLoaderHookFactory.getClassLoaderHook((ClassLoader)this);
    }

    Iterable<LibertyLoader> getDelegateLoaders() {
        return this.delegateLoaders;
    }

    Iterable<SearchLocation> getSearchOrder() {
        return PARENT_FIRST_SEARCH_ORDER;
    }

    @Override
    public boolean addTransformer(ClassFileTransformer cft) {
        this.transformers.add(cft);
        if (this.parent instanceof AppClassLoader) {
            if (Util.isGlobalSharedLibraryLoader((AppClassLoader)this.parent)) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"addTransformer - skipping parent loader because it is a GlobalSharedLibrary", (Object[])new Object[0]);
                }
            } else {
                return ((AppClassLoader)this.parent).addTransformer(cft);
            }
        }
        return true;
    }

    @Override
    public ClassLoader getThrowawayClassLoader() {
        return new ShadowClassLoader(this);
    }

    @Override
    public EnumSet<ApiType> getApiTypeVisibility() {
        return this.apiAccess.getApiTypeVisibility();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final URL findResource(String name) {
        URL result = null;
        Object token = ThreadIdentityManager.runAsServer();
        try {
            result = super.findResource(name);
            if (result == null) {
                result = this.findResourceCommonLibraryClassLoaders(name);
            }
        }
        finally {
            ThreadIdentityManager.reset((Object)token);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Trivial
    public CompositeEnumeration<URL> findResources(String name) throws IOException {
        Object token = ThreadIdentityManager.runAsServer();
        try {
            CompositeEnumeration enumerations = new CompositeEnumeration(super.findResources(name));
            CompositeEnumeration<URL> compositeEnumeration = this.findResourcesCommonLibraryClassLoaders(name, (CompositeEnumeration<URL>)enumerations);
            return compositeEnumeration;
        }
        finally {
            ThreadIdentityManager.reset((Object)token);
        }
    }

    @Override
    @Trivial
    public Enumeration<URL> getResources(String name) throws IOException {
        try {
            final String f_name = name;
            final ClassLoader f_parent = this.parent;
            Enumeration<URL> eURL = AccessController.doPrivileged(new PrivilegedExceptionAction<Enumeration<URL>>(){
                static final long serialVersionUID = 5468342255214973221L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Enumeration<URL> run() throws Exception {
                    return f_parent.getResources(f_name);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.classloading.internal.AppClassLoader$1", 1.class, (String)"ClassLoadingService", (String)"com.ibm.ws.classloading.internal.resources.ClassLoadingServiceMessages");
                }
            });
            return new CompositeEnumeration(eURL).add(this.findResources(name));
        }
        catch (PrivilegedActionException f_name) {
            FFDCFilter.processException((Throwable)f_name, (String)"com.ibm.ws.classloading.internal.AppClassLoader", (String)"292", (Object)this, (Object[])new Object[]{name});
            return null;
        }
    }

    @Override
    public Bundle getBundle() {
        return this.parent instanceof GatewayClassLoader ? ((GatewayClassLoader)this.parent).getBundle() : (this.parent instanceof LibertyLoader ? ((LibertyLoader)this.parent).getBundle() : null);
    }

    boolean removeTransformer(ClassFileTransformer transformer) {
        if (this.parent instanceof AppClassLoader) {
            ((AppClassLoader)this.parent).removeTransformer(transformer);
        }
        return this.transformers.remove(transformer);
    }

    @Override
    protected final Class<?> findClass(String name, boolean returnNull) throws ClassNotFoundException {
        String resourceName = Util.convertClassNameToResourceName(name);
        ContainerClassLoader.ByteResourceInformation byteResInfo = this.findClassBytes(name, resourceName);
        if (byteResInfo == null) {
            return this.findClassCommonLibraryClassLoaders(name, returnNull);
        }
        byte[] bytes = this.transformers.isEmpty() && this.systemTransformers.isEmpty() ? byteResInfo.getBytes() : this.transformClassBytes(name, byteResInfo);
        return this.definePackageAndClass(name, resourceName, byteResInfo, bytes);
    }

    byte[] transformClassBytes(String name, ContainerClassLoader.ByteResourceInformation toTransform) throws ClassNotFoundException {
        byte[] originalBytes;
        boolean fromSCC = toTransform.foundInClassCache();
        if (!fromSCC) {
            originalBytes = toTransform.getBytes();
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Attempt to transform \" + name + \" found in shared class cache because we have " + (!this.transformers.isEmpty() ? "[transformers]" : "") + (!this.systemTransformers.isEmpty() ? "[system transformers]" : "")), (Object[])new Object[0]);
            }
            try {
                originalBytes = toTransform.getActualBytes();
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.classloading.internal.AppClassLoader", (String)"354", (Object)this, (Object[])new Object[]{name, toTransform});
                return toTransform.getBytes();
            }
        }
        byte[] bytes = this.transformClassBytes(originalBytes, name, this.transformers);
        bytes = this.transformClassBytes(bytes, name, this.systemTransformers);
        if (fromSCC && (bytes == originalBytes || Arrays.equals(bytes, originalBytes))) {
            bytes = toTransform.getBytes();
        }
        return bytes;
    }

    private byte[] transformClassBytes(byte[] originalBytes, String name, List<ClassFileTransformer> cfts) throws ClassNotFoundException {
        byte[] bytes = originalBytes;
        for (ClassFileTransformer transformer : cfts) {
            bytes = this.doTransformation(name, bytes, transformer);
        }
        return bytes;
    }

    /*
     * WARNING - void declaration
     */
    private byte[] doTransformation(String name, byte[] bytes, ClassFileTransformer transformer) throws ClassNotFoundException {
        try {
            byte[] newBytes = transformer.transform(this, name, null, this.config.getProtectionDomain(), bytes);
            if (newBytes != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    if (bytes == newBytes) {
                        Tr.debug((TraceComponent)tc, (String)("transformer " + transformer + " was invoked but returned an unaltered byte array"), (Object[])new Object[0]);
                    } else {
                        Tr.debug((TraceComponent)tc, (String)("transformer " + transformer + " successfully transformed the class bytes"), (Object[])new Object[0]);
                    }
                }
                bytes = newBytes;
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("transformer " + transformer + " was invoked but did not alter the loaded bytes"), (Object[])new Object[0]);
            }
        }
        catch (IllegalClassFormatException newBytes) {
            void ex;
            FFDCFilter.processException((Throwable)newBytes, (String)"com.ibm.ws.classloading.internal.AppClassLoader", (String)"394", (Object)this, (Object[])new Object[]{name, bytes, transformer});
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("bad transform - transformer: " + transformer + " attempting to transform class: " + name), (Object[])new Object[]{ex});
            }
            throw new ClassNotFoundException(name, (Throwable)ex);
        }
        return bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class<?> definePackageAndClass(String name, String resourceName, ContainerClassLoader.ByteResourceInformation byteResourceInformation, byte[] bytes) throws ClassFormatError {
        URL sharedClassCacheURL;
        TraceComponent cltc;
        ProtectionDomain pd;
        int lastDotIndex = name.lastIndexOf(46);
        String packageName = DEFAULT_PACKAGE;
        if (lastDotIndex != -1) {
            packageName = name.substring(0, lastDotIndex);
            this.definePackage(byteResourceInformation, packageName);
        }
        URL resourceURL = byteResourceInformation.getResourceUrl();
        final ProtectionDomain fpd = pd = this.getClassSpecificProtectionDomain(resourceName, resourceURL);
        PermissionCollection pc = null;
        if (pd.getPermissions() == null) {
            try {
                pc = AccessController.doPrivileged(new PrivilegedExceptionAction<PermissionCollection>(){
                    static final long serialVersionUID = -5185837412411999709L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    @Override
                    public PermissionCollection run() {
                        Policy p = Policy.getPolicy();
                        PermissionCollection fpc = p.getPermissions(fpd.getCodeSource());
                        return fpc;
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register((String)"com.ibm.ws.classloading.internal.AppClassLoader$2", 2.class, (String)"ClassLoadingService", (String)"com.ibm.ws.classloading.internal.resources.ClassLoadingServiceMessages");
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ws.classloading.internal.AppClassLoader", (String)"428", (Object)this, (Object[])new Object[]{name, resourceName, byteResourceInformation, bytes});
            }
            pd = new ProtectionDomain(pd.getCodeSource(), pc);
        }
        Class<?> clazz = null;
        try {
            clazz = this.defineClass(name, bytes, 0, bytes.length, pd);
        }
        catch (Throwable throwable) {
            TraceComponent cltc2;
            if (TraceComponent.isAnyTracingEnabled() && (cltc2 = this.getClassLoadingTraceComponent(packageName)).isDebugEnabled()) {
                String path;
                String loc = "" + byteResourceInformation.getResourceUrl();
                if (loc.endsWith(path = byteResourceInformation.getResourcePath())) {
                    loc = loc.substring(0, loc.length() - path.length());
                }
                if (loc.endsWith("!/")) {
                    loc = loc.substring(0, loc.length() - 2);
                }
                String message = clazz == null ? "CLASS FAIL" : "CLASS LOAD";
                Tr.debug((TraceComponent)cltc2, (String)String.format("%s: [%s] [%s] [%s]", message, this.getKey(), loc, name), (Object[])new Object[0]);
            }
            throw throwable;
        }
        if (TraceComponent.isAnyTracingEnabled() && (cltc = this.getClassLoadingTraceComponent(packageName)).isDebugEnabled()) {
            String path;
            String loc = "" + byteResourceInformation.getResourceUrl();
            if (loc.endsWith(path = byteResourceInformation.getResourcePath())) {
                loc = loc.substring(0, loc.length() - path.length());
            }
            if (loc.endsWith("!/")) {
                loc = loc.substring(0, loc.length() - 2);
            }
            String message = clazz == null ? "CLASS FAIL" : "CLASS LOAD";
            Tr.debug((TraceComponent)cltc, (String)String.format("%s: [%s] [%s] [%s]", message, this.getKey(), loc, name), (Object[])new Object[0]);
        }
        if (!byteResourceInformation.foundInClassCache() && this.hook != null && (sharedClassCacheURL = AppClassLoader.getSharedClassCacheURL(resourceURL, byteResourceInformation.getResourcePath())) != null && Arrays.equals(bytes, byteResourceInformation.getBytes())) {
            this.hook.storeClass(sharedClassCacheURL, clazz);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Called shared class cache to store class", (Object[])new Object[]{clazz.getName(), sharedClassCacheURL});
            }
        }
        return clazz;
    }

    @Trivial
    private ProtectionDomain getClassSpecificProtectionDomain(final String resourceName, final URL resourceUrl) {
        ProtectionDomain pd = this.config.getProtectionDomain();
        try {
            pd = AccessController.doPrivileged(new PrivilegedExceptionAction<ProtectionDomain>(){
                static final long serialVersionUID = 3149965399767566929L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public ProtectionDomain run() {
                    return AppClassLoader.this.getClassSpecificProtectionDomainPrivileged(resourceName, resourceUrl);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.classloading.internal.AppClassLoader$3", 3.class, (String)"ClassLoadingService", (String)"com.ibm.ws.classloading.internal.resources.ClassLoadingServiceMessages");
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ws.classloading.internal.AppClassLoader", (String)"473", (Object)this, (Object[])new Object[]{resourceName, resourceUrl});
            return this.config.getProtectionDomain();
        }
        return pd;
    }

    ProtectionDomain getClassSpecificProtectionDomainPrivileged(String resourceName, URL resourceUrl) {
        ProtectionDomain pd;
        try {
            ProtectionDomain pdFromConfig;
            CodeSource cs;
            ProtectionDomain oldPD;
            URLConnection conn = resourceUrl.openConnection();
            URL containerUrl = conn instanceof JarURLConnection ? ((JarURLConnection)conn).getJarFileURL() : (conn instanceof WSJarURLConnection ? ((WSJarURLConnection)conn).getFile().toURI().toURL() : new URL(resourceUrl.toString().replace(resourceName, "")));
            String containerUrlString = containerUrl.toString();
            pd = this.protectionDomains.get(containerUrlString);
            if (pd == null && (oldPD = this.protectionDomains.putIfAbsent(containerUrlString, pd = new ProtectionDomain(cs = new CodeSource(containerUrl, (pdFromConfig = this.config.getProtectionDomain()).getCodeSource().getCertificates()), pdFromConfig.getPermissions()))) != null) {
                pd = oldPD;
            }
        }
        catch (IOException conn) {
            FFDCFilter.processException((Throwable)conn, (String)"com.ibm.ws.classloading.internal.AppClassLoader", (String)"509", (Object)this, (Object[])new Object[]{resourceName, resourceUrl});
            pd = this.config.getProtectionDomain();
        }
        return pd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void definePackage(ContainerClassLoader.ByteResourceInformation byteResourceInformation, String packageName) {
        if (!this.packagesDefined.contains(packageName)) {
            NameBasedClassLoaderLock nameBasedClassLoaderLock = this.getClassLoadingLock(packageName);
            synchronized (nameBasedClassLoaderLock) {
                if (!this.packagesDefined.contains(packageName)) {
                    byteResourceInformation.definePackage(packageName, this);
                    this.packagesDefined.add(packageName);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    final ContainerClassLoader.ByteResourceInformation findClassBytes(String className, String resourceName) {
        try {
            return this.findClassBytes(className, resourceName, this.hook);
        }
        catch (IOException iOException) {
            void e;
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.classloading.internal.AppClassLoader", (String)"541", (Object)this, (Object[])new Object[]{className, resourceName});
            Tr.error((TraceComponent)tc, (String)"cls.class.file.not.readable", (Object[])new Object[]{className, resourceName});
            String message = String.format("Could not read class '%s' as resource '%s'", className, resourceName);
            ClassFormatError error = new ClassFormatError(message);
            error.initCause((Throwable)e);
            throw error;
        }
    }

    @Override
    @Trivial
    protected final Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        return this.loadClass(name, resolve, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Trivial
    @FFDCIgnore(value={ClassNotFoundException.class})
    protected final Class<?> loadClass(String name, boolean resolve, boolean onlySearchSelf, boolean returnNull) throws ClassNotFoundException {
        if (forbiddenClassNames.contains(name)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("loadClass " + name + " forbidden"), (Object[])new Object[0]);
            }
            if (returnNull) {
                return null;
            }
            throw new ClassNotFoundException(name);
        }
        ClassNotFoundException cnfe = null;
        Object token = ThreadIdentityManager.runAsServer();
        try {
            Class<?> result = this.findOrDelegateLoadClass(name, onlySearchSelf, returnNull);
            if (result != null) {
                Class<?> clazz = result;
                return clazz;
            }
        }
        catch (ClassNotFoundException e) {
            cnfe = e;
        }
        finally {
            ThreadIdentityManager.reset((Object)token);
        }
        ClassNotFoundException toThrow = FeatureSuggestion.getExceptionWithSuggestion(cnfe, name, returnNull);
        if (returnNull) {
            return null;
        }
        throw toThrow;
    }

    @Trivial
    Class<?> generateClass(String name) throws ClassNotFoundException {
        byte[] bytes;
        Class<?> generatedClass = null;
        if (this.generator != null && (bytes = this.generator.generateClass(name, this)) != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("defining generated class " + name), (Object[])new Object[0]);
            }
            String remoteInterfaceClassName = null;
            ProtectionDomain pd = null;
            if (name != null && name.endsWith("_Stub") && !name.endsWith("._Stub")) {
                StringBuilder nameBuilder = new StringBuilder(name);
                nameBuilder.setLength(nameBuilder.length() - 5);
                int packageOffset = nameBuilder.lastIndexOf(".") + 1;
                if (nameBuilder.charAt(packageOffset) == '_') {
                    nameBuilder.deleteCharAt(packageOffset);
                }
                remoteInterfaceClassName = nameBuilder.toString();
                try {
                    final Class<?> remoteClass = super.loadClass(remoteInterfaceClassName, false);
                    pd = AccessController.doPrivileged(new PrivilegedExceptionAction<ProtectionDomain>(){
                        static final long serialVersionUID = 2238317208619288395L;
                        private static final /* synthetic */ TraceComponent $$$tc$$$;

                        @Override
                        public ProtectionDomain run() {
                            return remoteClass.getProtectionDomain();
                        }

                        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                        static {
                            $$$tc$$$ = Tr.register((String)"com.ibm.ws.classloading.internal.AppClassLoader$4", 4.class, (String)"ClassLoadingService", (String)"com.ibm.ws.classloading.internal.resources.ClassLoadingServiceMessages");
                        }
                    });
                }
                catch (PrivilegedActionException remoteClass) {
                    FFDCFilter.processException((Throwable)remoteClass, (String)"com.ibm.ws.classloading.internal.AppClassLoader", (String)"641", (Object)this, (Object[])new Object[]{name});
                }
                final ProtectionDomain fpd = pd;
                PermissionCollection pc = null;
                if (pd.getPermissions() == null) {
                    try {
                        pc = AccessController.doPrivileged(new PrivilegedExceptionAction<PermissionCollection>(){
                            static final long serialVersionUID = 2130515200060161890L;
                            private static final /* synthetic */ TraceComponent $$$tc$$$;

                            @Override
                            public PermissionCollection run() {
                                Policy p = Policy.getPolicy();
                                PermissionCollection fpc = p.getPermissions(fpd.getCodeSource());
                                return fpc;
                            }

                            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                            static {
                                $$$tc$$$ = Tr.register((String)"com.ibm.ws.classloading.internal.AppClassLoader$5", 5.class, (String)"ClassLoadingService", (String)"com.ibm.ws.classloading.internal.resources.ClassLoadingServiceMessages");
                            }
                        });
                        pd = new ProtectionDomain(pd.getCodeSource(), pc);
                        generatedClass = this.defineClass(name, bytes, 0, bytes.length, pd);
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ws.classloading.internal.AppClassLoader", (String)"662", (Object)this, (Object[])new Object[]{name});
                    }
                } else {
                    generatedClass = this.defineClass(name, bytes, 0, bytes.length, pd);
                }
            } else {
                generatedClass = this.defineClass(name, bytes, 0, bytes.length, this.config.getProtectionDomain());
            }
        }
        return generatedClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FFDCIgnore(value={ClassNotFoundException.class})
    protected Class<?> findOrDelegateLoadClass(String name, boolean onlySearchSelf, boolean returnNull) throws ClassNotFoundException {
        if (this.parent == null) {
            return super.loadClass(name, false);
        }
        Class<?> result = null;
        ClassNotFoundException findException = null;
        NameBasedClassLoaderLock nameBasedClassLoaderLock = this.getClassLoadingLock(name);
        synchronized (nameBasedClassLoaderLock) {
            result = this.findLoadedClass(name);
            if (result == null) {
                if (!onlySearchSelf) {
                    if (this.parent instanceof NoClassNotFoundLoader) {
                        result = ((NoClassNotFoundLoader)((Object)this.parent)).loadClassNoException(name);
                    } else {
                        try {
                            result = this.parent.loadClass(name);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            // empty catch block
                        }
                    }
                }
                if (result == null) {
                    try {
                        result = this.findClass(name, returnNull);
                    }
                    catch (ClassNotFoundException cnfe) {
                        findException = cnfe;
                    }
                    if (result == null) {
                        result = this.generateClass(name);
                    }
                }
            }
        }
        if (result != null || returnNull) {
            return result;
        }
        throw findException;
    }

    @FFDCIgnore(value={ClassNotFoundException.class})
    private Class<?> findClassCommonLibraryClassLoaders(String name, boolean returnNull) throws ClassNotFoundException {
        for (LibertyLoader cl : this.delegateLoaders) {
            try {
                Class<?> rc = cl.loadClass(name, false, true, true);
                if (rc == null) continue;
                return rc;
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        if (returnNull) {
            return null;
        }
        throw new ClassNotFoundException(name);
    }

    private URL findResourceCommonLibraryClassLoaders(String name) {
        for (LibertyLoader cl : this.delegateLoaders) {
            URL url = cl.findResource(name);
            if (url == null) continue;
            return url;
        }
        return null;
    }

    private CompositeEnumeration<URL> findResourcesCommonLibraryClassLoaders(String name, CompositeEnumeration<URL> enumerations) throws IOException {
        for (LibertyLoader cl : this.delegateLoaders) {
            enumerations.add(cl.findResources(name));
        }
        return enumerations;
    }

    @Override
    protected void lazyInit() {
        if (this.privateLibraries != null) {
            for (Library lib : this.privateLibraries) {
                this.copyLibraryElementsToClasspath(lib);
            }
        }
        this.privateLibraries = null;
    }

    private void copyLibraryElementsToClasspath(Library library) {
        Collection<File> files = library.getFiles();
        this.addToClassPath(library.getContainers());
        if (files != null && !files.isEmpty()) {
            for (File file : files) {
                this.nativeLibraryFiles.add(file);
            }
        }
        for (Fileset fileset : library.getFilesets()) {
            for (File file : fileset.getFileset()) {
                this.nativeLibraryFiles.add(file);
            }
        }
    }

    private static boolean isWindows(String basename) {
        return basename.endsWith(".dll") || basename.endsWith(".DLL");
    }

    private static boolean checkLib(final File f, String basename) {
        boolean fExists = System.getSecurityManager() == null ? f.exists() : AccessController.doPrivileged(new PrivilegedAction<Boolean>(){
            static final long serialVersionUID = 6014336558473948371L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Boolean run() {
                return f.exists();
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.classloading.internal.AppClassLoader$6", 6.class, (String)"ClassLoadingService", (String)"com.ibm.ws.classloading.internal.resources.ClassLoadingServiceMessages");
            }
        }).booleanValue();
        return fExists && (f.getName().equals(basename) || AppClassLoader.isWindows(basename) && f.getName().equalsIgnoreCase(basename));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String findLibrary(String libname) {
        if (libname == null || libname.length() == 0) {
            return null;
        }
        String path = super.findLibrary(libname);
        if (path != null) {
            return path;
        }
        Object token = ThreadIdentityManager.runAsServer();
        try {
            String psLibname = System.mapLibraryName(libname);
            for (File f : this.nativeLibraryFiles) {
                if (!AppClassLoader.checkLib(f, psLibname)) continue;
                String string = f.getAbsolutePath();
                return string;
            }
        }
        finally {
            ThreadIdentityManager.reset((Object)token);
        }
        return null;
    }

    @Override
    public ClassLoaderIdentity getKey() {
        return this.config.getId();
    }

    public String toDiagString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.config).append(ClassLoadingConstants.LS);
        sb.append("    API Visibility: ");
        for (ApiType apiType : this.apiAccess.getApiTypeVisibility()) {
            sb.append((Object)apiType).append(" ");
        }
        sb.append(ClassLoadingConstants.LS);
        sb.append("    ClassPath: ").append(ClassLoadingConstants.LS);
        for (Collection collection : this.getClassPath()) {
            sb.append("      * ");
            for (URL url : collection) {
                sb.append(url.toString()).append(" | ");
            }
            sb.append(ClassLoadingConstants.LS);
        }
        sb.append(ClassLoadingConstants.LS);
        sb.append("    CodeSources: ");
        for (Map.Entry entry : this.protectionDomains.entrySet()) {
            sb.append(ClassLoadingConstants.LS).append("      ").append((String)entry.getKey()).append(" = ").append(((ProtectionDomain)entry.getValue()).getCodeSource().getLocation());
        }
        sb.append(ClassLoadingConstants.LS);
        return sb.toString();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        ClassLoader.registerAsParallelCapable();
        disableSharedClassesCache = Boolean.getBoolean("liberty.disableApplicationClassSharing");
        PARENT_FIRST_SEARCH_ORDER = Util.freeze(Util.list(SearchLocation.PARENT, SearchLocation.SELF, SearchLocation.DELEGATES));
    }

    static enum SearchLocation {
        PARENT,
        SELF,
        DELEGATES;

    }
}

