/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.collective.repository.client.internal;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.websphere.ssl.JSSEHelper;
import com.ibm.ws.collective.member.Endpoint;
import com.ibm.ws.collective.member.connection.ConnectionPropertiesCollector;
import com.ibm.ws.collective.member.heartbeat.HeartBeatSender;
import com.ibm.ws.collective.member.heartbeat.RepositoryMemberHeartBeat;
import com.ibm.ws.collective.repository.client.internal.RemoteConnectionHelper;
import com.ibm.ws.collective.repository.client.internal.RemoteConnectionHelperImpl;
import com.ibm.ws.collective.repository.client.internal.TraceConstants;
import com.ibm.ws.collective.utils.GatherMemberDataUtil;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.ssl.KeyStoreService;
import com.ibm.wsspi.collective.repository.RepositoryClient;
import com.ibm.wsspi.collective.repository.RepositoryMember;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.kernel.service.utils.FrameworkState;
import com.ibm.wsspi.ssl.SSLConfiguration;
import com.ibm.wsspi.ssl.SSLSupport;
import java.io.IOException;
import java.net.ConnectException;
import java.security.AccessControlException;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.management.InstanceNotFoundException;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationEvent;
import org.osgi.service.cm.ConfigurationListener;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(configurationPid={"com.ibm.ws.management.repository.connection"}, configurationPolicy=ConfigurationPolicy.REQUIRE, immediate=true, service={RepositoryMemberHeartBeat.class, ConfigurationListener.class, ConnectionPropertiesCollector.class}, property={"service.vendor=IBM", "service.ranking:Integer=25"})
public class RemoteRepositoryConnection
implements RepositoryClient,
RepositoryMember,
RepositoryMemberHeartBeat,
ConfigurationListener,
TraceConstants,
ConnectionPropertiesCollector {
    private static final TraceComponent tc = Tr.register(RemoteRepositoryConnection.class, (String)"Collective", (String)"com.ibm.ws.collective.repository.client.internal.resources.RepositoryClientMessages");
    private volatile boolean isActiveFlag = true;
    private final Object lostConnLock = new Object(){
        static final long serialVersionUID = 1736317647234195417L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.collective.repository.client.internal.RemoteRepositoryConnection$1", 1.class, (String)"Collective", (String)"com.ibm.ws.collective.repository.client.internal.resources.RepositoryClientMessages");
        }
    };
    static final String CFG_KEY_HOST = "controllerHost";
    static final String CFG_KEY_PORT = "controllerPort";
    static final String CFG_KEY_FAILOVER_CONTROLLER = "failoverController";
    static final String CFG_KEY_FAILOVER_HOST = "host";
    static final String CFG_KEY_FAILOVER_PORT = "port";
    static final String CFG_KEY_HEART_BEAT_INTERVAL = "heartBeatInterval";
    static final String CFG_KEY_READ_TIMEOUT = "controllerReadTimeout";
    static final String CFG_KEY_DISABLE_HEART_BEAT = "disableHeartBeat";
    static final int MINIMUM_HEARTBEAT_INTERVAL_SECONDS = 1;
    static final int DEFAULT_HEARTBEAT_INTERVAL_SECONDS = 60;
    static final int MINIMUM_READ_TIMEOUT_MILLISECONDS = 120000;
    static final int DEFAULT_READ_TIMEOUT_MILLISECONDS = 300000;
    static final String SSL_CONFIG_ID = "controllerConnectionConfig";
    static final String KEY_CONFIG_ADMIN = "configurationAdmin";
    static final String KEY_SSL_SUPPORT = "sslSupport";
    static final String KEY_HEART_BEAT_SENDER = "heartBeatSender";
    static final String KEY_EXECUTOR_SERVICE = "executorService";
    static final String KEY_MEMBER_DATA_UTIL = "gatherMemberDataUtil";
    private final AtomicServiceReference<ConfigurationAdmin> configAdminRef = new AtomicServiceReference("configurationAdmin");
    private final AtomicServiceReference<SSLSupport> sslSupport = new AtomicServiceReference("sslSupport");
    private final AtomicServiceReference<HeartBeatSender> heartBeatSenderRef = new AtomicServiceReference("heartBeatSender");
    private final AtomicServiceReference<ScheduledExecutorService> executorService = new AtomicServiceReference("executorService");
    private GatherMemberDataUtil gatherMemberDataUtil = null;
    private ServiceRegistration<?> repositoryReg = null;
    private RemoteConnectionHelper remoteConnectionHelper = null;
    private String memberId;
    private volatile boolean connected = false;
    private boolean needToSendNewHeartBeatInterval = false;
    private BundleContext bundleContext;
    ScheduledConnect scheduledConnect;
    private WsLocationAdmin locationAdmin;
    private long startTimeSendHeartBeatFailure = 0L;
    private final long endTimeSendHeartBeatFailure = 0L;
    private long maxSendHeartBeatFailure = 120000L;
    private boolean handleLostConnection = false;
    private Map<String, Object> properties;
    private final Set<String> pids = new HashSet<String>();
    private boolean attemptedInitialConnection = false;
    private int heartBeatInterval_s = 60;
    private boolean disableHeartBeat;
    private int readTimeoutMillis = 300000;
    static final String SERVER_TRUSTSTORE_NAME = "collectiveTrust";
    static final String KEY_KEYSTORE_SERVICE_REF = "keyStoreService";
    static final String MEMBER_ROOT_KEY_ALIAS = "memberRoot";
    private final AtomicServiceReference<KeyStoreService> keyStoreServiceRef = new AtomicServiceReference("keyStoreService");
    private String bundleLocation;
    static final long serialVersionUID = -709330320905231583L;

    @Reference(service=WsLocationAdmin.class)
    protected void setWsLocationAdmin(WsLocationAdmin reference) {
        this.locationAdmin = reference;
    }

    protected void unsetWsLocationAdmin(WsLocationAdmin reference) {
        if (this.locationAdmin == reference) {
            this.locationAdmin = null;
        }
    }

    @Reference(name="configurationAdmin", service=ConfigurationAdmin.class)
    protected void setConfigurationAdmin(ServiceReference<ConfigurationAdmin> reference) {
        this.configAdminRef.setReference(reference);
    }

    protected void unsetConfigurationAdmin(ServiceReference<ConfigurationAdmin> reference) {
        this.configAdminRef.unsetReference(reference);
    }

    @Reference(name="sslSupport", service=SSLSupport.class)
    protected void setSSLSupport(ServiceReference<SSLSupport> ref) {
        this.sslSupport.setReference(ref);
    }

    protected void unsetSSLSupport(ServiceReference<SSLSupport> ref) {
        this.sslSupport.unsetReference(ref);
    }

    @Reference(service=SSLConfiguration.class, target="(id=controllerConnectionConfig)")
    protected void setSSLConfiguration(ServiceReference<SSLConfiguration> ref) {
    }

    protected void unsetSSLConfiguration(ServiceReference<SSLConfiguration> ref) {
    }

    @Reference(name="keyStoreService", service=KeyStoreService.class)
    protected void setKeyStoreService(ServiceReference<KeyStoreService> reference) {
        this.keyStoreServiceRef.setReference(reference);
    }

    protected void unsetKeyStoreService(ServiceReference<KeyStoreService> reference) {
        this.keyStoreServiceRef.unsetReference(reference);
    }

    @Reference(name="executorService", service=ScheduledExecutorService.class)
    protected void setExecutorService(ServiceReference<ScheduledExecutorService> ref) {
        this.executorService.setReference(ref);
    }

    protected void unsetExecutorService(ServiceReference<ScheduledExecutorService> ref) {
        this.executorService.unsetReference(ref);
    }

    @Reference(name="heartBeatSender", service=HeartBeatSender.class)
    protected void setHeartBeatSender(ServiceReference<HeartBeatSender> ref) {
        this.heartBeatSenderRef.setReference(ref);
    }

    protected void unsetHeartBeatSender(ServiceReference<HeartBeatSender> ref) {
        HeartBeatSender hbs = (HeartBeatSender)this.heartBeatSenderRef.getService();
        if (hbs != null) {
            hbs.cancelHeartBeat((RepositoryMemberHeartBeat)this);
        }
        this.heartBeatSenderRef.unsetReference(ref);
    }

    @Reference(name="gatherMemberDataUtil", service=GatherMemberDataUtil.class)
    protected void setGatherMemberDataUtil(GatherMemberDataUtil ref) {
        this.gatherMemberDataUtil = ref;
    }

    protected void unsetGatherMemberDataUtil(GatherMemberDataUtil ref) {
        this.gatherMemberDataUtil = null;
    }

    void setClientConnectionHelper(RemoteConnectionHelper remoteConnectionHelper) {
        this.remoteConnectionHelper = remoteConnectionHelper;
    }

    void setMemberId(String memberId) {
        this.memberId = memberId;
    }

    private synchronized void processFailoverEndpoints(ConfigurationAdmin configAdmin, Map<String, Object> properties, List<Endpoint> endpoints) {
        this.pids.clear();
        String[] failoverEndpoints = (String[])properties.get(CFG_KEY_FAILOVER_CONTROLLER);
        if (failoverEndpoints == null || failoverEndpoints.length == 0) {
            return;
        }
        for (String failoverEndpointPid : failoverEndpoints) {
            this.pids.add(failoverEndpointPid);
            Configuration config = null;
            try {
                config = configAdmin.getConfiguration(failoverEndpointPid, this.bundleLocation);
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.collective.repository.client.internal.RemoteRepositoryConnection", (String)"293", (Object)this, (Object[])new Object[]{configAdmin, properties, endpoints});
                Tr.error((TraceComponent)tc, (String)"REMOTE_REPOSITORY_BAD_FAILOVER_CONTROLLER_CONFIG", (Object[])new Object[]{failoverEndpointPid});
                continue;
            }
            if (config == null || config.getProperties() == null) {
                Tr.error((TraceComponent)tc, (String)"REMOTE_REPOSITORY_BAD_FAILOVER_CONTROLLER_CONFIG", (Object[])new Object[]{failoverEndpointPid});
                continue;
            }
            String host = (String)config.getProperties().get(CFG_KEY_FAILOVER_HOST);
            Integer port = (Integer)config.getProperties().get(CFG_KEY_FAILOVER_PORT);
            if (host == null || host.trim().isEmpty()) {
                Tr.warning((TraceComponent)tc, (String)"REMOTE_REPOSITORY_INCOMPLETE_FAILOVER_CONTROLLER_CONFIG", (Object[])new Object[]{CFG_KEY_FAILOVER_HOST});
                continue;
            }
            if (port == null) {
                Tr.warning((TraceComponent)tc, (String)"REMOTE_REPOSITORY_INCOMPLETE_FAILOVER_CONTROLLER_CONFIG", (Object[])new Object[]{CFG_KEY_FAILOVER_PORT});
                continue;
            }
            Endpoint endpoint = new Endpoint(host, port.intValue());
            if (endpoints.contains(endpoint)) {
                Tr.warning((TraceComponent)tc, (String)"REMOTE_REPOSITORY_DUPLICATE_CONTROLLER_ADDRESS", (Object[])new Object[]{endpoint});
                continue;
            }
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Adding failover controller address: " + endpoint), (Object[])new Object[0]);
            }
            endpoints.add(endpoint);
        }
    }

    private List<Endpoint> processEndpoints(Map<String, Object> properties, List<String> missingAttributes) {
        ArrayList<Endpoint> endpoints = new ArrayList<Endpoint>();
        String host = (String)properties.get(CFG_KEY_HOST);
        if (host == null || host.isEmpty()) {
            missingAttributes.add(CFG_KEY_HOST);
        } else {
            host = host.trim();
        }
        Integer port = (Integer)properties.get(CFG_KEY_PORT);
        if (port == null) {
            missingAttributes.add(CFG_KEY_PORT);
        }
        if (missingAttributes.isEmpty()) {
            Endpoint endpoint = new Endpoint(host, port.intValue());
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Setting primary controller address: " + endpoint), (Object[])new Object[0]);
            }
            endpoints.add(endpoint);
        }
        this.processFailoverEndpoints((ConfigurationAdmin)this.configAdminRef.getService(), properties, endpoints);
        return endpoints;
    }

    private int processPropertyHeartBeatInterval(Map<String, Object> properties) {
        Object heartBeatInterval = properties.get(CFG_KEY_HEART_BEAT_INTERVAL);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("heartBeatInterval value (in seconds) from config: " + heartBeatInterval), (Object[])new Object[0]);
        }
        if (heartBeatInterval != null && heartBeatInterval instanceof Number) {
            int heartBeatMilliseconds = ((Number)heartBeatInterval).intValue();
            if (heartBeatMilliseconds < 1000) {
                Tr.warning((TraceComponent)tc, (String)"CONFIG_HEART_BEAT_INTERVAL_TOO_SMALL", (Object[])new Object[]{heartBeatMilliseconds, 1000, 60000});
                return 60;
            }
            return heartBeatMilliseconds / 1000;
        }
        return 60;
    }

    private int processPropertyReadTimeout(Map<String, Object> properties) {
        Object readTimeout = properties.get(CFG_KEY_READ_TIMEOUT);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("controllerReadTimeout value (in milliseconds) from config: " + readTimeout), (Object[])new Object[0]);
        }
        if (readTimeout != null && readTimeout instanceof Number) {
            int readTimeoutMillis = ((Number)readTimeout).intValue();
            if (readTimeoutMillis < 120000) {
                Tr.warning((TraceComponent)tc, (String)"CONFIG_READ_TIMEOUT_TOO_SMALL", (Object[])new Object[]{readTimeoutMillis, 120000, 300000});
                return 300000;
            }
            return readTimeoutMillis;
        }
        return 300000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processProperties() {
        block6: {
            ArrayList<String> missingAttributes = new ArrayList<String>();
            List<Endpoint> endpoints = this.processEndpoints(this.properties, missingAttributes);
            this.heartBeatInterval_s = this.processPropertyHeartBeatInterval(this.properties);
            this.readTimeoutMillis = this.processPropertyReadTimeout(this.properties);
            this.disableHeartBeat = this.properties.get(CFG_KEY_DISABLE_HEART_BEAT) != null;
            RemoteConnectionHelper oldHelper = null;
            if (this.remoteConnectionHelper != null) {
                oldHelper = this.remoteConnectionHelper;
            }
            try {
                if (missingAttributes.isEmpty()) {
                    JSSEHelper jsseHelper = this.getSSLSupportService().getJSSEHelper();
                    this.setClientConnectionHelper(new RemoteConnectionHelperImpl(jsseHelper, this.locationAdmin, endpoints, this.readTimeoutMillis, SSL_CONFIG_ID));
                    break block6;
                }
                Tr.error((TraceComponent)tc, (String)"REMOTE_REPOSITORY_CONFIGURATION_ERROR", (Object[])new Object[]{((Object)missingAttributes).toString()});
                throw new IllegalArgumentException(TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.collective.repository.client.internal.resources.RepositoryClientMessages", (String)"REMOTE_REPOSITORY_CONFIGURATION_ERROR", (Object[])new Object[]{((Object)missingAttributes).toString()}, (String)"CWWKX8050E: A configuration error has occurred. The <collectiveMember> element is missing values for the following attributes: {0}"));
            }
            finally {
                if (oldHelper != null) {
                    oldHelper.disconnectRemoteConnection();
                }
            }
        }
    }

    int getReadTimeout() {
        return this.readTimeoutMillis;
    }

    int getHeartBeatInterval() {
        return this.heartBeatInterval_s;
    }

    @FFDCIgnore(value={IllegalArgumentException.class})
    @Activate
    protected synchronized void activate(ComponentContext cc, Map<String, Object> properties) {
        this.isActiveFlag = true;
        this.executorService.activate(cc);
        this.configAdminRef.activate(cc);
        this.sslSupport.activate(cc);
        this.heartBeatSenderRef.activate(cc);
        this.keyStoreServiceRef.activate(cc);
        try {
            this.properties = properties;
            this.processProperties();
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)(this.getClass().getCanonicalName() + " has been successfully activated"), (Object[])new Object[0]);
            }
            Tr.info((TraceComponent)tc, (String)"REMOTE_REPOSITORY_HEARTBEAT_INTERVAL", (Object[])new Object[]{this.heartBeatInterval_s});
        }
        catch (IllegalArgumentException e) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)(this.getClass().getCanonicalName() + " could not be activated. Exception: " + e.getMessage()), (Object[])new Object[]{e});
            }
            throw e;
        }
        this.bundleContext = cc.getBundleContext();
        this.bundleLocation = this.bundleContext.getBundle().getLocation();
        this.scheduledConnect = new ScheduledConnect();
        this.getScheduledExecutorService().submit(this.scheduledConnect);
    }

    @FFDCIgnore(value={IOException.class})
    private void sendNewHeartBeatInterval() {
        block4: {
            if (!this.connected) {
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"Heartbeat updated, but we're not connected yet -- nothing to do.", (Object[])new Object[0]);
                }
                return;
            }
            try {
                this.sendHeartBeat(this.heartBeatInterval_s);
            }
            catch (IOException e) {
                this.needToSendNewHeartBeatInterval = true;
                if (!tc.isEventEnabled()) break block4;
                Tr.event((TraceComponent)tc, (String)"Unexpected IOException while sending new heart beat, will requeue update", (Object[])new Object[]{e});
            }
        }
    }

    @FFDCIgnore(value={IllegalArgumentException.class})
    @Modified
    protected synchronized void modified(Map<String, Object> properties) {
        try {
            this.properties = properties;
            this.processProperties();
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)(this.getClass().getCanonicalName() + " has been successfully modified"), (Object[])new Object[0]);
            }
        }
        catch (IllegalArgumentException e) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)(this.getClass().getCanonicalName() + " could not be modified. Exception: " + e.getMessage()), (Object[])new Object[]{e});
            }
            throw e;
        }
        this.sendNewHeartBeatInterval();
    }

    public synchronized void registerMember() throws IOException, IllegalArgumentException, IllegalStateException {
        HeartBeatSender hbs;
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"Attempting to register as a member...", (Object[])new Object[0]);
        }
        this.isActive("registerMember");
        Object[] params = new Object[]{this.heartBeatInterval_s, this.gatherMemberDataUtil.getMemberData()};
        String[] signature = new String[]{"int", "java.util.Map"};
        Object returnObject = this.accessMBean("registerMember", params, signature);
        this.memberId = this.processReturnedString(returnObject);
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Assigned memberId: " + this.memberId), (Object[])new Object[0]);
        }
        if ((hbs = (HeartBeatSender)this.heartBeatSenderRef.getService()) != null) {
            hbs.startHeartBeat((RepositoryMemberHeartBeat)this, this.heartBeatInterval_s);
        }
        this.setConnected(true);
        this.registerService();
        this.checkForMemberRootCertificate();
    }

    @FFDCIgnore(value={Exception.class})
    private void checkForMemberRootCertificate() {
        block4: {
            try {
                if (!this.hasMemberRootCertificate()) {
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)"This member does not have the member root certificate, adding it now", (Object[])new Object[0]);
                    }
                    this.addMemberRootCertificate();
                }
            }
            catch (Exception e) {
                if (!tc.isEventEnabled()) break block4;
                Tr.event((TraceComponent)tc, (String)("Could not update the trust store for the member due to: " + e.getLocalizedMessage()), (Object[])new Object[0]);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @FFDCIgnore(value={CertificateException.class})
    private boolean hasMemberRootCertificate() throws Exception {
        boolean foundCert = false;
        try {
            if (this.keyStoreServiceRef == null || this.keyStoreServiceRef.getService() == null) {
                Exception exception = new Exception("KeyStore service is not ready. Cannot access the trust store.");
                exception.fillInStackTrace();
                throw exception;
            }
            this.getKeyStoreServiceService().getCertificateFromKeyStore(SERVER_TRUSTSTORE_NAME, MEMBER_ROOT_KEY_ALIAS);
            foundCert = true;
        }
        catch (CertificateException ce) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("The truststore [collectiveTrust.p12] for the member does not contain the member root: " + ce.getLocalizedMessage()), (Object[])new Object[0]);
            }
        }
        catch (KeyStoreException ce) {
            void e;
            FFDCFilter.processException((Throwable)ce, (String)"com.ibm.ws.collective.repository.client.internal.RemoteRepositoryConnection", (String)"663", (Object)this, (Object[])new Object[0]);
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("The truststore [collectiveTrust.p12] for the member does not exist. Cannot access the trust store due to: " + e.getLocalizedMessage()), (Object[])new Object[0]);
            }
            throw e;
        }
        return foundCert;
    }

    /*
     * WARNING - void declaration
     */
    private void addMemberRootCertificate() throws Exception {
        IOException exception = null;
        Certificate rootCert = null;
        try {
            rootCert = (Certificate)this.accessMBean("retrieveMemberRootCertificate", null, null);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Successfully retrieved member root certificate for memberId " + this.memberId), (Object[])new Object[0]);
            }
        }
        catch (IllegalStateException illegalStateException) {
            void e;
            FFDCFilter.processException((Throwable)illegalStateException, (String)"com.ibm.ws.collective.repository.client.internal.RemoteRepositoryConnection", (String)"690", (Object)this, (Object[])new Object[0]);
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)(this.getClass().getCanonicalName() + " could not retrieve member root certificate for memberId [" + this.memberId + "]. IllegalStateException: " + e.getMessage()), (Object[])new Object[]{e});
            }
            exception = e;
        }
        catch (IllegalArgumentException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.collective.repository.client.internal.RemoteRepositoryConnection", (String)"698", (Object)this, (Object[])new Object[0]);
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("MemberId [" + this.memberId + "] is unable to access operation retrieveMemberRootCertificate as it is not defined on the controller. The controller is likely a lower version than the member. " + e.getMessage()), (Object[])new Object[]{e});
            }
        }
        catch (IOException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.collective.repository.client.internal.RemoteRepositoryConnection", (String)"708", (Object)this, (Object[])new Object[0]);
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)(this.getClass().getCanonicalName() + "  could not retrieve member root certificate for memberId [" + this.memberId + "]. IOException: " + e.getMessage()), (Object[])new Object[]{e});
            }
            exception = e;
        }
        if (exception != null) {
            throw exception;
        }
        this.getKeyStoreServiceService().addCertificateToKeyStore(SERVER_TRUSTSTORE_NAME, MEMBER_ROOT_KEY_ALIAS, rootCert);
    }

    @FFDCIgnore(value={IllegalStateException.class, IOException.class, IllegalArgumentException.class})
    public synchronized void deregisterMember() {
        block12: {
            Object[] params = new Object[]{this.memberId};
            String[] signature = new String[]{"java.lang.String"};
            try {
                this.accessMBean("deregisterMember", params, signature);
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("Successfully deregistered with memberId " + this.memberId), (Object[])new Object[0]);
                }
            }
            catch (IllegalStateException e) {
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)(this.getClass().getCanonicalName() + " could not deregisterMember. IllegalStateException: " + e.getMessage()), (Object[])new Object[]{e});
                }
            }
            catch (IllegalArgumentException e) {
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)(this.getClass().getCanonicalName() + " could not deregisterMember. IllegalArgumentException: " + e.getMessage()), (Object[])new Object[]{e});
                }
            }
            catch (IOException e) {
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)(this.getClass().getCanonicalName() + " could not deregisterMember. IOException: " + e.getMessage()), (Object[])new Object[]{e});
                }
            }
            catch (AccessControlException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.collective.repository.client.internal.RemoteRepositoryConnection", (String)"746", (Object)this, (Object[])new Object[0]);
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)(this.getClass().getCanonicalName() + " could not deregisterMember. AccessControlException: " + e.getMessage()), (Object[])new Object[]{e});
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.collective.repository.client.internal.RemoteRepositoryConnection", (String)"750", (Object)this, (Object[])new Object[0]);
                if (!tc.isEventEnabled()) break block12;
                Tr.event((TraceComponent)tc, (String)(this.getClass().getCanonicalName() + " could not deregisterMember. Exception: " + e.getMessage()), (Object[])new Object[]{e});
            }
        }
        this.memberId = null;
        HeartBeatSender hbs = (HeartBeatSender)this.heartBeatSenderRef.getService();
        if (hbs != null) {
            hbs.cancelHeartBeat((RepositoryMemberHeartBeat)this);
        }
    }

    @Deactivate
    protected synchronized void deactivate(ComponentContext cc, int reason) {
        this.unregisterService();
        this.isActiveFlag = false;
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)(this.getClass().getCanonicalName() + " has been deactivated, reason=" + reason), (Object[])new Object[0]);
        }
        if (this.memberId != null) {
            this.deregisterMember();
        } else if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)(this.getClass().getCanonicalName() + " was deactivated before it was registered, nothing to do."), (Object[])new Object[0]);
        }
        this.heartBeatSenderRef.deactivate(cc);
        this.sslSupport.deactivate(cc);
        this.configAdminRef.deactivate(cc);
        this.executorService.deactivate(cc);
        this.keyStoreServiceRef.deactivate(cc);
        if (this.remoteConnectionHelper != null) {
            this.remoteConnectionHelper.disconnectRemoteConnection();
        }
        this.remoteConnectionHelper = null;
        this.bundleLocation = null;
    }

    private void isActive(String methodName) throws IllegalStateException {
        if (!this.isActiveFlag) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("(CWWKX8054E) Service deactivated while doing operation " + methodName + "."), (Object[])new Object[0]);
            }
            String msg = TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.collective.repository.client.internal.resources.RepositoryClientMessages", (String)"REMOTE_REPOSITORY_CONNECTION_DEACTIVATED", (Object[])new Object[]{methodName}, (String)"CWWKX8054E: The remote repository {0} operation cannot be initiated. The connection service is stopping.");
            throw new IllegalStateException(msg);
        }
    }

    private RemoteConnectionHelper getRemoteConnectionHelper() {
        return this.remoteConnectionHelper;
    }

    @FFDCIgnore(value={ConnectException.class, IOException.class})
    private Object accessMBean(String operation, @Sensitive Object[] params, String[] signature) throws IOException, IllegalArgumentException, IllegalStateException {
        RemoteConnectionHelper remoteConnectionHelper = this.getRemoteConnectionHelper();
        if (remoteConnectionHelper == null) {
            throw new IllegalStateException("RemoteRepositoryConnection not fully initialized, RemoteConnectionHelper is null");
        }
        try {
            if (remoteConnectionHelper.isFailoverEnabled()) {
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"Member is re-registering due to a failover.", (Object[])new Object[0]);
                }
                remoteConnectionHelper.resetFailover();
                if (!operation.equals("registerMember")) {
                    Object[] registerParams = new Object[]{this.heartBeatInterval_s, this.gatherMemberDataUtil.getMemberData()};
                    String[] registerSignature = new String[]{"int", "java.util.Map"};
                    remoteConnectionHelper.invoke("registerMember", registerParams, registerSignature);
                }
            }
            return remoteConnectionHelper.invoke(operation, params, signature);
        }
        catch (ConnectException ce) {
            this.handleLostConnection();
            throw ce;
        }
        catch (IOException ioe) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Caught IOException message: " + ioe.getMessage()), (Object[])new Object[0]);
            }
            if (ioe.getCause() instanceof ConnectException || ioe.getMessage().contains("CWWKX0206E")) {
                this.handleLostConnection();
            }
            throw ioe;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleLostConnection() {
        boolean doCleanUp = false;
        Object object = this.lostConnLock;
        synchronized (object) {
            if (this.connected) {
                this.setConnected(false);
                doCleanUp = true;
            }
        }
        if (doCleanUp) {
            HeartBeatSender hbs = (HeartBeatSender)this.heartBeatSenderRef.getService();
            if (hbs != null) {
                hbs.cancelHeartBeat((RepositoryMemberHeartBeat)this);
            }
            this.unregisterService();
            this.scheduledConnect.schedule();
        }
    }

    public boolean create(String nodeName, @Sensitive Object data) throws IOException, IllegalArgumentException, IllegalStateException {
        if (tc.isDebugEnabled() && (nodeName.endsWith("sys.status") || nodeName.endsWith("State") || nodeName.endsWith("state"))) {
            Tr.debug((TraceComponent)tc, (String)("NodeName=" + nodeName + ", Value=" + data), (Object[])new Object[0]);
        }
        this.isActive("create");
        Object[] params = new Object[]{nodeName, data};
        String[] signature = new String[]{"java.lang.String", "java.lang.Object"};
        Object returnObject = this.accessMBean("create", params, signature);
        return this.processReturnedBoolean(returnObject);
    }

    public boolean delete(String nodeName) throws IOException, IllegalArgumentException, IllegalStateException {
        this.isActive("delete");
        Object[] params = new Object[]{nodeName};
        String[] signature = new String[]{"java.lang.String"};
        Object returnObject = this.accessMBean("delete", params, signature);
        return this.processReturnedBoolean(returnObject);
    }

    public boolean exists(String nodeName) throws IOException, IllegalArgumentException, IllegalStateException {
        this.isActive("exists");
        Object[] params = new Object[]{nodeName};
        String[] signature = new String[]{"java.lang.String"};
        Object returnObject = this.accessMBean("exists", params, signature);
        return this.processReturnedBoolean(returnObject);
    }

    public Object getData(String nodeName) throws IOException, IllegalArgumentException, NoSuchElementException {
        this.isActive("getData");
        Object[] params = new Object[]{nodeName};
        String[] signature = new String[]{"java.lang.String"};
        return this.accessMBean("getData", params, signature);
    }

    public Map<String, Object> getDescendantData(String nodeName) throws IOException, IllegalArgumentException, IllegalStateException, NoSuchElementException {
        this.isActive("getDescendantData");
        Object[] params = new Object[]{nodeName};
        String[] signature = new String[]{"java.lang.String"};
        Object returnObject = this.accessMBean("getDescendantData", params, signature);
        return this.processReturnedMap(returnObject, String.class, Object.class);
    }

    public boolean setData(String nodeName, @Sensitive Object data) throws IOException, IllegalArgumentException, IllegalStateException {
        if (tc.isDebugEnabled() && (nodeName.endsWith("sys.status") || nodeName.endsWith("State") || nodeName.endsWith("state"))) {
            Tr.debug((TraceComponent)tc, (String)("NodeName=" + nodeName + ", Value=" + data), (Object[])new Object[0]);
        }
        this.isActive("setData");
        Object[] params = new Object[]{nodeName, data};
        String[] signature = new String[]{"java.lang.String", "java.lang.Object"};
        Object returnObject = this.accessMBean("setData", params, signature);
        return this.processReturnedBoolean(returnObject);
    }

    public Collection<String> getChildren(String nodeName, boolean absolutePath) throws IOException, IllegalArgumentException, IllegalStateException {
        this.isActive("getChildren");
        Object[] params = new Object[]{nodeName, absolutePath};
        String[] signature = new String[]{"java.lang.String", "boolean"};
        Object returnObject = this.accessMBean("getChildren", params, signature);
        return this.processReturnedStringCollection(returnObject);
    }

    public void sendHeartBeat() throws IOException, IllegalArgumentException {
        if (this.needToSendNewHeartBeatInterval) {
            this.sendHeartBeat(this.heartBeatInterval_s);
            this.needToSendNewHeartBeatInterval = false;
        } else {
            this.isActive("sendHeartBeat");
            Object[] params = new Object[]{this.memberId};
            String[] signature = new String[]{"java.lang.String"};
            if (!this.disableHeartBeat) {
                this.invokeSendHeartBeat(params, signature);
            }
        }
    }

    public void sendHeartBeat(int newHeartBeatInterval) throws IOException, IllegalArgumentException {
        this.isActive("sendHeartBeat");
        Tr.info((TraceComponent)tc, (String)"REMOTE_REPOSITORY_HEARTBEAT_INTERVAL", (Object[])new Object[]{newHeartBeatInterval});
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Sending new heartbeat interval " + newHeartBeatInterval + " for our memberId: " + this.memberId), (Object[])new Object[0]);
        }
        newHeartBeatInterval = Math.max(1, newHeartBeatInterval);
        Object[] params = new Object[]{this.memberId, newHeartBeatInterval};
        String[] signature = new String[]{"java.lang.String", "int"};
        this.invokeSendHeartBeat(params, signature);
        this.getHeartBeatSenderService().startHeartBeat((RepositoryMemberHeartBeat)this, newHeartBeatInterval);
    }

    /*
     * WARNING - void declaration
     */
    protected void invokeSendHeartBeat(Object[] params, String[] signature) throws IOException, IllegalArgumentException {
        try {
            this.accessMBean("sendHeartBeat", params, signature);
            this.resetFailoverTimer();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            void iae;
            FFDCFilter.processException((Throwable)illegalArgumentException, (String)"com.ibm.ws.collective.repository.client.internal.RemoteRepositoryConnection", (String)"1047", (Object)this, (Object[])new Object[]{params, signature});
            this.updateFailoverTimer();
            if (this.handleLostConnection) {
                this.handleLostConnection();
            }
            throw iae;
        }
        catch (RuntimeException iae) {
            void re;
            FFDCFilter.processException((Throwable)iae, (String)"com.ibm.ws.collective.repository.client.internal.RemoteRepositoryConnection", (String)"1053", (Object)this, (Object[])new Object[]{params, signature});
            this.updateFailoverTimer();
            if (this.handleLostConnection) {
                this.handleLostConnection();
            }
            throw re;
        }
        catch (IOException re) {
            void ioe;
            FFDCFilter.processException((Throwable)re, (String)"com.ibm.ws.collective.repository.client.internal.RemoteRepositoryConnection", (String)"1059", (Object)this, (Object[])new Object[]{params, signature});
            this.updateFailoverTimer();
            if (this.handleLostConnection) {
                this.handleLostConnection();
            }
            throw ioe;
        }
    }

    private void resetFailoverTimer() {
        this.startTimeSendHeartBeatFailure = 0L;
        this.handleLostConnection = false;
    }

    private void updateFailoverTimer() {
        long elapsedTime;
        if (this.startTimeSendHeartBeatFailure == 0L) {
            this.startTimeSendHeartBeatFailure = System.nanoTime();
        }
        if ((elapsedTime = (System.nanoTime() - this.startTimeSendHeartBeatFailure) / 1000000L) >= this.maxSendHeartBeatFailure) {
            this.handleLostConnection = true;
        }
    }

    @Trivial
    protected boolean processReturnedBoolean(Object returnObject) {
        if (returnObject == null) {
            throw new IllegalArgumentException("Returned object was null");
        }
        if (!(returnObject instanceof Boolean)) {
            throw new IllegalArgumentException("Returned object was not a Boolean");
        }
        return (Boolean)returnObject;
    }

    @Trivial
    protected Collection<String> processReturnedStringCollection(Object returnObject) {
        if (returnObject == null) {
            return null;
        }
        if (!(returnObject instanceof Collection)) {
            throw new IllegalArgumentException("Returned object was not a String array");
        }
        return (Collection)returnObject;
    }

    @Trivial
    protected String processReturnedString(Object returnObject) {
        if (returnObject == null) {
            return null;
        }
        if (!(returnObject instanceof String)) {
            throw new IllegalArgumentException("Returned object was not a String");
        }
        return (String)returnObject;
    }

    @Trivial
    protected <K, V> Map<K, V> processReturnedMap(Object returnObject, Class<K> keyClass, Class<V> valueClass) {
        if (returnObject == null) {
            return null;
        }
        if (!(returnObject instanceof Map)) {
            throw new IllegalArgumentException("Returned object was not a Map");
        }
        return (Map)returnObject;
    }

    private synchronized void registerService() {
        if (this.repositoryReg != null) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Already registered, will not re-register.", (Object[])new Object[0]);
            }
        } else if (this.bundleContext != null) {
            this.repositoryReg = this.bundleContext.registerService(new String[]{RepositoryClient.class.getName(), RepositoryMember.class.getName()}, (Object)this, null);
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"The bundle context was null, we must have been deactivated before we got here", (Object[])new Object[0]);
            }
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)(this.getClass().getCanonicalName() + " could not register our service because bundle context was null"), (Object[])new Object[0]);
            }
        }
    }

    private synchronized void unregisterService() {
        if (this.repositoryReg != null) {
            this.repositoryReg.unregister();
            this.repositoryReg = null;
        }
    }

    private boolean hasAttemptedInitialConnection() {
        return this.attemptedInitialConnection;
    }

    private void setHasAttemptedInitialConnection() {
        this.attemptedInitialConnection = true;
    }

    @FFDCIgnore(value={IOException.class, Exception.class})
    private synchronized void doScheduledConnect(ScheduledConnect sc) {
        if (this.connected) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"We're already connected, will not attempt to connect again.", (Object[])new Object[0]);
            }
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Attempting to establish a connection to a collective controller.", (Object[])new Object[0]);
        }
        if (this.memberId != null) {
            HeartBeatSender hbs = (HeartBeatSender)this.heartBeatSenderRef.getService();
            if (hbs != null) {
                hbs.cancelHeartBeat((RepositoryMemberHeartBeat)this);
            }
            this.memberId = null;
        }
        try {
            this.registerMember();
        }
        catch (IOException e) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"IOException while attempting connect to collective controller, this can happen if the controller is unreachable", (Object[])new Object[]{e});
            }
        }
        catch (Exception e) {
            if (e instanceof IllegalStateException && e.getCause() instanceof InstanceNotFoundException) {
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"InstanceNotFoundException while registering with collective controller: ", (Object[])new Object[]{e});
                }
            }
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.collective.repository.client.internal.RemoteRepositroyConnection.doScheduledConnect", (String)"1144", (Object)this);
        }
        if (this.memberId == null) {
            sc.schedule();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configurationEvent(ConfigurationEvent event) {
        boolean process;
        RemoteRepositoryConnection remoteRepositoryConnection = this;
        synchronized (remoteRepositoryConnection) {
            process = event.getType() == 1 && this.pids.contains(event.getPid());
        }
        if (process) {
            this.processProperties();
        }
    }

    /*
     * WARNING - void declaration
     */
    public Map<String, Object> getMemberConnectionProperties() {
        HashMap<String, Object> connProperties = new HashMap<String, Object>();
        ArrayList<String> attributes = new ArrayList<String>();
        try {
            List<Endpoint> endpoints = this.processEndpoints(this.properties, attributes);
            int readTimeoutMillis = this.processPropertyReadTimeout(this.properties);
            connProperties.put("Endpoints", endpoints);
            connProperties.put("ReadTimeoutMillis", readTimeoutMillis);
            connProperties.put("SSLConfig", SSL_CONFIG_ID);
        }
        catch (IllegalArgumentException endpoints) {
            void e;
            FFDCFilter.processException((Throwable)endpoints, (String)"com.ibm.ws.collective.repository.client.internal.RemoteRepositoryConnection", (String)"1431", (Object)this, (Object[])new Object[0]);
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Could not gather member connection properties: " + e.getMessage()), (Object[])new Object[]{e});
            }
            throw e;
        }
        return connProperties;
    }

    @Trivial
    private SSLSupport getSSLSupportService() {
        SSLSupport service = (SSLSupport)this.sslSupport.getService();
        if (service == null) {
            if (FrameworkState.isStopping()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Ignore that SSLSupportService is null because Framework is in the process of stopping or already stopped", (Object[])new Object[0]);
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"SSLSupportService is null and Framework is not in the process of stopping or already stopped", (Object[])new Object[0]);
                }
                IllegalStateException ise = new IllegalStateException("The SSLSupport service is not available - it was likely accessed after it was deactivated.");
                ise.fillInStackTrace();
                throw ise;
            }
        }
        return service;
    }

    @Trivial
    private ScheduledExecutorService getScheduledExecutorService() {
        ScheduledExecutorService service = (ScheduledExecutorService)this.executorService.getService();
        if (service == null) {
            if (FrameworkState.isStopping()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Ignore that ScheduledExecutorService is null because Framework is in the process of stopping or already stopped", (Object[])new Object[0]);
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"ScheduledExecutorService is null and Framework is not in the process of stopping or already stopped", (Object[])new Object[0]);
                }
                IllegalStateException ise = new IllegalStateException("The ScheduledExecutorService service is not available - it was likely accessed after it was deactivated.");
                ise.fillInStackTrace();
                throw ise;
            }
        }
        return service;
    }

    @Trivial
    private KeyStoreService getKeyStoreServiceService() {
        KeyStoreService service = (KeyStoreService)this.keyStoreServiceRef.getService();
        if (service == null) {
            if (FrameworkState.isStopping()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Ignore that KeyStoreService is null because Framework is in the process of stopping or already stopped", (Object[])new Object[0]);
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"KeyStoreService is null and Framework is not in the process of stopping or already stopped", (Object[])new Object[0]);
                }
                IllegalStateException ise = new IllegalStateException("The KeyStoreService service is not available - it was likely accessed after it was deactivated.");
                ise.fillInStackTrace();
                throw ise;
            }
        }
        return service;
    }

    @Trivial
    private HeartBeatSender getHeartBeatSenderService() {
        HeartBeatSender service = (HeartBeatSender)this.heartBeatSenderRef.getService();
        if (service == null) {
            if (FrameworkState.isStopping()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Ignore that HeartBeatSenderService is null because Framework is in the process of stopping or already stopped", (Object[])new Object[0]);
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"HeartBeatSenderService is null and Framework is not in the process of stopping or already stopped", (Object[])new Object[0]);
                }
                IllegalStateException ise = new IllegalStateException("The HeartBeatSender service is not available - it was likely accessed after it was deactivated.");
                ise.fillInStackTrace();
                throw ise;
            }
        }
        return service;
    }

    protected void setMaxFailoverTimer(long maxFailoverTimer) {
        this.maxSendHeartBeatFailure = maxFailoverTimer;
    }

    protected void setConnected(boolean connect) {
        this.connected = connect;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    class ScheduledConnect
    implements Callable<Void> {
        private final Random randGen = new Random();
        private boolean isCanceled = false;
        private boolean scheduled = false;
        private final int minInterval = 10;
        private final int maxInterval = 60;
        private ScheduledFuture<Void> scheduledFuture = null;
        static final long serialVersionUID = 8054123031468679891L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        ScheduledConnect() {
        }

        int getInterval() {
            if (RemoteRepositoryConnection.this.hasAttemptedInitialConnection()) {
                return this.randGen.nextInt(60) + 10;
            }
            RemoteRepositoryConnection.this.setHasAttemptedInitialConnection();
            return 1;
        }

        public synchronized void schedule() {
            if (!this.scheduled) {
                if (FrameworkState.isStopping()) {
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)"Framework is stopping, will not schedule any new attempts.", (Object[])new Object[0]);
                    }
                    return;
                }
                if (this.isCanceled) {
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)"Task is canceled, will not schedule any new attempts.", (Object[])new Object[0]);
                    }
                    return;
                }
                int interval = this.getInterval();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Scheduling a connection attempt in " + interval + " seconds"), (Object[])new Object[0]);
                }
                this.scheduledFuture = RemoteRepositoryConnection.this.getScheduledExecutorService().schedule(this, (long)interval, TimeUnit.SECONDS);
                this.scheduled = true;
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public synchronized Void call() throws Exception {
            if (this.isCanceled) {
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"Task is canceled, will not attempt to connect.", (Object[])new Object[0]);
                }
                return null;
            }
            try {
                this.scheduled = false;
                RemoteRepositoryConnection.this.isActive("ScheduledConnect");
                RemoteRepositoryConnection.this.doScheduledConnect(this);
            }
            catch (Throwable throwable) {
                void t;
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.collective.repository.client.internal.RemoteRepositoryConnection$ScheduledConnect", (String)"1380", (Object)this, (Object[])new Object[0]);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Caught throwable during scheduled connection attempt: " + t.getMessage()), (Object[])new Object[0]);
                }
                throw t;
            }
            return null;
        }

        public synchronized void cancel() {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Canceling the currently scheduled future", (Object[])new Object[0]);
            }
            this.isCanceled = true;
            if (this.scheduledFuture != null) {
                this.scheduledFuture.cancel(true);
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.collective.repository.client.internal.RemoteRepositoryConnection$ScheduledConnect", ScheduledConnect.class, (String)"Collective", (String)"com.ibm.ws.collective.repository.client.internal.resources.RepositoryClientMessages");
        }
    }
}

