/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.client.internal.jaas;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.clientcontainer.metadata.CallbackHandlerProvider;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.client.internal.authentication.ClientAuthenticationService;
import com.ibm.ws.security.jaas.common.JAASChangeNotifier;
import com.ibm.ws.security.jaas.common.JAASConfigurationFactory;
import com.ibm.ws.security.jaas.common.JAASLoginContextEntry;
import com.ibm.ws.security.jaas.common.JAASLoginModuleConfig;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.kernel.service.utils.ConcurrentServiceReferenceMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.security.auth.login.Configuration;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={JAASClientService.class}, immediate=true, configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM"})
public class JAASClientService {
    private static volatile JAASClientService ACTIVE_INSTANCE = null;
    private static final TraceComponent tc = Tr.register(JAASClientService.class, (String)"security", (String)"com.ibm.ws.security.client.internal.resources.SecurityClientMessages");
    protected static final String KEY_JAAS_LOGIN_CONTEXT_ENTRY = "jaasLoginContextEntry";
    protected static final String KEY_JAAS_LOGIN_MODULE_CONFIG = "jaasLoginModuleConfig";
    protected static final String KEY_CHANGE_SERVICE = "jaasChangeNotifier";
    public static final String KEY_JAAS_CONFIG_FACTORY = "jaasConfigurationFactory";
    private static final String KEY_ID = "id";
    private static final String KEY_SERVICE_PID = "service.pid";
    public static final String KEY_CALLBACK_PROVIDER = "callbackHandlerProvider";
    public static final String KEY_CLIENT_AUTHN_SERVICE = "clientAuthenticationService";
    private final AtomicServiceReference<ClientAuthenticationService> clientauthenticationServiceRef = new AtomicServiceReference("clientAuthenticationService");
    private final AtomicServiceReference<JAASConfigurationFactory> jaasConfigurationFactoryRef = new AtomicServiceReference("jaasConfigurationFactory");
    private final AtomicServiceReference<CallbackHandlerProvider> callbackHandlerRef = new AtomicServiceReference("callbackHandlerProvider");
    protected ConcurrentServiceReferenceMap<String, JAASLoginContextEntry> jaasLoginContextEntries = new ConcurrentServiceReferenceMap("jaasLoginContextEntry");
    protected final HashSet<ServiceReference<JAASLoginContextEntry>> pendingContextEntryRefs = new HashSet();
    protected final HashSet<String> reportedFailures = new HashSet();
    protected ConcurrentServiceReferenceMap<String, JAASLoginModuleConfig> jaasLoginModuleConfigs = new ConcurrentServiceReferenceMap("jaasLoginModuleConfig");
    private final AtomicServiceReference<JAASChangeNotifier> jaasChangeNotifierService = new AtomicServiceReference("jaasChangeNotifier");
    protected ComponentContext cc;
    protected Map<String, Object> properties;
    private JAASConfigurationFactory jaasConfigurationFactory;
    static final long serialVersionUID = -2752414591637864875L;

    @Reference(service=JAASLoginContextEntry.class, target="(id=*)", name="jaasLoginContextEntry", cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setJaasLoginContextEntry(ServiceReference<JAASLoginContextEntry> ref) {
        this.processContextEntry(ref);
    }

    protected void updatedJaasLoginContextEntry(ServiceReference<JAASLoginContextEntry> ref) {
        this.processContextEntry(ref);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unsetJaasLoginContextEntry(ServiceReference<JAASLoginContextEntry> ref) {
        HashSet<ServiceReference<JAASLoginContextEntry>> hashSet = this.pendingContextEntryRefs;
        synchronized (hashSet) {
            this.jaasLoginContextEntries.removeReference((Object)((String)ref.getProperty(KEY_ID)), ref);
            this.pendingContextEntryRefs.remove(ref);
        }
        this.modified(this.properties);
    }

    @Reference(service=JAASLoginModuleConfig.class, target="(id=*)", name="jaasLoginModuleConfig", cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setJaasLoginModuleConfig(ServiceReference<JAASLoginModuleConfig> ref) {
        String pid = (String)ref.getProperty(KEY_SERVICE_PID);
        this.jaasLoginModuleConfigs.putReference((Object)pid, ref);
        this.addedLoginModule();
    }

    private boolean isDefaultLoginModule(String pid) {
        JAASLoginModuleConfig loginModule = (JAASLoginModuleConfig)this.jaasLoginModuleConfigs.getService((Object)pid);
        if (loginModule != null) {
            return loginModule.isDefaultLoginModule();
        }
        return false;
    }

    protected void updatedJaasLoginModuleConfig(ServiceReference<JAASLoginModuleConfig> ref) {
        this.modified(this.properties);
    }

    protected void unsetJaasLoginModuleConfig(ServiceReference<JAASLoginModuleConfig> ref) {
        String pid = (String)ref.getProperty(KEY_SERVICE_PID);
        this.jaasLoginModuleConfigs.removeReference((Object)pid, ref);
        this.removedLoginModule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processContextEntry(ServiceReference<JAASLoginContextEntry> ref) {
        String id = (String)ref.getProperty(KEY_ID);
        String[] modulePids = (String[])ref.getProperty("loginModuleRef");
        boolean changedEntryContext = false;
        if (modulePids == null || modulePids.length == 0) {
            Tr.error((TraceComponent)tc, (String)"JAAS_LOGIN_CONTEXT_ENTRY_HAS_NO_LOGIN_MODULE", (Object[])new Object[]{id});
            changedEntryContext |= this.jaasLoginContextEntries.removeReference((Object)id, ref);
        } else if (this.haveAllModules(modulePids)) {
            this.jaasLoginContextEntries.putReference((Object)id, ref);
            changedEntryContext = true;
        } else {
            changedEntryContext |= this.jaasLoginContextEntries.removeReference((Object)id, ref);
            HashSet<ServiceReference<JAASLoginContextEntry>> hashSet = this.pendingContextEntryRefs;
            synchronized (hashSet) {
                this.pendingContextEntryRefs.add(ref);
            }
        }
        if (changedEntryContext) {
            this.modified(this.properties);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void addedLoginModule() {
        boolean changedEntries = false;
        HashSet<ServiceReference<JAASLoginContextEntry>> hashSet = this.pendingContextEntryRefs;
        synchronized (hashSet) {
            Iterator<ServiceReference<JAASLoginContextEntry>> i = this.pendingContextEntryRefs.iterator();
            while (i.hasNext()) {
                ServiceReference<JAASLoginContextEntry> contextEntryRef = i.next();
                String[] entryModulePids = (String[])contextEntryRef.getProperty("loginModuleRef");
                if (!this.haveAllModules(entryModulePids)) continue;
                i.remove();
                this.jaasLoginContextEntries.putReference((Object)((String)contextEntryRef.getProperty(KEY_ID)), contextEntryRef);
                changedEntries = true;
            }
        }
        if (changedEntries) {
            this.modified(this.properties);
        }
    }

    private synchronized void removedLoginModule() {
        boolean changedEntries = false;
        Iterator i = this.jaasLoginContextEntries.references().iterator();
        while (i.hasNext()) {
            ServiceReference contextEntryRef = (ServiceReference)i.next();
            String[] entryModulePids = (String[])contextEntryRef.getProperty("loginModuleRef");
            if (this.haveAllModules(entryModulePids)) continue;
            i.remove();
            this.pendingContextEntryRefs.add((ServiceReference<JAASLoginContextEntry>)contextEntryRef);
            changedEntries = true;
        }
        if (changedEntries) {
            this.modified(this.properties);
        }
    }

    private boolean haveAllModules(String[] modulePids) {
        boolean allIsWell = true;
        if (modulePids != null) {
            for (String modulePid : modulePids) {
                if (this.jaasLoginModuleConfigs.getReference((Object)modulePid) != null) continue;
                allIsWell = false;
                break;
            }
        }
        return allIsWell;
    }

    @Reference(service=JAASChangeNotifier.class, name="jaasChangeNotifier")
    protected void setJaasChangeNotifier(ServiceReference<JAASChangeNotifier> jaasChangeNotifierRef) {
        this.jaasChangeNotifierService.setReference(jaasChangeNotifierRef);
    }

    protected void unsetJaasChangeNotifier(ServiceReference<JAASChangeNotifier> jaasChangeNotifierRef) {
        this.jaasChangeNotifierService.unsetReference(jaasChangeNotifierRef);
    }

    @Reference(service=JAASConfigurationFactory.class, name="jaasConfigurationFactory")
    public void setJaasConfigurationFactory(ServiceReference<JAASConfigurationFactory> ref) {
        this.jaasConfigurationFactoryRef.setReference(ref);
    }

    protected void unsetJaasConfigurationFactory(ServiceReference<JAASConfigurationFactory> ref) {
        this.jaasConfigurationFactoryRef.unsetReference(ref);
    }

    @Reference(service=CallbackHandlerProvider.class, name="callbackHandlerProvider")
    public void setCallbackHandlerProvider(ServiceReference<CallbackHandlerProvider> ref) {
        this.callbackHandlerRef.setReference(ref);
    }

    protected void unsetCallbackHandlerProvider(ServiceReference<CallbackHandlerProvider> ref) {
        this.callbackHandlerRef.unsetReference(ref);
    }

    @Reference(service=ClientAuthenticationService.class, name="clientAuthenticationService")
    public void setClientAuthenticationService(ServiceReference<ClientAuthenticationService> ref) {
        this.clientauthenticationServiceRef.setReference(ref);
    }

    protected void unsetClientAuthenticationService(ServiceReference<ClientAuthenticationService> ref) {
        this.clientauthenticationServiceRef.unsetReference(ref);
    }

    @Activate
    public void activate(ComponentContext cc, Map<String, Object> properties) {
        ACTIVE_INSTANCE = this;
        this.jaasLoginModuleConfigs.activate(cc);
        this.jaasLoginContextEntries.activate(cc);
        this.jaasChangeNotifierService.activate(cc);
        this.callbackHandlerRef.activate(cc);
        this.clientauthenticationServiceRef.activate(cc);
        this.jaasConfigurationFactoryRef.activate(cc);
        this.modified(properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Modified
    protected void modified(Map<String, Object> properties) {
        this.properties = properties;
        this.jaasConfigurationFactory = (JAASConfigurationFactory)this.jaasConfigurationFactoryRef.getService();
        if (this.jaasConfigurationFactory != null) {
            this.jaasConfigurationFactory.installJAASConfiguration(this.jaasLoginContextEntries);
            HashSet<ServiceReference<JAASLoginContextEntry>> hashSet = this.pendingContextEntryRefs;
            synchronized (hashSet) {
                if (!this.pendingContextEntryRefs.isEmpty()) {
                    HashSet<String> missingModules = new HashSet<String>();
                    for (ServiceReference<JAASLoginContextEntry> contextEntryRef : this.pendingContextEntryRefs) {
                        String[] entryModulePids;
                        for (String pid : entryModulePids = (String[])contextEntryRef.getProperty("loginModuleRef")) {
                            if (this.isDefaultLoginModule(pid) || this.jaasLoginModuleConfigs.getReference((Object)pid) != null) continue;
                            missingModules.add(pid);
                        }
                    }
                    this.reportedFailures.retainAll(missingModules);
                    for (String missing : missingModules) {
                        if (this.reportedFailures.contains(missing)) continue;
                        if (!this.jaasLoginModuleConfigs.isEmpty()) {
                            Tr.warning((TraceComponent)tc, (String)"JAAS_LOGIN_MODULE_NOT_FOUND_FOR_LOGIN_MODULE_REF", (Object[])new Object[]{missing});
                        }
                        this.reportedFailures.add(missing);
                    }
                } else {
                    this.configReady();
                }
            }
        }
    }

    public void configReady() {
        JAASChangeNotifier notifier = (JAASChangeNotifier)this.jaasChangeNotifierService.getService();
        if (notifier != null) {
            notifier.notifyListeners();
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext cc) {
        this.jaasLoginContextEntries.deactivate(cc);
        this.jaasLoginModuleConfigs.deactivate(cc);
        this.jaasChangeNotifierService.deactivate(cc);
        this.callbackHandlerRef.deactivate(cc);
        this.clientauthenticationServiceRef.deactivate(cc);
        this.jaasConfigurationFactoryRef.deactivate(cc);
        Configuration.setConfiguration(null);
        ACTIVE_INSTANCE = null;
    }

    public static CallbackHandlerProvider getCallbackHandlerProvider() {
        JAASClientService current = ACTIVE_INSTANCE;
        return current == null ? null : (CallbackHandlerProvider)current.callbackHandlerRef.getService();
    }

    public static ClientAuthenticationService getClientAuthenticationService() {
        JAASClientService current = ACTIVE_INSTANCE;
        return current == null ? null : (ClientAuthenticationService)current.clientauthenticationServiceRef.getServiceWithException();
    }
}

