/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.core;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ssl.JSSEProvider;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.kernel.service.util.JavaInfo;
import com.ibm.ws.ssl.JSSEProviderFactory;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.KeyStore;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.Provider;
import java.security.ProviderException;
import java.security.Security;
import java.util.Iterator;
import java.util.ServiceLoader;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;

public final class WSPKCSInKeyStore {
    protected static final TraceComponent tc = Tr.register(WSPKCSInKeyStore.class, (String)"SSL", (String)"com.ibm.ws.ssl.resources.ssl");
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static String pkcsType_ibm = "PKCS11IMPLKS";
    private static String pkcsType_oracle = "PKCS11";
    private static final String IBM_PKCS11_PROVIDER_CLASS_NAME = "com.ibm.crypto.pkcs11impl.provider.IBMPKCS11Impl";
    private static final String ORACLE_PKCS11_PROVIDER_CLASS_NAME = "sun.security.pkcs11.SunPKCS11";
    private static final String IBMPKCS11_PROVIDER_NAME = "IBMPKCS11";
    private static final String IBMPKCS11Impl_PROVIDER_NAME = "IBMPKCS11Impl";
    private static final String SUNPKCS11_PROVIDER_NAME = "SunPKCS11";
    private String pkcsProvider = "IBMPKCS11Impl";
    private String pkcsProviderClass = "com.ibm.crypto.pkcs11impl.provider.IBMPKCS11Impl";
    private String pkcsType = pkcsType_ibm;
    private Provider hwProvider = null;
    private KeyManagerFactory kmf;
    private KeyStore ks;
    private TrustManagerFactory tmf;
    private KeyStore ts;
    private JSSEProvider jsseProvider = null;
    private String tokenLib_key;
    private String tokenType_key;
    private String tokenLib_trust;
    private String tokenType_trust;
    private final int noOfProvidersCreated = 0;
    private BufferedReader fileReader = null;
    private final StringBuilder tokenConfigBuffer = new StringBuilder();
    private String nameAttribute = null;

    public WSPKCSInKeyStore(String tokenConfigName, String ksProvider) throws Exception {
        if (!ksProvider.equals(IBMPKCS11Impl_PROVIDER_NAME)) {
            this.pkcsType = pkcsType_oracle;
            this.pkcsProvider = ksProvider;
            this.pkcsProviderClass = ORACLE_PKCS11_PROVIDER_CLASS_NAME;
        }
        if (ksProvider.equals(IBMPKCS11Impl_PROVIDER_NAME) || ksProvider.equals(SUNPKCS11_PROVIDER_NAME)) {
            this.initializePKCS11ImplProvider(tokenConfigName);
        }
    }

    public void asKeyStore(String tokenType, String tokenlib, String tokenPwd) throws Exception {
        this.jsseProvider = JSSEProviderFactory.getInstance();
        String provider = this.pkcsProvider;
        if (this.hwProvider != null) {
            provider = this.hwProvider.getName();
        }
        try {
            if (this.tokenLib_key != null && this.tokenLib_key.compareToIgnoreCase(tokenlib) == 0 && this.ks != null) {
                return;
            }
            if (this.tokenLib_trust != null && tokenlib.compareTo(this.tokenLib_trust) == 0 && this.ts != null) {
                this.kmf = this.jsseProvider.getKeyManagerFactoryInstance();
                this.ks = this.ts;
                this.kmf.init(this.ts, tokenPwd.toCharArray());
            } else {
                this.kmf = this.jsseProvider.getKeyManagerFactoryInstance();
                this.ks = KeyStore.getInstance(this.pkcsType, provider);
                this.ks.load(null, tokenPwd.toCharArray());
                this.kmf.init(this.ks, tokenPwd.toCharArray());
            }
            this.tokenLib_key = tokenlib;
            this.tokenType_key = tokenType;
        }
        catch (Exception e) {
            this.kmf = null;
            this.ks = null;
            this.tokenLib_key = null;
            this.tokenType_key = null;
            throw e;
        }
    }

    public void asTrustStore(String tokenType, String tokenlib, String tokenPwd) throws Exception {
        this.jsseProvider = JSSEProviderFactory.getInstance();
        String provider = this.pkcsProvider;
        if (this.hwProvider != null) {
            provider = this.hwProvider.getName();
        }
        try {
            if (this.tokenLib_trust != null && this.tokenLib_trust.compareToIgnoreCase(tokenlib) == 0 && this.ts != null) {
                return;
            }
            if (this.tokenLib_key != null && tokenlib.compareTo(this.tokenLib_key) == 0 && this.ks != null) {
                this.tmf = this.jsseProvider.getTrustManagerFactoryInstance();
                this.ts = this.ks;
                this.tmf.init(this.ks);
            } else {
                this.tmf = this.jsseProvider.getTrustManagerFactoryInstance();
                this.ts = KeyStore.getInstance(this.pkcsType, provider);
                this.ts.load(null, tokenPwd.toCharArray());
                this.tmf.init(this.ts);
            }
            this.tokenLib_trust = tokenlib;
            this.tokenType_trust = tokenType;
        }
        catch (Exception e) {
            this.tmf = null;
            this.ts = null;
            this.tokenLib_trust = null;
            this.tokenType_trust = null;
            throw e;
        }
    }

    public KeyManagerFactory getKMF() {
        return this.kmf;
    }

    public KeyStore getKS() {
        return this.ks;
    }

    public TrustManagerFactory getTMF() {
        return this.tmf;
    }

    public KeyStore getTS() {
        return this.ts;
    }

    public String getlibName_key() {
        return this.tokenLib_key;
    }

    public String getlibName_trust() {
        return this.tokenLib_trust;
    }

    public String gettokType_key() {
        return this.tokenType_key;
    }

    public String gettokType_trust() {
        return this.tokenType_trust;
    }

    public void initializePKCS11ImplProvider(String tokenConfigName) throws Exception {
        final String configFile = tokenConfigName;
        try {
            this.hwProvider = AccessController.doPrivileged(new PrivilegedExceptionAction<Provider>(){

                @Override
                public Provider run() throws Exception {
                    Provider p = WSPKCSInKeyStore.this.createPKCS11Provider(configFile);
                    if (p == null) {
                        throw new ProviderException("No PKCS11 provider available.");
                    }
                    Security.addProvider(p);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("The provider: " + p + "is added at the end of the provider list"), (Object[])new Object[0]);
                    }
                    return p;
                }
            });
        }
        catch (PrivilegedActionException e) {
            Exception ex = e.getException();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Cannot initialize IBMPKCS11Impl provider: " + ex), (Object[])new Object[0]);
            }
            FFDCFilter.processException((Throwable)ex, (String)this.getClass().getName(), (String)"initializePKCS11ImplProvider");
            throw ex;
        }
    }

    private Provider createPKCS11Provider(String configFileName) throws Exception {
        Provider provider = null;
        if (JavaInfo.majorVersion() >= 9) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"The java version is 9 or higher so take new path to setup the pkcs11 provider.", (Object[])new Object[0]);
            }
            provider = this.getProvider(configFileName);
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Calling legacy method to setup the pkcs11 provider.", (Object[])new Object[0]);
            }
            provider = this.getProviderLegacy(configFileName);
        }
        return provider;
    }

    private Provider getProviderLegacy(String configFileName) throws Exception {
        Provider provider = null;
        Class<?> pkcs11ProviderClass = Class.forName(this.pkcsProviderClass);
        if (pkcs11ProviderClass != null) {
            if (configFileName != null && !configFileName.isEmpty()) {
                Constructor<?> constructor = pkcs11ProviderClass.getDeclaredConstructor(String.class);
                provider = (Provider)constructor.newInstance(configFileName);
            } else {
                provider = (Provider)pkcs11ProviderClass.newInstance();
            }
        }
        return provider;
    }

    private Provider getProvider(String configFileName) throws Exception {
        ServiceLoader<Provider> sl = ServiceLoader.load(Provider.class);
        Iterator<Provider> iter = sl.iterator();
        Provider p = null;
        while (iter.hasNext()) {
            p = iter.next();
            if (!p.getName().equals(this.pkcsProvider)) continue;
            Method configure = p.getClass().getMethod("configure", String.class);
            configure.invoke((Object)p, configFileName);
            break;
        }
        return p;
    }

    private BufferedReader convertFileToBuffer(String tokenConfigName) throws Exception {
        StringBuilder sb = new StringBuilder();
        String inLine = null;
        try {
            if (this.fileReader == null) {
                this.fileReader = new BufferedReader(new FileReader(tokenConfigName));
                try {
                    while ((inLine = this.fileReader.readLine()) != null) {
                        String str = inLine.trim();
                        if (str.startsWith("name")) {
                            this.nameAttribute = str;
                            continue;
                        }
                        this.tokenConfigBuffer.append(str).append(LINE_SEPARATOR);
                    }
                }
                catch (IOException ioe) {
                    FFDCFilter.processException((Throwable)ioe, (String)this.getClass().getName(), (String)"convertFileToBuffer");
                    throw ioe;
                }
                finally {
                    if (this.fileReader != null) {
                        try {
                            this.fileReader.close();
                        }
                        catch (IOException ioe) {
                            FFDCFilter.processException((Throwable)ioe, (String)this.getClass().getName(), (String)"convertFileToBuffer");
                            throw ioe;
                        }
                    }
                }
            }
            sb.append(this.nameAttribute).append(0).append(LINE_SEPARATOR).append((CharSequence)this.tokenConfigBuffer);
        }
        catch (FileNotFoundException fne) {
            FFDCFilter.processException((Throwable)fne, (String)this.getClass().getName(), (String)"convertFileToBuffer");
            throw fne;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Name attribute and other card related info: " + this.nameAttribute + ":" + this.tokenConfigBuffer.toString()), (Object[])new Object[0]);
        }
        return new BufferedReader(new StringReader(sb.toString()));
    }
}

