/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.common.jaxb;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.annotation.XmlElementDecl;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.transform.dom.DOMSource;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.jaxb.JAXBUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.CacheMap;
import org.apache.cxf.common.util.CachedClass;
import org.apache.cxf.common.util.StringUtils;

public final class JAXBContextCache {
    private static final Logger LOG;
    private static final Map<Set<Class<?>>, Map<String, CachedContextAndSchemasInternal>> JAXBCONTEXT_CACHE;
    private static final Map<Package, CachedClass> OBJECT_FACTORY_CACHE;
    private static final boolean HAS_MOXY;

    private JAXBContextCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearCaches() {
        Map<Object, Object> map = JAXBCONTEXT_CACHE;
        synchronized (map) {
            JAXBCONTEXT_CACHE.clear();
        }
        map = OBJECT_FACTORY_CACHE;
        synchronized (map) {
            OBJECT_FACTORY_CACHE.clear();
        }
    }

    public static void scanPackages(Set<Class<?>> classes) {
        JAXBUtils.scanPackages(classes, OBJECT_FACTORY_CACHE);
    }

    public static CachedContextAndSchemas getCachedContextAndSchemas(Class<?> ... cls) throws JAXBException {
        HashSet classes = new HashSet();
        for (Class<?> c : cls) {
            classes.add(c);
        }
        JAXBContextCache.scanPackages(classes);
        return JAXBContextCache.getCachedContextAndSchemas(classes, null, null, null, false);
    }

    public static CachedContextAndSchemas getCachedContextAndSchemas(String pkg, Map<String, Object> props, ClassLoader loader) throws JAXBException {
        HashSet classes = new HashSet();
        JAXBContextCache.addPackage(classes, pkg, loader);
        return JAXBContextCache.getCachedContextAndSchemas(classes, null, props, null, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CachedContextAndSchemas getCachedContextAndSchemas(final Set<Class<?>> classes, String defaultNs, Map<String, Object> props, Collection<Object> typeRefs, boolean exact) throws JAXBException {
        Map<String, CachedContextAndSchemasInternal> cachedContextAndSchemasInternalMap;
        JAXBContext context;
        CachedContextAndSchemasInternal cachedContextAndSchemasInternal;
        block27: {
            HashMap<String, Object> map;
            boolean isLoggableFine;
            block28: {
                isLoggableFine = LOG.isLoggable(Level.FINE);
                for (Class<?> clz : classes) {
                    if (!clz.getName().endsWith("ObjectFactory") || !JAXBContextCache.checkObjectFactoryNamespaces(clz)) continue;
                    defaultNs = null;
                }
                map = new HashMap<String, Object>();
                if (defaultNs != null) {
                    if (HAS_MOXY) {
                        map.put("eclipselink.default-target-namespace", defaultNs);
                    }
                    map.put("org.glassfish.jaxb.defaultNamespaceRemap", defaultNs);
                }
                if (props != null) {
                    map.putAll(props);
                }
                cachedContextAndSchemasInternal = null;
                context = null;
                cachedContextAndSchemasInternalMap = null;
                if (typeRefs != null && !typeRefs.isEmpty()) break block28;
                Map<Set<Class<?>>, Map<String, CachedContextAndSchemasInternal>> map2 = JAXBCONTEXT_CACHE;
                synchronized (map2) {
                    block30: {
                        block29: {
                            if (!exact) break block29;
                            cachedContextAndSchemasInternalMap = JAXBCONTEXT_CACHE.get(classes);
                            if (cachedContextAndSchemasInternalMap == null || defaultNs == null) break block30;
                            cachedContextAndSchemasInternal = cachedContextAndSchemasInternalMap.get(defaultNs);
                            break block30;
                        }
                        for (Map.Entry<Set<Class<?>>, Map<String, CachedContextAndSchemasInternal>> k : JAXBCONTEXT_CACHE.entrySet()) {
                            Set<Class<Class<?>>> key = k.getKey();
                            if (key == null || !key.containsAll(classes)) continue;
                            cachedContextAndSchemasInternalMap = k.getValue();
                            if (defaultNs != null) {
                                cachedContextAndSchemasInternal = cachedContextAndSchemasInternalMap.get(defaultNs);
                                break;
                            }
                            cachedContextAndSchemasInternal = cachedContextAndSchemasInternalMap.get("");
                            break;
                        }
                    }
                    if (cachedContextAndSchemasInternal != null) {
                        context = cachedContextAndSchemasInternal.getContext();
                        if (context == null) {
                            Set<Class<?>> cls = cachedContextAndSchemasInternal.getClasses();
                            if (cls != null) {
                                JAXBCONTEXT_CACHE.remove(cls);
                            }
                        } else {
                            if (isLoggableFine) {
                                LOG.fine("JAXBContext found in cache.");
                            }
                            return new CachedContextAndSchemas(context, cachedContextAndSchemasInternal.getClasses(), cachedContextAndSchemasInternal);
                        }
                    }
                }
            }
            try {
                long startTime = System.currentTimeMillis();
                context = JAXBContextCache.createContext(classes, map, typeRefs);
                if (isLoggableFine) {
                    long endTime = System.currentTimeMillis();
                    int elapsedTime = (int)(endTime - startTime);
                    LOG.fine("JAXBContext creation time in milliseconds: " + elapsedTime);
                }
            }
            catch (JAXBException ex) {
                boolean added;
                if (isLoggableFine) {
                    LOG.fine("Exception from createContext: " + (Object)((Object)ex));
                }
                if (added = JAXBContextCache.addJaxbObjectFactory(ex, classes)) {
                    try {
                        long startTime = System.currentTimeMillis();
                        context = AccessController.doPrivileged(new PrivilegedExceptionAction<JAXBContext>(){

                            @Override
                            public JAXBContext run() throws Exception {
                                return JAXBContext.newInstance((Class[])classes.toArray(new Class[0]), null);
                            }
                        });
                        if (isLoggableFine) {
                            long endTime = System.currentTimeMillis();
                            int elapsedTime = (int)(endTime - startTime);
                            LOG.fine("JAXBContext2 creation time in milliseconds: " + elapsedTime);
                        }
                    }
                    catch (PrivilegedActionException e) {
                        throw ex;
                    }
                }
                if (context != null) break block27;
                throw ex;
            }
        }
        cachedContextAndSchemasInternal = new CachedContextAndSchemasInternal(context, classes);
        Map<Set<Class<?>>, Map<String, CachedContextAndSchemasInternal>> map = JAXBCONTEXT_CACHE;
        synchronized (map) {
            if (typeRefs == null || typeRefs.isEmpty()) {
                if (cachedContextAndSchemasInternalMap == null) {
                    cachedContextAndSchemasInternalMap = new CacheMap<String, CachedContextAndSchemasInternal>();
                }
                cachedContextAndSchemasInternalMap.put(defaultNs != null ? defaultNs : "", cachedContextAndSchemasInternal);
                JAXBCONTEXT_CACHE.put(classes, cachedContextAndSchemasInternalMap);
            }
        }
        return new CachedContextAndSchemas(context, classes, cachedContextAndSchemasInternal);
    }

    private static boolean checkObjectFactoryNamespaces(Class<?> clz) {
        for (Method meth : clz.getMethods()) {
            XmlElementDecl decl = meth.getAnnotation(XmlElementDecl.class);
            if (decl == null || !XmlElementDecl.GLOBAL.class.equals((Object)decl.scope()) || !StringUtils.isEmpty(decl.namespace())) continue;
            return true;
        }
        return false;
    }

    private static JAXBContext createContext(final Set<Class<?>> classes, final Map<String, Object> map, Collection<Object> typeRefs) throws JAXBException {
        JAXBContext ctx;
        boolean isLoggableFinest = LOG.isLoggable(Level.FINEST);
        if (typeRefs != null && !typeRefs.isEmpty()) {
            String pfx;
            Class<?> fact;
            block13: {
                fact = null;
                pfx = "org.glassfish.jaxb.runtime.";
                try {
                    fact = ClassLoaderUtils.loadClass("org.glassfish.jaxb.runtime.v2.ContextFactory", JAXBContextCache.class);
                }
                catch (Throwable t) {
                    try {
                        fact = ClassLoaderUtils.loadClass("com.sun.xml.internal.bind.v2.ContextFactory", JAXBContextCache.class);
                        pfx = "org.glassfish.jaxb.";
                    }
                    catch (Throwable t2) {
                        if (!isLoggableFinest) break block13;
                        LOG.finest("Ignoring throwable t2: " + t2);
                    }
                }
            }
            if (fact != null) {
                for (Method m : fact.getMethods()) {
                    if (!"createContext".equals(m.getName()) || m.getParameterTypes().length != 9) continue;
                    try {
                        return (JAXBContext)m.invoke(null, classes.toArray(new Class[0]), typeRefs, map.get(pfx + "subclassReplacements"), map.get(pfx + "defaultNamespaceRemap"), map.get(pfx + "c14n") == null ? Boolean.FALSE : map.get(pfx + "c14n"), map.get(pfx + "v2.model.annotation.RuntimeAnnotationReader"), map.get(pfx + "XmlAccessorFactory") == null ? Boolean.FALSE : map.get(pfx + "XmlAccessorFactory"), map.get(pfx + "treatEverythingNillable") == null ? Boolean.FALSE : map.get(pfx + "treatEverythingNillable"), map.get("retainReferenceToInfo") == null ? Boolean.FALSE : map.get("retainReferenceToInfo"));
                    }
                    catch (Throwable e) {
                        if (!isLoggableFinest) continue;
                        LOG.finest("createContext: Ignoring throwable: " + e);
                    }
                }
            }
        }
        try {
            ctx = AccessController.doPrivileged(new PrivilegedExceptionAction<JAXBContext>(){

                @Override
                public JAXBContext run() throws Exception {
                    return JAXBContext.newInstance((Class[])classes.toArray(new Class[0]), (Map)map);
                }
            });
        }
        catch (PrivilegedActionException e2) {
            if (e2.getException() instanceof JAXBException) {
                JAXBException ex = (JAXBException)((Object)e2.getException());
                if (map.containsKey("org.glassfish.jaxb.defaultNamespaceRemap") && ex.getMessage() != null && ex.getMessage().contains("org.glassfish.jaxb.defaultNamespaceRemap")) {
                    map.put("org.glassfish.jaxb.defaultNamespaceRemap", map.remove("org.glassfish.jaxb.defaultNamespaceRemap"));
                    ctx = JAXBContext.newInstance((Class[])classes.toArray(new Class[0]), map);
                }
                throw ex;
            }
            throw new RuntimeException(e2.getException());
        }
        return ctx;
    }

    private static boolean addJaxbObjectFactory(JAXBException e1, Set<Class<?>> classes) {
        boolean added = false;
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        PrintStream pout = new PrintStream(bout);
        e1.printStackTrace(pout);
        String str = new String(bout.toByteArray());
        Pattern pattern = Pattern.compile("(?<=There's\\sno\\sObjectFactory\\swith\\san\\s@XmlElementDecl\\sfor\\sthe\\selement\\s\\{)\\S*(?=\\})");
        Matcher matcher = pattern.matcher(str);
        while (matcher.find()) {
            String pkgName = JAXBUtils.namespaceURIToPackage(matcher.group());
            try {
                Class<?> clz = JAXBContextCache.class.getClassLoader().loadClass(pkgName + ".ObjectFactory");
                if (classes.contains(clz)) continue;
                classes.add(clz);
                added = true;
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        return added;
    }

    public static void addPackage(Set<Class<?>> classes, String pkg, ClassLoader loader) {
        block23: {
            boolean isLoggableFinest;
            block21: {
                isLoggableFinest = LOG.isLoggable(Level.FINEST);
                try {
                    classes.add(Class.forName(pkg + ".ObjectFactory", false, loader));
                }
                catch (Exception ex) {
                    if (!isLoggableFinest) break block21;
                    LOG.finest("addPackage: Ignoring exception: " + ex);
                }
            }
            try (InputStream ins = loader.getResourceAsStream('/' + pkg.replace('.', '/') + "/jaxb.index");
                 BufferedReader reader = new BufferedReader(new InputStreamReader(ins, StandardCharsets.UTF_8));){
                if (!StringUtils.isEmpty(pkg)) {
                    pkg = pkg + '.';
                }
                String line = reader.readLine();
                while (line != null) {
                    block22: {
                        if ((line = line.trim()).indexOf(35) != -1) {
                            line = line.substring(0, line.indexOf(35));
                        }
                        if (!StringUtils.isEmpty(line)) {
                            try {
                                Class<?> ncls = Class.forName(pkg + line, false, loader);
                                classes.add(ncls);
                            }
                            catch (Exception e) {
                                if (!isLoggableFinest) break block22;
                                LOG.finest("addPackage: Ignoring exception 1: " + e);
                            }
                        }
                    }
                    line = reader.readLine();
                }
            }
            catch (Exception ex) {
                if (!isLoggableFinest) break block23;
                LOG.finest("addPackage: Ignoring exception 2: " + ex);
            }
        }
    }

    static {
        boolean b;
        block2: {
            LOG = LogUtils.getLogger(JAXBContextCache.class);
            JAXBCONTEXT_CACHE = new CacheMap();
            OBJECT_FACTORY_CACHE = new CacheMap<Package, CachedClass>();
            b = false;
            try {
                JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{String.class});
                b = ctx.getClass().getName().contains(".eclipse");
            }
            catch (Throwable t) {
                if (!LOG.isLoggable(Level.FINEST)) break block2;
                LOG.finest("Ignoring throwable: " + t);
            }
        }
        HAS_MOXY = b;
    }

    public static final class CachedContextAndSchemas {
        private final JAXBContext context;
        private final Set<Class<?>> classes;
        private final WeakReference<CachedContextAndSchemasInternal> ccas;

        private CachedContextAndSchemas(JAXBContext context, Set<Class<?>> classes, CachedContextAndSchemasInternal i) {
            this.context = context;
            this.classes = classes;
            this.ccas = new WeakReference<CachedContextAndSchemasInternal>(i);
        }

        public JAXBContext getContext() {
            return this.context;
        }

        public Set<Class<?>> getClasses() {
            return this.classes;
        }

        public Collection<DOMSource> getSchemas() {
            CachedContextAndSchemasInternal i = (CachedContextAndSchemasInternal)this.ccas.get();
            if (i != null) {
                return i.getSchemas();
            }
            return null;
        }

        public void setSchemas(Collection<DOMSource> schemas) {
            CachedContextAndSchemasInternal i = (CachedContextAndSchemasInternal)this.ccas.get();
            if (i != null) {
                i.setSchemas(schemas);
            }
        }
    }

    private static final class CachedContextAndSchemasInternal {
        private final WeakReference<JAXBContext> context;
        private final WeakReference<Set<Class<?>>> classes;
        private Collection<DOMSource> schemas;

        CachedContextAndSchemasInternal(JAXBContext context, Set<Class<?>> classes) {
            this.context = new WeakReference<JAXBContext>(context);
            this.classes = new WeakReference(classes);
        }

        public JAXBContext getContext() {
            return (JAXBContext)this.context.get();
        }

        public Set<Class<?>> getClasses() {
            return (Set)this.classes.get();
        }

        public Collection<DOMSource> getSchemas() {
            return this.schemas;
        }

        public void setSchemas(Collection<DOMSource> schemas) {
            this.schemas = schemas;
        }
    }
}

