/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.collective.routing.member.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.collective.routing.member.EndpointRoutingInfoMBean;
import com.ibm.ws.collective.routing.member.VHostChangeListener;
import com.ibm.ws.collective.routing.member.VHostRoutingInfoManager;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.webcontainer.osgi.mbeans.GeneratePluginConfigMBean;
import com.ibm.wsspi.channelfw.utils.HostNameUtils;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.webcontainer.osgi.mbeans.GeneratePluginConfig;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.AttributeChangeNotification;
import javax.management.DynamicMBean;
import javax.management.MBeanNotificationInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationBroadcasterSupport;
import javax.management.StandardEmitterMBean;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(immediate=true, service={VHostRoutingInfoManager.class, EndpointRoutingInfoMBean.class, DynamicMBean.class}, configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM", "jmx.objectname=WebSphere:feature=collectiveMember,type=EndpointRoutingInfo,name=EndpointRoutingInfo"})
public class EndpointRoutingInfoMBeanImpl
extends StandardEmitterMBean
implements EndpointRoutingInfoMBean,
VHostRoutingInfoManager {
    private static final TraceComponent tc = Tr.register(EndpointRoutingInfoMBeanImpl.class, (String)"Collective", (String)"com.ibm.ws.collective.routing.member.internal.resources.RoutingMemberMessages");
    private volatile Map<String, Object> configMap = null;
    private volatile GeneratePluginConfig pluginConfig = null;
    static final String CFG_CONNECT_TIMEOUT = "connectTimeout";
    static final String CFG_SERVER_IO_TIMEOUT = "serverIOTimeout";
    static final String CFG_SERVER_WS_IO_TIMEOUT = "wsServerIOTimeout";
    static final String CFG_SERVER_WS_IDLE_TIMEOUT = "wsServerIdleTimeout";
    static final String CFG_WAIT_FOR_CONTINUE = "waitForContinue";
    static final String CFG_HTTP_ENDPOINT_REF = "httpEndpointRef";
    static final String HTTPENDPOINT_PID = "service.pid";
    static final String HTTPENDPOINT_DISPLAY_ID = "config.displayId";
    static final String HTTPENDPOINT_HOST = "host";
    static final String HTTPENDPOINT_HTTP_PORT = "httpPort";
    static final String HTTPENDPOINT_HTTPS_PORT = "httpsPort";
    static final String HTTPENDPOINT_HTTP_OPTIONS_REF = "httpOptionsRef";
    static final String HTTPENDPOINT_ENABLED = "enabled";
    static final String HTTPOPTIONS_DISPLAY_ID = "config.displayId";
    static final String HTTPOPTIONS_PID = "service.pid";
    static final String HTTPOPTIONS_PERSIST_TIMEOUT = "persistTimeout";
    private final AtomicLong sequenceNum = new AtomicLong();
    static final String ATTRIBUTE_NAME_VIRTUAL_HOSTS = "VirtualHosts";
    private static final String VHOST_TRACKER_FILTER_SUFFIX = "(&(|(enabled=true)(id=default_host))(objectClass=com.ibm.wsspi.http.VirtualHost))";
    private volatile String httpEndpointRef;
    private volatile EndpointAttributes epaCurrent = new EndpointAttributes(null, null, null, null);
    private ServiceTracker<Object, ServiceReference<?>> httpEndpointTracker = null;
    private String httpOptionsRef = null;
    private ServiceTracker<Object, ServiceReference<?>> httpOptionsTracker = null;
    private ServiceTracker<Object, ServiceReference<?>> virtualHostTracker = null;
    private final Object trackerLock = new Object(){
        static final long serialVersionUID = 5860161711030778147L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.collective.routing.member.internal.EndpointRoutingInfoMBeanImpl$1", 1.class, (String)"Collective", (String)"com.ibm.ws.collective.routing.member.internal.resources.RoutingMemberMessages");
        }
    };
    private final AtomicServiceReference<ExecutorService> executorService = new AtomicServiceReference("executorService");
    private final CopyOnWriteArrayList<VHostChangeListener> vhostChangeListeners = new CopyOnWriteArrayList();
    private final Map<String, Collection<String>> virtualHosts = new ConcurrentHashMap<String, Collection<String>>();
    private final Object actionLock = new Object(){
        static final long serialVersionUID = 3244544701846816582L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.collective.routing.member.internal.EndpointRoutingInfoMBeanImpl$2", 2.class, (String)"Collective", (String)"com.ibm.ws.collective.routing.member.internal.resources.RoutingMemberMessages");
        }
    };
    private final LinkedList<Runnable> actionQueue = new LinkedList();
    private Future<?> actionFuture = null;
    private final Runnable actionsRunner = new Runnable(){
        static final long serialVersionUID = -6800937867558222829L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Trivial
        public void run() {
            while (true) {
                Runnable r;
                LinkedList linkedList = EndpointRoutingInfoMBeanImpl.this.actionQueue;
                synchronized (linkedList) {
                    r = (Runnable)EndpointRoutingInfoMBeanImpl.this.actionQueue.poll();
                    if (r == null) {
                        EndpointRoutingInfoMBeanImpl.this.actionFuture = null;
                        return;
                    }
                }
                r.run();
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.collective.routing.member.internal.EndpointRoutingInfoMBeanImpl$3", 3.class, (String)"Collective", (String)"com.ibm.ws.collective.routing.member.internal.resources.RoutingMemberMessages");
        }
    };
    static final long serialVersionUID = 6554698274543869069L;

    @Override
    public void addVHostChangeListener(VHostChangeListener listener) {
        this.vhostChangeListeners.add(listener);
    }

    @Override
    public void removeVHostChangeListener(VHostChangeListener listener) {
        this.vhostChangeListeners.remove(listener);
    }

    @Override
    public Map<String, Collection<String>> getVirtualHosts() {
        return this.virtualHosts;
    }

    /*
     * WARNING - void declaration
     */
    private void notifyVHostChangeListeners(EndpointRepositoryPublisherElement element) {
        if (this.vhostChangeListeners != null) {
            String vhostName = null;
            String[] newAliases = null;
            String[] oldAliases = null;
            if (null != element.getNewValue()) {
                vhostName = ((VirtualHost)element.getNewValue()).vhostName;
                newAliases = ((VirtualHost)element.getNewValue()).aliases;
            }
            if (null != element.getOldValue()) {
                oldAliases = ((VirtualHost)element.getOldValue()).aliases;
            }
            for (VHostChangeListener listener : this.vhostChangeListeners) {
                try {
                    listener.onVhostChange(vhostName, oldAliases, newAliases);
                }
                catch (Throwable throwable) {
                    void t;
                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.collective.routing.member.internal.EndpointRoutingInfoMBeanImpl", (String)"213", (Object)this, (Object[])new Object[]{element});
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("Call to " + listener.getClass().getSimpleName() + ".onVhostChange threw " + t.toString()), (Object[])new Object[0]);
                }
            }
        }
    }

    public EndpointRoutingInfoMBeanImpl() throws NotCompliantMBeanException {
        super(EndpointRoutingInfoMBean.class, new NotificationBroadcasterSupport((Executor)null, new MBeanNotificationInfo(new String[]{"jmx.attribute.change"}, AttributeChangeNotification.class.getName(), "")));
    }

    /*
     * WARNING - void declaration
     */
    @Activate
    protected void activate(ComponentContext context) {
        this.executorService.activate(context);
        try {
            BundleContext bundleContext = context.getBundleContext();
            Filter vHostFilter = bundleContext.createFilter(VHOST_TRACKER_FILTER_SUFFIX);
            this.virtualHostTracker = new ServiceTracker(bundleContext, vHostFilter, (ServiceTrackerCustomizer)new VirtualHostServiceTrackerCustomizer());
            this.performUpdates(null, null, this.pluginConfig, this.configMap);
            this.virtualHostTracker.open();
        }
        catch (InvalidSyntaxException bundleContext) {
            void e;
            FFDCFilter.processException((Throwable)bundleContext, (String)"com.ibm.ws.collective.routing.member.internal.EndpointRoutingInfoMBeanImpl", (String)"367", (Object)this, (Object[])new Object[]{context});
            throw new RuntimeException("InvalidSyntaxException while registering virtual host ServiceTracker. This is VERY unexpected.", (Throwable)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"EndpointRoutingInfoMBean activated for server.", (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deactivate
    protected void deactivate(ComponentContext context) {
        this.executorService.deactivate(context);
        Object object = this.trackerLock;
        synchronized (object) {
            if (null != this.httpEndpointTracker) {
                this.httpEndpointTracker.close();
            }
            if (null != this.httpOptionsTracker) {
                this.httpOptionsTracker.close();
            }
        }
        if (null != this.virtualHostTracker) {
            this.virtualHostTracker.close();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"EndpointRoutingInfoMBean deactivated for server.", (Object[])new Object[0]);
        }
    }

    @Reference(name="executorService", service=ExecutorService.class, policy=ReferencePolicy.DYNAMIC)
    protected void setExecutorService(ServiceReference<ExecutorService> executorService) {
        this.executorService.setReference(executorService);
    }

    protected void unsetExecutorService(ServiceReference<ExecutorService> executorService) {
        this.executorService.unsetReference(executorService);
    }

    @Reference(name="cfgPlugin", service=GeneratePluginConfig.class, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, cardinality=ReferenceCardinality.MANDATORY)
    protected void setCfgPlugin(GeneratePluginConfig config, Map<String, Object> configMap) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)this, (TraceComponent)tc, (String)"set PluginConfigMBean ", (Object[])new Object[]{this});
        }
        this.updatedCfgPlugin(config, configMap);
    }

    protected void updatedCfgPlugin(GeneratePluginConfig config, Map<String, Object> configMap) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)this, (TraceComponent)tc, (String)"update PluginConfigMBean ", (Object[])new Object[]{this});
        }
        Map<String, Object> oldMap = this.configMap;
        GeneratePluginConfig oldPluginCfg = this.pluginConfig;
        this.configMap = configMap;
        this.pluginConfig = config;
        if (this.virtualHostTracker != null && (oldMap != configMap || oldPluginCfg != this.pluginConfig)) {
            this.performUpdates(oldPluginCfg, oldMap, config, configMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void performUpdates(GeneratePluginConfig oldCfg, Map<String, Object> oldConfigMap, GeneratePluginConfig config, Map<String, Object> configMap) {
        boolean trackerModified = false;
        String newHttpEndpointRef = (String)configMap.get(CFG_HTTP_ENDPOINT_REF);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"RepositoryPublisher: updating Endpoint Routing Info in repository", (Object[])new Object[0]);
        }
        Long oldConnectTimeout = null;
        Long oldIoTimeout = null;
        Long oldWsIoTimeout = null;
        Long oldWsIdleTimeout = null;
        Boolean oldWaitForContinue = null;
        ArrayList<EndpointRepositoryPublisherElement> elements = new ArrayList<EndpointRepositoryPublisherElement>();
        if (oldConfigMap != null) {
            oldConnectTimeout = (Long)oldConfigMap.get(CFG_CONNECT_TIMEOUT);
            oldIoTimeout = (Long)oldConfigMap.get(CFG_SERVER_IO_TIMEOUT);
            oldWsIoTimeout = (Long)oldConfigMap.get(CFG_SERVER_WS_IO_TIMEOUT);
            oldWsIdleTimeout = (Long)oldConfigMap.get(CFG_SERVER_WS_IDLE_TIMEOUT);
            oldWaitForContinue = (Boolean)oldConfigMap.get(CFG_WAIT_FOR_CONTINUE);
        }
        Long newConnectTimeout = (Long)configMap.get(CFG_CONNECT_TIMEOUT);
        Long newIoTimeout = (Long)configMap.get(CFG_SERVER_IO_TIMEOUT);
        Long newWsIoTimeout = (Long)configMap.get(CFG_SERVER_WS_IO_TIMEOUT);
        Long newWsIdleTimeout = (Long)configMap.get(CFG_SERVER_WS_IDLE_TIMEOUT);
        Boolean newWaitForContinue = (Boolean)configMap.get(CFG_WAIT_FOR_CONTINUE);
        if (oldIoTimeout != null && !oldIoTimeout.equals(newIoTimeout)) {
            elements.add(new EndpointRepositoryPublisherElement("IoTimeout", "java.lang.String", oldIoTimeout, newIoTimeout));
        }
        if (oldWsIoTimeout != null && !oldWsIoTimeout.equals(newWsIoTimeout)) {
            elements.add(new EndpointRepositoryPublisherElement("WsIoTimeout", "java.lang.String", oldWsIoTimeout, newWsIoTimeout));
        }
        if (oldWsIdleTimeout != null && !oldWsIdleTimeout.equals(newWsIdleTimeout)) {
            elements.add(new EndpointRepositoryPublisherElement("WsIdleTimeout", "java.lang.String", oldWsIdleTimeout, newWsIdleTimeout));
        }
        if (oldConnectTimeout != null && !oldConnectTimeout.equals(newConnectTimeout)) {
            elements.add(new EndpointRepositoryPublisherElement("ConnectTimeout", "java.lang.String", oldConnectTimeout, newConnectTimeout));
        }
        if (oldWaitForContinue != null && !oldWaitForContinue.equals(newWaitForContinue)) {
            elements.add(new EndpointRepositoryPublisherElement("WaitForContinue", "java.lang.Boolean", oldWaitForContinue, newWaitForContinue));
        }
        if (!elements.isEmpty()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("Publishing " + elements.size() + " change elements"), (Object[])new Object[0]);
            }
            this.performAction(new EndpointRepositoryPublisher(elements));
        }
        if (null == newHttpEndpointRef) {
            EndpointAttributes epaOld;
            Object object = this.trackerLock;
            synchronized (object) {
                EndpointAttributes epaNew;
                epaOld = this.epaCurrent;
                if (null != this.httpEndpointTracker) {
                    this.httpEndpointTracker.close();
                }
                if (null != this.httpOptionsTracker) {
                    this.httpOptionsTracker.close();
                }
                this.httpEndpointTracker = null;
                this.httpOptionsTracker = null;
                trackerModified = true;
                this.epaCurrent = epaNew = new EndpointAttributes(null, null, null, null);
            }
            this.performEndpointUpdates(epaOld, this.epaCurrent);
            Tr.error((TraceComponent)tc, (String)"Routing.config.endpoint.is.not.available", (Object[])new Object[0]);
        } else if (!newHttpEndpointRef.equals(this.httpEndpointRef)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"Starting to track new httpEndpointRef", (Object[])new Object[0]);
            }
            Object object = this.trackerLock;
            synchronized (object) {
                this.httpEndpointRef = newHttpEndpointRef;
                if (null != this.httpEndpointTracker) {
                    this.httpEndpointTracker.close();
                }
                try {
                    this.httpEndpointTracker = new ServiceTracker(((GeneratePluginConfigMBean)this.pluginConfig).getBundleContext(), ((GeneratePluginConfigMBean)this.pluginConfig).getBundleContext().createFilter("(service.pid=" + this.httpEndpointRef + ")"), (ServiceTrackerCustomizer)new HttpEndpointServiceTrackerCustomizer());
                    this.httpEndpointTracker.open(true);
                }
                catch (InvalidSyntaxException invalidSyntaxException) {
                    void ise;
                    FFDCFilter.processException((Throwable)invalidSyntaxException, (String)"com.ibm.ws.collective.routing.member.internal.EndpointRoutingInfoMBeanImpl", (String)"541", (Object)this, (Object[])new Object[]{oldCfg, oldConfigMap, config, configMap});
                    throw new RuntimeException("InvalidSyntaxException while registering ServiceTracker. This is VERY unexpected.", (Throwable)ise);
                }
                trackerModified = true;
            }
        }
        if (trackerModified) {
            this.updateAndPublishVirtualHostInfo();
        }
    }

    private void performEndpointUpdates(EndpointAttributes epaOld, EndpointAttributes epaNew) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"Updating Transport config in repository", (Object[])new Object[0]);
        }
        ArrayList<EndpointRepositoryPublisherElement> elements = new ArrayList<EndpointRepositoryPublisherElement>();
        if (null != epaNew.host && !epaNew.host.equals(epaOld.host) || null != epaOld.host && !epaOld.host.equals(epaNew.host)) {
            elements.add(new EndpointRepositoryPublisherElement("Host", "java.lang.String", epaOld.host, epaNew.host));
        }
        if (null != epaNew.httpPort && !epaNew.httpPort.equals(epaOld.httpPort) || null != epaOld.httpPort && !epaOld.httpPort.equals(epaNew.httpPort)) {
            Integer newHttpPort = this.getPortFromEnvironment(epaNew.httpPort, "memberHttpPort");
            elements.add(new EndpointRepositoryPublisherElement("HttpPort", "java.lang.Integer", epaOld.httpPort, newHttpPort));
        }
        if (null != epaNew.httpsPort && !epaNew.httpsPort.equals(epaOld.httpsPort) || null != epaOld.httpsPort && !epaOld.httpsPort.equals(epaNew.httpsPort)) {
            Integer newHttpsPort = this.getPortFromEnvironment(epaNew.httpsPort, "memberHttpsPort");
            elements.add(new EndpointRepositoryPublisherElement("HttpsPort", "java.lang.Integer", epaOld.httpsPort, newHttpsPort));
        }
        if (null != epaNew.persistTimeout && !epaNew.persistTimeout.equals(epaOld.persistTimeout) || null != epaOld.persistTimeout && !epaOld.persistTimeout.equals(epaNew.persistTimeout)) {
            elements.add(new EndpointRepositoryPublisherElement("PersistentTimeout", "java.lang.Long", epaOld.persistTimeout, epaNew.persistTimeout));
        }
        if (!elements.isEmpty()) {
            this.performAction(new EndpointRepositoryPublisher(elements));
        }
    }

    protected void unsetCfgPlugin(GeneratePluginConfig config) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Trivial
    @FFDCIgnore(value={FileNotFoundException.class, IOException.class})
    private Integer getPortFromEnvironment(Integer defaultPortValue, String portName) {
        Integer newPortValue = defaultPortValue == null ? null : new Integer(defaultPortValue);
        FileInputStream fis = null;
        Properties fileProperties = new Properties();
        try {
            fis = new FileInputStream("/opt/ibm/docker/env.properties");
            fileProperties.load(fis);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"Loaded Docker env.properties", (Object[])new Object[0]);
            }
        }
        catch (FileNotFoundException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"Docker env.properties not found", (Object[])new Object[0]);
            }
        }
        catch (IOException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("Docker env.properties failed to open: " + e.getMessage()), (Object[])new Object[0]);
            }
        }
        finally {
            block22: {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException e) {
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block22;
                        Tr.debug((Object)this, (TraceComponent)tc, (String)("Docker env.properties failed to close: " + e.getMessage()), (Object[])new Object[0]);
                    }
                }
            }
        }
        if (portName != null && fileProperties.getProperty(portName) != null) {
            newPortValue = Integer.parseInt(fileProperties.getProperty(portName));
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("Retrieved port value " + portName + " from properties: " + newPortValue), (Object[])new Object[0]);
            }
        }
        return newPortValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Trivial
    @FFDCIgnore(value={FileNotFoundException.class, IOException.class})
    private String getDockerConfigFromEnvironment(String propertyName) {
        FileInputStream fis = null;
        Properties fileProperties = new Properties();
        String newValue = null;
        try {
            fis = new FileInputStream("/opt/ibm/docker/env.properties");
            fileProperties.load(fis);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"Loaded Docker env.properties", (Object[])new Object[0]);
            }
        }
        catch (FileNotFoundException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"Docker env.properties not found", (Object[])new Object[0]);
            }
        }
        catch (IOException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("Docker env.properties failed to open: " + e.getMessage()), (Object[])new Object[0]);
            }
        }
        finally {
            block22: {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException e) {
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block22;
                        Tr.debug((Object)this, (TraceComponent)tc, (String)("Docker env.properties failed to close: " + e.getMessage()), (Object[])new Object[0]);
                    }
                }
            }
        }
        if (propertyName != null && fileProperties.getProperty(propertyName) != null) {
            newValue = fileProperties.getProperty(propertyName);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("Retrieved value " + propertyName + " from properties: " + newValue), (Object[])new Object[0]);
            }
        }
        return newValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Trivial
    private void performAction(Runnable action) {
        ExecutorService exec = (ExecutorService)this.executorService.getService();
        if (exec == null) {
            action.run();
        } else {
            LinkedList<Runnable> linkedList = this.actionQueue;
            synchronized (linkedList) {
                this.actionQueue.add(action);
                if (this.actionFuture == null) {
                    this.actionFuture = exec.submit(this.actionsRunner);
                }
            }
        }
    }

    @Override
    @Trivial
    public long getConnectTimeout() {
        if (this.configMap != null) {
            return (Long)this.configMap.get(CFG_CONNECT_TIMEOUT);
        }
        return 0L;
    }

    @Override
    @Trivial
    public long getIoTimeout() {
        if (this.configMap != null) {
            return (Long)this.configMap.get(CFG_SERVER_IO_TIMEOUT);
        }
        return 0L;
    }

    @Override
    @Trivial
    public long getWsIoTimeout() {
        Object obj;
        if (this.configMap != null && (obj = this.configMap.get(CFG_SERVER_WS_IO_TIMEOUT)) != null) {
            return (Long)obj;
        }
        return 30L;
    }

    @Override
    @Trivial
    public long getWsIdleTimeout() {
        Object obj;
        if (this.configMap != null && (obj = this.configMap.get(CFG_SERVER_WS_IDLE_TIMEOUT)) != null) {
            return (Long)obj;
        }
        return 900L;
    }

    @Override
    @Trivial
    public boolean getWaitForContinue() {
        if (this.configMap != null) {
            return (Boolean)this.configMap.get(CFG_WAIT_FOR_CONTINUE);
        }
        return false;
    }

    private void updateAndPublishVirtualHostInfo(ServiceReference<Object> reference) {
        VirtualHost vhost;
        ArrayList<EndpointRepositoryPublisherElement> elements = new ArrayList<EndpointRepositoryPublisherElement>();
        String[] hostAliases = (String[])reference.getProperty("aliases");
        Collection er = (Collection)reference.getProperty("endpointReferences");
        if (er != null) {
            if (this.blockedByRestrictions(er)) {
                this.virtualHosts.remove(reference.getProperty("id"));
                vhost = new VirtualHost((String)reference.getProperty("id"), null);
            } else if (hostAliases != null) {
                this.virtualHosts.put((String)reference.getProperty("id"), Arrays.asList(hostAliases));
                vhost = new VirtualHost((String)reference.getProperty("id"), hostAliases);
            } else {
                this.virtualHosts.remove(reference.getProperty("id"));
                vhost = new VirtualHost((String)reference.getProperty("id"), null);
            }
        } else if (hostAliases != null) {
            this.virtualHosts.put((String)reference.getProperty("id"), Arrays.asList(hostAliases));
            vhost = new VirtualHost((String)reference.getProperty("id"), hostAliases);
        } else {
            this.virtualHosts.remove(reference.getProperty("id"));
            vhost = new VirtualHost((String)reference.getProperty("id"), null);
        }
        elements.add(new EndpointRepositoryPublisherElement(ATTRIBUTE_NAME_VIRTUAL_HOSTS, "VirtualHost", null, vhost));
        this.performAction(new EndpointRepositoryPublisher(elements));
    }

    private void updateAndPublishVirtualHostInfo() {
        ServiceReference[] vHostTrackedServices;
        if (this.virtualHostTracker != null && (vHostTrackedServices = this.virtualHostTracker.getServiceReferences()) != null) {
            for (ServiceReference reference : vHostTrackedServices) {
                this.updateAndPublishVirtualHostInfo((ServiceReference<Object>)reference);
            }
        }
    }

    private boolean blockedByRestrictions(Collection<String> restrictions) {
        if (restrictions == null || restrictions.size() == 0) {
            return false;
        }
        return !restrictions.contains(this.httpEndpointRef);
    }

    @Override
    public String getHost() {
        return this.epaCurrent.host;
    }

    @Override
    public Integer getHttpPort() {
        return this.epaCurrent.httpPort;
    }

    @Override
    public Integer getHttpsPort() {
        return this.epaCurrent.httpsPort;
    }

    @Override
    public Long getPersistentTimeout() {
        return this.epaCurrent.persistTimeout;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class EndpointAttributes {
        public final String host;
        public final Integer httpPort;
        public final Integer httpsPort;
        public final Long persistTimeout;
        static final long serialVersionUID = -6489440332413372442L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        EndpointAttributes(String host, Integer httpPort, Integer httpsPort, Long persistTimeout) {
            this.host = host;
            this.httpPort = httpPort;
            this.httpsPort = httpsPort;
            this.persistTimeout = persistTimeout;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.collective.routing.member.internal.EndpointRoutingInfoMBeanImpl$EndpointAttributes", EndpointAttributes.class, (String)"Collective", (String)"com.ibm.ws.collective.routing.member.internal.resources.RoutingMemberMessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static final class EndpointRepositoryPublisherElement {
        private final String attributeName;
        private final String attributeType;
        private final Object oldValue;
        private final Object newValue;
        static final long serialVersionUID = 6144464270152755974L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Trivial
        public String getAttributeName() {
            return this.attributeName;
        }

        @Trivial
        public String getAttributeType() {
            return this.attributeType;
        }

        @Trivial
        public Object getOldValue() {
            return this.oldValue;
        }

        @Trivial
        public Object getNewValue() {
            return this.newValue;
        }

        EndpointRepositoryPublisherElement(String attributeName, String attributeType, Object oldValue, Object newValue) {
            this.attributeName = attributeName;
            this.attributeType = attributeType;
            this.oldValue = oldValue;
            this.newValue = newValue;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("attributeName: " + this.attributeName);
            sb.append("attributeType: " + this.attributeType);
            sb.append("oldValue: " + this.oldValue);
            sb.append("newValue: " + this.newValue);
            return sb.toString();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.collective.routing.member.internal.EndpointRoutingInfoMBeanImpl$EndpointRepositoryPublisherElement", EndpointRepositoryPublisherElement.class, (String)"Collective", (String)"com.ibm.ws.collective.routing.member.internal.resources.RoutingMemberMessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class VirtualHost {
        public final String vhostName;
        public final String[] aliases;
        static final long serialVersionUID = 8498806697390204935L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        VirtualHost(String vhostName, String[] aliases) {
            this.vhostName = vhostName;
            this.aliases = aliases;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.collective.routing.member.internal.EndpointRoutingInfoMBeanImpl$VirtualHost", VirtualHost.class, (String)"Collective", (String)"com.ibm.ws.collective.routing.member.internal.resources.RoutingMemberMessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    class VirtualHostServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<Object, ServiceReference<?>> {
        static final long serialVersionUID = -2608015187560856412L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        VirtualHostServiceTrackerCustomizer() {
        }

        public ServiceReference<?> addingService(ServiceReference<Object> reference) {
            this.modifiedService(reference, null);
            return reference;
        }

        public void modifiedService(ServiceReference<Object> reference, ServiceReference<?> service) {
            EndpointRoutingInfoMBeanImpl.this.updateAndPublishVirtualHostInfo((ServiceReference<Object>)reference);
        }

        public void removedService(ServiceReference<Object> reference, ServiceReference<?> service) {
            ArrayList<EndpointRepositoryPublisherElement> elements = new ArrayList<EndpointRepositoryPublisherElement>();
            EndpointRoutingInfoMBeanImpl.this.virtualHosts.remove(reference.getProperty("id"));
            elements.add(new EndpointRepositoryPublisherElement(EndpointRoutingInfoMBeanImpl.ATTRIBUTE_NAME_VIRTUAL_HOSTS, "VirtualHost", null, new VirtualHost((String)reference.getProperty("id"), null)));
            EndpointRoutingInfoMBeanImpl.this.performAction(new EndpointRepositoryPublisher(elements));
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.collective.routing.member.internal.EndpointRoutingInfoMBeanImpl$VirtualHostServiceTrackerCustomizer", VirtualHostServiceTrackerCustomizer.class, (String)"Collective", (String)"com.ibm.ws.collective.routing.member.internal.resources.RoutingMemberMessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private final class EndpointRepositoryPublisher
    implements Runnable {
        private final ArrayList<EndpointRepositoryPublisherElement> elements;
        static final long serialVersionUID = -1979564240118751574L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        EndpointRepositoryPublisher(ArrayList<EndpointRepositoryPublisherElement> elements) {
            this.elements = elements;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = EndpointRoutingInfoMBeanImpl.this.actionLock;
            synchronized (object) {
                if (this.elements != null) {
                    for (EndpointRepositoryPublisherElement element : this.elements) {
                        String newHost;
                        String newHttpsPort;
                        String newHttpPort;
                        if (element.getAttributeName().equals("HttpPort") && (newHttpPort = EndpointRoutingInfoMBeanImpl.this.getDockerConfigFromEnvironment("memberHttpPort")) != null && !newHttpPort.isEmpty()) {
                            element = new EndpointRepositoryPublisherElement("HttpPort", "java.lang.Integer", element.getOldValue(), Integer.parseInt(newHttpPort));
                        }
                        if (element.getAttributeName().equals("HttpsPort") && (newHttpsPort = EndpointRoutingInfoMBeanImpl.this.getDockerConfigFromEnvironment("memberHttpsPort")) != null && !newHttpsPort.isEmpty()) {
                            element = new EndpointRepositoryPublisherElement("HttpsPort", "java.lang.Integer", element.getOldValue(), Integer.parseInt(newHttpsPort));
                        }
                        if (element.getAttributeName().equals("Host") && (newHost = EndpointRoutingInfoMBeanImpl.this.getDockerConfigFromEnvironment("containerHost")) != null && !newHost.isEmpty()) {
                            element = new EndpointRepositoryPublisherElement("Host", "java.lang.String", element.getOldValue(), newHost);
                        }
                        if (element.getAttributeName().equals(EndpointRoutingInfoMBeanImpl.ATTRIBUTE_NAME_VIRTUAL_HOSTS)) {
                            EndpointRoutingInfoMBeanImpl.this.notifyVHostChangeListeners(element);
                            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                            Tr.debug((Object)this, (TraceComponent)tc, (String)"Sending Vhost update ", (Object[])new Object[]{element.toString()});
                            continue;
                        }
                        EndpointRoutingInfoMBeanImpl.this.sendNotification(new AttributeChangeNotification(this, EndpointRoutingInfoMBeanImpl.this.sequenceNum.incrementAndGet(), System.currentTimeMillis(), "", element.getAttributeName(), element.getAttributeType(), element.getOldValue(), element.getNewValue()));
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                        Tr.debug((Object)this, (TraceComponent)tc, (String)"Sending notification ", (Object[])new Object[]{element.toString()});
                    }
                }
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.collective.routing.member.internal.EndpointRoutingInfoMBeanImpl$EndpointRepositoryPublisher", EndpointRepositoryPublisher.class, (String)"Collective", (String)"com.ibm.ws.collective.routing.member.internal.resources.RoutingMemberMessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    class HttpEndpointServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<Object, ServiceReference<?>>,
    Runnable {
        EndPointProperties endPointProperties;
        static final long serialVersionUID = -7045922944940939270L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        HttpEndpointServiceTrackerCustomizer() {
        }

        public ServiceReference<?> addingService(ServiceReference<Object> reference) {
            this.endPointProperties = new EndPointProperties(reference);
            EndpointRoutingInfoMBeanImpl.this.performAction(this);
            return reference;
        }

        public void modifiedService(ServiceReference<Object> reference, ServiceReference<?> service) {
            this.endPointProperties = new EndPointProperties(reference);
            EndpointRoutingInfoMBeanImpl.this.performAction(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        private void processModifiedService(EndPointProperties endPointProperties) {
            EndpointAttributes epaOld;
            boolean trackerModified = false;
            Object object = EndpointRoutingInfoMBeanImpl.this.trackerLock;
            synchronized (object) {
                epaOld = EndpointRoutingInfoMBeanImpl.this.epaCurrent;
                if (endPointProperties.getHttpEndPointPID().equals(EndpointRoutingInfoMBeanImpl.this.httpEndpointRef)) {
                    String dockerHost;
                    String dockerHttpsPort;
                    String dockerHttpPort;
                    String newHttpOptionsRef = endPointProperties.getHttpEndPointHttpOptionsRef();
                    if (null != EndpointRoutingInfoMBeanImpl.this.httpOptionsRef && !EndpointRoutingInfoMBeanImpl.this.httpOptionsRef.equals(newHttpOptionsRef)) {
                        EndpointRoutingInfoMBeanImpl.this.httpOptionsTracker.close();
                    }
                    Long newPersistTimeout = ((EndpointRoutingInfoMBeanImpl)EndpointRoutingInfoMBeanImpl.this).epaCurrent.persistTimeout;
                    if (null == newHttpOptionsRef) {
                        EndpointRoutingInfoMBeanImpl.this.httpOptionsRef = null;
                        newPersistTimeout = null;
                        Tr.warning((TraceComponent)tc, (String)"Routing.config.httpoptions.are.not.available", (Object[])new Object[0]);
                    } else if (!newHttpOptionsRef.equals(EndpointRoutingInfoMBeanImpl.this.httpOptionsRef)) {
                        EndpointRoutingInfoMBeanImpl.this.httpOptionsRef = newHttpOptionsRef;
                        try {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug((Object)this, (TraceComponent)tc, (String)"Opening new options tracker", (Object[])new Object[0]);
                            }
                            EndpointRoutingInfoMBeanImpl.this.httpOptionsTracker = new ServiceTracker(((GeneratePluginConfigMBean)EndpointRoutingInfoMBeanImpl.this.pluginConfig).getBundleContext(), ((GeneratePluginConfigMBean)EndpointRoutingInfoMBeanImpl.this.pluginConfig).getBundleContext().createFilter("(service.pid=" + EndpointRoutingInfoMBeanImpl.this.httpOptionsRef + ")"), (ServiceTrackerCustomizer)new HttpOptionsServiceTrackerCustomizer());
                            EndpointRoutingInfoMBeanImpl.this.httpOptionsTracker.open(true);
                            newPersistTimeout = ((EndpointRoutingInfoMBeanImpl)EndpointRoutingInfoMBeanImpl.this).epaCurrent.persistTimeout;
                        }
                        catch (InvalidSyntaxException invalidSyntaxException) {
                            void ise;
                            FFDCFilter.processException((Throwable)invalidSyntaxException, (String)"com.ibm.ws.collective.routing.member.internal.EndpointRoutingInfoMBeanImpl$HttpEndpointServiceTrackerCustomizer", (String)"899", (Object)this, (Object[])new Object[]{endPointProperties});
                            throw new RuntimeException("InvalidSyntaxException while registering ServiceTracker. This is VERY unexpected.", (Throwable)ise);
                        }
                    }
                    String newHost = endPointProperties.getHttpEndPointHost();
                    Integer newHttpPort = endPointProperties.getHttpEndPointHttpPort();
                    Integer newHttpsPort = endPointProperties.getHttpEndpointHttpsPort();
                    Boolean endpointEnabled = endPointProperties.getHttpEndpointEnabled();
                    String endpointDisplayId = endPointProperties.getHttpEndPointDisplayId();
                    if (newHost.equals("*")) {
                        String realHost = HostNameUtils.tryResolveHostName((String)newHost);
                        if (null != realHost && "*" != realHost.trim()) {
                            newHost = realHost;
                        } else {
                            Tr.error((TraceComponent)tc, (String)"Routing.config.could.not.resolve.hostname", (Object[])new Object[]{newHost, endpointDisplayId});
                        }
                    }
                    if ((dockerHttpPort = EndpointRoutingInfoMBeanImpl.this.getDockerConfigFromEnvironment("memberHttpPort")) != null && !dockerHttpPort.isEmpty()) {
                        newHttpPort = Integer.parseInt(dockerHttpPort);
                    }
                    if ((dockerHttpsPort = EndpointRoutingInfoMBeanImpl.this.getDockerConfigFromEnvironment("memberHttpsPort")) != null && !dockerHttpsPort.isEmpty()) {
                        newHttpsPort = Integer.parseInt(dockerHttpsPort);
                    }
                    if ((dockerHost = EndpointRoutingInfoMBeanImpl.this.getDockerConfigFromEnvironment("containerHost")) != null && !dockerHost.isEmpty()) {
                        newHost = dockerHost;
                    }
                    if (0 > newHttpPort && 0 > newHttpsPort) {
                        Tr.error((TraceComponent)tc, (String)"Routing.config.has.no.ports.available", (Object[])new Object[]{endpointDisplayId});
                    }
                    if (!endpointEnabled.booleanValue()) {
                        Tr.warning((TraceComponent)tc, (String)"Routing.config.endpoint.is.not.enabled", (Object[])new Object[]{endpointDisplayId});
                    }
                    trackerModified = true;
                    EndpointAttributes epaNew = new EndpointAttributes(newHost, newHttpPort, newHttpsPort, newPersistTimeout);
                    EndpointRoutingInfoMBeanImpl.this.epaCurrent = epaNew;
                }
            }
            if (trackerModified) {
                EndpointRoutingInfoMBeanImpl.this.performEndpointUpdates(epaOld, EndpointRoutingInfoMBeanImpl.this.epaCurrent);
                EndpointRoutingInfoMBeanImpl.this.updateAndPublishVirtualHostInfo();
            }
        }

        public void removedService(ServiceReference<Object> reference, ServiceReference<?> service) {
        }

        @Override
        public void run() {
            if (this.endPointProperties != null) {
                this.processModifiedService(this.endPointProperties);
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.collective.routing.member.internal.EndpointRoutingInfoMBeanImpl$HttpEndpointServiceTrackerCustomizer", HttpEndpointServiceTrackerCustomizer.class, (String)"Collective", (String)"com.ibm.ws.collective.routing.member.internal.resources.RoutingMemberMessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    class HttpOptionsServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<Object, ServiceReference<?>> {
        static final long serialVersionUID = -2956197776667573420L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        HttpOptionsServiceTrackerCustomizer() {
        }

        public ServiceReference<?> addingService(ServiceReference<Object> reference) {
            this.modifiedService(reference, null);
            return reference;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void modifiedService(ServiceReference<Object> reference, ServiceReference<?> service) {
            boolean trackerModified = false;
            ArrayList<EndpointRepositoryPublisherElement> elements = new ArrayList<EndpointRepositoryPublisherElement>();
            Object object = EndpointRoutingInfoMBeanImpl.this.trackerLock;
            synchronized (object) {
                Long newPersistTimeout;
                if (reference.getProperty("service.pid").equals(EndpointRoutingInfoMBeanImpl.this.httpOptionsRef) && !(newPersistTimeout = (Long)reference.getProperty(EndpointRoutingInfoMBeanImpl.HTTPOPTIONS_PERSIST_TIMEOUT)).equals(((EndpointRoutingInfoMBeanImpl)EndpointRoutingInfoMBeanImpl.this).epaCurrent.persistTimeout)) {
                    Long oldPersistTimeout = ((EndpointRoutingInfoMBeanImpl)EndpointRoutingInfoMBeanImpl.this).epaCurrent.persistTimeout;
                    EndpointAttributes epaNew = new EndpointAttributes(((EndpointRoutingInfoMBeanImpl)EndpointRoutingInfoMBeanImpl.this).epaCurrent.host, ((EndpointRoutingInfoMBeanImpl)EndpointRoutingInfoMBeanImpl.this).epaCurrent.httpPort, ((EndpointRoutingInfoMBeanImpl)EndpointRoutingInfoMBeanImpl.this).epaCurrent.httpsPort, newPersistTimeout);
                    EndpointRoutingInfoMBeanImpl.this.epaCurrent = epaNew;
                    elements.add(new EndpointRepositoryPublisherElement("PersistentTimeout", "java.lang.Long", oldPersistTimeout, ((EndpointRoutingInfoMBeanImpl)EndpointRoutingInfoMBeanImpl.this).epaCurrent.persistTimeout));
                    trackerModified = true;
                }
            }
            if (trackerModified && !elements.isEmpty()) {
                EndpointRoutingInfoMBeanImpl.this.performAction(new EndpointRepositoryPublisher(elements));
            }
        }

        public void removedService(ServiceReference<Object> reference, ServiceReference<?> service) {
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.collective.routing.member.internal.EndpointRoutingInfoMBeanImpl$HttpOptionsServiceTrackerCustomizer", HttpOptionsServiceTrackerCustomizer.class, (String)"Collective", (String)"com.ibm.ws.collective.routing.member.internal.resources.RoutingMemberMessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    class EndPointProperties {
        String httpEndPointPID;
        String httpEndPointHttpOptionsRef;
        String httpEndPointHost;
        Integer httpEndPointHttpPort;
        Integer httpEndpointHttpsPort;
        Boolean httpEndpointEnabled;
        String httpEndPointDisplayId;
        static final long serialVersionUID = -1003362232661962971L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public EndPointProperties(ServiceReference<Object> reference) {
            this.httpEndPointPID = (String)reference.getProperty("service.pid");
            this.httpEndPointHttpOptionsRef = (String)reference.getProperty(EndpointRoutingInfoMBeanImpl.HTTPENDPOINT_HTTP_OPTIONS_REF);
            this.httpEndPointHost = (String)reference.getProperty(EndpointRoutingInfoMBeanImpl.HTTPENDPOINT_HOST);
            this.httpEndPointHttpPort = (Integer)reference.getProperty(EndpointRoutingInfoMBeanImpl.HTTPENDPOINT_HTTP_PORT);
            this.httpEndpointHttpsPort = (Integer)reference.getProperty(EndpointRoutingInfoMBeanImpl.HTTPENDPOINT_HTTPS_PORT);
            this.httpEndpointEnabled = (Boolean)reference.getProperty(EndpointRoutingInfoMBeanImpl.HTTPENDPOINT_ENABLED);
            this.httpEndPointDisplayId = (String)reference.getProperty("config.displayId");
        }

        String getHttpEndPointPID() {
            return this.httpEndPointPID;
        }

        String getHttpEndPointHttpOptionsRef() {
            return this.httpEndPointHttpOptionsRef;
        }

        String getHttpEndPointHost() {
            return this.httpEndPointHost;
        }

        Integer getHttpEndPointHttpPort() {
            return this.httpEndPointHttpPort;
        }

        Integer getHttpEndpointHttpsPort() {
            return this.httpEndpointHttpsPort;
        }

        String getHttpEndPointDisplayId() {
            return this.httpEndPointDisplayId;
        }

        Boolean getHttpEndpointEnabled() {
            return this.httpEndpointEnabled;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.collective.routing.member.internal.EndpointRoutingInfoMBeanImpl$EndPointProperties", EndPointProperties.class, (String)"Collective", (String)"com.ibm.ws.collective.routing.member.internal.resources.RoutingMemberMessages");
        }
    }
}

