/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.rest.handler.config.openapi.common;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.rest.handler.helper.ServletRESTRequestImpl;
import com.ibm.ws.rest.handler.helper.ServletRESTResponseImpl;
import com.ibm.wsspi.rest.handler.RESTHandlerContainer;
import com.ibm.wsspi.rest.handler.RESTRequest;
import com.ibm.wsspi.rest.handler.RESTResponse;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.util.Locale;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ConfigValidationSchemaRESTProxy
extends HttpServlet {
    private static final TraceComponent tc = Tr.register(ConfigValidationSchemaRESTProxy.class, (String)"rest.config", (String)"io.openliberty.rest.handler.config.openapi.common.resources.CWWKOMessages");
    private static final long serialVersionUID = 1L;
    private transient RESTHandlerContainer REST_HANDLER_CONTAINER = null;

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.getAndSetRESTHandlerContainer(request);
        this.handleWithDelegate(request, response);
    }

    private void handleWithDelegate(HttpServletRequest request, HttpServletResponse response) throws IOException {
        boolean foundHandler = this.REST_HANDLER_CONTAINER.handleRequest((RESTRequest)new ServletRESTRequestImpl(request), (RESTResponse)new ServletRESTResponseImpl(response));
        if (!foundHandler) {
            String errorMsg = Tr.formatMessage((TraceComponent)tc, (Locale)request.getLocale(), (String)"CWWKO1570_HANDLER_NOT_FOUND", (Object[])new Object[]{request.getRequestURI()});
            response.sendError(404, errorMsg);
        }
    }

    private synchronized void getAndSetRESTHandlerContainer(HttpServletRequest request) throws ServletException {
        if (this.REST_HANDLER_CONTAINER == null) {
            HttpSession session = request.getSession();
            ServletContext sc = session.getServletContext();
            BundleContext ctxt = (BundleContext)sc.getAttribute("osgi-bundlecontext");
            ServiceReference ref = ctxt.getServiceReference(RESTHandlerContainer.class);
            if (ref == null) {
                throw new ServletException(Tr.formatMessage((TraceComponent)tc, (String)"CWWKO1571_OSGI_SERVICE_NOT_AVAILABLE", (Object[])new Object[]{"RESTHandlerContainer"}));
            }
            this.REST_HANDLER_CONTAINER = (RESTHandlerContainer)ctxt.getService(ref);
        }
    }
}

