/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;

@Component(service={Scheduler.class}, configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM"})
public class Scheduler {
    private static TraceComponent tc = Tr.register(Scheduler.class, (String)"WebSphere Dynamic Cache", (String)"com.ibm.ws.cache.resources.dynacache");
    private static Scheduler instance;
    private final AtomicReference<ScheduledExecutorService> scheduledExecutorService = new AtomicReference<Object>(null);
    private final AtomicReference<ExecutorService> executorService = new AtomicReference<Object>(null);
    private final AtomicReference<WsLocationAdmin> locationAdminRef = new AtomicReference<Object>(null);

    private static void setInstance(Scheduler value) {
        instance = value;
    }

    @Reference(service=ScheduledExecutorService.class, target="(deferrable=false)")
    protected void setScheduledExecutorService(ScheduledExecutorService scheduler) {
        this.scheduledExecutorService.getAndSet(scheduler);
    }

    @Reference(service=ExecutorService.class, target="(service.vendor=IBM)")
    protected void setExecutorService(ExecutorService es) {
        this.executorService.getAndSet(es);
    }

    protected void unsetScheduledExecutorService(ScheduledExecutorService schedulerRef) {
        this.scheduledExecutorService.compareAndSet(schedulerRef, null);
    }

    protected void unsetExecutorService(ExecutorService esRef) {
        this.executorService.compareAndSet(esRef, null);
    }

    public ScheduledExecutorService getScheduledExecutorService() {
        ScheduledExecutorService sRef = this.scheduledExecutorService.get();
        if (sRef == null) {
            throw new IllegalStateException("ScheduledExecutorService service is unavailable");
        }
        return sRef;
    }

    public ExecutorService getExecutorService() {
        ExecutorService eRef = this.executorService.get();
        if (eRef == null) {
            throw new IllegalStateException("ExecutorService service is unavailable");
        }
        return eRef;
    }

    public static void createNonDeferrable(long sleepInterval, Object context, Runnable run) {
        block4: {
            if (null != instance) {
                try {
                    instance.getScheduledExecutorService().schedule(new WrappedRunnable(run), sleepInterval, TimeUnit.MILLISECONDS);
                }
                catch (Exception ex) {
                    if (!(ex instanceof IllegalStateException)) {
                        throw ex;
                    }
                    if (!tc.isDebugEnabled()) break block4;
                    Tr.debug((TraceComponent)tc, (String)"IllegalStateException during createNonDeferrable, server likely shutting down", (Object[])new Object[0]);
                }
            }
        }
    }

    public static Future<?> submit(Runnable task) {
        if (null != instance) {
            return instance.getExecutorService().submit(new WrappedRunnable(task));
        }
        return null;
    }

    public void activate() {
        Scheduler.setInstance(this);
    }

    public void deactivate() {
        Scheduler.setInstance(null);
    }

    public static WsLocationAdmin getLocationAdmin() {
        return Scheduler.instance.locationAdminRef.get();
    }

    @Reference(service=WsLocationAdmin.class)
    protected void setLocationAdmin(WsLocationAdmin vr) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"setWsLocationAdmin ", (Object[])new Object[]{vr});
        }
        this.locationAdminRef.set(vr);
    }

    protected void unsetLocationAdmin(WsLocationAdmin vr) {
        this.locationAdminRef.compareAndSet(vr, null);
    }

    static class WrappedRunnable
    implements Runnable {
        Runnable _r = null;

        WrappedRunnable(Runnable r) {
            this._r = r;
        }

        @Override
        public void run() {
            block2: {
                try {
                    this._r.run();
                }
                catch (Exception ex) {
                    FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.cache.Scheduler.createNonDeferrable(long, Object, Runnable)", (String)"77", (Object)this);
                    if (!tc.isDebugEnabled()) break block2;
                    Tr.debug((TraceComponent)tc, (String)"exception during wakeUp", (Object[])new Object[]{ex.getCause()});
                }
            }
        }
    }
}

