/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.component.search;

import jakarta.faces.FacesException;
import jakarta.faces.component.ContextCallback;
import jakarta.faces.component.NamingContainer;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIViewRoot;
import jakarta.faces.component.search.ComponentNotFoundException;
import jakarta.faces.component.search.SearchExpressionContext;
import jakarta.faces.component.search.SearchExpressionHandler;
import jakarta.faces.component.search.SearchExpressionHint;
import jakarta.faces.component.search.SearchKeywordContext;
import jakarta.faces.context.FacesContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.myfaces.core.api.shared.ComponentUtils;
import org.apache.myfaces.core.api.shared.lang.SharedStringBuilder;
import org.apache.myfaces.util.lang.StringUtils;

public class SearchExpressionHandlerImpl
extends SearchExpressionHandler {
    private static final String SB_SPLIT = SearchExpressionHandlerImpl.class.getName() + "#split";

    protected void addHint(SearchExpressionContext searchExpressionContext, SearchExpressionHint hint) {
        searchExpressionContext.getExpressionHints().add(hint);
    }

    protected boolean isHintSet(SearchExpressionContext searchExpressionContext, SearchExpressionHint hint) {
        if (searchExpressionContext.getExpressionHints() == null) {
            return false;
        }
        return searchExpressionContext.getExpressionHints().contains(hint);
    }

    public String resolveClientId(SearchExpressionContext searchExpressionContext, String expression) {
        expression = expression == null ? "" : expression.trim();
        FacesContext facesContext = searchExpressionContext.getFacesContext();
        SearchExpressionHandler handler = facesContext.getApplication().getSearchExpressionHandler();
        this.addHint(searchExpressionContext, SearchExpressionHint.RESOLVE_SINGLE_COMPONENT);
        if (handler.isPassthroughExpression(searchExpressionContext, expression)) {
            return expression;
        }
        CollectClientIdCallback callback = null;
        if (!expression.isEmpty()) {
            callback = new CollectClientIdCallback();
            handler.invokeOnComponent(searchExpressionContext, searchExpressionContext.getSource(), expression, (ContextCallback)callback);
        }
        if (callback == null || !callback.isClientIdFound()) {
            if (this.isHintSet(searchExpressionContext, SearchExpressionHint.IGNORE_NO_RESULT)) {
                return null;
            }
            throw new ComponentNotFoundException("Cannot find component for expression \"" + expression + "\" referenced from \"" + searchExpressionContext.getSource().getClientId(facesContext) + "\".");
        }
        return callback.getClientId();
    }

    public List<String> resolveClientIds(SearchExpressionContext searchExpressionContext, String expressions) {
        expressions = expressions == null ? "" : expressions.trim();
        FacesContext facesContext = searchExpressionContext.getFacesContext();
        SearchExpressionHandler handler = facesContext.getApplication().getSearchExpressionHandler();
        CollectClientIdsCallback callback = null;
        if (!expressions.isEmpty()) {
            callback = new CollectClientIdsCallback();
            for (String expression : handler.splitExpressions(facesContext, expressions)) {
                if (handler.isPassthroughExpression(searchExpressionContext, expression)) {
                    callback.addClientId(expression);
                    continue;
                }
                handler.invokeOnComponent(searchExpressionContext, searchExpressionContext.getSource(), expression, (ContextCallback)callback);
            }
        }
        if (callback == null || !callback.isClientIdFound()) {
            if (this.isHintSet(searchExpressionContext, SearchExpressionHint.IGNORE_NO_RESULT)) {
                return Collections.emptyList();
            }
            throw new ComponentNotFoundException("Cannot find component for expression \"" + expressions + "\" referenced from \"" + searchExpressionContext.getSource().getClientId(facesContext) + "\".");
        }
        return callback.getClientIds();
    }

    public void resolveComponent(SearchExpressionContext searchExpressionContext, String expression, ContextCallback callback) {
        expression = expression == null ? "" : expression.trim();
        FacesContext facesContext = searchExpressionContext.getFacesContext();
        SearchExpressionHandler handler = facesContext.getApplication().getSearchExpressionHandler();
        this.addHint(searchExpressionContext, SearchExpressionHint.RESOLVE_SINGLE_COMPONENT);
        SingleInvocationCallback checkCallback = null;
        if (!expression.isEmpty()) {
            checkCallback = new SingleInvocationCallback(callback);
            handler.invokeOnComponent(searchExpressionContext, searchExpressionContext.getSource(), expression, (ContextCallback)checkCallback);
        }
        if (!(checkCallback != null && checkCallback.isInvoked() || this.isHintSet(searchExpressionContext, SearchExpressionHint.IGNORE_NO_RESULT))) {
            throw new ComponentNotFoundException("Cannot find component for expression \"" + expression + "\" referenced from \"" + searchExpressionContext.getSource().getClientId(facesContext) + "\".");
        }
    }

    public void resolveComponents(SearchExpressionContext searchExpressionContext, String expressions, ContextCallback callback) {
        expressions = expressions == null ? "" : expressions.trim();
        FacesContext facesContext = searchExpressionContext.getFacesContext();
        SearchExpressionHandler handler = facesContext.getApplication().getSearchExpressionHandler();
        MultipleInvocationCallback checkCallback = null;
        if (!expressions.isEmpty()) {
            checkCallback = new MultipleInvocationCallback(callback);
            for (String expression : handler.splitExpressions(facesContext, expressions)) {
                handler.invokeOnComponent(searchExpressionContext, searchExpressionContext.getSource(), expression, (ContextCallback)checkCallback);
            }
        }
        if (!(checkCallback != null && checkCallback.isInvoked() || this.isHintSet(searchExpressionContext, SearchExpressionHint.IGNORE_NO_RESULT))) {
            throw new ComponentNotFoundException("Cannot find component for expression \"" + expressions + "\" referenced from \"" + searchExpressionContext.getSource().getClientId(facesContext) + "\".");
        }
    }

    public void invokeOnComponent(final SearchExpressionContext searchExpressionContext, UIComponent previous, String topExpression, final ContextCallback topCallback) {
        topExpression = topExpression == null ? "" : topExpression.trim();
        FacesContext facesContext = searchExpressionContext.getFacesContext();
        final SearchExpressionHandler handler = facesContext.getApplication().getSearchExpressionHandler();
        char separatorChar = facesContext.getNamingContainerSeparatorChar();
        if (topExpression.charAt(0) == separatorChar) {
            UIComponent findBase = ComponentUtils.findRootComponent(previous);
            handler.invokeOnComponent(searchExpressionContext, findBase, topExpression.substring(1), topCallback);
            return;
        }
        if (topExpression.charAt(0) == "@".charAt(0)) {
            String remaining;
            String command = SearchExpressionHandlerImpl.extractKeyword(topExpression, 1, separatorChar);
            String string = remaining = command.length() + 1 < topExpression.length() ? topExpression.substring(1 + command.length() + 1) : null;
            if (remaining != null) {
                if (facesContext.getApplication().getSearchKeywordResolver().isLeaf(searchExpressionContext, command)) {
                    throw new FacesException("Expression cannot have keywords or ids at the right side: " + command);
                }
                this.applyKeyword(searchExpressionContext, previous, command, remaining, new ContextCallback(){

                    public void invokeContextCallback(FacesContext facesContext, UIComponent target) {
                        handler.invokeOnComponent(searchExpressionContext, target, remaining, topCallback);
                    }
                });
            } else {
                this.applyKeyword(searchExpressionContext, previous, command, null, topCallback);
            }
        } else {
            UIComponent baseNC;
            String expression;
            String nextExpression = null;
            if (topExpression.indexOf(":@") > 0) {
                int idx = topExpression.indexOf(":@");
                nextExpression = topExpression.substring(idx + 1);
                expression = topExpression.substring(0, idx);
            } else {
                expression = topExpression;
            }
            UIComponent target = previous.findComponent(expression);
            if (target == null) {
                int idx = expression.indexOf(separatorChar);
                String base = idx > 0 ? expression.substring(0, idx) : expression;
                String contextClientId = previous.getClientId(facesContext);
                int startCommon = contextClientId.lastIndexOf(base + facesContext.getNamingContainerSeparatorChar());
                if (!(startCommon < 0 || startCommon != 0 && contextClientId.charAt(startCommon - 1) != separatorChar || startCommon + base.length() > contextClientId.length() - 1 && contextClientId.charAt(startCommon + base.length() + 1) != separatorChar)) {
                    UIComponent parent;
                    for (parent = previous; !(parent == null || base.equals(parent.getId()) && parent instanceof NamingContainer); parent = parent.getParent()) {
                    }
                    if (parent != null && (target = parent.findComponent(expression)) == null && !searchExpressionContext.getExpressionHints().contains(SearchExpressionHint.SKIP_VIRTUAL_COMPONENTS)) {
                        contextClientId = parent.getClientId(facesContext);
                        String targetClientId = contextClientId.substring(0, startCommon + base.length()) + expression.substring(base.length());
                        if (nextExpression != null) {
                            final String childExpression = nextExpression;
                            parent.invokeOnComponent(facesContext, targetClientId, new ContextCallback(){

                                public void invokeContextCallback(FacesContext context, UIComponent target) {
                                    handler.invokeOnComponent(searchExpressionContext, target, childExpression, topCallback);
                                }
                            });
                        } else {
                            parent.invokeOnComponent(facesContext, targetClientId, topCallback);
                        }
                        return;
                    }
                }
            }
            if (target != null) {
                if (nextExpression != null) {
                    handler.invokeOnComponent(searchExpressionContext, target, nextExpression, topCallback);
                } else {
                    topCallback.invokeContextCallback(facesContext, target);
                }
                return;
            }
            if (target == null && searchExpressionContext.getSource() == previous && topExpression.indexOf(separatorChar) == -1 && (baseNC = previous.getNamingContainer()) != null && baseNC.getParent() != null) {
                UIComponent parentNC = SearchExpressionHandlerImpl.getParentNamingContainerUIViewRoot(baseNC.getParent());
                while (target == null && parentNC != null) {
                    UIComponent parent = parentNC.getParent();
                    target = parentNC.findComponent(expression);
                    if (parent != null) {
                        parentNC = SearchExpressionHandlerImpl.getParentNamingContainerUIViewRoot(parent);
                        continue;
                    }
                    parentNC = null;
                }
                if (target != null) {
                    topCallback.invokeContextCallback(facesContext, target);
                    return;
                }
            }
            topCallback.invokeContextCallback(facesContext, previous);
        }
    }

    private static UIComponent getParentNamingContainerUIViewRoot(UIComponent component) {
        do {
            if (!(component instanceof NamingContainer) && !(component instanceof UIViewRoot)) continue;
            return component;
        } while ((component = component.getParent()) != null);
        return null;
    }

    protected void applyKeyword(SearchExpressionContext searchExpressionContext, UIComponent last, String command, String remainingExpression, ContextCallback topCallback) {
        SearchKeywordContext searchContext = new SearchKeywordContext(searchExpressionContext, topCallback, remainingExpression);
        searchExpressionContext.getFacesContext().getApplication().getSearchKeywordResolver().resolve(searchContext, last, command);
    }

    public boolean isPassthroughExpression(SearchExpressionContext searchExpressionContext, String topExpression) {
        if (StringUtils.isBlank(topExpression)) {
            return false;
        }
        topExpression = topExpression.trim();
        FacesContext facesContext = searchExpressionContext.getFacesContext();
        char separatorChar = facesContext.getNamingContainerSeparatorChar();
        if (topExpression.charAt(0) == separatorChar) {
            return false;
        }
        if (topExpression.charAt(0) == "@".charAt(0)) {
            String command = SearchExpressionHandlerImpl.extractKeyword(topExpression, 1, separatorChar);
            String remaining = command.length() + 1 < topExpression.length() ? topExpression.substring(1 + command.length() + 1) : null;
            SearchExpressionHandler currentInstance = facesContext.getApplication().getSearchExpressionHandler();
            boolean passthrough = facesContext.getApplication().getSearchKeywordResolver().isPassthrough(searchExpressionContext, command);
            if (passthrough) {
                return remaining != null ? currentInstance.isPassthroughExpression(searchExpressionContext, remaining) : true;
            }
            return false;
        }
        return false;
    }

    public boolean isValidExpression(SearchExpressionContext searchExpressionContext, String topExpression) {
        if (StringUtils.isBlank(topExpression)) {
            return true;
        }
        topExpression = topExpression.trim();
        FacesContext facesContext = searchExpressionContext.getFacesContext();
        boolean isValid = true;
        char separatorChar = facesContext.getNamingContainerSeparatorChar();
        if (topExpression.charAt(0) == separatorChar) {
            return facesContext.getApplication().getSearchExpressionHandler().isValidExpression(searchExpressionContext, topExpression.substring(1));
        }
        if (topExpression.charAt(0) == "@".charAt(0)) {
            String command = SearchExpressionHandlerImpl.extractKeyword(topExpression, 1, separatorChar);
            String remaining = command.length() + 1 < topExpression.length() ? topExpression.substring(1 + command.length() + 1) : null;
            SearchExpressionHandler currentInstance = facesContext.getApplication().getSearchExpressionHandler();
            isValid = facesContext.getApplication().getSearchKeywordResolver().isResolverForKeyword(searchExpressionContext, command);
            if (remaining != null) {
                if (facesContext.getApplication().getSearchKeywordResolver().isLeaf(searchExpressionContext, command)) {
                    isValid = false;
                }
                return !isValid ? false : currentInstance.isValidExpression(searchExpressionContext, remaining);
            }
        } else {
            String nextExpression = null;
            String expression = null;
            if (topExpression.indexOf(":@") > 0) {
                int idx = topExpression.indexOf(":@");
                nextExpression = topExpression.substring(idx + 1);
                expression = topExpression.substring(0, idx);
            } else {
                expression = topExpression;
            }
            for (int i = 0; i < expression.length(); ++i) {
                char c = expression.charAt(i);
                if (Character.isLetterOrDigit(c) || c == '-' || c == '_' || c == separatorChar) continue;
                isValid = false;
            }
            if (nextExpression != null) {
                return !isValid ? false : facesContext.getApplication().getSearchExpressionHandler().isValidExpression(searchExpressionContext, nextExpression);
            }
        }
        return isValid;
    }

    private static String extractKeyword(String expression, int startIndex, char separatorChar) {
        int parenthesesCounter = -1;
        int count = -1;
        for (int i = startIndex; i < expression.length(); ++i) {
            char c = expression.charAt(i);
            if (c == '(') {
                if (parenthesesCounter == -1) {
                    parenthesesCounter = 0;
                }
                ++parenthesesCounter;
            }
            if (c == ')') {
                --parenthesesCounter;
            }
            if (parenthesesCounter == 0) {
                count = i + 1;
                break;
            }
            if (parenthesesCounter != -1 || c != separatorChar) continue;
            count = i;
            break;
        }
        if (count == -1) {
            return expression.substring(startIndex);
        }
        return expression.substring(startIndex, count);
    }

    public String[] splitExpressions(FacesContext context, String expressions) {
        String[] splittedExpressions = SearchExpressionHandlerImpl.split(context, expressions, EXPRESSION_SEPARATOR_CHARS);
        return splittedExpressions;
    }

    private static String[] split(FacesContext context, String value, char ... separators) {
        if (StringUtils.isBlank(value)) {
            return null;
        }
        ArrayList<String> tokens = new ArrayList<String>(5);
        StringBuilder buffer = SharedStringBuilder.get(context, SB_SPLIT);
        int parenthesesCounter = 0;
        int length = value.length();
        for (int i = 0; i < length; ++i) {
            char c = value.charAt(i);
            if (c == '(') {
                ++parenthesesCounter;
            }
            if (c == ')') {
                --parenthesesCounter;
            }
            if (parenthesesCounter == 0) {
                boolean isSeparator = false;
                for (char separator : separators) {
                    if (c != separator) continue;
                    isSeparator = true;
                }
                if (isSeparator) {
                    String bufferString = buffer.toString().trim();
                    if (bufferString.length() > 0) {
                        tokens.add(bufferString);
                    }
                    buffer.delete(0, buffer.length());
                    continue;
                }
                buffer.append(c);
                continue;
            }
            buffer.append(c);
        }
        tokens.add(buffer.toString());
        return tokens.toArray(new String[tokens.size()]);
    }

    private static class MultipleInvocationCallback
    implements ContextCallback {
        private boolean invoked;
        private final ContextCallback innerCallback;

        public MultipleInvocationCallback(ContextCallback innerCallback) {
            this.innerCallback = innerCallback;
            this.invoked = false;
        }

        public void invokeContextCallback(FacesContext context, UIComponent target) {
            try {
                this.innerCallback.invokeContextCallback(context, target);
            }
            finally {
                this.invoked = true;
            }
        }

        public boolean isInvoked() {
            return this.invoked;
        }
    }

    private static class SingleInvocationCallback
    implements ContextCallback {
        private boolean invoked;
        private final ContextCallback innerCallback;

        public SingleInvocationCallback(ContextCallback innerCallback) {
            this.innerCallback = innerCallback;
            this.invoked = false;
        }

        public void invokeContextCallback(FacesContext context, UIComponent target) {
            if (!this.isInvoked()) {
                try {
                    this.innerCallback.invokeContextCallback(context, target);
                }
                finally {
                    this.invoked = true;
                }
            }
        }

        public boolean isInvoked() {
            return this.invoked;
        }
    }

    private static class CollectClientIdsCallback
    implements ContextCallback {
        private List<String> clientIds = null;

        private CollectClientIdsCallback() {
        }

        public void invokeContextCallback(FacesContext context, UIComponent target) {
            if (this.clientIds == null) {
                this.clientIds = new ArrayList<String>(5);
            }
            this.clientIds.add(target.getClientId(context));
        }

        private List<String> getClientIds() {
            return this.clientIds == null ? Collections.emptyList() : this.clientIds;
        }

        private boolean isClientIdFound() {
            return this.clientIds != null;
        }

        private void addClientId(String clientId) {
            if (this.clientIds == null) {
                this.clientIds = new ArrayList<String>(5);
            }
            this.clientIds.add(clientId);
        }
    }

    private static class CollectClientIdCallback
    implements ContextCallback {
        private String clientId = null;

        private CollectClientIdCallback() {
        }

        public void invokeContextCallback(FacesContext context, UIComponent target) {
            if (this.clientId == null) {
                this.clientId = target.getClientId(context);
            }
        }

        private String getClientId() {
            return this.clientId;
        }

        private boolean isClientIdFound() {
            return this.clientId != null;
        }
    }
}

