/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.health31.internal.servlet;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.health31.internal.HealthCheck31Service;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class HealthCheckReadinessServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final TraceComponent tc = Tr.register(HealthCheckReadinessServlet.class, (String)"HEALTH", (String)"io.openliberty.microprofile.health.resources.Health");
    private transient HealthCheck31Service healthService = null;
    private ServiceTracker<HealthCheck31Service, HealthCheck31Service> healthServiceTracker;
    private static final Logger logger = Logger.getLogger(HealthCheckReadinessServlet.class.getName(), "io.openliberty.microprofile.health.resources.Health");

    public void init(ServletConfig config) throws ServletException {
        BundleContext bundleContext = (BundleContext)config.getServletContext().getAttribute("osgi-bundlecontext");
        this.healthServiceTracker = new ServiceTracker(bundleContext, HealthCheck31Service.class, null);
        this.healthServiceTracker.open();
        super.init(config);
    }

    public void destroy() {
        super.destroy();
        this.healthServiceTracker.close();
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.findHealthService();
        this.healthService.performHealthCheck(request, response, "READY");
    }

    private synchronized void findHealthService() throws ServletException {
        if (this.healthService == null) {
            if (this.healthServiceTracker == null) {
                logger.log(Level.SEVERE, "OSGI_SERVICE_ERROR", "HealthCheckService");
                throw new ServletException(Tr.formatMessage((TraceComponent)tc, (String)"OSGI_SERVICE_ERROR", (Object[])new Object[]{"HealthCheckService"}));
            }
            this.healthService = (HealthCheck31Service)this.healthServiceTracker.getService();
        }
    }
}

