/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.jmf.impl;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.mfp.jmf.JMFUninitializedAccessException;
import com.ibm.ws.sib.mfp.jmf.JmfTr;
import com.ibm.ws.sib.mfp.jmf.impl.JSEnum;
import com.ibm.ws.sib.mfp.jmf.impl.JSField;
import com.ibm.ws.sib.mfp.jmf.impl.JSPrimitive;
import com.ibm.ws.sib.mfp.jmf.impl.JSTuple;
import com.ibm.ws.sib.mfp.jmf.impl.JSType;
import com.ibm.ws.sib.mfp.jmf.impl.JSVariant;
import com.ibm.ws.sib.mfp.jmf.impl.JSchema;
import java.math.BigInteger;

public final class MessageMap {
    private static TraceComponent tc = JmfTr.register(MessageMap.class, "SIBJmf", "com.ibm.ws.sib.mfp.CWSIFMessages");
    public BigInteger multiChoice;
    public int offsetsNeeded;
    public int[] choiceCodes;
    public Remap[] fields;

    public MessageMap(JSchema schema, BigInteger multiChoice) {
        this.multiChoice = multiChoice;
        JSField[] cfields = schema.getFields();
        this.choiceCodes = new int[schema.getVariants().length];
        for (int i = 0; i < this.choiceCodes.length; ++i) {
            this.choiceCodes[i] = -1;
        }
        this.fields = new Remap[cfields.length];
        if (this.choiceCodes.length > 0) {
            this.setChoices(multiChoice, schema);
        }
        int moi = -1;
        int length = 0;
        int incr = 0;
        for (int i = 0; i < cfields.length; ++i) {
            JSField field = cfields[i];
            if (!this.isPresent(field)) continue;
            length = field.getIndirection() != -1 ? -1 : (field instanceof JSPrimitive ? ((JSPrimitive)field).getLength() : (field instanceof JSEnum ? 4 : -1));
            this.fields[i] = new Remap(moi, incr, length == -1);
            if (length == -1) {
                ++moi;
                incr = 0;
                continue;
            }
            incr += length;
        }
        this.offsetsNeeded = moi == -1 ? 0 : (length == -1 ? moi : moi + 1);
    }

    private void setChoices(BigInteger multiChoice, JSchema schema) {
        JSType topType = (JSType)schema.getJMFType();
        if (topType instanceof JSVariant) {
            this.setChoices(multiChoice, schema, (JSVariant)topType);
        } else if (topType instanceof JSTuple) {
            this.setChoices(multiChoice, topType.getMultiChoiceCount(), schema, ((JSTuple)topType).getDominatedVariants());
        } else {
            return;
        }
    }

    private void setChoices(BigInteger multiChoice, JSchema schema, JSVariant var) {
        for (int i = 0; i < var.getCaseCount(); ++i) {
            BigInteger count = ((JSType)var.getCase(i)).getMultiChoiceCount();
            if (multiChoice.compareTo(count) < 0) {
                this.choiceCodes[var.getIndex()] = i;
                JSVariant[] subVars = var.getDominatedVariants(i);
                this.setChoices(multiChoice, count, schema, subVars);
                return;
            }
            multiChoice = multiChoice.subtract(count);
        }
        throw new RuntimeException("Bad multiChoice code");
    }

    private void setChoices(BigInteger multiChoice, BigInteger radix, JSchema schema, JSVariant[] vars) {
        for (int j = 0; j < vars.length; ++j) {
            radix = radix.divide(vars[j].getMultiChoiceCount());
            BigInteger contrib = multiChoice.divide(radix);
            multiChoice = multiChoice.remainder(radix);
            this.setChoices(contrib, schema, vars[j]);
        }
    }

    private boolean isPresent(JSType testCase) {
        JSType dom = (JSType)testCase.getParent();
        while (dom != null && !(dom instanceof JSVariant)) {
            testCase = dom;
            dom = (JSType)testCase.getParent();
        }
        if (dom == null) {
            return true;
        }
        if (this.choiceCodes[((JSVariant)dom).getIndex()] != testCase.getSiblingPosition()) {
            return false;
        }
        return this.isPresent(dom);
    }

    static BigInteger getMultiChoice(int[] choices, JSchema schema) throws JMFUninitializedAccessException {
        if (choices == null || choices.length == 0) {
            return BigInteger.ZERO;
        }
        JSType topType = (JSType)schema.getJMFType();
        if (topType instanceof JSVariant) {
            return MessageMap.getMultiChoice(choices, schema, (JSVariant)topType);
        }
        if (topType instanceof JSTuple) {
            return MessageMap.getMultiChoice(choices, schema, ((JSTuple)topType).getDominatedVariants());
        }
        return BigInteger.ZERO;
    }

    private static BigInteger getMultiChoice(int[] choices, JSchema schema, JSVariant var) throws JMFUninitializedAccessException {
        int choice = choices[var.getIndex()];
        if (choice == -1) {
            throw new JMFUninitializedAccessException(schema.getPathName(var));
        }
        BigInteger ans = BigInteger.ZERO;
        for (int i = 0; i < choice; ++i) {
            ans = ans.add(((JSType)var.getCase(i)).getMultiChoiceCount());
        }
        JSVariant[] subVars = var.getDominatedVariants(choice);
        if (subVars == null) {
            return ans;
        }
        return ans.add(MessageMap.getMultiChoice(choices, schema, subVars));
    }

    private static BigInteger getMultiChoice(int[] choices, JSchema schema, JSVariant[] vars) throws JMFUninitializedAccessException {
        BigInteger base = BigInteger.ZERO;
        for (int i = 0; i < vars.length; ++i) {
            base = base.multiply(vars[i].getMultiChoiceCount()).add(MessageMap.getMultiChoice(choices, schema, vars[i]));
        }
        return base;
    }

    public static class Remap {
        public int offsetIndex;
        public int fixedIncr;
        public boolean varying;

        Remap(int offsetIndex, int fixedIncr, boolean varying) {
            this.offsetIndex = offsetIndex;
            this.fixedIncr = fixedIncr;
            this.varying = varying;
        }
    }
}

