/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.impl;

import com.ibm.tx.jta.OnePhaseXAResource;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.FFDCSelfIntrospectable;
import com.ibm.ws.jca.adapter.WSXAResource;
import com.ibm.ws.rsadapter.AdapterUtil;
import com.ibm.ws.rsadapter.DSConfig;
import com.ibm.ws.rsadapter.FFDCLogger;
import com.ibm.ws.rsadapter.exceptions.TransactionException;
import com.ibm.ws.rsadapter.impl.WSRdbManagedConnectionImpl;
import com.ibm.ws.rsadapter.impl.WSStateManager;
import jakarta.resource.spi.ManagedConnection;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.atomic.AtomicReference;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class WSRdbOnePhaseXaResourceImpl
implements WSXAResource,
OnePhaseXAResource,
FFDCSelfIntrospectable {
    private final Connection ivSqlConn;
    private final WSRdbManagedConnectionImpl ivManagedConnection;
    private final WSStateManager ivStateManager;
    private final AtomicReference<DSConfig> dsConfig;
    private static final Class<?> currClass = WSRdbOnePhaseXaResourceImpl.class;
    private static final TraceComponent tc = Tr.register(currClass, (String)"RRA", (String)"com.ibm.ws.rsadapter.resources.IBMDataStoreAdapterNLS");

    public WSRdbOnePhaseXaResourceImpl(Connection conn, WSRdbManagedConnectionImpl mc) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object[])new Object[]{AdapterUtil.toString(conn), mc});
        }
        this.ivSqlConn = conn;
        this.ivManagedConnection = mc;
        this.ivStateManager = this.ivManagedConnection.stateMgr;
        this.dsConfig = mc.mcf.dsConfig;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"<init>", (Object)this);
        }
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        XAException xae;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"commit", (Object[])new Object[]{this.ivManagedConnection, AdapterUtil.toString(xid), onePhase ? "ONE PHASE" : "TWO PHASE"});
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            String cId = null;
            try {
                cId = this.ivManagedConnection.mcf.getCorrelator(this.ivManagedConnection);
            }
            catch (SQLException x) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"got an exception trying to get the correlator in commit, exception is: ", (Object[])new Object[]{x});
            }
            if (cId != null) {
                StringBuffer stbuf = new StringBuffer(200);
                stbuf.append("Correlator: DB2, ID: ");
                stbuf.append(cId);
                if (xid != null) {
                    stbuf.append("Transaction ID : ");
                    stbuf.append(xid);
                }
                stbuf.append(" COMMIT");
                Tr.debug((Object)this, (TraceComponent)tc, (String)stbuf.toString(), (Object[])new Object[0]);
            }
        }
        if (this.dsConfig.get().enableMultithreadedAccessDetection) {
            this.ivManagedConnection.detectMultithreadedAccess();
        }
        if (!onePhase) {
            XAException xaX = new XAException(105);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"commit", (Object)xaX);
            }
            throw xaX;
        }
        boolean commitFailed = false;
        boolean rollbackFailed = false;
        boolean setStateFailed = false;
        this.ivManagedConnection.wasLazilyEnlistedInGlobalTran = false;
        try {
            this.ivSqlConn.commit();
            this.ivStateManager.setState(7);
        }
        catch (SQLException sqeC) {
            FFDCFilter.processException((Throwable)sqeC, (String)"com.ibm.ws.rsadapter.spi.WSRdbOnePhaseXaResourceImpl.commit", (String)"105", (Object)this);
            commitFailed = true;
            Tr.error((TraceComponent)tc, (String)"DSA_INTERNAL_ERROR", (Object[])new Object[]{"Exception caught during commit on the OnePhaseXAResource", sqeC});
            try {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"issue a rollback due to commit failure", (Object[])new Object[0]);
                }
                this.ivSqlConn.rollback();
            }
            catch (SQLException sqeR) {
                FFDCFilter.processException((Throwable)sqeR, (String)"com.ibm.ws.rsadapter.spi.WSRdbOnePhaseXaResourceImpl.commit", (String)"197", (Object)this);
                rollbackFailed = true;
                Tr.error((TraceComponent)tc, (String)"DSA_INTERNAL_ERROR", (Object[])new Object[]{"Exception caught during rollback on the OnePhaseXAResource after a commit failed", sqeR});
            }
            catch (RuntimeException x) {
                FFDCFilter.processException((Throwable)x, (String)"com.ibm.ws.rsadapter.spi.WSRdbOnePhaseXaResourceImpl.commit", (String)"204", (Object)this);
                rollbackFailed = true;
                Tr.error((TraceComponent)tc, (String)"DSA_INTERNAL_ERROR", (Object[])new Object[]{"Exception caught during rollback on the OnePhaseXAResource after a commit failed", x});
            }
        }
        catch (TransactionException te) {
            FFDCFilter.processException((Throwable)((Object)te), (String)"com.ibm.ws.rsadapter.spi.WSRdbOnePhaseXaResourceImpl.commit", (String)"123", (Object)this);
            Tr.error((TraceComponent)tc, (String)"INVALID_TX_STATE", (Object[])new Object[]{"OnePhaseXAResource.commit()", this.ivManagedConnection.getTransactionStateAsString()});
            setStateFailed = false;
        }
        catch (RuntimeException x) {
            FFDCFilter.processException((Throwable)x, (String)"com.ibm.ws.rsadapter.spi.WSRdbOnePhaseXaResourceImpl.commit", (String)"221", (Object)this);
            Tr.error((TraceComponent)tc, (String)"DSA_INTERNAL_ERROR", (Object[])new Object[]{"Exception caught during commit on the OnePhaseXAResource", x});
            XAException xae2 = new XAException(8);
            WSRdbOnePhaseXaResourceImpl.traceXAException(xae2, currClass);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"commit", (Object)"Exception");
            }
            throw xae2;
        }
        if (rollbackFailed) {
            xae = new XAException(-3);
            WSRdbOnePhaseXaResourceImpl.traceXAException(xae, currClass);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"commit", (Object)"Exception");
            }
            throw xae;
        }
        if (commitFailed) {
            xae = new XAException(8);
            WSRdbOnePhaseXaResourceImpl.traceXAException(xae, currClass);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"commit", (Object)"Exception");
            }
            throw xae;
        }
        if (setStateFailed) {
            xae = new XAException(-3);
            WSRdbOnePhaseXaResourceImpl.traceXAException(xae, currClass);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"commit", (Object)"Exception");
            }
            throw xae;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"commit");
        }
    }

    public void end(Xid xid, int flags) throws XAException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"end", (Object[])new Object[]{this.ivManagedConnection, AdapterUtil.toString(xid), AdapterUtil.getXAResourceEndFlagString(flags)});
        }
        try {
            if (flags == 0x20000000) {
                this.ivStateManager.setState(6);
            } else {
                this.ivStateManager.setState(5);
            }
        }
        catch (TransactionException te) {
            FFDCFilter.processException((Throwable)((Object)te), (String)"com.ibm.ws.rsadapter.spi.WSRdbOnePhaseXaResourceImpl.end", (String)"189", (Object)this);
            Tr.error((TraceComponent)tc, (String)"INVALID_TX_STATE", (Object[])new Object[]{"OnePhaseXAResource.end()", this.ivManagedConnection.getTransactionStateAsString()});
            XAException xae = new XAException(105);
            WSRdbOnePhaseXaResourceImpl.traceXAException(xae, currClass);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"end", (Object)"Exception");
            }
            throw xae;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"end");
        }
    }

    public void forget(Xid xid) throws XAException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"forget", (Object[])new Object[]{AdapterUtil.toString(xid)});
        }
        Tr.error((TraceComponent)tc, (String)"INVALID_TX_STATE", (Object[])new Object[]{"OnePhaseXAResource.forget()", this.ivManagedConnection.getTransactionStateAsString()});
        XAException xae = new XAException(105);
        WSRdbOnePhaseXaResourceImpl.traceXAException(xae, currClass);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"forget", (Object)xae);
        }
        throw xae;
    }

    public final ManagedConnection getManagedConnection() {
        return this.ivManagedConnection;
    }

    public final String getResourceName() {
        return this.ivManagedConnection.helper.getDatabaseProductName();
    }

    public int getTransactionTimeout() throws XAException {
        return -1;
    }

    public final String[] introspectSelf() {
        return this.ivManagedConnection.introspectSelf();
    }

    void introspectThisClassOnly(FFDCLogger info) {
        info.createFFDCHeader(this);
        info.append("Connection:", AdapterUtil.toString(this.ivSqlConn));
        info.append("ManagedConnection:", this.ivManagedConnection);
    }

    public boolean isSameRM(XAResource xares) throws XAException {
        return false;
    }

    public int prepare(Xid xid) throws XAException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"prepare", (Object[])new Object[]{AdapterUtil.toString(xid)});
        }
        Tr.error((TraceComponent)tc, (String)"INVALID_TX_STATE", (Object[])new Object[]{"OnePhaseXAResource.prepare()", this.ivManagedConnection.getTransactionStateAsString()});
        XAException xae = new XAException(105);
        WSRdbOnePhaseXaResourceImpl.traceXAException(xae, currClass);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"prepare", (Object)xae);
        }
        throw xae;
    }

    public Xid[] recover(int flag) throws XAException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"recover", (Object[])new Object[]{AdapterUtil.getXAResourceRecoverFlagString(flag)});
        }
        Xid[] emptyList = new Xid[]{};
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"recover", (Object)emptyList);
        }
        return emptyList;
    }

    public void rollback(Xid xid) throws XAException {
        XAException xae;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"rollback", (Object[])new Object[]{this.ivManagedConnection, AdapterUtil.toString(xid)});
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            String cId = null;
            try {
                cId = this.ivManagedConnection.mcf.getCorrelator(this.ivManagedConnection);
            }
            catch (SQLException x) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"got an exception trying to get the correlator in commit, exception is: ", (Object[])new Object[]{x});
            }
            if (cId != null) {
                StringBuffer stbuf = new StringBuffer(200);
                stbuf.append("Correlator: DB2, ID: ");
                stbuf.append(cId);
                if (xid != null) {
                    stbuf.append("Transaction ID : ");
                    stbuf.append(xid);
                }
                stbuf.append(" ROLLBACK");
                Tr.debug((Object)this, (TraceComponent)tc, (String)stbuf.toString(), (Object[])new Object[0]);
            }
        }
        this.ivManagedConnection.wasLazilyEnlistedInGlobalTran = false;
        try {
            this.ivSqlConn.rollback();
            this.ivStateManager.setState(8);
        }
        catch (SQLException sqe) {
            FFDCFilter.processException((Throwable)sqe, (String)"com.ibm.ws.rsadapter.spi.WSRdbOnePhaseXaResourceImpl.rollback", (String)"342", (Object)this);
            Tr.error((TraceComponent)tc, (String)"DSA_INTERNAL_ERROR", (Object[])new Object[]{"Exception caught during rollback on the OnePhaseXAResource", sqe});
            xae = new XAException(-3);
            WSRdbOnePhaseXaResourceImpl.traceXAException(xae, currClass);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"rollback", (Object)"Exception");
            }
            throw xae;
        }
        catch (TransactionException te) {
            FFDCFilter.processException((Throwable)((Object)te), (String)"com.ibm.ws.rsadapter.spi.WSRdbOnePhaseXaResourceImpl.rollback", (String)"351", (Object)this);
            Tr.error((TraceComponent)tc, (String)"INVALID_TX_STATE", (Object[])new Object[]{"OnePhaseXAResource.rollback()", this.ivManagedConnection.getTransactionStateAsString()});
            xae = new XAException(-3);
            WSRdbOnePhaseXaResourceImpl.traceXAException(xae, currClass);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"rollback", (Object)"Exception");
            }
            throw xae;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"rollback");
        }
    }

    public boolean setTransactionTimeout(int seconds) throws XAException {
        return false;
    }

    public void start(Xid xid, int flags) throws XAException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"start", (Object[])new Object[]{this.ivManagedConnection, AdapterUtil.toString(xid), AdapterUtil.getXAResourceStartFlagString(flags)});
        }
        if (this.dsConfig.get().enableMultithreadedAccessDetection) {
            this.ivManagedConnection.detectMultithreadedAccess();
        }
        try {
            this.ivManagedConnection.setAutoCommit(false);
            this.ivStateManager.setState(4);
        }
        catch (SQLException sqle) {
            FFDCFilter.processException((Throwable)sqle, (String)"com.ibm.ws.rsadapter.spi.WSRdbOnePhaseXaResourceImpl.start", (String)"406", (Object)this);
            Tr.error((TraceComponent)tc, (String)"DSA_ERROR", (Object[])new Object[]{sqle, "com.ibm.ws.rsadapter.spi.WSRdbOnePhaseXaResourceImpl.start"});
            XAException xae = new XAException(105);
            WSRdbOnePhaseXaResourceImpl.traceXAException(xae, currClass);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"start", (Object)"Exception");
            }
            throw xae;
        }
        catch (TransactionException te) {
            FFDCFilter.processException((Throwable)((Object)te), (String)"com.ibm.ws.rsadapter.spi.WSRdbOnePhaseXaResourceImpl.start", (String)"407", (Object)this);
            Tr.error((TraceComponent)tc, (String)"INVALID_TX_STATE", (Object[])new Object[]{"OnePhaseXAResource.start()", this.ivManagedConnection.getTransactionStateAsString()});
            XAException xae = new XAException(105);
            WSRdbOnePhaseXaResourceImpl.traceXAException(xae, currClass);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"start", (Object)"Exception");
            }
            throw xae;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"start");
        }
    }

    public static final XAException traceXAException(XAException xae, Class<?> callerClass) {
        Tr.warning((TraceComponent)tc, (String)"THROW_XAEXCEPTION", (Object[])new Object[]{AdapterUtil.getXAExceptionCodeString(xae.errorCode), xae.getMessage()});
        return xae;
    }
}

