/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.openapi20.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.container.service.app.deploy.ApplicationInfo;
import com.ibm.ws.container.service.app.deploy.ContainerInfo;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.kernel.feature.ServerStartedPhase2;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.utils.FrameworkState;
import io.openliberty.microprofile.openapi.internal.common.services.OpenAPIAppConfigProvider;
import io.openliberty.microprofile.openapi20.internal.ApplicationProcessor;
import io.openliberty.microprofile.openapi20.internal.ApplicationReadException;
import io.openliberty.microprofile.openapi20.internal.MergeDisabledAlerter;
import io.openliberty.microprofile.openapi20.internal.services.ApplicationRegistry;
import io.openliberty.microprofile.openapi20.internal.services.MergeProcessor;
import io.openliberty.microprofile.openapi20.internal.services.ModuleSelectionConfig;
import io.openliberty.microprofile.openapi20.internal.services.OpenAPIProvider;
import io.openliberty.microprofile.openapi20.internal.utils.LoggingUtils;
import io.openliberty.microprofile.openapi20.internal.utils.ModuleUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(configurationPolicy=ConfigurationPolicy.IGNORE)
public class ApplicationRegistryImpl
implements ApplicationRegistry,
OpenAPIAppConfigProvider.OpenAPIAppConfigListener {
    private static final TraceComponent tc = Tr.register(ApplicationRegistryImpl.class, (String)"MPOPENAPI", (String)"io.openliberty.microprofile.openapi.internal.resources.OpenAPI");
    @Reference
    private ApplicationProcessor applicationProcessor;
    @Reference
    private MergeDisabledAlerter mergeDisabledAlerter;
    @Reference
    private MergeProcessor mergeProcessor;
    private Map<String, ApplicationRecord> applications = new LinkedHashMap<String, ApplicationRecord>();
    private OpenAPIProvider cachedProvider = null;
    @Reference
    private ModuleSelectionConfig moduleSelectionConfig;
    static final long serialVersionUID = 819781574693376808L;

    @Reference(cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.STATIC, unbind="unbindAppConfigListener")
    public void bindAppConfigListener(OpenAPIAppConfigProvider openAPIAppConfigProvider) {
        openAPIAppConfigProvider.registerAppConfigListener((OpenAPIAppConfigProvider.OpenAPIAppConfigListener)this);
    }

    public void unbindAppConfigListener(OpenAPIAppConfigProvider openAPIAppConfigProvider) {
        openAPIAppConfigProvider.unregisterAppConfigListener((OpenAPIAppConfigProvider.OpenAPIAppConfigListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addApplication(ApplicationInfo newAppInfo) {
        ApplicationRecord record = new ApplicationRecord(newAppInfo);
        ApplicationRegistryImpl applicationRegistryImpl = this;
        synchronized (applicationRegistryImpl) {
            if (LoggingUtils.isEventEnabled(tc)) {
                Tr.event((TraceComponent)tc, (String)("Application Processor: Adding application started: appInfo=" + newAppInfo), (Object[])new Object[0]);
            }
            this.applications.put(newAppInfo.getName(), record);
            OpenAPIProvider firstProvider = this.getFirstProvider();
            if (this.moduleSelectionConfig.useFirstModuleOnly() && firstProvider != null) {
                if (LoggingUtils.isEventEnabled(tc)) {
                    Tr.event((Object)this, (TraceComponent)tc, (String)("Application Processor: useFirstModuleOnly is configured and we already have a module. Not processing. appInfo=" + newAppInfo), (Object[])new Object[0]);
                }
                this.mergeDisabledAlerter.setUsingMultiModulesWithoutConfig(firstProvider);
            } else {
                Collection<OpenAPIProvider> openApiProviders = this.applicationProcessor.processApplication(newAppInfo, this.moduleSelectionConfig);
                if (!openApiProviders.isEmpty()) {
                    this.cachedProvider = null;
                }
                record.providers.addAll(openApiProviders);
            }
        }
        if (LoggingUtils.isEventEnabled(tc)) {
            Tr.event((TraceComponent)tc, (String)("Application Processor: Adding application ended: appInfo=" + newAppInfo), (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeApplication(ApplicationInfo removedAppInfo) {
        ApplicationRegistryImpl applicationRegistryImpl = this;
        synchronized (applicationRegistryImpl) {
            ApplicationRecord removedRecord;
            if (LoggingUtils.isEventEnabled(tc)) {
                Tr.event((TraceComponent)tc, (String)("Application Processor: Removing application started: appInfo=" + removedAppInfo), (Object[])new Object[0]);
            }
            if (!(removedRecord = this.applications.remove(removedAppInfo.getName())).providers.isEmpty()) {
                this.cachedProvider = null;
                if (this.moduleSelectionConfig.useFirstModuleOnly() && !FrameworkState.isStopping()) {
                    if (LoggingUtils.isEventEnabled(tc)) {
                        Tr.event((Object)this, (TraceComponent)tc, (String)"Application Processor: Current OpenAPI application removed, looking for another application to document.", (Object[])new Object[0]);
                    }
                    for (ApplicationRecord app : this.applications.values()) {
                        Collection<OpenAPIProvider> providers = this.applicationProcessor.processApplication(app.info, this.moduleSelectionConfig);
                        if (providers.isEmpty()) continue;
                        app.providers.addAll(providers);
                        break;
                    }
                }
            }
            if (LoggingUtils.isEventEnabled(tc)) {
                Tr.event((TraceComponent)tc, (String)("Application Processor: Removing application ended: appInfo=" + removedAppInfo), (Object[])new Object[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FFDCIgnore(value={ApplicationReadException.class})
    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    protected void setServerStartPhase2(ServerStartedPhase2 event) {
        ApplicationRegistryImpl applicationRegistryImpl = this;
        synchronized (applicationRegistryImpl) {
            if (LoggingUtils.isEventEnabled(tc)) {
                Tr.event((Object)this, (TraceComponent)tc, (String)"Checking for unused configuration entries", (Object[])new Object[0]);
            }
            ArrayList modules = new ArrayList();
            for (ApplicationRecord record : this.applications.values()) {
                try {
                    this.applicationProcessor.getModuleClassesContainerInfos(record.info).stream().map(mcci -> (ContainerInfo)mcci).filter(c -> c.getType() == ContainerInfo.Type.WEB_MODULE).map(ContainerInfo::getContainer).map(ModuleUtils::getWebModuleInfo).filter(Objects::nonNull).forEach(modules::add);
                }
                catch (ApplicationReadException applicationReadException) {}
            }
            this.moduleSelectionConfig.sendWarningsForAppsAndModulesNotMatchingAnything(modules);
        }
    }

    protected void unsetServerStartPhase2(ServerStartedPhase2 event) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OpenAPIProvider getOpenAPIProvider() {
        ApplicationRegistryImpl applicationRegistryImpl = this;
        synchronized (applicationRegistryImpl) {
            OpenAPIProvider result;
            List<OpenAPIProvider> providers;
            if (this.cachedProvider != null) {
                if (LoggingUtils.isDebugEnabled(tc)) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"OpenAPIProvider retrieved from cache", (Object[])new Object[0]);
                }
                return this.cachedProvider;
            }
            if (LoggingUtils.isDebugEnabled(tc)) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"Finding OpenAPIProvider", (Object[])new Object[0]);
            }
            if ((providers = this.getProvidersToMerge()).isEmpty()) {
                result = null;
            } else if (providers.size() == 1) {
                result = providers.get(0);
            } else {
                OpenAPIProvider mergedProvider = this.mergeProcessor.mergeDocuments(providers);
                if (!mergedProvider.getMergeProblems().isEmpty()) {
                    StringBuilder sb = new StringBuilder();
                    for (String problem : mergedProvider.getMergeProblems()) {
                        sb.append("\n - ");
                        sb.append(problem);
                    }
                    Tr.warning((TraceComponent)tc, (String)"OPENAPI_MERGE_PROBLEMS_CWWKO1662W", (Object[])new Object[]{sb.toString()});
                }
                result = mergedProvider;
            }
            this.cachedProvider = result;
            if (LoggingUtils.isEventEnabled(tc)) {
                Tr.event((Object)this, (TraceComponent)tc, (String)"Finished creating OpenAPI provider", (Object[])new Object[0]);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<OpenAPIProvider> getProvidersToMerge() {
        ApplicationRegistryImpl applicationRegistryImpl = this;
        synchronized (applicationRegistryImpl) {
            return this.applications.values().stream().flatMap(r -> ((ApplicationRecord)r).providers.stream()).collect(Collectors.toList());
        }
    }

    private OpenAPIProvider getFirstProvider() {
        for (Map.Entry<String, ApplicationRecord> entry : this.applications.entrySet()) {
            List providers = entry.getValue().providers;
            if (providers.isEmpty()) continue;
            return (OpenAPIProvider)providers.get(0);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processConfigUpdate() {
        ApplicationRegistryImpl applicationRegistryImpl = this;
        synchronized (applicationRegistryImpl) {
            Map<String, ApplicationRecord> oldApps = this.applications;
            this.applications = new LinkedHashMap<String, ApplicationRecord>();
            for (ApplicationRecord record : oldApps.values()) {
                this.addApplication(record.info);
            }
            this.cachedProvider = null;
        }
    }

    public int getConfigListenerPriority() {
        return 2;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class ApplicationRecord {
        private final ApplicationInfo info;
        private final List<OpenAPIProvider> providers = new ArrayList<OpenAPIProvider>();
        static final long serialVersionUID = 4988394894016509249L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public ApplicationRecord(ApplicationInfo info) {
            this.info = info;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"io.openliberty.microprofile.openapi20.internal.ApplicationRegistryImpl$ApplicationRecord", ApplicationRecord.class, (String)"MPOPENAPI", (String)"io.openliberty.microprofile.openapi.internal.resources.OpenAPI");
        }
    }
}

