/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.openapi20.internal.validation;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.openapi20.internal.services.OASValidationResult;
import io.openliberty.microprofile.openapi20.internal.utils.OpenAPIModelWalker;
import io.openliberty.microprofile.openapi20.internal.validation.TypeValidator;
import io.openliberty.microprofile.openapi20.internal.validation.ValidationHelper;
import io.openliberty.microprofile.openapi20.internal.validation.ValidatorUtils;
import java.util.Map;
import org.eclipse.microprofile.openapi.models.media.Content;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.eclipse.microprofile.openapi.models.parameters.Parameter;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ParameterValidator
extends TypeValidator<Parameter> {
    private static final TraceComponent tc = Tr.register(ParameterValidator.class, (String)"MPOPENAPI", (String)"io.openliberty.microprofile.openapi.internal.resources.validation.ValidationMessages");
    private static final ParameterValidator INSTANCE = new ParameterValidator();
    static final long serialVersionUID = 8076984305102786746L;

    public static ParameterValidator getInstance() {
        return INSTANCE;
    }

    private ParameterValidator() {
    }

    @Override
    public void validate(ValidationHelper helper, OpenAPIModelWalker.Context context, String key, Parameter t) {
        if (t != null) {
            Map mediaTypes;
            String message;
            String message2;
            String reference = t.getRef();
            if (reference != null && !reference.isEmpty()) {
                helper.validateReference(context, key, reference, Parameter.class);
                return;
            }
            ValidatorUtils.validateRequiredField(t.getName(), context, "name").ifPresent(helper::addValidationEvent);
            Parameter.In in = t.getIn();
            ValidatorUtils.validateRequiredField(in, context, "in").ifPresent(helper::addValidationEvent);
            if (in != null && in != Parameter.In.COOKIE && in != Parameter.In.HEADER && in != Parameter.In.PATH && in != Parameter.In.QUERY) {
                message2 = Tr.formatMessage((TraceComponent)tc, (String)"parameterInFieldInvalid", (Object[])new Object[]{in, t.getName()});
                helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation("in"), message2));
            }
            if (t.getExample() != null && t.getExamples() != null && !t.getExamples().isEmpty()) {
                message2 = Tr.formatMessage((TraceComponent)tc, (String)"parameterExampleOrExamples", (Object[])new Object[]{t.getName()});
                helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.WARNING, context.getLocation(), message2));
            }
            Schema schema = t.getSchema();
            Content content = t.getContent();
            if (schema == null && content == null) {
                message = Tr.formatMessage((TraceComponent)tc, (String)"parameterSchemaOrContent", (Object[])new Object[]{t.getName()});
                helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation(), message));
            }
            if (schema != null && content != null) {
                message = Tr.formatMessage((TraceComponent)tc, (String)"parameterSchemaAndContent", (Object[])new Object[]{t.getName()});
                helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation(), message));
            }
            if (content != null && (mediaTypes = content.getMediaTypes()) != null && mediaTypes.size() > 1) {
                String message3 = Tr.formatMessage((TraceComponent)tc, (String)"parameterContentMapMustNotBeEmpty", (Object[])new Object[]{t.getName()});
                helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation("content"), message3));
            }
        }
    }
}

