/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jca.security.internal;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.security.EntryNotFoundException;
import com.ibm.websphere.security.PasswordCheckFailedException;
import com.ibm.websphere.security.UserRegistry;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jca.security.internal.Invocation;
import com.ibm.wsspi.security.registry.RegistryHelper;
import jakarta.security.auth.message.callback.CallerPrincipalCallback;
import jakarta.security.auth.message.callback.GroupPrincipalCallback;
import jakarta.security.auth.message.callback.PasswordValidationCallback;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import javax.security.auth.Subject;

public class J2CSecurityHelper {
    static final TraceComponent tc = Tr.register(J2CSecurityHelper.class, (String)"WAS.j2c.security", (String)"com.ibm.ws.jca.security.resources.J2CAMessages");
    private static ThreadLocal<Subject> subjectStorage = new ThreadLocal();
    private static final String CACHE_KEY_PREFIX = "j2c:inboundSecurity:";
    private static final String CACHE_KEY_SEPARATOR = ":";
    private static TraceNLS nls = TraceNLS.getTraceNLS(J2CSecurityHelper.class, (String)"com.ibm.ws.jca.security.resources.J2CAMessages");
    private static String REALM_SEPARATOR = "/";

    public static Subject getRunAsSubject() {
        return subjectStorage.get();
    }

    public static void setRunAsSubject(Subject subject) {
        subjectStorage.set(subject);
    }

    public static void removeRunAsSubject() {
        subjectStorage.remove();
    }

    private static void updateCustomHashtable(Hashtable<String, Object> credData, String realmName, String uniqueId, String securityName, List<?> groupList) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"updateCustomHashtable", (Object[])new Object[]{credData, realmName, uniqueId, securityName, groupList});
        }
        String cacheKey = J2CSecurityHelper.getCacheKey(uniqueId, realmName);
        credData.put("com.ibm.wsspi.security.cred.cacheKey", cacheKey);
        credData.put("com.ibm.wsspi.security.cred.realm", realmName);
        credData.put("com.ibm.wsspi.security.cred.securityName", securityName);
        if (uniqueId != null) {
            credData.put("com.ibm.wsspi.security.cred.uniqueId", uniqueId);
        }
        if (groupList != null && !groupList.isEmpty()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Adding groups found in registry", (Object[])new Object[]{groupList});
            }
            credData.put("com.ibm.wsspi.security.cred.groups", groupList);
        } else {
            credData.put("com.ibm.wsspi.security.cred.groups", new ArrayList());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"updateCustomHashtable");
        }
    }

    public static void addSubjectCustomData(Subject callSubject, Hashtable<String, Object> newCred) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addSubjectCustomData", (Object[])new Object[]{newCred});
        }
        AddPrivateCredentials action = new AddPrivateCredentials(callSubject, newCred);
        AccessController.doPrivileged(action);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addSubjectCustomData");
        }
    }

    public static Hashtable<String, Object> getCustomCredentials(Subject callSubject, String cacheKey) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getCustomCredentials", (Object[])new Object[]{cacheKey});
        }
        if (callSubject == null || cacheKey == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getCustomCredentials", (Object)" null");
            }
            return null;
        }
        GetCustomCredentials action = new GetCustomCredentials(callSubject, cacheKey);
        Hashtable cred = (Hashtable)AccessController.doPrivileged(action);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getCustomCredentials", (Object)J2CSecurityHelper.objectId(cred));
        }
        return cred;
    }

    public static void handlePasswordValidationCallback(PasswordValidationCallback callback, Subject executionSubject, Hashtable<String, Object> addedCred, String appRealm, Invocation[] invocations) throws RemoteException, WSSecurityException {
        Subject callSubject;
        invocations[2] = Invocation.PASSWORDVALIDATIONCALLBACK;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"handlePasswordValidationCallback", (Object[])new Object[]{J2CSecurityHelper.objectId(callback), callback.getUsername()});
        }
        if (!executionSubject.equals(callSubject = callback.getSubject())) {
            Tr.warning((TraceComponent)tc, (String)"EXECUTION_CALLBACK_SUBJECT_MISMATCH_J2CA0673", (Object[])new Object[]{"PasswordValidationCallback"});
            callSubject = executionSubject;
        }
        try {
            String userName = callback.getUsername();
            String password = null;
            if (callback.getPassword() != null) {
                password = new String(callback.getPassword());
            }
            if (callSubject != null) {
                GetRegistry action = new GetRegistry(appRealm);
                UserRegistry registry = AccessController.doPrivileged(action);
                if (J2CSecurityHelper.checkUserPassword(userName, password, registry, appRealm, addedCred, invocations[0])) {
                    callback.setResult(true);
                } else {
                    callback.setResult(false);
                    addedCred.clear();
                }
            }
        }
        catch (PrivilegedActionException pae) {
            callback.setResult(false);
            addedCred.clear();
            Exception ex = pae.getException();
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"handlePasswordValidationCallback", (Object)callback.getResult());
            }
            if (ex instanceof WSSecurityException) {
                throw (WSSecurityException)ex;
            }
            throw new WSSecurityException((Throwable)ex);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"handlePasswordValidationCallback", (Object)callback.getResult());
        }
    }

    public static void handleCallerPrincipalCallback(CallerPrincipalCallback callback, Subject executionSubject, Hashtable<String, Object> addedCred, String appRealm, String unauthenticated, Invocation[] invocations) throws WSSecurityException, RemoteException {
        Subject callSubject;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"handleCallerPrincipalCallback", (Object[])new Object[0]);
        }
        if (invocations[0] == Invocation.CALLERPRINCIPALCALLBACK) {
            String message = J2CSecurityHelper.getNLS().getString("MULTIPLE_CALLERPRINCIPALCALLBACKS_NOT_SUPPORTED_J2CA0676", "J2CA0676E: The inflown security context supplied multiple instances of a JASPIC CallerPrincipalCallback in order to establish the security context of the Work instance.");
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"handleCallerPrincipalCallback");
            }
            throw new WSSecurityException(message);
        }
        invocations[0] = Invocation.CALLERPRINCIPALCALLBACK;
        String userName = callback.getName();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"The userName got from the callback is : ", (Object[])new Object[]{userName});
        }
        Principal userPrincipal = callback.getPrincipal();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"handleCallerPrincipalCallback", (Object[])new Object[]{"user=" + userName, "principal=" + userPrincipal});
        }
        if (!executionSubject.equals(callSubject = callback.getSubject())) {
            Tr.warning((TraceComponent)tc, (String)"EXECUTION_CALLBACK_SUBJECT_MISMATCH_J2CA0673", (Object[])new Object[]{"CallerPrincipalCallback"});
        }
        String securityName = null;
        securityName = userName == null && userPrincipal == null ? unauthenticated : (userPrincipal != null ? userPrincipal.getName() : userName);
        if (securityName == null) {
            securityName = unauthenticated;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"The securityName is : ", (Object[])new Object[]{securityName});
        }
        if (!securityName.equals(unauthenticated)) {
            J2CSecurityHelper.addUniqueIdAndGroupsForUser(securityName, addedCred, appRealm);
        } else {
            addedCred.put("com.ibm.wsspi.security.cred.securityName", securityName);
            addedCred.put("com.ibm.wsspi.security.cred.cacheKey", J2CSecurityHelper.getCacheKey(null, null));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Added Credentials: ", (Object[])new Object[]{addedCred});
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"handleCallerPrincipalCallback");
        }
    }

    public static void handleGroupPrincipalCallback(GroupPrincipalCallback callback, Subject executionSubject, Hashtable<String, Object> addedCred, String appRealm, Invocation[] invocations) throws RemoteException, WSSecurityException {
        String[] groups;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"handleGroupPrincipalCallback", (Object[])new Object[]{J2CSecurityHelper.objectId(callback)});
        }
        invocations[1] = Invocation.GROUPPRINCIPALCALLBACK;
        Subject callSubject = callback.getSubject();
        if (!executionSubject.equals(callSubject)) {
            Tr.warning((TraceComponent)tc, (String)"EXECUTION_CALLBACK_SUBJECT_MISMATCH_J2CA0673", (Object[])new Object[]{"GroupPrincipalCallback"});
        }
        if ((groups = callback.getGroups()) != null && groups.length > 0) {
            ArrayList<String> groupNames;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Group names in Callback: ", (Object[])new Object[]{Arrays.asList(groups)});
            }
            if ((groupNames = (ArrayList<String>)addedCred.get("com.ibm.wsspi.security.cred.groups")) == null) {
                groupNames = new ArrayList<String>();
                addedCred.put("com.ibm.wsspi.security.cred.groups", groupNames);
            }
            GetRegistry action = new GetRegistry(appRealm);
            UserRegistry registry = null;
            try {
                registry = AccessController.doPrivileged(action);
            }
            catch (PrivilegedActionException pae) {
                Exception ex = pae.getException();
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"handleGroupPrincipalCallback");
                }
                if (ex instanceof WSSecurityException) {
                    throw (WSSecurityException)ex;
                }
                throw new WSSecurityException((Throwable)ex);
            }
            for (int i = 0; i < groups.length; ++i) {
                String group = groups[i];
                if (group == null || group.isEmpty()) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)"Group is null or an empty string, it has been ignored.", (Object[])new Object[0]);
                    continue;
                }
                if (registry.isValidGroup(group)) {
                    String groupName = registry.getUniqueGroupId(group);
                    if (!groupNames.contains(groupName)) {
                        groupNames.add(groupName);
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)tc, (String)("Added groupId: " + groupName), (Object[])new Object[0]);
                        continue;
                    }
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)(groupName + " already exists in custom credential data, avoid duplicates."), (Object[])new Object[0]);
                    continue;
                }
                Tr.warning((TraceComponent)tc, (String)"INVALID_GROUP_ENCOUNTERED_J2CA0678", (Object[])new Object[]{group});
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Callback has no groups.", (Object[])new Object[0]);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Added Credentials", (Object[])new Object[]{addedCred});
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"handleGroupPrincipalCallback");
        }
    }

    private static void addUniqueIdAndGroupsForUser(String securityName, Hashtable<String, Object> credData, String appRealm) throws WSSecurityException, RemoteException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addUniqueIdAndGroupsForUser", (Object[])new Object[]{securityName});
        }
        GetRegistry action = new GetRegistry(appRealm);
        UserRegistry registry = null;
        try {
            registry = AccessController.doPrivileged(action);
        }
        catch (PrivilegedActionException pae) {
            Exception ex = pae.getException();
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"addUniqueIdAndGroupsForUser");
            }
            if (ex instanceof WSSecurityException) {
                throw (WSSecurityException)ex;
            }
            throw new WSSecurityException((Throwable)ex);
        }
        if (registry.isValidUser(securityName)) {
            String uniqueId = registry.getUniqueUserId(securityName);
            String uidGrp = J2CSecurityHelper.stripRealm(uniqueId, appRealm);
            List groups = null;
            try {
                groups = registry.getUniqueGroupIds(uidGrp);
            }
            catch (EntryNotFoundException ex) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Exception is ", (Object[])new Object[]{ex});
                }
                Tr.warning((TraceComponent)tc, (String)"NO_GROUPS_FOR_UNIQUEID_J2CA0679", (Object[])new Object[]{uidGrp});
            }
            J2CSecurityHelper.updateCustomHashtable(credData, appRealm, uniqueId, securityName, groups);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Added uniqueId: " + uniqueId + " and uniqueGroups: " + groups), (Object[])new Object[0]);
            }
        } else {
            String message = J2CSecurityHelper.getNLS().getFormattedMessage("INVALID_USER_NAME_IN_PRINCIPAL_J2CA0670", new Object[]{securityName}, "J2CA0670E: The WorkManager was unable to establish the security context for the Work instance, because the resource adapter provided a caller identity " + securityName + ", which does not belong to the security domain associated with the application.");
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"addUniqueIdAndGroupsForUser");
            }
            throw new WSSecurityException(message);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addUniqueIdAndGroupsForUser");
        }
    }

    private static boolean checkUserPassword(String userSecurityName, String password, UserRegistry registry, String realmName, Hashtable<String, Object> addedCred, Invocation isCCInvoked) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("checkUserPassword user: " + userSecurityName + ", realm: " + realmName), (Object[])new Object[0]);
        }
        if (userSecurityName == null || password == null) {
            Tr.error((TraceComponent)tc, (String)"INVALID_USERNAME_PASSWORD_INBOUND_J2CA0674", (Object[])new Object[]{userSecurityName});
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"checkUserPassword", (Object)new Object[]{userSecurityName, password});
            }
            return false;
        }
        boolean match = J2CSecurityHelper.validateCallbackInformation(addedCred, userSecurityName, isCCInvoked);
        if (!match) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"checkUserPassword", (Object)" - invalid username and password.");
            }
            return false;
        }
        try {
            registry.checkPassword(userSecurityName, password);
            String uniqueId = registry.getUniqueUserId(userSecurityName);
            uniqueId = J2CSecurityHelper.stripRealm(uniqueId, realmName);
            ArrayList<String> uniqueGroups = new ArrayList<String>();
            List groupNames = registry.getGroupsForUser(userSecurityName);
            if (groupNames != null) {
                for (Object group : groupNames) {
                    uniqueGroups.add(registry.getUniqueGroupId((String)group));
                }
            }
            J2CSecurityHelper.updateCustomHashtable(addedCred, realmName, uniqueId, userSecurityName, uniqueGroups);
        }
        catch (PasswordCheckFailedException e) {
            Tr.error((TraceComponent)tc, (String)"INVALID_USERNAME_PASSWORD_INBOUND_J2CA0674", (Object[])new Object[]{userSecurityName});
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"checkUserPassword", (Object)" - invalid username and password");
            }
            return false;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.j2c.work.security.J2CSecurityHelper.checkUserPassword", (String)"%C");
            Tr.error((TraceComponent)tc, (String)"VALIDATION_FAILED_INBOUND_J2CA0684", (Object[])new Object[]{userSecurityName});
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"checkUserPassword", (Object)" - unable to validate password.");
            }
            return false;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"checkUserPassword", (Object)" - password is valid.");
        }
        return true;
    }

    public static String getCacheKey(String uniqueId, String appRealm) {
        StringBuilder cacheKey = new StringBuilder();
        if (uniqueId == null || appRealm == null) {
            cacheKey.append(CACHE_KEY_PREFIX);
        } else {
            cacheKey.append(CACHE_KEY_PREFIX).append(uniqueId).append(CACHE_KEY_SEPARATOR).append(appRealm);
        }
        return cacheKey.toString();
    }

    private static boolean validateCallbackInformation(Hashtable<String, Object> credData, String securityName, Invocation isInvoked) {
        String existingName;
        boolean status = true;
        if (isInvoked == Invocation.CALLERPRINCIPALCALLBACK && (existingName = (String)credData.get("com.ibm.wsspi.security.cred.securityName")) != null && !existingName.equals(securityName)) {
            status = false;
            Tr.error((TraceComponent)tc, (String)"CALLBACK_SECURITY_NAME_MISMATCH_J2CA0675", (Object[])new Object[]{securityName, existingName});
        }
        return status;
    }

    private static String stripRealm(String uniqueUserId, String realm) {
        if (uniqueUserId == null || realm == null) {
            return uniqueUserId;
        }
        int index = uniqueUserId.indexOf(realm + REALM_SEPARATOR);
        if (index > -1) {
            uniqueUserId = uniqueUserId.substring(index + realm.length() + 1);
        }
        return uniqueUserId;
    }

    public static String objectId(Object o) {
        return o == null ? "0x0" : o.getClass().getName() + "@" + Integer.toHexString(o.hashCode());
    }

    public static TraceNLS getNLS() {
        return nls;
    }

    static class AddPrivateCredentials
    implements PrivilegedAction<Object> {
        private final Subject execSubject;
        private final Hashtable<String, Object> newCred;

        public AddPrivateCredentials(Subject subject, Hashtable<String, Object> credentials) {
            this.execSubject = subject;
            this.newCred = credentials;
        }

        @Override
        public Object run() {
            this.execSubject.getPrivateCredentials().add(this.newCred);
            return null;
        }
    }

    static class GetCustomCredentials
    implements PrivilegedAction<Object> {
        private final Subject execSubject;
        private final String cacheKey;

        public GetCustomCredentials(Subject subject, String key) {
            this.execSubject = subject;
            this.cacheKey = key;
        }

        @Override
        public Object run() {
            Set<Hashtable> s = this.execSubject.getPrivateCredentials(Hashtable.class);
            if (s == null || s.isEmpty()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Subject has no Hashtable with custom credentials, return null.", (Object[])new Object[0]);
                }
                return null;
            }
            for (Hashtable t : s) {
                String key = (String)t.get("com.ibm.wsspi.security.cred.cacheKey");
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Hashtable custom key", (Object[])new Object[]{key});
                }
                if (!this.cacheKey.equals(key)) continue;
                return t;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Subject has no Hashtable that matches cacheKey, return null.", (Object[])new Object[0]);
            }
            return null;
        }
    }

    static class GetRegistry
    implements PrivilegedExceptionAction<UserRegistry> {
        private final String appRealm;

        public GetRegistry(String realm) {
            this.appRealm = realm;
        }

        @Override
        public UserRegistry run() throws Exception {
            UserRegistry registry = RegistryHelper.getUserRegistry((String)this.appRealm);
            return registry;
        }
    }
}

