/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.jaeger;

import io.opentelemetry.exporter.internal.marshal.Marshaler;
import io.opentelemetry.exporter.internal.marshal.MarshalerUtil;
import io.opentelemetry.exporter.internal.marshal.MarshalerWithSize;
import io.opentelemetry.exporter.internal.marshal.ProtoFieldInfo;
import io.opentelemetry.exporter.internal.marshal.Serializer;
import io.opentelemetry.exporter.jaeger.ProcessMarshaler;
import io.opentelemetry.exporter.jaeger.SpanMarshaler;
import io.opentelemetry.exporter.jaeger.proto.api_v2.internal.Batch;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.data.SpanData;
import java.io.IOException;
import java.util.List;

final class BatchMarshaler
extends MarshalerWithSize {
    private final SpanMarshaler[] spans;
    private final ProcessMarshaler process;

    static BatchMarshaler create(List<SpanData> spans, Resource resource) {
        SpanMarshaler[] spanMarshalers = SpanMarshaler.createRepeated(spans);
        ProcessMarshaler processMarshaler = ProcessMarshaler.create(resource);
        return new BatchMarshaler(spanMarshalers, processMarshaler);
    }

    BatchMarshaler(SpanMarshaler[] spans, ProcessMarshaler process) {
        super(BatchMarshaler.calculateSize(spans, process));
        this.spans = spans;
        this.process = process;
    }

    @Override
    protected void writeTo(Serializer output) throws IOException {
        output.serializeRepeatedMessage(Batch.SPANS, this.spans);
        output.serializeMessage(Batch.PROCESS, this.process);
    }

    private static int calculateSize(SpanMarshaler[] spans, ProcessMarshaler process) {
        int size = 0;
        size += MarshalerUtil.sizeRepeatedMessage((ProtoFieldInfo)Batch.SPANS, (Marshaler[])spans);
        return size += MarshalerUtil.sizeMessage(Batch.PROCESS, process);
    }
}

