/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.autoconfigure;

import io.opentelemetry.exporter.internal.retry.RetryPolicy;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigurationException;
import io.opentelemetry.sdk.metrics.InstrumentType;
import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.metrics.export.AggregationTemporalitySelector;
import io.opentelemetry.sdk.metrics.export.DefaultAggregationSelector;
import io.opentelemetry.sdk.metrics.internal.view.ExponentialHistogramAggregation;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nullable;

final class OtlpConfigUtil {
    static final String DATA_TYPE_TRACES = "traces";
    static final String DATA_TYPE_METRICS = "metrics";
    static final String DATA_TYPE_LOGS = "logs";
    static final String PROTOCOL_GRPC = "grpc";
    static final String PROTOCOL_HTTP_PROTOBUF = "http/protobuf";

    static String getOtlpProtocol(String dataType, ConfigProperties config) {
        String protocol = config.getString("otel.exporter.otlp." + dataType + ".protocol");
        if (protocol != null) {
            return protocol;
        }
        return config.getString("otel.exporter.otlp.protocol", PROTOCOL_GRPC);
    }

    static void configureOtlpExporterBuilder(String dataType, ConfigProperties config, Consumer<String> setEndpoint, BiConsumer<String, String> addHeader, Consumer<String> setCompression, Consumer<Duration> setTimeout, Consumer<byte[]> setTrustedCertificates, BiConsumer<byte[], byte[]> setClientTls, Consumer<RetryPolicy> setRetryPolicy) {
        boolean retryEnabled;
        Duration timeout;
        Map<String, String> headers;
        String protocol = OtlpConfigUtil.getOtlpProtocol(dataType, config);
        boolean isHttpProtobuf = protocol.equals(PROTOCOL_HTTP_PROTOBUF);
        URL endpoint = OtlpConfigUtil.validateEndpoint(config.getString("otel.exporter.otlp." + dataType + ".endpoint"), isHttpProtobuf);
        if (endpoint != null) {
            if (endpoint.getPath().isEmpty()) {
                endpoint = OtlpConfigUtil.createUrl(endpoint, "/");
            }
        } else {
            endpoint = OtlpConfigUtil.validateEndpoint(config.getString("otel.exporter.otlp.endpoint"), isHttpProtobuf);
            if (endpoint != null && isHttpProtobuf) {
                String path = endpoint.getPath();
                if (!path.endsWith("/")) {
                    path = path + "/";
                }
                path = path + OtlpConfigUtil.signalPath(dataType);
                endpoint = OtlpConfigUtil.createUrl(endpoint, path);
            }
        }
        if (endpoint != null) {
            setEndpoint.accept(endpoint.toString());
        }
        if ((headers = config.getMap("otel.exporter.otlp." + dataType + ".headers")).isEmpty()) {
            headers = config.getMap("otel.exporter.otlp.headers");
        }
        headers.forEach(addHeader);
        String compression = config.getString("otel.exporter.otlp." + dataType + ".compression");
        if (compression == null) {
            compression = config.getString("otel.exporter.otlp.compression");
        }
        if (compression != null) {
            setCompression.accept(compression);
        }
        if ((timeout = config.getDuration("otel.exporter.otlp." + dataType + ".timeout")) == null) {
            timeout = config.getDuration("otel.exporter.otlp.timeout");
        }
        if (timeout != null) {
            setTimeout.accept(timeout);
        }
        String certificatePath = config.getString(OtlpConfigUtil.determinePropertyByType(config, "otel.exporter.otlp", dataType, "certificate"));
        String clientKeyPath = config.getString(OtlpConfigUtil.determinePropertyByType(config, "otel.exporter.otlp", dataType, "client.key"));
        String clientKeyChainPath = config.getString(OtlpConfigUtil.determinePropertyByType(config, "otel.exporter.otlp", dataType, "client.certificate"));
        if (clientKeyPath != null && clientKeyChainPath == null) {
            throw new ConfigurationException("Client key provided but certification chain is missing");
        }
        if (clientKeyPath == null && clientKeyChainPath != null) {
            throw new ConfigurationException("Client key chain provided but key is missing");
        }
        byte[] certificateBytes = OtlpConfigUtil.readFileBytes(certificatePath);
        if (certificateBytes != null) {
            setTrustedCertificates.accept(certificateBytes);
        }
        byte[] clientKeyBytes = OtlpConfigUtil.readFileBytes(clientKeyPath);
        byte[] clientKeyChainBytes = OtlpConfigUtil.readFileBytes(clientKeyChainPath);
        if (clientKeyBytes != null && clientKeyChainBytes != null) {
            setClientTls.accept(clientKeyBytes, clientKeyChainBytes);
        }
        if (retryEnabled = config.getBoolean("otel.experimental.exporter.otlp.retry.enabled", false)) {
            setRetryPolicy.accept(RetryPolicy.getDefault());
        }
    }

    static void configureOtlpAggregationTemporality(ConfigProperties config, Consumer<AggregationTemporalitySelector> aggregationTemporalitySelectorConsumer) {
        AggregationTemporality temporality;
        String temporalityStr = config.getString("otel.exporter.otlp.metrics.temporality.preference");
        if (temporalityStr == null) {
            return;
        }
        try {
            temporality = AggregationTemporality.valueOf(temporalityStr.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new ConfigurationException("Unrecognized aggregation temporality: " + temporalityStr, e);
        }
        AggregationTemporalitySelector temporalitySelector = temporality == AggregationTemporality.CUMULATIVE ? AggregationTemporalitySelector.alwaysCumulative() : AggregationTemporalitySelector.deltaPreferred();
        aggregationTemporalitySelectorConsumer.accept(temporalitySelector);
    }

    static void configureOtlpHistogramDefaultAggregation(ConfigProperties config, Consumer<DefaultAggregationSelector> defaultAggregationSelectorConsumer) {
        String defaultHistogramAggregation = config.getString("otel.exporter.otlp.metrics.default.histogram.aggregation");
        if (defaultHistogramAggregation == null) {
            return;
        }
        if (defaultHistogramAggregation.equalsIgnoreCase("EXPONENTIAL_BUCKET_HISTOGRAM")) {
            defaultAggregationSelectorConsumer.accept(DefaultAggregationSelector.getDefault().with(InstrumentType.HISTOGRAM, ExponentialHistogramAggregation.getDefault()));
        } else if (!defaultHistogramAggregation.equalsIgnoreCase("EXPLICIT_BUCKET_HISTOGRAM")) {
            throw new ConfigurationException("Unrecognized default histogram aggregation: " + defaultHistogramAggregation);
        }
    }

    private static URL createUrl(URL context, String spec) {
        try {
            return new URL(context, spec);
        }
        catch (MalformedURLException e) {
            throw new ConfigurationException("Unexpected exception creating URL.", e);
        }
    }

    @Nullable
    private static URL validateEndpoint(@Nullable String endpoint, boolean allowPath) {
        URL endpointUrl;
        if (endpoint == null) {
            return null;
        }
        try {
            endpointUrl = new URL(endpoint);
        }
        catch (MalformedURLException e) {
            throw new ConfigurationException("OTLP endpoint must be a valid URL: " + endpoint, e);
        }
        if (!endpointUrl.getProtocol().equals("http") && !endpointUrl.getProtocol().equals("https")) {
            throw new ConfigurationException("OTLP endpoint scheme must be http or https: " + endpointUrl.getProtocol());
        }
        if (endpointUrl.getQuery() != null) {
            throw new ConfigurationException("OTLP endpoint must not have a query string: " + endpointUrl.getQuery());
        }
        if (endpointUrl.getRef() != null) {
            throw new ConfigurationException("OTLP endpoint must not have a fragment: " + endpointUrl.getRef());
        }
        if (!(allowPath || endpointUrl.getPath().isEmpty() || endpointUrl.getPath().equals("/"))) {
            throw new ConfigurationException("OTLP endpoint must not have a path: " + endpointUrl.getPath());
        }
        return endpointUrl;
    }

    @Nullable
    private static byte[] readFileBytes(@Nullable String filePath) {
        if (filePath == null) {
            return null;
        }
        Path path = Paths.get(filePath, new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            throw new ConfigurationException("Invalid OTLP certificate/key path: " + path);
        }
        try {
            return Files.readAllBytes(path);
        }
        catch (IOException e) {
            throw new ConfigurationException("Error reading content of file (" + path + ")", e);
        }
    }

    private static String determinePropertyByType(ConfigProperties config, String prefix, String dataType, String suffix) {
        String propertyToRead = prefix + "." + dataType + "." + suffix;
        if (OtlpConfigUtil.configContainsKey(config, propertyToRead)) {
            return propertyToRead;
        }
        return prefix + "." + suffix;
    }

    private static boolean configContainsKey(ConfigProperties config, String propertyToRead) {
        return config.getString(propertyToRead) != null;
    }

    private static String signalPath(String dataType) {
        switch (dataType) {
            case "metrics": {
                return "v1/metrics";
            }
            case "traces": {
                return "v1/traces";
            }
            case "logs": {
                return "v1/logs";
            }
        }
        throw new IllegalArgumentException("Cannot determine signal path for unrecognized data type: " + dataType);
    }

    private OtlpConfigUtil() {
    }
}

