/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.logs;

import io.opentelemetry.api.logs.LoggerBuilder;
import io.opentelemetry.api.logs.LoggerProvider;
import io.opentelemetry.sdk.common.Clock;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import io.opentelemetry.sdk.internal.ComponentRegistry;
import io.opentelemetry.sdk.logs.LogLimits;
import io.opentelemetry.sdk.logs.LogRecordProcessor;
import io.opentelemetry.sdk.logs.LoggerSharedState;
import io.opentelemetry.sdk.logs.NoopLogRecordProcessor;
import io.opentelemetry.sdk.logs.SdkLogger;
import io.opentelemetry.sdk.logs.SdkLoggerBuilder;
import io.opentelemetry.sdk.logs.SdkLoggerProviderBuilder;
import io.opentelemetry.sdk.resources.Resource;
import java.io.Closeable;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class SdkLoggerProvider
implements LoggerProvider,
Closeable {
    static final String DEFAULT_LOGGER_NAME = "unknown";
    private static final Logger LOGGER = Logger.getLogger(SdkLoggerProvider.class.getName());
    private final LoggerSharedState sharedState;
    private final ComponentRegistry<SdkLogger> loggerComponentRegistry;
    private final boolean isNoopLogRecordProcessor;

    public static SdkLoggerProviderBuilder builder() {
        return new SdkLoggerProviderBuilder();
    }

    SdkLoggerProvider(Resource resource, Supplier<LogLimits> logLimitsSupplier, List<LogRecordProcessor> processors, Clock clock) {
        LogRecordProcessor logRecordProcessor = LogRecordProcessor.composite(processors);
        this.sharedState = new LoggerSharedState(resource, logLimitsSupplier, logRecordProcessor, clock);
        this.loggerComponentRegistry = new ComponentRegistry<SdkLogger>(instrumentationScopeInfo -> new SdkLogger(this.sharedState, (InstrumentationScopeInfo)instrumentationScopeInfo));
        this.isNoopLogRecordProcessor = logRecordProcessor instanceof NoopLogRecordProcessor;
    }

    @Override
    public io.opentelemetry.api.logs.Logger get(String instrumentationScopeName) {
        return this.loggerBuilder(instrumentationScopeName).build();
    }

    @Override
    public LoggerBuilder loggerBuilder(String instrumentationScopeName) {
        if (this.isNoopLogRecordProcessor) {
            return LoggerProvider.noop().loggerBuilder(instrumentationScopeName);
        }
        if (instrumentationScopeName == null || instrumentationScopeName.isEmpty()) {
            LOGGER.fine("Logger requested without instrumentation scope name.");
            instrumentationScopeName = DEFAULT_LOGGER_NAME;
        }
        return new SdkLoggerBuilder(this.loggerComponentRegistry, instrumentationScopeName);
    }

    public CompletableResultCode forceFlush() {
        return this.sharedState.getLogRecordProcessor().forceFlush();
    }

    public CompletableResultCode shutdown() {
        if (this.sharedState.hasBeenShutdown()) {
            LOGGER.log(Level.WARNING, "Calling shutdown() multiple times.");
            return CompletableResultCode.ofSuccess();
        }
        return this.sharedState.shutdown();
    }

    @Override
    public void close() {
        this.shutdown().join(10L, TimeUnit.SECONDS);
    }
}

