/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.collective.utility.tasks;

import com.ibm.ws.collective.utility.ICollectiveRegistrationMBeanConnection;
import com.ibm.ws.collective.utility.IFileUtility;
import com.ibm.ws.collective.utility.TaskErrorException;
import com.ibm.ws.collective.utility.tasks.BaseCommandTask;
import com.ibm.ws.collective.utility.tasks.GenKeyTask;
import com.ibm.ws.collective.utility.utils.ConsoleWrapper;
import com.ibm.ws.collective.utility.utils.Trlog;
import java.io.File;
import java.io.PrintStream;
import java.util.Arrays;

public class GenKeyControllerTask
extends BaseCommandTask {
    private static final String className = GenKeyControllerTask.class.getName();
    String CERTIFICATE_SUBJECT_ALT_NAMES = "certificateSubjectAltNames";
    GenKeyTask genKeyTask = null;

    public GenKeyControllerTask(String scriptName, IFileUtility fileUtility, ICollectiveRegistrationMBeanConnection registrationMBean) {
        super(scriptName, fileUtility);
        this.genKeyTask = new GenKeyTask(scriptName, fileUtility, registrationMBean);
    }

    @Override
    public String getTaskName() {
        return "genKeyController";
    }

    @Override
    public String getTaskUsage() {
        return this.getTaskUsage("genKeyController.usage.options");
    }

    @Override
    public String getTaskHelp() {
        String footer = this.buildScriptOptions("genKey.required-option-key.keystorePassword", "genKey.required-option-desc.keystorePassword") + this.buildScriptOptions("genKey.option-key.", "genKey.option-desc.") + this.buildScriptOptions("genKey.controller-key.sanHostName", "genKey.controller-desc.sanHostName") + this.buildScriptOptions("encoding.option-key.", "encoding.option-desc.") + this.buildScriptOptions("certProps.option-key.autoAccept", "certProps.option-desc.autoAccept") + this.buildScriptOptions("certProps.option-key.disableHostnameVerification", "certProps.option-desc.disableHostnameVerification");
        return this.getTaskHelp("genKeyController.desc", "genKeyController.usage.options", "connection.option-key.", "connection.option-desc.", null, footer, this.scriptName);
    }

    @Override
    public String getTaskDescription() {
        return this.getOption("genKeyController.desc", new Object[0]);
    }

    @Override
    protected void abort(String message) throws TaskErrorException {
        this.stdout.println(this.getMessage("genKeyController.abort", new Object[0]));
        throw new TaskErrorException(message);
    }

    @Override
    protected void abortAndPerformCleanup(String message, File keyFile) throws TaskErrorException {
        this.stdout.println(this.getMessage("genKeyController.abort", new Object[0]));
        if (!this.fileUtility.recurisveDelete(keyFile)) {
            this.stdout.println(this.getMessage("genKeyController.cleanupFail", keyFile));
        }
        throw new TaskErrorException(message);
    }

    @Override
    public void handleTask(ConsoleWrapper stdin, PrintStream stdout, PrintStream stderr, String[] args) throws TaskErrorException {
        String[] controllerArgs = new String[args.length + 1];
        controllerArgs = Arrays.copyOf(args, args.length + 1);
        controllerArgs[args.length] = "--keyForController=true";
        Trlog.debug(className, "genKeyController handleTask", "calls genKey handleTask with args: ");
        for (int i = 0; i < controllerArgs.length; ++i) {
            Trlog.debug(className, "genKeyController handleTask", controllerArgs[i]);
        }
        this.genKeyTask.handleTask(stdin, stdout, stderr, controllerArgs);
    }
}

