/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.collective.utility.tasks;

import com.ibm.ws.collective.utility.ICollectiveRegistrationMBeanConnection;
import com.ibm.ws.collective.utility.TaskErrorException;
import com.ibm.ws.collective.utility.tasks.BaseCommandTask;
import com.ibm.ws.collective.utility.utils.ConsoleWrapper;
import com.ibm.ws.collective.utility.utils.Trlog;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.ConnectException;
import java.net.UnknownHostException;
import javax.management.RuntimeMBeanException;

public class UnregisterHostTask
extends BaseCommandTask {
    private static final String className = UnregisterHostTask.class.getName();
    private final ICollectiveRegistrationMBeanConnection registrationMBean;

    public UnregisterHostTask(String scriptName, ICollectiveRegistrationMBeanConnection registrationMBean) {
        super(scriptName, null);
        this.registrationMBean = registrationMBean;
        this.reqConnectArgs.add("--host");
        this.reqConnectArgs.add("--port");
        this.reqConnectArgs.add("--user");
        this.reqConnectArgs.add("--password");
        this.promptableArgs.add("--password");
        this.flagArgs.add("--trace");
        this.flagArgs.add("--controller");
        this.knownArgs.addAll(this.reqConnectArgs);
        this.knownArgs.addAll(this.promptableArgs);
        this.knownArgs.addAll(this.confirmedArgs);
        this.knownArgs.addAll(this.flagArgs);
        this.knownArgs.add("--hostName");
        this.addAutoAcceptAndDisableHostnameVerificationArguments();
    }

    @Override
    public String getTaskName() {
        return "unregisterHost";
    }

    @Override
    public String getTaskUsage() {
        return this.getTaskUsage("unregisterHost.usage.options");
    }

    @Override
    public String getTaskHelp() {
        String footer = this.buildScriptOptions("certProps.option-key.autoAccept", "certProps.option-desc.autoAccept") + this.buildScriptOptions("certProps.option-key.disableHostnameVerification", "certProps.option-desc.disableHostnameVerification");
        return this.getTaskHelp("unregisterHost.desc", "unregisterHost.usage.options", "connection.option-key.", "connection.option-desc.", null, footer, this.scriptName);
    }

    @Override
    public String getTaskDescription() {
        return this.getOption("unregisterHost.desc", new Object[0]);
    }

    @Override
    protected void abort(String message) {
        this.stderr.println(message);
    }

    @Override
    protected void abortAndPerformCleanup(String message, File collectiveResourcesDir) throws TaskErrorException {
    }

    private boolean unregisterHost(String host, int port, String user, String password, String hostName) {
        String methodName = "unregisterHost";
        Trlog.enter(className, methodName, new Object[]{host, port, user, password.replaceAll(".", "*"), hostName});
        try {
            this.registrationMBean.unregisterHost(host, port, user, password, hostName);
            Trlog.exit(className, methodName, "Host " + hostName + " successfully unregistered.");
            this.stdout.println(this.getMessage("unregisterHost.unregisterSuccess", hostName));
            return true;
        }
        catch (RuntimeMBeanException e) {
            Trlog.debug(className, methodName, "Caught RuntimeMBeanException, this may be expected, but here's the stack incase it helps.", e);
            if (e.getCause() instanceof IllegalStateException) {
                Trlog.exit(className, methodName, "Host " + hostName + " is registered already and no need to resgister it again.");
                this.stdout.println(this.getMessage("unregisterHost.unregisteredAlready", hostName));
                return true;
            }
            Trlog.debug(className, methodName, "Unexpected RuntimeMBeanException while invoking the MBean", e);
            this.stderr.println(this.getMessage("error", e.getMessage()));
            this.abort(this.getMessage("common.connectionError", host, port, user, e.getMessage()));
        }
        catch (UnknownHostException e) {
            Trlog.debug(className, methodName, "UnknownHostException while invoking the MBean: ", e);
            this.abort(this.getMessage("common.hostError", host));
        }
        catch (ConnectException e) {
            Trlog.debug(className, methodName, "ConnectException while invoking the MBean: ", e);
            this.abort(this.getMessage("common.portError", String.valueOf(port)));
        }
        catch (IOException e) {
            Trlog.debug(className, methodName, "IOException while invoking the MBean: ", e);
            this.abort(this.getMessage("common.connectionError", host, port, user, e.getMessage()));
        }
        catch (Exception e) {
            Trlog.debug(className, methodName, "Unexpected Exception while invoking the MBean: ", e);
            this.stderr.println(this.getMessage("error", e.getMessage()));
            this.abort(this.getMessage("common.connectionError", host, port, user, e.getMessage()));
        }
        Trlog.exit(className, methodName, "return false");
        return false;
    }

    @Override
    public void handleTask(ConsoleWrapper stdin, PrintStream stdout, PrintStream stderr, String[] args) {
        this.setupTrace(args, className, this.fileUtility);
        String methodName = "handleTask";
        Trlog.enter(className, methodName);
        this.stdin = stdin;
        this.stdout = stdout;
        this.stderr = stderr;
        this.validateArgumentList(args, true);
        String hostName = this.getTaskTarget(args);
        if (hostName == null) {
            hostName = this.getHostName();
            Trlog.debug(className, methodName, "The host name was not specified, defaulting to this hosts name: " + hostName);
        }
        String controllerHost = this.getControllerHost(args);
        int controllerPort = Integer.valueOf(this.getControllerPort(args));
        String user = this.getControllerUser(args);
        String password = this.getControllerPassword(args);
        this.handleAutoAcceptAndDisableHostnameVerificationArgs(args);
        Trlog.debug(className, methodName, "Unregistering the host from the collective...");
        stdout.println(this.getMessage("unregisterHost.attemptUnregister", new Object[0]));
        if (!this.unregisterHost(controllerHost, controllerPort, user, password, hostName)) {
            Trlog.debug(className, methodName, "Host " + hostName + " could not be unregistered due to an error.");
            stdout.println(this.getMessage("unregisterHost.unregisterFailed", hostName));
        }
        Trlog.exit(className, methodName);
    }
}

