/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.collective.utility.utils;

import com.ibm.ws.collective.utility.ICommonMBeanConnection;
import com.ibm.ws.collective.utility.utils.ConsoleWrapper;
import com.ibm.ws.collective.utility.utils.PromptX509TrustManager;
import com.ibm.ws.jmx.connector.client.rest.ClientProvider;
import java.io.IOException;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXServiceURL;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class CommonMBeanConnection
implements ICommonMBeanConnection {
    private final ConsoleWrapper stdin;
    private final PrintStream stdout;

    public CommonMBeanConnection(ConsoleWrapper stdin, PrintStream stdout) {
        this.stdin = stdin;
        this.stdout = stdout;
    }

    private X509TrustManager createPromptingTrustManager() {
        TrustManager[] trustManagers = null;
        try {
            String defaultAlg = TrustManagerFactory.getDefaultAlgorithm();
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(defaultAlg);
            tmf.init((KeyStore)null);
            trustManagers = tmf.getTrustManagers();
        }
        catch (KeyStoreException defaultAlg) {
        }
        catch (NoSuchAlgorithmException defaultAlg) {
            // empty catch block
        }
        boolean autoAccept = Boolean.valueOf(System.getProperty("com.ibm.websphere.collective.utility.autoAcceptCertificates", "false"));
        return new PromptX509TrustManager(this.stdin, this.stdout, trustManagers, autoAccept);
    }

    private SSLSocketFactory setUpSSLContext() throws NoSuchAlgorithmException, KeyManagementException {
        SSLContext ctx = SSLContext.getInstance("SSL");
        ctx.init(null, new TrustManager[]{this.createPromptingTrustManager()}, null);
        return ctx.getSocketFactory();
    }

    private HashMap<String, Object> createJMXEnvironment(String user, String password, SSLSocketFactory sslSF) {
        HashMap<String, Object> environment = new HashMap<String, Object>();
        environment.put("jmx.remote.protocol.provider.pkgs", "com.ibm.ws.jmx.connector.client");
        environment.put("jmx.remote.credentials", new String[]{user, password});
        environment.put("com.ibm.ws.jmx.connector.client.rest.readTimeout", 120000);
        environment.put("com.ibm.ws.jmx.connector.client.disableURLHostnameVerification", Boolean.valueOf(System.getProperty("com.ibm.websphere.collective.utility.disableHostnameVerification", "false")));
        environment.put("com.ibm.ws.jmx.connector.client.CUSTOM_SSLSOCKETFACTORY", sslSF);
        environment.put("isCollectiveUtil", Boolean.TRUE);
        return environment;
    }

    private JMXConnector getMBeanServerConnection(String controllerHost, int controllerPort, HashMap<String, Object> environment) throws MalformedURLException, IOException {
        JMXServiceURL serviceURL = new JMXServiceURL("REST", controllerHost, controllerPort, "/IBMJMXConnectorREST");
        return new ClientProvider().newJMXConnector(serviceURL, environment);
    }

    public JMXConnector getJMXConnector(String controllerHost, int controllerPort, String user, String password) throws NoSuchAlgorithmException, KeyManagementException, MalformedURLException, IOException {
        HashMap<String, Object> environment = this.createJMXEnvironment(user, password, this.setUpSSLContext());
        JMXConnector connector = this.getMBeanServerConnection(controllerHost, controllerPort, environment);
        connector.connect();
        return connector;
    }
}

