/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.openapi40.internal.services.validation;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.openapi20.internal.services.OASValidationResult;
import io.openliberty.microprofile.openapi20.internal.utils.OpenAPIModelWalker;
import io.openliberty.microprofile.openapi20.internal.validation.TypeValidator;
import io.openliberty.microprofile.openapi20.internal.validation.ValidationHelper;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.microprofile.openapi.models.Constructible;
import org.eclipse.microprofile.openapi.models.media.Schema;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class Schema31Validator
extends TypeValidator<Schema> {
    private static final TraceComponent tc = Tr.register(Schema31Validator.class, (String)"MPOPENAPI", (String)"io.openliberty.microprofile.openapi.internal.resources.validation.ValidationMessages");
    private static final Set<String> VALID_TYPES = Set.of("null", "boolean", "object", "array", "number", "integer", "string");
    private static final Schema31Validator INSTANCE = new Schema31Validator();
    static final long serialVersionUID = -5419575599797111250L;

    public static Schema31Validator getInstance() {
        return INSTANCE;
    }

    private Schema31Validator() {
    }

    public void validate(ValidationHelper helper, OpenAPIModelWalker.Context context, String key, Schema schema) {
        if (schema == null) {
            return;
        }
        if (!this.isSupportedDialect(schema, context)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)"Schema uses an unsupported dialect, not validating.", (Object[])new Object[]{schema.getSchemaDialect()});
            }
            return;
        }
        if (schema.getBooleanSchema() != null) {
            return;
        }
        String ref = schema.getRef();
        if (ref != null) {
            helper.validateReference(context, key, schema.getRef(), Schema.class);
        }
        this.validatePropType(helper, context, schema, "$comment", PropertyType.STRING);
        this.validateArrayOfSchema(helper, context, schema, "allOf");
        this.validateArrayOfSchema(helper, context, schema, "anyOf");
        this.validateArrayOfSchema(helper, context, schema, "oneOf");
        this.validateIsSchema(helper, context, schema, "not");
        this.validateIsSchema(helper, context, schema, "if");
        this.validateIsSchema(helper, context, schema, "then");
        this.validateIsSchema(helper, context, schema, "else");
        this.validateIsMapOfNamedSchemas(helper, context, schema, "dependentSchemas");
        this.validateArrayOfSchema(helper, context, schema, "prefixItems");
        this.validateIsSchema(helper, context, schema, "items");
        this.validateIsSchema(helper, context, schema, "contains");
        this.validateIsMapOfNamedSchemas(helper, context, schema, "properties");
        this.validateIsMapOfNamedSchemas(helper, context, schema, "patternProperties");
        this.validateIsSchema(helper, context, schema, "additionalProperties");
        this.validateIsSchema(helper, context, schema, "propertyNames");
        this.validateIsSchema(helper, context, schema, "unevaluatedItems");
        this.validateIsSchema(helper, context, schema, "unevaluatedProperties");
        this.validateType(helper, context, schema);
        this.validateEnum(helper, context, schema);
        this.validateMultipleOf(helper, context, schema);
        this.validatePropType(helper, context, schema, "maximum", PropertyType.NUMBER);
        this.validatePropType(helper, context, schema, "exclusiveMaximum", PropertyType.NUMBER);
        this.validatePropType(helper, context, schema, "minimum", PropertyType.NUMBER);
        this.validatePropType(helper, context, schema, "exclusiveMinimum", PropertyType.NUMBER);
        this.validateIntZeroOrGreater(helper, context, schema, "maxLength");
        this.validateIntZeroOrGreater(helper, context, schema, "minLength");
        this.validatePropType(helper, context, schema, "pattern", PropertyType.STRING);
        this.validateIntZeroOrGreater(helper, context, schema, "maxItems");
        this.validateIntZeroOrGreater(helper, context, schema, "minItems");
        this.validatePropType(helper, context, schema, "uniqueItems", PropertyType.BOOLEAN);
        this.validateIntZeroOrGreater(helper, context, schema, "maxContains");
        this.validateIntZeroOrGreater(helper, context, schema, "minContains");
        this.validateIntZeroOrGreater(helper, context, schema, "maxProperties");
        this.validateIntZeroOrGreater(helper, context, schema, "minProperties");
        this.validateRequired(helper, context, schema);
        this.validateDependentRequred(helper, context, schema);
        this.validatePropType(helper, context, schema, "format", PropertyType.STRING);
        this.validatePropType(helper, context, schema, "contentEncoding", PropertyType.STRING);
        this.validatePropType(helper, context, schema, "contentMediaType", PropertyType.STRING);
        this.validateIsSchema(helper, context, schema, "contentSchema");
        this.validatePropType(helper, context, schema, "title", PropertyType.STRING);
        this.validatePropType(helper, context, schema, "description", PropertyType.STRING);
        this.validatePropType(helper, context, schema, "deprecated", PropertyType.BOOLEAN);
        this.validatePropType(helper, context, schema, "readOnly", PropertyType.BOOLEAN);
        this.validatePropType(helper, context, schema, "writeOnly", PropertyType.BOOLEAN);
        this.validatePropType(helper, context, schema, "examples", PropertyType.ARRAY);
    }

    private void validateType(ValidationHelper helper, OpenAPIModelWalker.Context context, Schema schema) {
        boolean isValid;
        Object o = schema.get("type");
        if (o == null) {
            return;
        }
        if (o instanceof List) {
            isValid = true;
            for (Object e : (List)o) {
                if (this.isValidTypeElement(e)) continue;
                isValid = false;
                break;
            }
        } else {
            isValid = this.isValidTypeElement(o);
        }
        if (!isValid) {
            String message = Tr.formatMessage((TraceComponent)tc, (String)"schemaInvalidType", (Object[])new Object[0]);
            helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation(), message));
            return;
        }
        if (o instanceof List) {
            HashSet set = new HashSet();
            for (Object e : (List)o) {
                if (set.add(e)) continue;
                String message = Tr.formatMessage((TraceComponent)tc, (String)"schemaPropertyNotUnique", (Object[])new Object[]{"type"});
                helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation(), message));
                return;
            }
        }
    }

    private boolean isValidTypeElement(Object o) {
        if (o instanceof Schema.SchemaType) {
            return true;
        }
        if (o instanceof String) {
            return VALID_TYPES.contains(o);
        }
        return false;
    }

    private void validateEnum(ValidationHelper helper, OpenAPIModelWalker.Context context, Schema schema) {
        Object o = schema.get("enum");
        if (o == null) {
            return;
        }
        if (!(o instanceof List)) {
            String message = Tr.formatMessage((TraceComponent)tc, (String)"schemaPropertyWrongType", (Object[])new Object[]{"enum", "array"});
            helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation(), message));
            return;
        }
        List list = (List)o;
        if (list.size() == 0) {
            String message = Tr.formatMessage((TraceComponent)tc, (String)"schemaPropertyEmptyArray", (Object[])new Object[]{"enum"});
            helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.WARNING, context.getLocation(), message));
            return;
        }
        HashSet set = new HashSet();
        for (Object e : list) {
            if (set.add(e)) continue;
            String message = Tr.formatMessage((TraceComponent)tc, (String)"schemaPropertyNotUnique", (Object[])new Object[]{"enum"});
            helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.WARNING, context.getLocation(), message));
            return;
        }
    }

    private void validateMultipleOf(ValidationHelper helper, OpenAPIModelWalker.Context context, Schema schema) {
        boolean isGreaterThanZero;
        Object o = schema.get("multipleOf");
        if (o == null) {
            return;
        }
        if (!(o instanceof Number)) {
            String message = Tr.formatMessage((TraceComponent)tc, (String)"schemaPropertyWrongType", (Object[])new Object[]{"multipleOf", "number"});
            helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation(), message));
            return;
        }
        if (o instanceof BigDecimal) {
            BigDecimal decimal = (BigDecimal)o;
            isGreaterThanZero = decimal.compareTo(BigDecimal.ZERO) > 0;
        } else if (o instanceof Double) {
            Double d = (Double)o;
            isGreaterThanZero = d > 0.0;
        } else if (o instanceof Float) {
            Float f = (Float)o;
            isGreaterThanZero = f.floatValue() > 0.0f;
        } else if (o instanceof BigInteger) {
            BigInteger bigInteger = (BigInteger)o;
            isGreaterThanZero = bigInteger.compareTo(BigInteger.ZERO) > 0;
        } else {
            Number n = (Number)o;
            boolean bl = isGreaterThanZero = n.doubleValue() > 0.0;
        }
        if (!isGreaterThanZero) {
            String message = Tr.formatMessage((TraceComponent)tc, (String)"schemaMultipleOfNotGreaterThanZero", (Object[])new Object[0]);
            helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation(), message));
        }
    }

    private void validateRequired(ValidationHelper helper, OpenAPIModelWalker.Context context, Schema schema) {
        Object o = schema.get("required");
        if (o == null) {
            return;
        }
        if (!(o instanceof List)) {
            String message = Tr.formatMessage((TraceComponent)tc, (String)"schemaPropertyWrongType", (Object[])new Object[]{"required", "array"});
            helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation(), message));
            return;
        }
        List list = (List)o;
        for (Object e : list) {
            if (e instanceof String) continue;
            String message = Tr.formatMessage((TraceComponent)tc, (String)"schemaCollectionElementWrongType", (Object[])new Object[]{"required", "string"});
            helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation(), message));
            return;
        }
        HashSet set = new HashSet();
        for (Object e : list) {
            if (set.add(e)) continue;
            String message = Tr.formatMessage((TraceComponent)tc, (String)"schemaPropertyNotUnique", (Object[])new Object[]{"required"});
            helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation(), message));
            return;
        }
    }

    private void validateDependentRequred(ValidationHelper helper, OpenAPIModelWalker.Context context, Schema schema) {
        Object o = schema.get("dependentRequired");
        if (o == null) {
            return;
        }
        if (!(o instanceof Map)) {
            String message = Tr.formatMessage((TraceComponent)tc, (String)"schemaPropertyWrongType", (Object[])new Object[]{"dependentRequired", "object"});
            helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation(), message));
            return;
        }
        Map map = (Map)o;
        for (Object value : map.values()) {
            if (value instanceof List) continue;
            String message = Tr.formatMessage((TraceComponent)tc, (String)"schemaCollectionElementWrongType", (Object[])new Object[]{"dependentRequired", "array"});
            helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation(), message));
            return;
        }
        for (Object value : map.values()) {
            List list = (List)value;
            HashSet set = new HashSet();
            for (Object element : list) {
                if (element instanceof String && set.add(element)) continue;
                String message = Tr.formatMessage((TraceComponent)tc, (String)"schemaDependentRequiredUniqueStrings", (Object[])new Object[0]);
                helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation(), message));
                return;
            }
        }
    }

    private void validateIntZeroOrGreater(ValidationHelper helper, OpenAPIModelWalker.Context context, Schema schema, String prop) {
        Number value;
        boolean isZeroOrGreater;
        Object o = schema.get(prop);
        if (o == null) {
            return;
        }
        if (o instanceof Integer) {
            Integer integer = (Integer)o;
            isZeroOrGreater = integer >= 0;
        } else if (o instanceof Long) {
            value = (Long)o;
            isZeroOrGreater = (Long)value >= 0L;
        } else if (o instanceof Short) {
            Short s = (Short)o;
            isZeroOrGreater = s >= 0;
        } else if (o instanceof Byte) {
            value = (Byte)o;
            isZeroOrGreater = (Byte)value >= 0;
        } else if (o instanceof BigInteger) {
            value = (BigInteger)o;
            isZeroOrGreater = ((BigInteger)value).compareTo(BigInteger.ZERO) >= 0;
        } else {
            String message = Tr.formatMessage((TraceComponent)tc, (String)"schemaPropertyWrongType", (Object[])new Object[]{prop, "integer"});
            helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation(), message));
            return;
        }
        if (!isZeroOrGreater) {
            String message = Tr.formatMessage((TraceComponent)tc, (String)"schemaPropertyLessThanZero", (Object[])new Object[]{prop});
            helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation(), message));
        }
    }

    private boolean isSchema(Object o) {
        if (o instanceof Schema) {
            return true;
        }
        if (o instanceof Boolean) {
            return true;
        }
        return o instanceof Map;
    }

    private void validateIsSchema(ValidationHelper helper, OpenAPIModelWalker.Context context, Schema schema, String prop) {
        Object o = schema.get(prop);
        if (o == null) {
            return;
        }
        if (!this.isSchema(o)) {
            String message = Tr.formatMessage((TraceComponent)tc, (String)"schemaPropertyWrongType", (Object[])new Object[]{prop, "schema"});
            helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation(), message));
        }
    }

    private void validateIsMapOfNamedSchemas(ValidationHelper helper, OpenAPIModelWalker.Context context, Schema schema, String prop) {
        Object o = schema.get(prop);
        if (o == null) {
            return;
        }
        if (!(o instanceof Map)) {
            String message = Tr.formatMessage((TraceComponent)tc, (String)"schemaPropertyWrongType", (Object[])new Object[]{prop, "object"});
            helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation(), message));
            return;
        }
        Map map = (Map)o;
        for (Object e : map.values()) {
            if (this.isSchema(e)) continue;
            String message = Tr.formatMessage((TraceComponent)tc, (String)"schemaCollectionElementWrongType", (Object[])new Object[]{prop, "schema"});
            helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation(), message));
            return;
        }
    }

    private void validateArrayOfSchema(ValidationHelper helper, OpenAPIModelWalker.Context context, Schema schema, String prop) {
        Object o = schema.get(prop);
        if (o == null) {
            return;
        }
        if (!(o instanceof List)) {
            String message = Tr.formatMessage((TraceComponent)tc, (String)"schemaPropertyWrongType", (Object[])new Object[]{prop, "array"});
            helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation(), message));
            return;
        }
        List list = (List)o;
        for (Object e : list) {
            if (this.isSchema(e)) continue;
            String message = Tr.formatMessage((TraceComponent)tc, (String)"schemaCollectionElementWrongType", (Object[])new Object[]{prop, "schema"});
            helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation(), message));
            return;
        }
    }

    private void validatePropType(ValidationHelper helper, OpenAPIModelWalker.Context context, Schema schema, String prop, PropertyType type) {
        Object o = schema.get(prop);
        if (o == null) {
            return;
        }
        PropertyType actualType = o instanceof Number ? PropertyType.NUMBER : (o instanceof String ? PropertyType.STRING : (o instanceof List ? PropertyType.ARRAY : (o instanceof Map ? PropertyType.OBJECT : (o instanceof Boolean ? PropertyType.BOOLEAN : (o instanceof Schema ? (((Schema)o).getBooleanSchema() != false ? PropertyType.BOOLEAN : PropertyType.OBJECT) : (o instanceof Constructible ? PropertyType.OBJECT : PropertyType.UNKNOWN))))));
        if (actualType != type) {
            String message = Tr.formatMessage((TraceComponent)tc, (String)"schemaPropertyWrongType", (Object[])new Object[]{prop, type});
            helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation(), message));
        }
    }

    private boolean isSupportedDialect(Schema schema, OpenAPIModelWalker.Context context) {
        String dialect = schema.getSchemaDialect();
        return dialect == null || dialect.equals("https://json-schema.org/draft/2020-12/schema") || dialect.equals("https://spec.openapis.org/oas/3.1/dialect/base");
    }

    private static enum PropertyType {
        STRING("string"),
        NUMBER("number"),
        ARRAY("array"),
        OBJECT("object"),
        BOOLEAN("boolean"),
        UNKNOWN("unknown");

        private String value;

        private PropertyType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

