/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.concurrent.internal;

import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.concurrent.ContextualAction;
import com.ibm.ws.concurrent.cdi.MTFBeanResourceInfo;
import com.ibm.ws.concurrent.internal.ManagedForkJoinWorkerThread;
import com.ibm.ws.concurrent.internal.ManagedThreadImpl;
import com.ibm.ws.concurrent.internal.ManagedVirtualThreadAction;
import com.ibm.ws.concurrent.internal.ThreadGroupTracker;
import com.ibm.ws.container.service.metadata.extended.DeferredMetaDataFactory;
import com.ibm.ws.container.service.metadata.extended.IdentifiableComponentMetaData;
import com.ibm.ws.container.service.metadata.extended.MetaDataIdentifierService;
import com.ibm.ws.kernel.service.util.JavaInfo;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.runtime.metadata.MetaData;
import com.ibm.ws.runtime.metadata.ModuleMetaData;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import com.ibm.wsspi.application.lifecycle.ApplicationRecycleComponent;
import com.ibm.wsspi.application.lifecycle.ApplicationRecycleContext;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.resource.ResourceFactory;
import com.ibm.wsspi.resource.ResourceInfo;
import com.ibm.wsspi.threadcontext.ThreadContextDescriptor;
import com.ibm.wsspi.threadcontext.WSContextService;
import io.openliberty.threading.virtual.VirtualThreadOps;
import jakarta.enterprise.concurrent.ManagedThreadFactory;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(configurationPid={"com.ibm.ws.concurrent.managedThreadFactory"}, configurationPolicy=ConfigurationPolicy.REQUIRE, service={ResourceFactory.class, ApplicationRecycleComponent.class}, property={"creates.objectClass=java.util.concurrent.ThreadFactory", "creates.objectClass=jakarta.enterprise.concurrent.ManagedThreadFactory"})
public class ManagedThreadFactoryService
implements ResourceFactory,
ApplicationRecycleComponent {
    private static final TraceComponent tc = Tr.register(ManagedThreadFactoryService.class, (String)"concurrent", (String)"com.ibm.ws.concurrent.resources.CWWKCMessages");
    private static final String CONFIG_ID = "config.displayId";
    private static final String CREATE_DAEMON_THREADS = "createDaemonThreads";
    private static final String DEFAULT_PRIORITY = "defaultPriority";
    private static final String MAX_PRIORITY = "maxPriority";
    private static final String VIRTUAL = "virtual";
    private final Set<String> applications = Collections.newSetFromMap(new ConcurrentHashMap());
    private final AtomicServiceReference<WSContextService> contextSvcRef = new AtomicServiceReference("ContextService");
    boolean createDaemonThreads;
    private final AtomicInteger createdThreadCount = new AtomicInteger();
    private final Map<String, String> defaultExecutionProperties;
    Integer defaultPriority;
    final AtomicBoolean isShutdown = new AtomicBoolean();
    private final MetaDataIdentifierService metadataIdentifierService;
    private final String name;
    private final ThreadGroup threadGroup;
    private final ThreadGroupTracker threadGroupTracker;
    private final ThreadFactory virtualThreadFactory;
    @Reference(target="(deferredMetaData=WEB)", cardinality=ReferenceCardinality.OPTIONAL, policyOption=ReferencePolicyOption.GREEDY)
    protected DeferredMetaDataFactory webMetadataFactory;
    static final long serialVersionUID = -7777207865028068169L;

    @Trivial
    @ManualTrace
    @Activate
    public ManagedThreadFactoryService(ComponentContext componentContext, @Reference(name="ContextService", service=WSContextService.class, target="(id=unbound)") ServiceReference<WSContextService> ref, @Reference MetaDataIdentifierService metadataSvc, @Reference ThreadGroupTracker threadGroupTracker, @Reference VirtualThreadOps virtualThreadOps) {
        Dictionary properties = componentContext.getProperties();
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"activate", (Object[])new Object[]{properties, "ContextService: " + ref, metadataSvc, threadGroupTracker, virtualThreadOps});
        }
        this.metadataIdentifierService = metadataSvc;
        this.threadGroupTracker = threadGroupTracker;
        this.contextSvcRef.setReference(ref);
        this.contextSvcRef.activate(componentContext);
        String jndiName = (String)properties.get("jndiName");
        this.name = jndiName == null ? (String)properties.get(CONFIG_ID) : jndiName;
        this.defaultExecutionProperties = new TreeMap<String, String>();
        this.defaultExecutionProperties.put("com.ibm.ws.concurrent.DEFAULT_CONTEXT", "UNCONFIGURED_CONTEXT_TYPES");
        this.defaultExecutionProperties.put("com.ibm.ws.concurrent.TASK_OWNER", this.name);
        this.createDaemonThreads = (Boolean)properties.get(CREATE_DAEMON_THREADS);
        this.defaultPriority = (Integer)properties.get(DEFAULT_PRIORITY);
        Integer maxPriority = (Integer)properties.get(MAX_PRIORITY);
        this.threadGroup = AccessController.doPrivileged(new CreateThreadGroupAction(this.name + " Thread Group", maxPriority), threadGroupTracker.serverAccessControlContext);
        boolean virtual = Boolean.TRUE.equals(properties.get(VIRTUAL));
        this.virtualThreadFactory = virtual ? (JavaInfo.majorVersion() >= 21 ? virtualThreadOps.createFactoryOfVirtualThreads(properties.get(CONFIG_ID) + ":", 1L, false, null) : new VirtualThreadsUnsupported()) : null;
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"activate");
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext componentContext) {
        this.isShutdown.set(true);
        this.contextSvcRef.deactivate(componentContext);
        this.threadGroupTracker.threadFactoryDestroyed(this.name, this.threadGroup);
    }

    public ApplicationRecycleContext getContext() {
        return null;
    }

    public Set<String> getDependentApplications() {
        HashSet<String> members = new HashSet<String>(this.applications);
        this.applications.removeAll(members);
        return members;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object createResource(ResourceInfo info) throws Exception {
        String appName = null;
        String identifier = null;
        ClassLoader classLoaderToRestore = null;
        boolean restoreClassLoader = false;
        boolean restoreMetadata = false;
        ComponentMetaDataAccessorImpl accessor = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor();
        try {
            ComponentMetaData cData;
            if (info instanceof MTFBeanResourceInfo) {
                ComponentMetaData cData2;
                MTFBeanResourceInfo beanInfo = (MTFBeanResourceInfo)info;
                MetaData metadata = beanInfo.getDeclaringMetaData();
                if (metadata instanceof ComponentMetaData) {
                    cData2 = (ComponentMetaData)metadata;
                } else if (metadata instanceof ModuleMetaData) {
                    ModuleMetaData mData = (ModuleMetaData)metadata;
                    ComponentMetaData[] c = mData.getComponentMetaDatas();
                    if (c != null && c.length == 1) {
                        cData2 = c[0];
                    } else {
                        String webMetadataIdentifier = null;
                        for (Class<?> ifc : mData.getClass().getInterfaces()) {
                            if (!ifc.getName().equals("com.ibm.wsspi.webcontainer.metadata.WebModuleMetaData")) continue;
                            J2EEName jeeName = mData.getJ2EEName();
                            webMetadataIdentifier = this.webMetadataFactory.getMetaDataIdentifier(jeeName.getApplication(), jeeName.getModule(), null);
                            break;
                        }
                        if (webMetadataIdentifier == null) {
                            throw new IllegalArgumentException("Unrecognized module metadata " + mData + " of type " + mData.getClass().getName());
                        }
                        cData2 = this.webMetadataFactory.createComponentMetaData(webMetadataIdentifier);
                        if (cData2 == null) {
                            J2EEName jeeName = mData.getJ2EEName();
                            String err = Tr.formatMessage((TraceComponent)tc, (String)"CWWKC1122.mod.unavail", (Object[])new Object[]{jeeName.getModule(), jeeName.getApplication()});
                            throw new IllegalStateException(err);
                        }
                    }
                } else {
                    throw new UnsupportedOperationException("A ManagedThreadFactory resource defined is in the " + metadata.getName() + " application artifact with " + metadata.getClass().getName() + " metadata.");
                }
                appName = cData2.getJ2EEName().getApplication();
                identifier = cData2 instanceof IdentifiableComponentMetaData ? this.metadataIdentifierService.getMetaDataIdentifier((MetaData)cData2) : null;
                ClassLoader declaringClassLoader = beanInfo.getDeclaringClassLoader();
                classLoaderToRestore = Thread.currentThread().getContextClassLoader();
                if (classLoaderToRestore != declaringClassLoader) {
                    Thread.currentThread().setContextClassLoader(declaringClassLoader);
                    restoreClassLoader = true;
                }
                if (accessor.getComponentMetaData() != cData2) {
                    accessor.beginContext(cData2);
                    restoreMetadata = true;
                }
            }
            if (appName == null && (cData = accessor.getComponentMetaData()) != null) {
                appName = cData.getJ2EEName().getApplication();
                if (identifier == null) {
                    identifier = this.metadataIdentifierService.getMetaDataIdentifier((MetaData)cData);
                }
            }
            if (appName != null) {
                this.applications.add(appName);
            }
            ManagedThreadFactoryImpl managedThreadFactoryImpl = new ManagedThreadFactoryImpl(identifier, this.threadGroupTracker.serverAccessControlContext);
            return managedThreadFactoryImpl;
        }
        finally {
            if (restoreMetadata) {
                accessor.endContext();
            }
            if (restoreClassLoader) {
                Thread.currentThread().setContextClassLoader(classLoaderToRestore);
            }
        }
    }

    @Trivial
    private static class CreateThreadGroupAction
    implements PrivilegedAction<ThreadGroup> {
        private final Integer maxPriority;
        private final String name;

        private CreateThreadGroupAction(String name, Integer maxPriority) {
            this.maxPriority = maxPriority;
            this.name = name;
        }

        @Override
        public ThreadGroup run() {
            ThreadGroup group = new ThreadGroup(this.name);
            group.setDaemon(false);
            if (this.maxPriority != null) {
                group.setMaxPriority(this.maxPriority);
            }
            return group;
        }
    }

    @Trivial
    private class VirtualThreadsUnsupported
    implements ThreadFactory {
        private VirtualThreadsUnsupported() {
        }

        @Override
        public Thread newThread(Runnable r) {
            throw new UnsupportedOperationException(Tr.formatMessage((TraceComponent)tc, (String)"CWWKC1121.virtual.invalid", (Object[])new Object[]{"ManagedThreadFactoryDefinition", "managed-thread-factory", ManagedThreadFactoryService.this.name}));
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    class ManagedThreadFactoryImpl
    implements ManagedThreadFactory {
        private final String identifier;
        final AccessControlContext serverAccessControlContext;
        final ManagedThreadFactoryService service;
        final ThreadContextDescriptor threadContextDescriptor;
        final ThreadGroup threadGroup;
        static final long serialVersionUID = 3189390581323488826L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        ManagedThreadFactoryImpl(String identifier, AccessControlContext serverAccessControlContext) {
            this.service = ManagedThreadFactoryService.this;
            this.identifier = identifier;
            this.serverAccessControlContext = serverAccessControlContext;
            WSContextService contextSvc = (WSContextService)ManagedThreadFactoryService.this.contextSvcRef.getServiceWithException();
            this.threadContextDescriptor = contextSvc.captureThreadContext(ManagedThreadFactoryService.this.defaultExecutionProperties, new Map[0]);
            this.threadGroup = identifier == null ? ManagedThreadFactoryService.this.threadGroup : ManagedThreadFactoryService.this.threadGroupTracker.getThreadGroup(identifier, ManagedThreadFactoryService.this.name, this.service.threadGroup);
        }

        @ManualTrace
        public Thread newThread(Runnable runnable) {
            Thread thread;
            boolean trace = TraceComponent.isAnyTracingEnabled();
            if (trace && tc.isEntryEnabled()) {
                Tr.entry((Object)ManagedThreadFactoryService.this, (TraceComponent)tc, (String)"newThread", (Object[])new Object[]{this, runnable});
            }
            if (ManagedThreadFactoryService.this.isShutdown.get()) {
                throw new IllegalStateException(Tr.formatMessage((TraceComponent)tc, (String)"CWWKC1100.resource.unavailable", (Object[])new Object[]{ManagedThreadFactoryService.this.name}));
            }
            if (runnable instanceof ContextualAction) {
                throw new IllegalArgumentException(runnable.getClass().getName());
            }
            if (ManagedThreadFactoryService.this.virtualThreadFactory == null) {
                String threadName = ManagedThreadFactoryService.this.name + "-thread-" + ManagedThreadFactoryService.this.createdThreadCount.incrementAndGet();
                thread = new ManagedThreadImpl(this, runnable, threadName);
            } else {
                thread = ManagedThreadFactoryService.this.virtualThreadFactory.newThread(new ManagedVirtualThreadAction(this, runnable));
            }
            if (trace && tc.isEntryEnabled()) {
                Tr.exit((Object)ManagedThreadFactoryService.this, (TraceComponent)tc, (String)"newThread", (Object)thread);
            }
            return thread;
        }

        @ManualTrace
        public ForkJoinWorkerThread newThread(ForkJoinPool pool) {
            boolean trace = TraceComponent.isAnyTracingEnabled();
            if (trace && tc.isEntryEnabled()) {
                Tr.entry((Object)ManagedThreadFactoryService.this, (TraceComponent)tc, (String)"newThread", (Object[])new Object[]{this, pool});
            }
            if (ManagedThreadFactoryService.this.isShutdown.get()) {
                throw new IllegalStateException(Tr.formatMessage((TraceComponent)tc, (String)"CWWKC1100.resource.unavailable", (Object[])new Object[]{ManagedThreadFactoryService.this.name}));
            }
            ManagedForkJoinWorkerThread thread = new ManagedForkJoinWorkerThread(this, pool);
            if (trace && tc.isEntryEnabled()) {
                Tr.exit((Object)ManagedThreadFactoryService.this, (TraceComponent)tc, (String)"newThread", (Object)thread);
            }
            return thread;
        }

        boolean sameMetaDataIdentity() {
            ComponentMetaData cData = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
            return this.identifier != null && ManagedThreadFactoryService.this.metadataIdentifierService != null && this.identifier.equals(ManagedThreadFactoryService.this.metadataIdentifierService.getMetaDataIdentifier((MetaData)cData));
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.concurrent.internal.ManagedThreadFactoryService$ManagedThreadFactoryImpl", ManagedThreadFactoryImpl.class, (String)"concurrent", (String)"com.ibm.ws.concurrent.resources.CWWKCMessages");
        }
    }
}

