/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.recoverylog.custom.jdbc.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.recoverylog.spi.CustomLogProperties;
import com.ibm.ws.recoverylog.spi.InternalLogException;
import com.ibm.wsspi.resource.ResourceFactory;
import javax.sql.DataSource;

public class SQLNonTransactionalDataSource {
    private static final TraceComponent tc = Tr.register(SQLNonTransactionalDataSource.class, (String)"Transaction", (String)"com.ibm.ws.recoverylog.resources.RecoveryLogMsgs");
    DataSource nonTranDataSource = null;
    private CustomLogProperties _customLogProperties = null;

    public SQLNonTransactionalDataSource(String dsName, CustomLogProperties customLogProperties) {
        this._customLogProperties = customLogProperties;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Setting CustomLogProperties in constructor" + customLogProperties), (Object[])new Object[0]);
        }
    }

    @FFDCIgnore(value={Exception.class})
    public DataSource getDataSource() throws InternalLogException {
        ResourceFactory dataSourceFactory;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getDataSource", (Object[])new Object[0]);
        }
        if ((dataSourceFactory = this._customLogProperties.resourceFactory()) != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Using DataSourceFactory " + dataSourceFactory), (Object[])new Object[0]);
            }
        } else {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getDataSource", (Object)"Null ResourceFactory InternalLogException");
            }
            throw new InternalLogException("Failed to locate DataSource, null Resourcefactory", null);
        }
        try {
            this.nonTranDataSource = (DataSource)dataSourceFactory.createResource(null);
        }
        catch (Exception e) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getDataSource", (Object)("Caught exception " + e + "throw InternalLogException"));
            }
            throw new InternalLogException("Failed to locate DataSource, caught exception ", null);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getDataSource", (Object)this.nonTranDataSource);
        }
        return this.nonTranDataSource;
    }
}

