/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.telemetry20.internal.info;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.telemetry.internal.common.constants.OpenTelemetryConstants;
import io.openliberty.microprofile.telemetry.internal.common.info.AbstractOpenTelemetryInfoFactory;
import io.openliberty.microprofile.telemetry.internal.interfaces.OpenTelemetryInfoFactory;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.resources.HostResource;
import io.opentelemetry.instrumentation.resources.OsResource;
import io.opentelemetry.instrumentation.resources.ProcessResource;
import io.opentelemetry.instrumentation.resources.ProcessRuntimeResource;
import io.opentelemetry.instrumentation.runtimemetrics.java8.Classes;
import io.opentelemetry.instrumentation.runtimemetrics.java8.Cpu;
import io.opentelemetry.instrumentation.runtimemetrics.java8.GarbageCollector;
import io.opentelemetry.instrumentation.runtimemetrics.java8.MemoryPools;
import io.opentelemetry.instrumentation.runtimemetrics.java8.Threads;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.autoconfigure.AutoConfiguredOpenTelemetrySdk;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.resources.ResourceBuilder;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiFunction;
import org.osgi.service.component.annotations.Component;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={OpenTelemetryInfoFactory.class}, property={"service.vendor=IBM", "service.ranking:Integer=1500"})
public class OpenTelemetryInfoFactoryImpl
extends AbstractOpenTelemetryInfoFactory {
    private static final TraceComponent tc = Tr.register(OpenTelemetryInfoFactoryImpl.class, (String)"TELEMETRY", (String)"io.openliberty.microprofile.telemetry.internal.common.resources.MPTelemetry");
    static final long serialVersionUID = 9185711195140707134L;

    public OpenTelemetry buildOpenTelemetry(Map<String, String> openTelemetryProperties, BiFunction<? super Resource, ConfigProperties, ? extends Resource> resourceCustomiser, ClassLoader classLoader) {
        OpenTelemetrySdk openTelemetry = AutoConfiguredOpenTelemetrySdk.builder().addPropertiesCustomizer(x -> openTelemetryProperties).addResourceCustomizer(resourceCustomiser).setServiceClassLoader(classLoader).disableShutdownHook().build().getOpenTelemetrySdk();
        return openTelemetry;
    }

    protected ResourceBuilder customizeResource(Resource resource, ConfigProperties c, boolean isEnabled) {
        ResourceBuilder builder = super.customizeResource(resource, c, isEnabled);
        builder.put(OpenTelemetryConstants.KEY_SERVICE_INSTANCE_ID, (Object)UUID.randomUUID().toString());
        builder.putAll(HostResource.get());
        builder.putAll(OsResource.get());
        builder.putAll(ProcessResource.get());
        builder.putAll(ProcessRuntimeResource.get());
        return builder;
    }

    protected void addDefaultVersionedProperties(Map<String, String> telemetryProperties) {
    }

    protected void mergeInJVMMetrics(OpenTelemetry openTelemetry, boolean runtimeEnabled) {
        if (openTelemetry != null && runtimeEnabled && this.runningOnJ9OrHotspot()) {
            Classes.registerObservers((OpenTelemetry)openTelemetry);
            Cpu.registerObservers((OpenTelemetry)openTelemetry);
            MemoryPools.registerObservers((OpenTelemetry)openTelemetry);
            Threads.registerObservers((OpenTelemetry)openTelemetry);
            GarbageCollector.registerObservers((OpenTelemetry)openTelemetry);
        }
    }
}

