/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.telemetry20.logging.internal;

import com.ibm.websphere.logging.WsLevel;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.kernel.productinfo.ProductInfo;
import com.ibm.ws.logging.data.AuditData;
import com.ibm.ws.logging.data.FFDCData;
import com.ibm.ws.logging.data.GenericData;
import com.ibm.ws.logging.data.KeyValuePair;
import com.ibm.ws.logging.data.KeyValuePairList;
import com.ibm.ws.logging.data.LogTraceData;
import io.openliberty.microprofile.telemetry20.logging.internal.MpTelemetryAuditEventMappingUtils;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.logs.LogRecordBuilder;
import io.opentelemetry.api.logs.Severity;
import io.opentelemetry.context.Context;
import io.opentelemetry.semconv.SemanticAttributes;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;

@Trivial
@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
public class MpTelemetryLogMappingUtils {
    private static final TraceComponent tc = Tr.register(MpTelemetryLogMappingUtils.class, (String)"TELEMETRY", (String)"io.openliberty.microprofile.telemetry.internal.common.resources.MPTelemetry");
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    private static boolean issuedBetaMessage = false;
    static final long serialVersionUID = 8890328777786779657L;

    public static String getLibertyEventType(String source) {
        if (source.equals("com.ibm.ws.logging.source.message")) {
            return "liberty_message";
        }
        if (source.endsWith("com.ibm.ws.logging.source.trace")) {
            return "liberty_trace";
        }
        if (source.endsWith("com.ibm.ws.logging.ffdc.source.ffdcsource")) {
            return "liberty_ffdc";
        }
        if (MpTelemetryLogMappingUtils.isBetaModeCheck() && source.endsWith("audit")) {
            return "liberty_audit";
        }
        return "";
    }

    public static void mapLibertyEventToOpenTelemetry(LogRecordBuilder builder, String eventType, Object event) {
        if (eventType.equals("liberty_message")) {
            MpTelemetryLogMappingUtils.mapMessageAndTraceToOpenTelemetry(builder, eventType, event);
        } else if (eventType.equals("liberty_trace")) {
            MpTelemetryLogMappingUtils.mapMessageAndTraceToOpenTelemetry(builder, eventType, event);
        } else if (eventType.equals("liberty_ffdc")) {
            MpTelemetryLogMappingUtils.mapFFDCToOpenTelemetry(builder, eventType, event);
        } else if (MpTelemetryLogMappingUtils.isBetaModeCheck() && eventType.equals("liberty_audit")) {
            MpTelemetryLogMappingUtils.mapAuditLogsToOpenTelemetry(builder, eventType, event);
        }
    }

    private static void mapMessageAndTraceToOpenTelemetry(LogRecordBuilder builder, String eventType, Object event) {
        LogTraceData logData = (LogTraceData)event;
        builder.setTimestamp(logData.getDatetime(), TimeUnit.MILLISECONDS);
        String loglevel = logData.getLoglevel();
        builder.setSeverity(MpTelemetryLogMappingUtils.mapWsLevelToSeverity(loglevel));
        String logSeverity = logData.getSeverity();
        builder.setSeverityText(logSeverity);
        String message = logData.getMessage();
        if (loglevel != null && (loglevel.equals("ENTRY") || loglevel.equals("EXIT"))) {
            message = MpTelemetryLogMappingUtils.removeSpace(message);
        }
        builder.setBody(message);
        AttributesBuilder attributes = Attributes.builder();
        attributes.put(SemanticAttributes.THREAD_NAME, (Object)logData.getThreadName());
        attributes.put(SemanticAttributes.THREAD_ID, logData.getThreadId());
        String exceptionName = logData.getExceptionName();
        String throwable = logData.getThrowable();
        if (exceptionName != null && throwable != null) {
            attributes.put(SemanticAttributes.EXCEPTION_TYPE, (Object)exceptionName);
            attributes.put(SemanticAttributes.EXCEPTION_STACKTRACE, (Object)throwable);
        }
        attributes.put("io.openliberty.type", eventType).put("io.openliberty.message_id", logData.getMessageId()).put("io.openliberty.method_name", logData.getMethodName()).put("io.openliberty.module", logData.getModule()).put("io.openliberty.class_name", logData.getClassName()).put("io.openliberty.sequence", logData.getSequence());
        ArrayList extensions = null;
        KeyValuePairList kvpl = null;
        kvpl = logData.getExtensions();
        if (kvpl != null && kvpl.getKey().equals("extensions")) {
            extensions = kvpl.getList();
            for (KeyValuePair k : extensions) {
                String extKey = k.getKey();
                if (extKey.equals("ext_appName")) {
                    attributes.put("io.openliberty.ext.app_name", k.getStringValue());
                    continue;
                }
                if (extKey.equals("ext_thread")) continue;
                if (extKey.endsWith("_int")) {
                    extKey = MpTelemetryLogMappingUtils.formatExtensionKey(extKey);
                    attributes.put(extKey, (long)k.getIntValue());
                    continue;
                }
                if (extKey.endsWith("_float")) {
                    extKey = MpTelemetryLogMappingUtils.formatExtensionKey(extKey);
                    attributes.put(extKey, (double)k.getFloatValue());
                    continue;
                }
                if (extKey.endsWith("_long")) {
                    extKey = MpTelemetryLogMappingUtils.formatExtensionKey(extKey);
                    attributes.put(extKey, k.getLongValue());
                    continue;
                }
                if (extKey.endsWith("_bool")) {
                    extKey = MpTelemetryLogMappingUtils.formatExtensionKey(extKey);
                    attributes.put(extKey, k.getBooleanValue());
                    continue;
                }
                extKey = MpTelemetryLogMappingUtils.formatExtensionKey(extKey);
                attributes.put(extKey, k.getStringValue());
            }
        }
        builder.setAllAttributes(attributes.build());
        builder.setContext(Context.current());
    }

    private static void mapFFDCToOpenTelemetry(LogRecordBuilder builder, String eventType, Object event) {
        FFDCData ffdcData = (FFDCData)event;
        builder.setTimestamp(ffdcData.getDatetime(), TimeUnit.MILLISECONDS);
        builder.setSeverity(Severity.WARN);
        String ffdcMsg = ffdcData.getMessage();
        if (ffdcMsg != null) {
            builder.setBody(ffdcMsg);
        } else {
            builder.setBody(ffdcData.getExceptionName());
        }
        AttributesBuilder attributes = Attributes.builder();
        attributes.put(SemanticAttributes.THREAD_ID, (Object)ffdcData.getThreadId());
        attributes.put(SemanticAttributes.EXCEPTION_TYPE, (Object)ffdcData.getExceptionName());
        attributes.put(SemanticAttributes.EXCEPTION_MESSAGE, (Object)ffdcData.getMessage());
        attributes.put(SemanticAttributes.EXCEPTION_STACKTRACE, (Object)ffdcData.getStacktrace());
        attributes.put("io.openliberty.type", eventType).put("io.openliberty.probe_id", ffdcData.getProbeId()).put("io.openliberty.object_details", ffdcData.getObjectDetails()).put("io.openliberty.class_name", ffdcData.getClassName()).put("io.openliberty.sequence", ffdcData.getSequence());
        builder.setAllAttributes(attributes.build());
        builder.setContext(Context.current());
    }

    private static void mapAuditLogsToOpenTelemetry(LogRecordBuilder builder, String eventType, Object event) {
        GenericData genData = (GenericData)event;
        KeyValuePair[] pairs = genData.getPairs();
        String key = null;
        builder.setSeverity(Severity.INFO2);
        AttributesBuilder attributes = Attributes.builder();
        attributes.put("io.openliberty.type", eventType);
        for (KeyValuePair kvp : pairs) {
            if (kvp == null || kvp.isList() || (key = kvp.getKey()).equals("ibm_datetime") || key.equals("loggingEventTime") || AuditData.getDatetimeKey((int)0).equals(key)) continue;
            if (key.equals("eventName")) {
                builder.setBody(kvp.getStringValue());
                attributes.put(MpTelemetryAuditEventMappingUtils.getOTelMappedAuditEventKeyName(key), kvp.getStringValue());
                continue;
            }
            if (key.equals("eventTime")) {
                builder.setTimestamp(MpTelemetryLogMappingUtils.formatDateTime(kvp.getStringValue()));
                continue;
            }
            if (key.equals("ibm_sequence") || key.equals("loggingSequenceNumber") || AuditData.getSequenceKey((int)0).equals(key)) {
                attributes.put("io.openliberty.sequence", kvp.getStringValue());
                continue;
            }
            if (key.equals("ibm_threadId") || AuditData.getThreadIDKey((int)0).equals(key)) {
                attributes.put(SemanticAttributes.THREAD_ID, kvp.getIntValue());
                continue;
            }
            attributes.put(MpTelemetryAuditEventMappingUtils.getOTelMappedAuditEventKeyName(key), kvp.getStringValue());
        }
        builder.setAllAttributes(attributes.build());
        builder.setContext(Context.current());
    }

    private static Severity mapWsLevelToSeverity(String level) {
        if (level.equals(WsLevel.FATAL.toString())) {
            return Severity.FATAL;
        }
        if (level.equals(WsLevel.SEVERE.toString()) || level.equals(WsLevel.ERROR.toString())) {
            return Severity.ERROR;
        }
        if (level.equals(WsLevel.WARNING.toString()) || level.equals("SystemErr")) {
            return Severity.WARN;
        }
        if (level.equals(WsLevel.AUDIT.toString())) {
            return Severity.INFO2;
        }
        if (level.equals(WsLevel.INFO.toString()) || level.equals("SystemOut")) {
            return Severity.INFO;
        }
        if (level.equals(WsLevel.CONFIG.toString())) {
            return Severity.DEBUG4;
        }
        if (level.equals(WsLevel.DETAIL.toString())) {
            return Severity.DEBUG3;
        }
        if (level.equals(WsLevel.FINE.toString()) || level.equals(WsLevel.EVENT.toString())) {
            return Severity.DEBUG2;
        }
        if (level.equals(WsLevel.FINER.toString()) || level.equals("ENTRY") || level.equals("EXIT")) {
            return Severity.DEBUG;
        }
        if (level.equals(WsLevel.FINEST.toString())) {
            return Severity.TRACE;
        }
        return Severity.INFO;
    }

    private static String formatExtensionKey(String extKey) {
        StringBuffer sb = new StringBuffer();
        String extName = "";
        int extStartIdx = extKey.indexOf("_");
        int extEndIdx = extKey.indexOf("_", extStartIdx + 1);
        extName = extEndIdx != -1 ? extKey.substring(extStartIdx + 1, extEndIdx) : extKey.substring(extStartIdx + 1);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Parsing the name from the following extension key: " + extKey + " to " + extName), (Object[])new Object[0]);
        }
        sb.append("io.openliberty.ext.").append(extName.toLowerCase());
        return sb.toString();
    }

    private static String removeSpace(String s) {
        StringBuilder sb = new StringBuilder();
        boolean isLine = false;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\n') {
                sb.append(c);
                isLine = true;
                continue;
            }
            if (c == ' ' && isLine) continue;
            if (isLine && c != ' ') {
                isLine = false;
                sb.append(c);
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static Instant formatDateTime(String dateTime) {
        TemporalAccessor tempAccessor = FORMATTER.parse(dateTime);
        Instant instant = Instant.from(tempAccessor);
        return instant;
    }

    public static boolean isBetaModeCheck() {
        if (!ProductInfo.getBetaEdition()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Not running Beta Edition, the audit logs will NOT be routed to OpenTelemetry.", (Object[])new Object[0]);
            }
            return false;
        }
        if (!issuedBetaMessage) {
            Tr.info((TraceComponent)tc, (String)("BETA: A beta method has been invoked for routing audit logs to OpenTelemetry in the class " + MpTelemetryLogMappingUtils.class.getName() + " for the first time."), (Object[])new Object[0]);
            issuedBetaMessage = !issuedBetaMessage;
        }
        return true;
    }
}

