/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.session.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.session.SessionCookieConfigImpl;
import com.ibm.ws.session.utils.LoggingUtil;
import jakarta.servlet.SessionCookieConfig;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;

public class SessionCookieConfigImpl60
extends SessionCookieConfigImpl
implements SessionCookieConfig,
Cloneable {
    private static final String methodClassName = "SessionCookieConfigImpl60";
    private static TraceNLS nls = TraceNLS.getTraceNLS(SessionCookieConfigImpl60.class, (String)"io.openliberty.session.resources.SessionMessages");
    private static final String TSPECIALS = "/()<>@,;:\\\"[]?={} \t";

    public SessionCookieConfigImpl60() {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINER)) {
            LoggingUtil.SESSION_LOGGER_CORE.log(Level.FINE, "SessionCookieConfigImpl60 Constructor default");
        }
    }

    public SessionCookieConfigImpl60(String name, String domain, String path, String comment, int maxAge, boolean httpOnly, boolean secure) {
        super(name, domain, path, comment, maxAge, httpOnly, secure);
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINER)) {
            LoggingUtil.SESSION_LOGGER_CORE.log(Level.FINE, "SessionCookieConfigImpl60 Constructor");
        }
    }

    public String getAttribute(String name) {
        return super.getAttribute(name);
    }

    public Map<String, String> getAttributes() {
        return super.getAttributes();
    }

    @Deprecated(since="Servlet 6.0", forRemoval=true)
    public String getComment() {
        return this.comment;
    }

    public void setAttribute(String name, String value) {
        this.setAttribute(name, value, true);
    }

    @Deprecated(since="Servlet 6.0", forRemoval=true)
    public void setComment(String c) {
        this.setComment(c, true);
    }

    public void setAttribute(String name, String value, boolean externalCall) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINER)) {
            LoggingUtil.SESSION_LOGGER_CORE.log(Level.FINE, "SessionCookieConfigImpl60 setAttribute , name [" + name + "] , value [" + value + "] , contextInitialized [" + this.contextInitialized + "] , externalCall [" + externalCall + "]");
        }
        if (externalCall) {
            this.programmaticChange = true;
        }
        if (this.contextInitialized) {
            this.throwWarning();
        }
        if (name == null) {
            throw new IllegalArgumentException(nls.getString("cookie.attribute.name.null"));
        }
        if (SessionCookieConfigImpl60.hasReservedCharacters(name)) {
            String msg = nls.getFormattedMessage("cookie.attribute.name.invalid.[{0}]", new Object[]{name}, "Cookie attribute name is invalid [" + name + "]");
            throw new IllegalArgumentException(msg);
        }
        if ("Max-Age".equalsIgnoreCase(name) && value != null) {
            this.setMaxAge(Integer.parseInt(value), externalCall);
        } else {
            this.putAttribute(name, value);
        }
    }

    public SessionCookieConfig clone() throws CloneNotSupportedException {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINER)) {
            LoggingUtil.SESSION_LOGGER_CORE.log(Level.FINE, "SessionCookieConfigImpl60 clone");
        }
        SessionCookieConfigImpl60 temp = new SessionCookieConfigImpl60(this.getName(), this.getDomain(), this.getPath(), this.comment, this.getMaxAge(), this.isHttpOnly(), this.isSecure());
        temp.attributes = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        temp.attributes.putAll(this.attributes);
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINER)) {
            LoggingUtil.SESSION_LOGGER_CORE.log(Level.FINE, "SessionCookieConfigImpl60 returns cloned SessionCookieConfig [" + temp + "]");
        }
        return temp;
    }

    private static boolean hasReservedCharacters(String value) {
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            char c = value.charAt(i);
            if (c >= ' ' && c < '\u007f' && TSPECIALS.indexOf(c) == -1) continue;
            return true;
        }
        return false;
    }
}

