/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.client;

import com.ibm.ws.sib.comms.ConnectionMetaData;
import com.ibm.ws.sib.comms.ProtocolVersion;
import com.ibm.ws.sib.jfapchannel.ConversationMetaData;
import com.ibm.ws.sib.jfapchannel.HandshakeProperties;
import java.net.InetAddress;
import javax.net.ssl.SSLSession;

public class ConnectionMetaDataImpl
implements ConnectionMetaData {
    private final ConversationMetaData conversationMetaData;
    private final HandshakeProperties handshakeProperties;

    public ConnectionMetaDataImpl(ConversationMetaData conversationMetaData, HandshakeProperties handshakeProperties) {
        this.conversationMetaData = conversationMetaData;
        this.handshakeProperties = handshakeProperties;
    }

    public String getChainName() {
        return this.conversationMetaData.getChainName();
    }

    public boolean isInbound() {
        return this.conversationMetaData.isInbound();
    }

    public SSLSession getSSLSession() {
        return this.conversationMetaData.getSSLSession();
    }

    public boolean requiresNonJavaBootstrap() {
        return (this.handshakeProperties.getCapabilites() & 8) == 8;
    }

    public InetAddress getRemoteAddress() {
        return this.conversationMetaData.getRemoteAddress();
    }

    public int getRemotePortNumber() {
        return this.conversationMetaData.getRemotePort();
    }

    public ProtocolVersion getProtocolVersion() {
        short fapLevel = this.handshakeProperties.getFapLevel();
        ProtocolVersion result = ProtocolVersion.UNKNOWN;
        if (fapLevel == 1) {
            result = ProtocolVersion.VERSION_6_0;
        } else if (fapLevel >= 2 && fapLevel <= 4) {
            result = ProtocolVersion.VERSION_6_0_2;
        } else if (fapLevel >= 5 && fapLevel <= 8) {
            result = ProtocolVersion.VERSION_6_1;
        } else if (fapLevel >= 9) {
            result = ProtocolVersion.VERSION_7;
        }
        return result;
    }

    public String getRemoteCellName() {
        return this.handshakeProperties.getRemoteCellName();
    }

    public String getRemoteNodeName() {
        return this.handshakeProperties.getRemoteNodeName();
    }

    public String getRemoteServerName() {
        return this.handshakeProperties.getRemoteServerName();
    }

    public String getRemoteClusterName() {
        return this.handshakeProperties.getRemoteClusterName();
    }
}

