/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.jfapchannel.netty;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.jfapchannel.framework.ConnectRequestListener;
import com.ibm.ws.sib.jfapchannel.framework.FrameworkException;
import com.ibm.ws.sib.jfapchannel.framework.NetworkConnection;
import com.ibm.ws.sib.jfapchannel.framework.NetworkConnectionContext;
import com.ibm.ws.sib.jfapchannel.framework.NetworkConnectionTarget;
import com.ibm.ws.sib.jfapchannel.impl.OutboundConnection;
import com.ibm.ws.sib.jfapchannel.netty.NettyJMSClientHandler;
import com.ibm.ws.sib.jfapchannel.netty.NettyJMSHeartbeatHandler;
import com.ibm.ws.sib.jfapchannel.netty.NettyNetworkConnectionContext;
import com.ibm.ws.sib.jfapchannel.netty.NettyNetworkConnectionFactory;
import com.ibm.ws.sib.jfapchannel.netty.NettyToWsBufferDecoder;
import com.ibm.ws.sib.jfapchannel.netty.WsBufferToNettyEncoder;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.kernel.service.utils.FrameworkState;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.openliberty.netty.internal.BootstrapExtended;
import io.openliberty.netty.internal.ChannelInitializerWrapper;
import io.openliberty.netty.internal.NettyFramework;
import io.openliberty.netty.internal.exception.NettyException;
import io.openliberty.netty.internal.tls.NettyTlsProvider;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;

public class NettyNetworkConnection
implements NetworkConnection {
    private static final TraceComponent tc = SibTr.register(NettyNetworkConnection.class, (String)"SIBJFapChannel", (String)"com.ibm.ws.sib.jfapchannel.CWSIJMessages");
    private Channel chan;
    private String chainName;
    private boolean isInbound;
    private Map<String, Object> sslOptions;
    private NettyTlsProvider tlsProvider;
    private NettyFramework nettyBundle;
    private BootstrapExtended bootstrap;

    public NettyNetworkConnection(BootstrapExtended bootstrap, String chainName, NettyFramework nettyBundle, Map<Object, Object> sslOptions, NettyTlsProvider tlsProvider, boolean isInbound) throws FrameworkException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object)new Object[]{bootstrap, chainName});
        }
        this.chainName = chainName;
        this.sslOptions = sslOptions == null ? null : new HashMap<Object, Object>(sslOptions);
        this.isInbound = isInbound;
        this.tlsProvider = tlsProvider;
        this.nettyBundle = nettyBundle;
        this.bootstrap = bootstrap;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"<init>", (Object)new Object[]{bootstrap, chainName});
        }
    }

    public NettyNetworkConnection(Channel chan, String chainName, boolean isInbound) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object)chan);
        }
        this.chan = chan;
        this.isInbound = isInbound;
        this.chainName = chainName;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"<init>", (Object)new Object[]{chan});
        }
    }

    public void linkOutboundConnection(OutboundConnection conn) throws NettyException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"linkOutboundConnection");
        }
        if (this.chan == null) {
            throw new NettyException("Error linking connection appropriately");
        }
        if (this.chan.attr(NettyNetworkConnectionFactory.CONNECTION).get() != null && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"linkOutboundConnection", (Object)("Connection was already set: " + this.chan.attr(NettyNetworkConnectionFactory.CONNECTION).get()));
        }
        this.chan.attr(NettyNetworkConnectionFactory.CONNECTION).set((Object)conn);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"linkOutboundConnection");
        }
    }

    Channel getVirtualConnection() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getVirtualConnection");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getVirtualConnection", (Object)this.chan);
        }
        return this.chan;
    }

    @Override
    public boolean requestPermissionToClose(long timeout) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"requestPermissionToClose", (Object)timeout);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"requestPermissionToClose", (Object)true);
        }
        return true;
    }

    public void setHearbeatInterval(int timeout) throws NettyException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this.chan, (TraceComponent)tc, (String)"setHearbeatInterval", (Object)timeout);
        }
        if (this.chan == null) {
            throw new NettyException("Haven't registered channel to set timeout");
        }
        ChannelPipeline pipeline = this.chan.pipeline();
        if (this.getHearbeatInterval() != (long)(timeout * 1000)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"setHearbeatInterval", (Object)("Replacing Heartbeat Interval for Channel: " + this.chan + " from: " + this.getHearbeatInterval() + " to: " + timeout));
            }
            pipeline.replace("heartBeatHandler", "heartBeatHandler", (ChannelHandler)new NettyJMSHeartbeatHandler(timeout));
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"setHearbeatInterval", (Object)("Heartbeat Interval set for Channel: " + this.chan + " pipeline names" + pipeline.names()));
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setHearbeatInterval");
        }
    }

    private long getHearbeatInterval() throws NettyException {
        if (this.chan == null) {
            throw new NettyException("Haven't registered channel to get timeout");
        }
        ChannelPipeline pipeline = this.chan.pipeline();
        return ((NettyJMSHeartbeatHandler)pipeline.get("heartBeatHandler")).getReaderIdleTimeInMillis();
    }

    protected SSLSession getSSLSession() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getSSLSession", (Object)new Object[]{this.chan});
        }
        SSLSession session = null;
        if (this.chan == null) {
            SibTr.warning((TraceComponent)tc, (String)"getSSLSession: Tried to get SSLSession without registering channel.", (Object)new Object[]{this.chan});
        } else {
            ChannelHandler handler = this.chan.pipeline().get("sslHandler");
            if (handler == null || !(handler instanceof SslHandler)) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"getSSLSession: No SSL session found for channel.", (Object)new Object[]{this.chan});
                }
            } else {
                session = ((SslHandler)handler).engine().getSession();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getSSLSession", (Object)session);
        }
        return session;
    }

    @Override
    public void connectAsynch(NetworkConnectionTarget target, ConnectRequestListener listener) {
        block9: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"connectAsynch", (Object)new Object[]{target, listener});
            }
            NettyNetworkConnection readyConnection = this;
            if (this.isInbound) {
                listener.connectRequestFailedNotification((Exception)((Object)new NettyException("Can't start outbound connection with an inbound channel")));
                return;
            }
            if (FrameworkState.isStopping()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Framework.isStopping() == true");
                }
                listener.connectRequestFailedNotification(new IllegalStateException("Framework stopped"));
            } else {
                try {
                    this.bootstrap.handler((ChannelHandler)new NettyJMSClientInitializer(this.bootstrap.getBaseInitializer(), target, listener));
                    NettyNetworkConnection parent = this;
                    this.nettyBundle.startOutbound(this.bootstrap, target.getRemoteAddress().getAddress().getHostAddress(), target.getRemoteAddress().getPort(), f -> {
                        if (f.isCancelled() || !f.isSuccess()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)("Channel exception during connect: " + f.cause().getMessage()));
                            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                                SibTr.entry((Object)parent, (TraceComponent)tc, (String)"destroy", (Object)f.cause());
                            }
                            listener.connectRequestFailedNotification((Exception)f.cause());
                            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                                SibTr.exit((Object)parent, (TraceComponent)tc, (String)"destroy");
                            }
                        } else {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                                SibTr.entry((Object)parent, (TraceComponent)tc, (String)"ready", (Object)f);
                            }
                            parent.chan = f.channel();
                            listener.connectRequestSucceededNotification(readyConnection);
                            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                                SibTr.exit((Object)parent, (TraceComponent)tc, (String)"ready");
                            }
                        }
                    });
                }
                catch (Exception e) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.entry((Object)this, (TraceComponent)tc, (String)"destroy", (Object)e);
                    }
                    listener.connectRequestFailedNotification(e);
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEntryEnabled()) break block9;
                    SibTr.exit((Object)this, (TraceComponent)tc, (String)"destroy");
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"connectAsynch");
        }
    }

    @Override
    public NetworkConnectionContext getNetworkConnectionContext() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getNetworkConnectionContext");
        }
        NettyNetworkConnectionContext context = new NettyNetworkConnectionContext(this);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getNetworkConnectionContext", (Object)context);
        }
        return context;
    }

    public String getChainName() {
        return this.chainName;
    }

    public boolean isInbound() {
        return this.isInbound;
    }

    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"@(#) SIB/ws/code/sib.jfapchannel.client.rich.impl/src/com/ibm/ws/sib/netty/jfapchannel/NettyNetworkConnection.java, SIB.comms, WASX.SIB, uu1215.01 1.2");
        }
    }

    private class NettyJMSClientInitializer
    extends ChannelInitializerWrapper {
        final ChannelInitializerWrapper parent;
        final NetworkConnectionTarget target;
        final ConnectRequestListener listener;

        public NettyJMSClientInitializer(ChannelInitializerWrapper parent, NetworkConnectionTarget target, ConnectRequestListener listener) {
            this.parent = parent;
            this.target = target;
            this.listener = listener;
        }

        protected void initChannel(Channel ch) throws Exception {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)((Object)this), (TraceComponent)tc, (String)"initChannel", (Object)"Constructing pipeline");
            }
            this.parent.init(ch);
            ChannelPipeline pipeline = ch.pipeline();
            if (NettyNetworkConnection.this.sslOptions != null) {
                SslContext context;
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)ch, (TraceComponent)tc, (String)"initChannel", (Object)"Adding SSL Support");
                }
                String host = this.target.getRemoteAddress().getAddress().getHostAddress();
                String port = Integer.toString(this.target.getRemoteAddress().getPort());
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)((Object)this), (TraceComponent)tc, (String)"Create SSL", (Object)new Object[]{NettyNetworkConnection.this.tlsProvider, host, port, NettyNetworkConnection.this.sslOptions});
                }
                if ((context = NettyNetworkConnection.this.tlsProvider.getOutboundSSLContext(NettyNetworkConnection.this.sslOptions, host, port)) == null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.entry((Object)((Object)this), (TraceComponent)tc, (String)"initChannel", (Object)"Error adding TLS Support");
                    }
                    this.listener.connectRequestFailedNotification((Exception)((Object)new NettyException("Problems creating SSL context")));
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((Object)((Object)this), (TraceComponent)tc, (String)"initChannel");
                    }
                    ch.close();
                    return;
                }
                SSLEngine engine = context.newEngine(ch.alloc());
                pipeline.addFirst("sslHandler", (ChannelHandler)new SslHandler(engine, false));
            }
            pipeline.addLast("decoder", (ChannelHandler)new NettyToWsBufferDecoder());
            pipeline.addLast("encoder", (ChannelHandler)new WsBufferToNettyEncoder());
            pipeline.replace("inactivityTimeoutHandler", "heartBeatHandler", (ChannelHandler)new NettyJMSHeartbeatHandler(0));
            pipeline.addLast("jmsClientHandler", (ChannelHandler)new NettyJMSClientHandler());
        }
    }
}

