/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client.jaxrs.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import jakarta.ws.rs.RuntimeType;
import jakarta.ws.rs.core.Configuration;
import java.security.AccessController;
import java.security.KeyStore;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpHost;
import org.apache.http.impl.nio.client.HttpAsyncClients;
import org.jboss.resteasy.client.jaxrs.ClientHttpEngine;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.jboss.resteasy.client.jaxrs.engines.ApacheHttpAsyncClient4Engine;
import org.jboss.resteasy.client.jaxrs.engines.ClientHttpEngineBuilder43;
import org.jboss.resteasy.client.jaxrs.i18n.LogMessages;
import org.jboss.resteasy.client.jaxrs.i18n.Messages;
import org.jboss.resteasy.client.jaxrs.internal.ClientConfigProviderFilter;
import org.jboss.resteasy.client.jaxrs.internal.ClientConfiguration;
import org.jboss.resteasy.client.jaxrs.internal.LocalResteasyProviderFactory;
import org.jboss.resteasy.client.jaxrs.internal.ResteasyClientImpl;
import org.jboss.resteasy.client.jaxrs.spi.ClientConfigProvider;
import org.jboss.resteasy.concurrent.ContextualExecutorService;
import org.jboss.resteasy.concurrent.ContextualExecutors;
import org.jboss.resteasy.core.providerfactory.ResteasyProviderFactoryDelegate;
import org.jboss.resteasy.plugins.interceptors.AcceptEncodingGZIPFilter;
import org.jboss.resteasy.plugins.providers.RegisterBuiltin;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

public class ResteasyClientBuilderImpl
extends ResteasyClientBuilder {
    protected KeyStore truststore;
    protected KeyStore clientKeyStore;
    protected String clientPrivateKeyPassword;
    protected boolean disableTrustManager;
    protected ResteasyClientBuilder.HostnameVerificationPolicy policy = ResteasyClientBuilder.HostnameVerificationPolicy.WILDCARD;
    protected ResteasyProviderFactory providerFactory;
    protected ExecutorService asyncExecutor;
    protected ScheduledExecutorService scheduledExecutorService;
    protected boolean cleanupExecutor;
    protected SSLContext sslContext;
    protected Map<String, Object> properties = new HashMap<String, Object>();
    protected ClientHttpEngine httpEngine;
    protected int connectionPoolSize = 50;
    protected int maxPooledPerRoute = 0;
    protected long connectionTTL = -1L;
    protected TimeUnit connectionTTLUnit = TimeUnit.MILLISECONDS;
    protected long socketTimeout = -1L;
    protected TimeUnit socketTimeoutUnits = TimeUnit.MILLISECONDS;
    protected long establishConnectionTimeout = -1L;
    protected TimeUnit establishConnectionTimeoutUnits = TimeUnit.MILLISECONDS;
    protected int connectionCheckoutTimeoutMs = -1;
    protected HostnameVerifier verifier = null;
    protected HttpHost defaultProxy;
    protected int responseBufferSize;
    protected List<String> sniHostNames = new ArrayList<String>();
    protected boolean trustSelfSignedCertificates = true;
    protected boolean cookieManagementEnabled;
    protected boolean disableAutomaticRetries = false;
    protected boolean followRedirects;
    static ResteasyProviderFactory PROVIDER_FACTORY;

    public static void setProviderFactory(ResteasyProviderFactory providerFactory) {
        PROVIDER_FACTORY = providerFactory;
    }

    public ResteasyClientBuilderImpl() {
        if (PROVIDER_FACTORY != null) {
            LocalResteasyProviderFactory localProviderFactory = new LocalResteasyProviderFactory(PROVIDER_FACTORY);
            if (ResteasyProviderFactory.peekInstance() != null) {
                ((ResteasyProviderFactory)localProviderFactory).initializeClientProviders(ResteasyProviderFactory.getInstance());
            }
            this.providerFactory = localProviderFactory;
        }
    }

    @Override
    public ResteasyClientBuilderImpl providerFactory(ResteasyProviderFactory providerFactory) {
        this.providerFactory = providerFactory instanceof LocalResteasyProviderFactory ? providerFactory : new ResteasyProviderFactoryDelegate(providerFactory){
            static final long serialVersionUID = 4335297506509881928L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public RuntimeType getRuntimeType() {
                return RuntimeType.CLIENT;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.client.jaxrs.internal.ResteasyClientBuilderImpl$1", 1.class, null, null);
            }
        };
        return this;
    }

    @Deprecated
    public ResteasyClientBuilderImpl asyncExecutor(ExecutorService asyncExecutor) {
        return this.asyncExecutor(asyncExecutor, false);
    }

    @Deprecated
    public ResteasyClientBuilderImpl asyncExecutor(ExecutorService asyncExecutor, boolean cleanupExecutor) {
        this.asyncExecutor = asyncExecutor;
        this.cleanupExecutor = cleanupExecutor;
        return this;
    }

    @Override
    public ResteasyClientBuilderImpl connectionTTL(long ttl, TimeUnit unit) {
        this.connectionTTL = ttl;
        this.connectionTTLUnit = unit;
        return this;
    }

    @Override
    public ResteasyClientBuilderImpl readTimeout(long timeout, TimeUnit unit) {
        this.socketTimeout = timeout;
        this.socketTimeoutUnits = unit;
        return this;
    }

    @Override
    public ResteasyClientBuilderImpl connectTimeout(long timeout, TimeUnit unit) {
        this.establishConnectionTimeout = timeout;
        this.establishConnectionTimeoutUnits = unit;
        return this;
    }

    @Override
    public ResteasyClientBuilderImpl maxPooledPerRoute(int maxPooledPerRoute) {
        this.maxPooledPerRoute = maxPooledPerRoute;
        return this;
    }

    @Override
    public ResteasyClientBuilderImpl connectionCheckoutTimeout(long timeout, TimeUnit unit) {
        this.connectionCheckoutTimeoutMs = (int)TimeUnit.MILLISECONDS.convert(timeout, unit);
        return this;
    }

    @Override
    public ResteasyClientBuilderImpl connectionPoolSize(int connectionPoolSize) {
        this.connectionPoolSize = connectionPoolSize;
        return this;
    }

    @Override
    public ResteasyClientBuilderImpl responseBufferSize(int size) {
        this.responseBufferSize = size;
        return this;
    }

    @Override
    public ResteasyClientBuilderImpl disableTrustManager() {
        this.disableTrustManager = true;
        return this;
    }

    @Override
    public ResteasyClientBuilderImpl hostnameVerification(ResteasyClientBuilder.HostnameVerificationPolicy policy) {
        this.policy = policy;
        return this;
    }

    @Override
    public ResteasyClientBuilderImpl httpEngine(ClientHttpEngine httpEngine) {
        this.httpEngine = httpEngine;
        return this;
    }

    @Override
    public ResteasyClientBuilderImpl useAsyncHttpEngine() {
        this.httpEngine = new ApacheHttpAsyncClient4Engine(HttpAsyncClients.createSystem(), true);
        return this;
    }

    @Override
    public ResteasyClientBuilderImpl sslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
        return this;
    }

    @Override
    public ResteasyClientBuilderImpl trustStore(KeyStore truststore) {
        this.truststore = truststore;
        return this;
    }

    @Override
    public ResteasyClientBuilderImpl keyStore(KeyStore keyStore, String password) {
        this.clientKeyStore = keyStore;
        this.clientPrivateKeyPassword = password;
        return this;
    }

    @Override
    public ResteasyClientBuilderImpl keyStore(KeyStore keyStore, char[] password) {
        this.clientKeyStore = keyStore;
        this.clientPrivateKeyPassword = new String(password);
        return this;
    }

    public ResteasyClientBuilderImpl property(String name, Object value) {
        this.getProviderFactory().property(name, value);
        return this;
    }

    @Override
    public ResteasyClientBuilderImpl sniHostNames(String ... sniHostNames) {
        this.sniHostNames.addAll(Arrays.asList(sniHostNames));
        return this;
    }

    @Override
    public ResteasyClientBuilderImpl defaultProxy(String hostname) {
        return this.defaultProxy(hostname, -1, null);
    }

    @Override
    public ResteasyClientBuilderImpl defaultProxy(String hostname, int port) {
        return this.defaultProxy(hostname, port, null);
    }

    @Override
    public ResteasyClientBuilderImpl defaultProxy(String hostname, int port, String scheme) {
        this.defaultProxy = hostname != null ? new HttpHost(hostname, port, scheme) : null;
        return this;
    }

    @Override
    public ResteasyProviderFactory getProviderFactory() {
        if (this.providerFactory == null) {
            ClassLoader loader = null;
            if (System.getSecurityManager() == null) {
                loader = Thread.currentThread().getContextClassLoader();
            } else {
                try {
                    loader = AccessController.doPrivileged(new PrivilegedExceptionAction<ClassLoader>(){
                        static final long serialVersionUID = 3592797448314506458L;
                        private static final /* synthetic */ TraceComponent $$$tc$$$;

                        @Override
                        public ClassLoader run() throws Exception {
                            return Thread.currentThread().getContextClassLoader();
                        }

                        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                        static {
                            $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.client.jaxrs.internal.ResteasyClientBuilderImpl$2", 2.class, null, null);
                        }
                    });
                }
                catch (PrivilegedActionException pae) {
                    throw new RuntimeException(pae);
                }
            }
            this.providerFactory = new LocalResteasyProviderFactory(RegisterBuiltin.getClientInitializedResteasyProviderFactory(loader));
            if (ResteasyProviderFactory.peekInstance() != null) {
                this.providerFactory.initializeClientProviders(ResteasyProviderFactory.getInstance());
            }
            if (RegisterBuiltin.isGZipEnabled()) {
                this.providerFactory.registerProvider(AcceptEncodingGZIPFilter.class, true);
            }
        }
        return this.providerFactory;
    }

    @Override
    public ResteasyClient build() {
        ContextualExecutorService executor;
        Iterator<ClientConfigProvider> serviceLoaderIterator;
        ClientHttpEngine clientHttpEngine;
        Object object;
        ClientConfiguration config = new ClientConfiguration(this.getProviderFactory());
        for (Map.Entry<String, Object> entry : this.properties.entrySet()) {
            config.property(entry.getKey(), entry.getValue());
        }
        boolean resetProxy = false;
        if (this.defaultProxy == null) {
            resetProxy = true;
            this.setProxyIfNeeded(config);
        }
        for (Object object2 : this.getProviderFactory().getProviderInstances()) {
            if (!(object2 instanceof ClientHttpEngine)) continue;
            this.httpEngine((ClientHttpEngine)object2);
            break;
        }
        if ((object = config.getProperty("dev.resteasy.client.follow.redirects")) != null) {
            this.followRedirects = Boolean.parseBoolean(String.valueOf(object));
        }
        ClientHttpEngine clientHttpEngine2 = clientHttpEngine = this.httpEngine != null ? this.httpEngine : new ClientHttpEngineBuilder43().resteasyClientBuilder(this).build();
        if (resetProxy) {
            this.defaultProxy = null;
        }
        if ((serviceLoaderIterator = ServiceLoader.load(ClientConfigProvider.class).iterator()).hasNext()) {
            config.register((Object)new ClientConfigProviderFilter(serviceLoaderIterator.next()), 1000);
        }
        return this.createResteasyClient(clientHttpEngine, executor, !(executor = this.getExecutorService()).isManaged(), ContextualExecutors.wrapOrLookup(this.scheduledExecutorService), config);
    }

    private void setProxyIfNeeded(ClientConfiguration clientConfig) {
        try {
            if (clientConfig.hasProperty("org.jboss.resteasy.jaxrs.client.proxy.host")) {
                Object proxyHostProp = clientConfig.getProperty("org.jboss.resteasy.jaxrs.client.proxy.host");
                Integer proxyPort = -1;
                if (clientConfig.hasProperty("org.jboss.resteasy.jaxrs.client.proxy.port")) {
                    Object proxyPortProp = clientConfig.getProperty("org.jboss.resteasy.jaxrs.client.proxy.port");
                    if (proxyPortProp instanceof Number) {
                        proxyPort = ((Number)proxyPortProp).intValue();
                    } else if (proxyPortProp instanceof String) {
                        proxyPort = Integer.parseInt((String)proxyPortProp);
                    }
                }
                Object proxySchemeProp = clientConfig.getProperty("org.jboss.resteasy.jaxrs.client.proxy.scheme");
                this.defaultProxy((String)proxyHostProp, proxyPort, (String)proxySchemeProp);
            }
        }
        catch (Exception e) {
            LogMessages.LOGGER.warn(Messages.MESSAGES.unableToSetHttpProxy(), e);
        }
    }

    protected ResteasyClient createResteasyClient(ClientHttpEngine engine, ExecutorService executor, boolean cleanupExecutor, ScheduledExecutorService scheduledExecutorService, ClientConfiguration config) {
        return new ResteasyClientImpl(engine, executor, cleanupExecutor, ContextualExecutors.wrapOrLookup(scheduledExecutorService), config);
    }

    @Override
    public ResteasyClientBuilderImpl hostnameVerifier(HostnameVerifier verifier) {
        this.verifier = verifier;
        return this;
    }

    public Configuration getConfiguration() {
        return this.getProviderFactory().getConfiguration();
    }

    public ResteasyClientBuilderImpl register(Class<?> componentClass) {
        this.getProviderFactory().register(componentClass);
        return this;
    }

    public ResteasyClientBuilderImpl register(Class<?> componentClass, int priority) {
        this.getProviderFactory().register(componentClass, priority);
        return this;
    }

    public ResteasyClientBuilderImpl register(Class<?> componentClass, Class<?> ... contracts) {
        this.getProviderFactory().register(componentClass, contracts);
        return this;
    }

    public ResteasyClientBuilderImpl register(Class<?> componentClass, Map<Class<?>, Integer> contracts) {
        this.getProviderFactory().register(componentClass, contracts);
        return this;
    }

    public ResteasyClientBuilderImpl register(Object component) {
        this.getProviderFactory().register(component);
        return this;
    }

    public ResteasyClientBuilderImpl register(Object component, int priority) {
        this.getProviderFactory().register(component, priority);
        return this;
    }

    public ResteasyClientBuilderImpl register(Object component, Class<?> ... contracts) {
        this.getProviderFactory().register(component, contracts);
        return this;
    }

    public ResteasyClientBuilderImpl register(Object component, Map<Class<?>, Integer> contracts) {
        this.getProviderFactory().register(component, contracts);
        return this;
    }

    @Override
    public ResteasyClientBuilderImpl withConfig(Configuration config) {
        Map contracts;
        this.providerFactory = new LocalResteasyProviderFactory();
        this.providerFactory.setProperties(config.getProperties());
        for (Class clazz : config.getClasses()) {
            contracts = config.getContracts(clazz);
            try {
                this.register(clazz, contracts);
            }
            catch (RuntimeException e) {
                throw new RuntimeException(Messages.MESSAGES.failedOnRegisteringClass(clazz.getName()), e);
            }
        }
        for (Object obj : config.getInstances()) {
            contracts = config.getContracts(obj.getClass());
            this.register(obj, contracts);
        }
        return this;
    }

    @Override
    public ResteasyClientBuilder executorService(ExecutorService executorService) {
        return this.asyncExecutor(executorService, false);
    }

    @Override
    public ResteasyClientBuilder executorService(ExecutorService executorService, boolean cleanupExecutor) {
        return this.asyncExecutor(executorService, cleanupExecutor);
    }

    @Override
    public ResteasyClientBuilder scheduledExecutorService(ScheduledExecutorService scheduledExecutorService) {
        this.scheduledExecutorService = scheduledExecutorService;
        return this;
    }

    @Override
    public long getConnectionTTL(TimeUnit unit) {
        return this.connectionTTLUnit.equals((Object)unit) ? this.connectionTTL : unit.convert(this.connectionTTL, this.connectionTTLUnit);
    }

    @Override
    public int getMaxPooledPerRoute() {
        return this.maxPooledPerRoute;
    }

    @Override
    public long getConnectionCheckoutTimeout(TimeUnit unit) {
        return TimeUnit.MILLISECONDS.equals((Object)unit) ? (long)this.connectionCheckoutTimeoutMs : unit.convert(this.connectionCheckoutTimeoutMs, TimeUnit.MILLISECONDS);
    }

    @Override
    public int getConnectionPoolSize() {
        return this.connectionPoolSize;
    }

    @Override
    public int getResponseBufferSize() {
        return this.responseBufferSize;
    }

    @Override
    public boolean isTrustManagerDisabled() {
        return this.disableTrustManager;
    }

    @Override
    public boolean isTrustSelfSignedCertificates() {
        return this.trustSelfSignedCertificates;
    }

    @Override
    public void setIsTrustSelfSignedCertificates(boolean b) {
        this.trustSelfSignedCertificates = b;
    }

    @Override
    public ResteasyClientBuilder.HostnameVerificationPolicy getHostnameVerification() {
        return this.policy;
    }

    @Override
    public ClientHttpEngine getHttpEngine() {
        return this.httpEngine;
    }

    @Override
    public boolean isUseAsyncHttpEngine() {
        return this.httpEngine != null && this.httpEngine instanceof ApacheHttpAsyncClient4Engine;
    }

    @Override
    public List<String> getSniHostNames() {
        return this.sniHostNames;
    }

    @Override
    public String getDefaultProxyHostname() {
        return this.defaultProxy != null ? this.defaultProxy.getHostName() : null;
    }

    @Override
    public int getDefaultProxyPort() {
        return this.defaultProxy != null ? this.defaultProxy.getPort() : -1;
    }

    @Override
    public String getDefaultProxyScheme() {
        return this.defaultProxy != null ? this.defaultProxy.getSchemeName() : null;
    }

    @Override
    public long getReadTimeout(TimeUnit unit) {
        return this.socketTimeoutUnits.equals((Object)unit) ? this.socketTimeout : unit.convert(this.socketTimeout, this.socketTimeoutUnits);
    }

    @Override
    public long getConnectionTimeout(TimeUnit unit) {
        return this.establishConnectionTimeoutUnits.equals((Object)unit) ? this.establishConnectionTimeout : unit.convert(this.establishConnectionTimeout, this.establishConnectionTimeoutUnits);
    }

    @Override
    public SSLContext getSSLContext() {
        return this.sslContext;
    }

    @Override
    public KeyStore getKeyStore() {
        return this.clientKeyStore;
    }

    @Override
    public String getKeyStorePassword() {
        return this.clientPrivateKeyPassword;
    }

    @Override
    public KeyStore getTrustStore() {
        return this.truststore;
    }

    @Override
    public HostnameVerifier getHostnameVerifier() {
        return this.verifier;
    }

    @Override
    public ResteasyClientBuilder enableCookieManagement() {
        this.cookieManagementEnabled = true;
        return this;
    }

    @Override
    public boolean isCookieManagementEnabled() {
        return this.cookieManagementEnabled;
    }

    @Override
    public ResteasyClientBuilder disableAutomaticRetries() {
        this.disableAutomaticRetries = true;
        return this;
    }

    @Override
    public boolean isDisableAutomaticRetries() {
        return this.disableAutomaticRetries;
    }

    @Override
    public ResteasyClientBuilder setFollowRedirects(boolean followRedirects) {
        this.followRedirects = followRedirects;
        return this;
    }

    @Override
    public boolean isFollowRedirects() {
        return this.followRedirects;
    }

    private ContextualExecutorService getExecutorService() {
        if (this.asyncExecutor != null) {
            return ContextualExecutors.wrap(this.asyncExecutor, !this.cleanupExecutor);
        }
        return ContextualExecutors.threadPool();
    }
}

