/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.concurrent;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.stream.Collectors;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.resteasy.concurrent.ContextualExecutorService;
import org.jboss.resteasy.concurrent.ContextualScheduledExecutorService;
import org.jboss.resteasy.concurrent.GlobalContextualExecutorService;
import org.jboss.resteasy.concurrent.GlobalContextualScheduledExecutorService;
import org.jboss.resteasy.resteasy_jaxrs.i18n.LogMessages;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.spi.concurrent.ThreadContext;
import org.jboss.resteasy.spi.concurrent.ThreadContexts;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
public class ContextualExecutors {
    private static final String EXECUTOR_SERVICE_JNDI = "java:comp/DefaultManagedExecutorService";
    private static final String SCHEDULED_EXECUTOR_SERVICE_JNDI = "java:comp/DefaultManagedScheduledExecutorService";
    private static final Map<String, Boolean> JNDI_LOOKUPS;
    static final long serialVersionUID = 6870963505411080660L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static Executor executor() {
        Map<ThreadContext<Object>, Object> contexts = ContextualExecutors.getContexts();
        return task -> ContextualExecutors.runnable(contexts, task).run();
    }

    public static ContextualExecutorService threadPool() {
        Object delegate = ContextualExecutors.lookup(EXECUTOR_SERVICE_JNDI);
        if (delegate == null) {
            delegate = GlobalContextualExecutorService.INSTANCE;
        }
        return ContextualExecutors.wrap(delegate, true);
    }

    public static ContextualScheduledExecutorService scheduledThreadPool() {
        ScheduledExecutorService delegate = (ScheduledExecutorService)ContextualExecutors.lookup(SCHEDULED_EXECUTOR_SERVICE_JNDI);
        if (delegate == null) {
            delegate = GlobalContextualScheduledExecutorService.INSTANCE;
        }
        return ContextualExecutors.wrap(delegate, true);
    }

    public static ContextualScheduledExecutorService scheduledThreadPool(int poolSize, ThreadFactory threadFactory) {
        ScheduledExecutorService delegate = (ScheduledExecutorService)ContextualExecutors.lookup(SCHEDULED_EXECUTOR_SERVICE_JNDI);
        boolean managed = true;
        if (delegate == null) {
            delegate = Executors.newScheduledThreadPool(poolSize, threadFactory);
            managed = false;
        }
        return ContextualExecutors.wrap(delegate, managed);
    }

    public static ContextualExecutorService wrap(ExecutorService delegate) {
        return ContextualExecutors.wrap(delegate, true);
    }

    public static ContextualExecutorService wrap(ExecutorService delegate, boolean managed) {
        if (delegate == null) {
            return null;
        }
        if (delegate instanceof ScheduledExecutorService) {
            return ContextualExecutors.wrap((ScheduledExecutorService)delegate, managed);
        }
        if (delegate instanceof ContextualExecutorService && managed == ((ContextualExecutorService)delegate).isManaged()) {
            if (managed == ((ContextualExecutorService)delegate).isManaged()) {
                return (ContextualExecutorService)delegate;
            }
            return new ContextualExecutorService(((ContextualExecutorService)delegate).getDelegate(), managed);
        }
        return new ContextualExecutorService(delegate, managed);
    }

    public static ContextualScheduledExecutorService wrap(ScheduledExecutorService delegate) {
        return ContextualExecutors.wrap(delegate, true);
    }

    public static ContextualScheduledExecutorService wrap(ScheduledExecutorService delegate, boolean managed) {
        if (delegate == null) {
            return null;
        }
        if (delegate instanceof ContextualScheduledExecutorService && managed == ((ContextualScheduledExecutorService)delegate).isManaged()) {
            if (managed == ((ContextualScheduledExecutorService)delegate).isManaged()) {
                return (ContextualScheduledExecutorService)delegate;
            }
            return new ContextualScheduledExecutorService(((ContextualScheduledExecutorService)delegate).getDelegate(), managed);
        }
        return new ContextualScheduledExecutorService(delegate, managed);
    }

    public static ContextualScheduledExecutorService wrapOrLookup(ScheduledExecutorService delegate) {
        if (delegate != null) {
            return ContextualExecutors.wrap(delegate, true);
        }
        ScheduledExecutorService found = (ScheduledExecutorService)ContextualExecutors.lookup(SCHEDULED_EXECUTOR_SERVICE_JNDI);
        return found == null ? null : ContextualExecutors.wrap(found, true);
    }

    public static Runnable runnable(Runnable task) {
        return ContextualExecutors.runnable(ContextualExecutors.getContexts(), task);
    }

    public static <V> Callable<V> callable(Callable<V> task) {
        Map<ThreadContext<Object>, Object> contexts = ContextualExecutors.getContexts();
        return () -> {
            try {
                for (Map.Entry entry : contexts.entrySet()) {
                    ((ThreadContext)entry.getKey()).push(entry.getValue());
                }
                Iterator iterator = task.call();
                return iterator;
            }
            finally {
                ContextualExecutors.reset(contexts);
            }
        };
    }

    public static <T> Collection<? extends Callable<T>> callable(Collection<? extends Callable<T>> tasks) {
        return tasks.stream().map(ContextualExecutors::callable).collect(Collectors.toList());
    }

    private static Runnable runnable(Map<ThreadContext<Object>, Object> contexts, Runnable task) {
        return () -> {
            try {
                for (Map.Entry entry : contexts.entrySet()) {
                    ((ThreadContext)entry.getKey()).push(entry.getValue());
                }
                task.run();
            }
            finally {
                ContextualExecutors.reset(contexts);
            }
        };
    }

    private static Map<ThreadContext<Object>, Object> getContexts() {
        LinkedHashMap<ThreadContext<Object>, Object> contexts = new LinkedHashMap<ThreadContext<Object>, Object>();
        ThreadContexts threadContexts = ResteasyProviderFactory.getInstance().getContextData(ThreadContexts.class);
        if (threadContexts == null) {
            threadContexts = new ThreadContexts();
        }
        for (ThreadContext<Object> context : threadContexts.getThreadContexts()) {
            contexts.put(context, context.capture());
        }
        return contexts;
    }

    private static void reset(Map<ThreadContext<Object>, Object> contexts) {
        Throwable error = null;
        for (Map.Entry<ThreadContext<Object>, Object> context : contexts.entrySet()) {
            try {
                context.getKey().reset(context.getValue());
            }
            catch (Throwable t) {
                if (error == null) {
                    error = t;
                    continue;
                }
                error.addSuppressed(t);
            }
        }
        if (error != null) {
            LogMessages.LOGGER.unableToResetThreadContext(error, Thread.currentThread().getName());
        }
    }

    private static <T extends ExecutorService> T lookup(String jndiName) {
        block8: {
            Boolean performLookup = JNDI_LOOKUPS.get(jndiName);
            if (performLookup != null && performLookup.booleanValue()) {
                try {
                    return (T)((ExecutorService)InitialContext.doLookup(jndiName));
                }
                catch (NamingException namingException) {
                    break block8;
                }
                catch (Exception e) {
                    LogMessages.LOGGER.failedToLookupManagedExecutorService(e, jndiName);
                    break block8;
                }
            }
            if (performLookup == null) {
                try {
                    ExecutorService service = (ExecutorService)InitialContext.doLookup(jndiName);
                    JNDI_LOOKUPS.put(jndiName, Boolean.TRUE);
                    return (T)service;
                }
                catch (NamingException service) {
                }
                catch (Exception e) {
                    LogMessages.LOGGER.failedToLookupManagedExecutorService(e, jndiName);
                }
                JNDI_LOOKUPS.put(jndiName, Boolean.FALSE);
            }
        }
        return null;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.concurrent.ContextualExecutors", ContextualExecutors.class, null, null);
        JNDI_LOOKUPS = new ConcurrentHashMap<String, Boolean>();
    }
}

