/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.concurrent;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import java.security.AccessController;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
class ContextualThreadFactory
implements ThreadFactory {
    private static final AtomicInteger POOL_COUNTER;
    private final AtomicInteger threadCounter = new AtomicInteger(0);
    private final String prefix;
    static final long serialVersionUID = -2470746655506950287L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    ContextualThreadFactory(String prefix) {
        this.prefix = String.format("%s-%d-thread", prefix, POOL_COUNTER.incrementAndGet());
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread thread = new Thread(r, String.format("%s-%d", this.prefix, this.threadCounter.incrementAndGet()));
        if (System.getSecurityManager() == null) {
            thread.setDaemon(true);
            if (thread.getPriority() != 5) {
                thread.setPriority(5);
            }
            return thread;
        }
        return AccessController.doPrivileged(() -> {
            thread.setDaemon(true);
            if (thread.getPriority() != 5) {
                thread.setPriority(5);
            }
            return thread;
        });
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.concurrent.ContextualThreadFactory", ContextualThreadFactory.class, null, null);
        POOL_COUNTER = new AtomicInteger(0);
    }
}

