/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers.multipart;

import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.EntityPart;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.jboss.resteasy.concurrent.ContextualExecutors;
import org.jboss.resteasy.plugins.providers.multipart.AbstractMultipartFormDataWriter;
import org.jboss.resteasy.plugins.providers.multipart.MultipartFormDataOutput;
import org.jboss.resteasy.plugins.providers.multipart.MultipartOutput;
import org.jboss.resteasy.plugins.providers.multipart.OutputPart;
import org.jboss.resteasy.spi.AsyncMessageBodyWriter;
import org.jboss.resteasy.spi.AsyncOutputStream;
import org.jboss.resteasy.spi.util.Types;

@Provider
@Produces(value={"multipart/form-data"})
public class MultipartEntityPartWriter
extends AbstractMultipartFormDataWriter
implements AsyncMessageBodyWriter<List<EntityPart>> {
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return List.class.isAssignableFrom(type) && genericType instanceof ParameterizedType && Types.isGenericTypeInstanceOf(EntityPart.class, genericType);
    }

    public void writeTo(List<EntityPart> entityParts, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        this.write(MultipartEntityPartWriter.create(entityParts), mediaType, httpHeaders, entityStream, annotations);
    }

    @Override
    public CompletionStage<Void> asyncWriteTo(List<EntityPart> entityParts, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, AsyncOutputStream entityStream) {
        return CompletableFuture.supplyAsync(() -> MultipartEntityPartWriter.create(entityParts), ContextualExecutors.threadPool()).thenCompose(out -> this.asyncWrite((MultipartOutput)out, mediaType, httpHeaders, entityStream, annotations));
    }

    private static MultipartFormDataOutput create(List<EntityPart> entityParts) {
        MultipartFormDataOutput output = new MultipartFormDataOutput();
        for (EntityPart entityPart : entityParts) {
            OutputPart part = output.addFormData(entityPart.getName(), (Object)entityPart.getContent(), entityPart.getMediaType(), entityPart.getFileName().orElse(null));
            entityPart.getHeaders().forEach((name, value) -> part.getHeaders().addAll(name, value.toArray()));
        }
        return output;
    }
}

